/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.patch;

import com.oracle.cie.common.Version;
import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.util.IObjectStore;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.DistributionTarget;
import com.oracle.cie.gdr.DummyHome;
import com.oracle.cie.gdr.Home;
import com.oracle.cie.gdr.common.NLS;
import com.oracle.cie.gdr.dao.cmn.QuickReference;
import com.oracle.cie.gdr.dao.cmn.Reference;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.cpd.Stringsubs;
import com.oracle.cie.gdr.dao.cpd.StringsubsDefinition;
import com.oracle.cie.gdr.dao.cpd.StringsubsFileEntry;
import com.oracle.cie.gdr.dao.cpd.StringsubsGroup;
import com.oracle.cie.gdr.dao.dbd.Distribution;
import com.oracle.cie.gdr.dao.dbd.FeatureSetGroup;
import com.oracle.cie.gdr.dao.dbd.FeatureSetReference;
import com.oracle.cie.gdr.dao.ftr.ComponentReference;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.dao.rgy.BaseInfoReference;
import com.oracle.cie.gdr.dao.rgy.ComponentInfo;
import com.oracle.cie.gdr.dao.rgy.FeatureInfo;
import com.oracle.cie.gdr.dao.rgy.Registry;
import com.oracle.cie.gdr.dao.rgy.SessionAction;
import com.oracle.cie.gdr.dao.rgy.SessionInfo;
import com.oracle.cie.gdr.dependency.FeatureSelectionTarget;
import com.oracle.cie.gdr.dependency.FeatureSelectionTargetFactory;
import com.oracle.cie.gdr.external.impl.LibraryGeneratorImpl;
import com.oracle.cie.gdr.helpers.ComponentHelper;
import com.oracle.cie.gdr.helpers.DistributionHelper;
import com.oracle.cie.gdr.helpers.FeatureSetHelper;
import com.oracle.cie.gdr.helpers.HomeHelper;
import com.oracle.cie.gdr.helpers.RegenerationHelper;
import com.oracle.cie.gdr.helpers.RegistryHelper;
import com.oracle.cie.gdr.libraries.LibraryException;
import com.oracle.cie.gdr.nio.NioCopy;
import com.oracle.cie.gdr.nio.NioDelete;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.patch.ComponentMetaDataPatchHandler;
import com.oracle.cie.gdr.patch.DistributionMetaDataPatchHandler;
import com.oracle.cie.gdr.patch.FeatureSetMetaDataPatchHandler;
import com.oracle.cie.gdr.patch.InternalPatchHandler;
import com.oracle.cie.gdr.patch.PatchLockedRegistryHandler;
import com.oracle.cie.gdr.patch.StringSubsEnvHandler;
import com.oracle.cie.gdr.services.ProductFamilyService;
import com.oracle.cie.gdr.services.VariableResolverService;
import com.oracle.cie.gdr.utils.GdrException;
import com.oracle.cie.gdr.utils.LocalizedGdrException;
import com.oracle.cie.nextgen.common.version.VersionHelper;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.glcm.opatch.common.api.BasePatchFactory;
import oracle.glcm.opatch.common.api.ComponentCheckResult;
import oracle.glcm.opatch.common.api.Patch;
import oracle.glcm.opatch.common.api.PatchCheckResults;
import oracle.glcm.opatch.common.api.PatchInventory;
import oracle.glcm.opatch.common.api.PatchSubType;
import oracle.glcm.opatch.common.api.Result;
import oracle.glcm.opatch.common.api.install.FileState;
import oracle.glcm.opatch.common.api.install.InventoryComponentInfo;
import oracle.glcm.opatch.common.impl.PatchFactoryImpl;
import oracle.glcm.opatch.common.impl.PatchInventoryImpl;
import oracle.glcm.opatch.common.impl.install.InventoryComponentInfoImpl;

public class PatchHandlerImpl
implements InternalPatchHandler {
    private static final Logger _log = Logger.getLogger(PatchHandlerImpl.class.getName());
    private Home _home;
    private PatchLockedRegistryHandler _patchLockedRegistryHandler;
    private SessionInfo _registrySession;
    private Set<Path> _createdFiles = new HashSet<Path>();
    private StringSubsEnvHandler _stringSubsEnvHandler;
    private Map<Reference, Component> _componentCache = new HashMap<Reference, Component>();
    DistributionMetaDataPatchHandler _distributionMetaDataPatchHandler;
    FeatureSetMetaDataPatchHandler _featureSetMetaDataPatchHandler;
    ComponentMetaDataPatchHandler _componentMetaDataPatchHandler;
    public static final String _disableSystemLibRegen = "PatchHandlerImpl.disable.library.regen";

    public PatchHandlerImpl(Path home) throws GdrException, IOException, DataHandlerException {
        this(Home.getHome(home));
    }

    public PatchHandlerImpl(Home home) throws GdrException {
        if (home == null) {
            LocalizedGdrException ex = new LocalizedGdrException("70001");
            _log.throwing(PatchHandlerImpl.class.getName(), "PatchHandlerImpl", (Throwable)((Object)ex));
            throw ex;
        }
        this._home = home;
        this._distributionMetaDataPatchHandler = new DistributionMetaDataPatchHandler(this, null);
        this._featureSetMetaDataPatchHandler = new FeatureSetMetaDataPatchHandler(this, null);
        this._componentMetaDataPatchHandler = new ComponentMetaDataPatchHandler(this, null, null, null);
    }

    @Override
    public Home getHome() {
        return this._home;
    }

    public StringSubsEnvHandler getStringSubsEnvHandler() {
        return this._stringSubsEnvHandler;
    }

    @Override
    public void setStringSubsEnvHandler(StringSubsEnvHandler stringSubsEnvHandler) {
        this._stringSubsEnvHandler = stringSubsEnvHandler;
    }

    @Override
    public Registry getLockedRegistry() throws GdrException {
        if (this._patchLockedRegistryHandler == null) {
            this._patchLockedRegistryHandler = new PatchLockedRegistryHandler(this.getHome());
        }
        return this._patchLockedRegistryHandler.getLockedRegistry();
    }

    protected void unlockRegistry(boolean persistChanges) throws GdrException {
        if (this._patchLockedRegistryHandler != null) {
            this._patchLockedRegistryHandler.unlockRegistry(persistChanges);
        }
    }

    public Set<Path> getCreatedFiles() {
        return this._createdFiles;
    }

    @Override
    public void addCreatedFile(Path file) {
        if (file != null) {
            this._createdFiles.add(file);
        }
    }

    @Override
    public SessionInfo getRegistrySession() throws GdrException {
        return this.getRegistrySession(SessionAction.upgrade);
    }

    @Override
    public SessionInfo getRegistrySession(SessionAction sessionAction) throws GdrException {
        if (this._registrySession == null) {
            this._registrySession = RegistryHelper.getInstance(this.getHome().getClassLoader()).getRegistrySession(this.getLockedRegistry(), sessionAction);
        } else if (this._registrySession.getAction() != sessionAction) {
            throw new GdrException("Attempt to obtain registry session with session action " + (Object)((Object)sessionAction) + " when existing session already exists with action " + (Object)((Object)this._registrySession.getAction()));
        }
        return this._registrySession;
    }

    @Override
    public PatchCheckResults getPatchCheckResults(Patch patch, boolean rollback) throws GdrException {
        if (patch == null) {
            LocalizedGdrException ex = new LocalizedGdrException("70002");
            _log.throwing(PatchHandlerImpl.class.getName(), "getPatchCheckResults", (Throwable)((Object)ex));
            throw ex;
        }
        if (!rollback) {
            return this.getApplyPatchCheckResults(patch);
        }
        return this.getRollbackPatchCheckResults(patch);
    }

    private PatchCheckResults getApplyPatchCheckResults(Patch patch) {
        PatchCheckResults results = BasePatchFactory.instance().getPatchCheckResults(patch);
        boolean upgradePatch = patch.getPatchSubType() == PatchSubType.UPGRADE;
        List patchComponents = patch.getComponents();
        if (patchComponents != null && !patchComponents.isEmpty()) {
            Set<ComponentReference> installedComponents = DummyHome.getInstance().hasCachedBootstrapComponents(this._home.getHomePath()) ? DummyHome.getInstance().getCachedBootstrapComponents(this._home.getHomePath()) : this.getHome().getInstalledComponents();
            PatchInventory.Component metaDataComponent = null;
            boolean componentsWillBeProcessed = false;
            for (PatchInventory.Component patchComponent : patchComponents) {
                String details;
                Result result;
                if ("oracle.nextgen.metadata".equals(patchComponent.getName())) {
                    metaDataComponent = patchComponent;
                    continue;
                }
                List<ComponentReference> matchingInstalledComponents = FeatureSetHelper.getInstance(this._home.getClassLoader()).getMatchingComponentRefs(patchComponent.getName(), installedComponents);
                if (matchingInstalledComponents.isEmpty()) {
                    result = patchComponent.isRequired() != false ? Result.ERR_NOT_FOUND : Result.IGNORE_NOT_FOUND;
                    details = NLS.getPublishedMessage("26001", patchComponent.getName(), this.getVersionDescription(patchComponent), patch.getPatchUpi(), this.getHome());
                } else {
                    ComponentReference compRef2;
                    ArrayList<Result> componentResults = new ArrayList<Result>();
                    for (ComponentReference compRef2 : matchingInstalledComponents) {
                        componentResults.add(this.getApplyVersionCompareResult(patchComponent, compRef2, upgradePatch));
                    }
                    Result componentCheckResult = Result.getHighLevelResult(componentResults);
                    compRef2 = matchingInstalledComponents.get(componentResults.indexOf(componentCheckResult));
                    if (componentCheckResult.isVersionMismatch()) {
                        if (upgradePatch) {
                            result = componentCheckResult;
                            details = NLS.getPublishedMessage("26002", compRef2.getName(), this.getVersionDescription(compRef2), this.getVersionDescription(patchComponent), patch.getPatchUpi());
                        } else {
                            result = patchComponent.isRequired() != false ? Result.ERR_NOT_FOUND : Result.IGNORE_NOT_FOUND;
                            details = NLS.getPublishedMessage("26002", patchComponent.getName(), this.getVersionDescription(patchComponent), patch.getPatchUpi(), this.getHome());
                        }
                    } else if (componentCheckResult.isProcessingNotRequired()) {
                        result = componentCheckResult;
                        details = NLS.getPublishedMessage("26003", compRef2.getName(), this.getVersionDescription(compRef2), this.getVersionDescription(patchComponent), patch.getPatchUpi());
                    } else {
                        result = componentCheckResult;
                        details = upgradePatch ? NLS.getPublishedMessage("26004", compRef2.getName(), this.getVersionDescription(compRef2), this.getHome(), this.getVersionDescription(patchComponent), patch.getPatchUpi()) : NLS.getPublishedMessage("26005", compRef2.getName(), this.getVersionDescription(compRef2), this.getVersionDescription(patchComponent), this.getHome(), patch.getPatchUpi());
                    }
                }
                if (!componentsWillBeProcessed && result.isProcessComponent()) {
                    componentsWillBeProcessed = true;
                }
                results.setResult(patchComponent, result, details);
            }
            if (metaDataComponent != null) {
                results.setResult(metaDataComponent, componentsWillBeProcessed ? Result.PROCESS_COMPONENT : Result.PROCESSING_NOT_REQUIRED, null);
            }
        }
        return results;
    }

    private PatchCheckResults getRollbackPatchCheckResults(Patch patch) {
        PatchCheckResults results = BasePatchFactory.instance().getPatchCheckResults(patch);
        RegistryHelper registryHelper = RegistryHelper.getInstance(this.getHome().getClassLoader());
        List<ComponentInfo> componentInfosForPatch = registryHelper.getComponentInfosForPatch(this.getHome().getRegistry(), patch.getPatchUpi());
        if (componentInfosForPatch.isEmpty()) {
            _log.warning("Unable to locate any component-info entries in registry which correspond to the specified patch " + patch.getPatchUpi());
            Collection<ComponentInfo> installedComponentInfos = registryHelper.getInstalledComponentInfos(this.getHome().getRegistry());
            for (PatchInventory.Component patchComponent : patch.getComponents()) {
                componentInfosForPatch.addAll(registryHelper.getComponentInfos(installedComponentInfos, patchComponent.getName(), patchComponent.getVersion(), false));
            }
        }
        boolean upgradePatch = patch.getPatchSubType() == PatchSubType.UPGRADE;
        List patchComponents = patch.getComponents();
        if (patchComponents != null && !patchComponents.isEmpty()) {
            PatchInventory.Component metaDataComponent = null;
            boolean componentsWillBeProcessed = false;
            for (PatchInventory.Component patchComponent : patchComponents) {
                Result result = null;
                String details = null;
                if ("oracle.nextgen.metadata".equals(patchComponent.getName())) {
                    metaDataComponent = patchComponent;
                    continue;
                }
                List<ComponentInfo> componentInfos = registryHelper.getComponentInfos(componentInfosForPatch, patchComponent.getName(), patchComponent.getVersion(), false);
                if (componentInfos.isEmpty()) {
                    result = Result.IGNORE_NOT_FOUND;
                    details = NLS.getPublishedMessage("26006", patchComponent.getName(), this.getVersionDescription(patchComponent), patch.getPatchUpi(), this.getHome());
                } else {
                    for (ComponentInfo componentInfo : componentInfos) {
                        int compareResult = this.comparePatchLevels(componentInfo.getPatchLevel(), patchComponent.getPatchLevel());
                        if (compareResult == 0) continue;
                        result = Result.VERSION_MISMATCH;
                        details = NLS.getPublishedMessage("26007", patchComponent.getName(), this.getVersionDescription(patchComponent), patch.getPatchUpi(), this.getHome());
                    }
                    if (result == null && upgradePatch) {
                        for (ComponentInfo componentInfo : componentInfos) {
                            List<String> supersedingPatches = this.getSupersedingPatches(componentInfo, patch, registryHelper);
                            if (supersedingPatches.isEmpty()) continue;
                            result = Result.VERSION_MISMATCH;
                            details = NLS.getPublishedMessage("26008", patchComponent.getName(), this.getVersionDescription(patchComponent), this.getHome(), supersedingPatches, patch.getPatchUpi());
                        }
                        List<FeatureInfo> featureInfosForPatch = registryHelper.getFeatureInfosForPatch(this.getHome().getRegistry(), patch.getPatchUpi());
                        for (FeatureInfo featureInfo : featureInfosForPatch) {
                            List<String> supersedingPatches = this.getSupersedingPatches(featureInfo, patch, registryHelper);
                            if (supersedingPatches.isEmpty()) continue;
                            result = Result.VERSION_MISMATCH;
                            details = NLS.getPublishedMessage("26009", patchComponent.getName(), this.getVersionDescription(patchComponent), this.getHome(), supersedingPatches, patch.getPatchUpi());
                        }
                    }
                    if (result == null) {
                        result = Result.PROCESS_COMPONENT;
                        details = NLS.getPublishedMessage("26010", patchComponent.getName(), this.getVersionDescription(patchComponent), patch.getPatchUpi(), this.getHome());
                    }
                }
                if (!componentsWillBeProcessed && result.isProcessComponent()) {
                    componentsWillBeProcessed = true;
                }
                results.setResult(patchComponent, result, details);
            }
            if (metaDataComponent != null) {
                results.setResult(metaDataComponent, componentsWillBeProcessed ? Result.PROCESS_COMPONENT : Result.PROCESSING_NOT_REQUIRED, null);
            }
        }
        return results;
    }

    private List<String> getSupersedingPatches(BaseInfoReference baseInfoReference, Patch patch, RegistryHelper registryHelper) {
        ArrayList<String> supersedingPatches = new ArrayList<String>();
        List<SessionInfo> sortedSessionInfos = baseInfoReference.getSortedSessions();
        SessionInfo currentPatchSession = registryHelper.getSessionInfoForPatch(sortedSessionInfos, patch.getPatchUpi());
        if (currentPatchSession == null) {
            throw new IllegalStateException("Unable to locate session info for patch " + patch.getPatchUpi());
        }
        int currentPatchSessionId = currentPatchSession.getId();
        List<SessionInfo> patchSessions = registryHelper.filterSessionInfos(sortedSessionInfos, SessionAction.upgrade, SessionAction.patch);
        for (SessionInfo sessionInfo : patchSessions) {
            if (sessionInfo.getId() <= currentPatchSessionId) continue;
            supersedingPatches.add(sessionInfo.getPatchIds());
        }
        return supersedingPatches;
    }

    private Result getApplyVersionCompareResult(PatchInventory.Component patchComponent, ComponentReference installedComponent, boolean upgradePatch) {
        Version installedVer;
        Result result = Result.VERSION_MISMATCH;
        Version patchesCompVer = new Version(patchComponent.getVersion());
        int versionCompare = patchesCompVer.compareTo(installedVer = new Version(installedComponent.getVersion()));
        if (versionCompare == 0) {
            int patchLevelCompare = this.comparePatchLevels(patchComponent.getPatchLevel(), installedComponent.getPatchLevel());
            if (upgradePatch) {
                result = patchLevelCompare <= 0 ? Result.PROCESSING_NOT_REQUIRED : Result.PROCESS_COMPONENT;
            } else if (patchLevelCompare == 0) {
                result = Result.PROCESS_COMPONENT;
            }
        } else if (upgradePatch && versionCompare < 0) {
            result = Result.PROCESSING_NOT_REQUIRED;
        }
        return result;
    }

    private int comparePatchLevels(String patchLevelA, String patchLevelB) {
        Version patchComponentPatchLevelVersion = new Version(StringUtil.isNullOrEmpty((String)patchLevelA, (boolean)true) ? "0" : patchLevelA);
        Version installedComponentPatchLevelVersion = new Version(StringUtil.isNullOrEmpty((String)patchLevelB, (boolean)true) ? "0" : patchLevelB);
        return patchComponentPatchLevelVersion.compareTo(installedComponentPatchLevelVersion);
    }

    private String getVersionDescription(ComponentReference componentReference) {
        return this.getVersionDescription(componentReference.getVersion(), componentReference.getPatchLevel());
    }

    private String getVersionDescription(PatchInventory.Component patchComponent) {
        return this.getVersionDescription(patchComponent.getVersion(), patchComponent.getPatchLevel());
    }

    private String getVersionDescription(String baseVersion, String patchLevel) {
        String versionDescription = baseVersion;
        if (!StringUtil.isNullOrEmpty((String)patchLevel, (boolean)true)) {
            versionDescription = versionDescription + " " + NLS.getString("PatchHandlerImpl.patch.level") + " " + patchLevel;
        }
        return versionDescription;
    }

    @Override
    public void processPatch(Patch patch, boolean rollback, List<File> affectedFiles, PatchCheckResults patchCheckResults) throws GdrException {
        HashMap<FileState, List<Path>> affectedFilePaths = new HashMap<FileState, List<Path>>();
        ArrayList<Path> paths = new ArrayList<Path>();
        affectedFilePaths.put(FileState.MODIFIED, paths);
        for (File file : affectedFiles) {
            paths.add(NioHelper.getInstance().getPath(file));
        }
        this.processPatchUsingPaths(patch, rollback, affectedFilePaths, null, patchCheckResults);
    }

    @Override
    public void processPatchUsingPaths(Patch patch, boolean rollback, Map<FileState, List<Path>> affectedFilePathsMap, Map<ComponentReference, Map<Path, Path>> overwrittenFilesMap, PatchCheckResults patchCheckResults) throws GdrException {
        this.processPatchUsingPaths(patch, rollback, affectedFilePathsMap, overwrittenFilesMap, patchCheckResults, false, false);
    }

    @Override
    public void processPatchUsingPaths(Patch patch, boolean rollback, Map<FileState, List<Path>> affectedFilePathsMap, Map<ComponentReference, Map<Path, Path>> overwrittenFilesMap, PatchCheckResults patchCheckResults, boolean metaDataPatch, boolean disableLibRegen) throws GdrException {
        this.processPatchUsingPaths(patch, null, rollback, affectedFilePathsMap, overwrittenFilesMap, patchCheckResults, false, false);
    }

    @Override
    public void processPatchUsingPaths(Patch patch, com.oracle.cie.gdr.dao.pch.Patch daoPatch, boolean rollback, Map<FileState, List<Path>> affectedFilePathsMap, Map<ComponentReference, Map<Path, Path>> overwrittenFilesMap, PatchCheckResults patchCheckResults, boolean metaDataPatch, boolean disableLibRegen) throws GdrException {
        block37: {
            Set failures;
            if (patch == null) {
                LocalizedGdrException ex = new LocalizedGdrException("70002");
                _log.throwing(PatchHandlerImpl.class.getName(), "processPatch", (Throwable)((Object)ex));
                throw ex;
            }
            if (patchCheckResults == null) {
                patchCheckResults = this.getPatchCheckResults(patch, rollback);
            }
            if (!(failures = patchCheckResults.getFailureResults()).isEmpty()) {
                LocalizedGdrException ex = new LocalizedGdrException("70003", null, failures);
                _log.throwing(PatchHandlerImpl.class.getName(), "processPatch", (Throwable)((Object)ex));
                throw ex;
            }
            Registry unmodifiedRegistry = this.getLockedRegistry().copy();
            Map<Reference, Component> previousComponentStates = ComponentMetaDataPatchHandler.loadCurrentComponents(this, patchCheckResults);
            ArrayList<Path> affectedFilePaths = new ArrayList<Path>();
            if (affectedFilePathsMap != null) {
                for (List<Path> paths : affectedFilePathsMap.values()) {
                    if (paths == null) continue;
                    affectedFilePaths.addAll(paths);
                }
            }
            try {
                LocalizedGdrException ex;
                if (metaDataPatch) {
                    boolean registryModified = !rollback ? ComponentMetaDataPatchHandler.applyUpdatePatchRegistryEntries(this, patch, patchCheckResults) : ComponentMetaDataPatchHandler.rollbackUpdatePatchRegistryEntries(this, patch);
                    this.unlockRegistry(registryModified);
                    break block37;
                }
                if (patch.getPatchSubType() != PatchSubType.UPGRADE) {
                    this.processUpdatePatch(patch, daoPatch, patchCheckResults, rollback, RegenerationHelper.getInstance());
                    this.unlockRegistry(true);
                    this.updateProductVars(patchCheckResults, previousComponentStates);
                    if (!rollback) {
                        this.executeStringSubs(patch, affectedFilePaths, patchCheckResults);
                    } else {
                        this.restoreStringSubsTemplateBackup(patch, patchCheckResults, unmodifiedRegistry);
                    }
                    if (!disableLibRegen) {
                        this.regenerateLibraries(patch, affectedFilePaths);
                    }
                    break block37;
                }
                if (!rollback) {
                    try {
                        this.applyDistributionUpgradePatches(patch);
                    }
                    catch (Exception e) {
                        ex = new LocalizedGdrException("70007", e, this.getHome());
                        _log.throwing(PatchHandlerImpl.class.getName(), "processPatch", (Throwable)((Object)ex));
                        throw ex;
                    }
                    try {
                        this.applyFeatureSetUpgradePatches(patch);
                    }
                    catch (Exception e) {
                        ex = new LocalizedGdrException("70008", e, this.getHome());
                        _log.throwing(PatchHandlerImpl.class.getName(), "processPatch", (Throwable)((Object)ex));
                        throw ex;
                    }
                    try {
                        this.applyComponentUpgradePatches(patch, patchCheckResults, affectedFilePaths);
                    }
                    catch (Exception e) {
                        ex = new LocalizedGdrException("70009", e, this.getHome());
                        _log.throwing(PatchHandlerImpl.class.getName(), "processPatch", (Throwable)((Object)ex));
                        throw ex;
                    }
                }
                try {
                    this.rollbackComponentUpgradePatches(patch, patchCheckResults, overwrittenFilesMap);
                }
                catch (Exception e) {
                    ex = new LocalizedGdrException("70012", e, this.getHome());
                    _log.throwing(PatchHandlerImpl.class.getName(), "processPatch", (Throwable)((Object)ex));
                    throw ex;
                }
                try {
                    this.rollbackDistributionUpgradePatches(patch);
                }
                catch (Exception e) {
                    ex = new LocalizedGdrException("70010", e, this.getHome());
                    _log.throwing(PatchHandlerImpl.class.getName(), "processPatch", (Throwable)((Object)ex));
                    throw ex;
                }
                try {
                    this.rollbackFeatureSetUpgradePatches(patch);
                }
                catch (Exception e) {
                    ex = new LocalizedGdrException("70011", e, this.getHome());
                    _log.throwing(PatchHandlerImpl.class.getName(), "processPatch", (Throwable)((Object)ex));
                    throw ex;
                }
                this.unlockRegistry(true);
                this.updateProductVars(patchCheckResults, previousComponentStates);
                if (!rollback) {
                    this.executeStringSubs(patch, affectedFilePaths, patchCheckResults);
                } else {
                    this.restoreStringSubsTemplateBackup(patch, patchCheckResults, unmodifiedRegistry);
                }
                if (!Boolean.getBoolean(_disableSystemLibRegen) && !disableLibRegen) {
                    this.regenerateLibraries(patch, affectedFilePaths);
                }
            }
            catch (Exception e) {
                try {
                    _log.log(Level.SEVERE, "Patch processing failed, attempting to revert changes....", e);
                    this.revertChanges(unmodifiedRegistry);
                }
                catch (Throwable t) {
                    _log.log(Level.SEVERE, "Failed to revert patching changes.", t);
                }
                throw e;
            }
            finally {
                try {
                    this.unlockRegistry(false);
                }
                catch (GdrException e) {
                    _log.log(Level.SEVERE, "Failed to unlock registry.", e);
                }
            }
        }
    }

    @Override
    public void analyzePatch(Set<Distribution> distributionsToUpgrade, Set<FeatureSet> featureSetsToAdd, Set<FeatureSet> featureSetsToRemove, Set<FeatureSet> featureSetsToUpgrade, Map<InventoryComponentInfo, Component> componentsToAdd, Map<InventoryComponentInfo, Component> componentsToRemove, InventoryComponentInfo metaDataComponent) throws GdrException {
        try {
            this.analyzeDistributionUpgradePatches();
            this.analyzeFeatureSetUpgradePatches();
            this.analyzeComponentUpgradePatches();
            this.validateMetaData(distributionsToUpgrade, featureSetsToAdd, featureSetsToRemove, featureSetsToUpgrade, componentsToAdd, componentsToRemove, metaDataComponent);
        }
        catch (DataHandlerException | GdrException | IOException e) {
            LocalizedGdrException ex = new LocalizedGdrException("70017", e, this.getHome());
            _log.throwing(PatchHandlerImpl.class.getName(), "analyzePatch", (Throwable)((Object)ex));
            throw ex;
        }
    }

    private void validateMetaData(Set<Distribution> distributionsToUpgrade, Set<FeatureSet> featureSetsToAdd, Set<FeatureSet> featureSetsToRemove, Set<FeatureSet> featureSetsToUpgrade, Map<InventoryComponentInfo, Component> componentsToAdd, Map<InventoryComponentInfo, Component> componentsToRemove, InventoryComponentInfo metaDataComponent) throws GdrException {
        if (metaDataComponent != null) {
            Component comp;
            Object details;
            Distribution dist;
            PatchInventoryImpl im;
            PatchInventoryImpl patchInventoryImpl = im = new PatchInventoryImpl();
            Objects.requireNonNull(patchInventoryImpl);
            PatchInventoryImpl.ComponentImpl metaDataPatchComponent = new PatchInventoryImpl.ComponentImpl(patchInventoryImpl, metaDataComponent.getName(), metaDataComponent.getVersion(), metaDataComponent.getPatchLevel(), "");
            ComponentCheckResult metaDataCompCheckResult = PatchFactoryImpl.instance().createComponentCheckResult((PatchInventory.Component)metaDataPatchComponent);
            metaDataCompCheckResult.setResult(Result.PROCESS_COMPONENT);
            for (FeatureSet featureSet : featureSetsToAdd) {
                dist = null;
                for (Map.Entry<Distribution, Set<FeatureSet>> entry : this.getFeatureSetMetaDataPatchHandler().getDistributionMap().entrySet()) {
                    if (!entry.getValue().contains(featureSet)) continue;
                    dist = entry.getKey();
                    break;
                }
                if (dist == null) {
                    metaDataCompCheckResult.setResult(Result.METADATA_ERROR);
                    String details2 = "Distribution not found for FeatureSet " + featureSet.getName() + " " + featureSet.getVersion();
                    metaDataCompCheckResult.setDetails(details2);
                    _log.severe(details2);
                    break;
                }
                block4: for (DistributionTarget distributionTarget : this.getHome().getInstalledDistributions()) {
                    Set<FeatureSet> set = distributionTarget.getInstalledFeatureSets();
                    if (distributionTarget.getDistributionName().equals(dist.getName())) {
                        if (set.contains(featureSet)) {
                            _log.warning("FeatureSet " + featureSet.getName() + " " + featureSet.getVersion() + " is already installed. Skipping.");
                            continue;
                        }
                        for (FeatureSet featureSet2 : set) {
                            if (!featureSet2.getName().equals(featureSet.getName()) || !featureSet.isSingleton()) continue;
                            metaDataCompCheckResult.setResult(Result.METADATA_ERROR);
                            details = "FeatureSet " + featureSet2.getName() + " " + featureSet2.getVersion() + " is already installed in the Home and is singleton. Installation of version " + featureSet.getVersion() + " can't proceed";
                            metaDataCompCheckResult.setDetails((String)details);
                            _log.severe((String)details);
                            continue block4;
                        }
                        continue;
                    }
                    for (FeatureSet featureSet3 : set) {
                        if (!featureSet3.getName().equals(featureSet.getName()) || VersionHelper.compare((String)featureSet3.getVersion(), (String)featureSet.getVersion()) <= 0) continue;
                        metaDataCompCheckResult.setResult(Result.METADATA_ERROR);
                        details = "FeatureSet " + featureSet.getName() + " " + featureSet.getVersion() + " already has a higher version installed as part of Distribution " + distributionTarget.getDistributionName() + " " + distributionTarget.getDistributionVersion();
                        metaDataCompCheckResult.setDetails((String)details);
                        _log.severe((String)details);
                        continue block4;
                    }
                }
            }
            block7: for (FeatureSet featureSet : featureSetsToRemove) {
                FeatureSetReference featureRef = new FeatureSetReference(featureSet.getName(), featureSet.getVersion());
                Object dist2 = null;
                for (Map.Entry<Distribution, Set<FeatureSet>> entry : this.getFeatureSetMetaDataPatchHandler().getDistributionMap().entrySet()) {
                    if (!entry.getValue().contains(featureSet)) continue;
                    dist2 = entry.getKey();
                    break;
                }
                if (dist2 == null) {
                    _log.warning("Distribution not found for FeatureSet " + featureSet.getName() + " " + featureSet.getVersion() + ", the featureset will be deinstalled from all distributions.");
                    break;
                }
                block9: for (DistributionTarget distributionTarget : this.getHome().getInstalledDistributions()) {
                    if (!distributionTarget.getDistributionName().equals(((Distribution)dist2).getName())) continue;
                    if (distributionTarget.getFeatureSet(featureSet.getName(), featureSet.getVersion()) == null) {
                        _log.warning("FeatureSet " + featureSet.getName() + " " + featureSet.getVersion() + " is not currently installed for Distribution " + distributionTarget.getDistributionName() + " " + distributionTarget.getDistributionVersion() + ". Skipping deinstallation.");
                        continue block7;
                    }
                    for (FeatureSetGroup featureSetGroup : distributionTarget.getDistribution().getFeatureSetGroups()) {
                        if (!featureSetGroup.getFeatures().contains((Object)featureRef)) continue;
                        if (distributionsToUpgrade.isEmpty()) {
                            metaDataCompCheckResult.setResult(Result.METADATA_ERROR);
                            details = "Reference for FeatureSet " + featureSet.getName() + " " + featureSet.getVersion() + " has not been removed from installed distribution " + distributionTarget.getDistributionName() + " " + distributionTarget.getDistributionVersion();
                            metaDataCompCheckResult.setDetails((String)details);
                            _log.severe((String)details);
                            continue block9;
                        }
                        for (Distribution upgradedDist : distributionsToUpgrade) {
                            if (!upgradedDist.getName().equals(distributionTarget.getDistributionName())) continue;
                            for (FeatureSetGroup upgradedFeatureGroup : upgradedDist.getFeatureSetGroups()) {
                                if (!upgradedFeatureGroup.getFeatures().contains((Object)featureRef)) continue;
                                metaDataCompCheckResult.setResult(Result.METADATA_ERROR);
                                String details3 = "Reference for FeatureSet " + featureSet.getName() + " " + featureSet.getVersion() + " has not been removed from installed distribution " + distributionTarget.getDistributionName() + " " + distributionTarget.getDistributionVersion();
                                metaDataCompCheckResult.setDetails(details3);
                                _log.severe(details3);
                                break;
                            }
                            if (!metaDataCompCheckResult.getResult().equals((Object)Result.METADATA_ERROR)) continue;
                            break;
                        }
                        if (!metaDataCompCheckResult.getResult().equals((Object)Result.METADATA_ERROR)) continue;
                        continue block9;
                    }
                }
            }
            block13: for (FeatureSet featureSet : featureSetsToUpgrade) {
                dist = null;
                for (Map.Entry<Distribution, Set<FeatureSet>> entry : this.getFeatureSetMetaDataPatchHandler().getDistributionMap().entrySet()) {
                    if (!entry.getValue().contains(featureSet)) continue;
                    dist = entry.getKey();
                    break;
                }
                if (dist == null && !featureSet.isSingleton()) {
                    _log.warning("Distribution not found for FeatureSet " + featureSet.getName() + " " + featureSet.getVersion());
                }
                for (DistributionTarget distributionTarget : this.getHome().getInstalledDistributions()) {
                    Set<FeatureSet> set = distributionTarget.getInstalledFeatureSets();
                    boolean found = false;
                    if (dist != null && distributionTarget.getDistributionName().equals(dist.getName())) {
                        if (set.contains(featureSet)) {
                            found = true;
                            _log.warning("FeatureSet " + featureSet.getName() + " " + featureSet.getVersion() + " is already installed. Skipping.");
                        } else {
                            for (FeatureSet installedFeature : set) {
                                if (!installedFeature.getName().equals(featureSet.getName())) continue;
                                found = true;
                                if (VersionHelper.compare((String)installedFeature.getVersion(), (String)featureSet.getVersion()) <= 0) break;
                                _log.warning("FeatureSet " + installedFeature.getName() + " " + installedFeature.getVersion() + " is already installed in the Home. Upgrade of version " + featureSet.getVersion() + " will be skipped.");
                                break;
                            }
                        }
                        if (!found) {
                            _log.warning("FeatureSet " + featureSet.getName() + " not found in the distribution " + dist + ", upgrade can't continue.");
                        }
                    }
                    if (!found) continue;
                    continue block13;
                }
            }
            if (!metaDataCompCheckResult.getResult().isMetaDataError()) {
                Set<FeatureSet> installedFeatures2 = this.getHome().getInstalledFeatures();
                block17: for (FeatureSet featureToUpgrade : featureSetsToUpgrade) {
                    Iterator<FeatureSet> it3 = installedFeatures2.iterator();
                    while (it3.hasNext()) {
                        FeatureSet featureSet = it3.next();
                        if (!featureSet.getName().equals(featureToUpgrade.getName()) || VersionHelper.compare((String)featureToUpgrade.getVersion(), (String)featureSet.getVersion()) <= 0) continue;
                        featureToUpgrade.addReplaces(featureSet);
                        it3.remove();
                        continue block17;
                    }
                }
                installedFeatures2.addAll(featureSetsToUpgrade);
                installedFeatures2.removeAll(featureSetsToRemove);
                HashSet<FeatureSet> hashSet = new HashSet<FeatureSet>();
                hashSet.addAll(installedFeatures2);
                hashSet.addAll(featureSetsToAdd);
                FeatureSelectionTarget selectionTarget = FeatureSelectionTargetFactory.getFeatureSelectionTarget(hashSet, null);
                List ordered = selectionTarget.getOrderedItems();
                try {
                    for (FeatureSet featureSet : ordered) {
                        if (selectionTarget.isInstalled(featureSet) || selectionTarget.isSelected(featureSet)) continue;
                        selectionTarget.selectWithPrerequisites(featureSet, true);
                    }
                }
                catch (Exception exception) {
                    String string = "Error validating the FeatureSet metadata: " + exception.getMessage();
                    _log.severe(string);
                    _log.throwing(this.getClass().getName(), "validateMetaData", exception);
                    metaDataCompCheckResult.setResult(Result.METADATA_ERROR);
                    metaDataCompCheckResult.setDetails(string);
                }
            }
            ((InventoryComponentInfoImpl)metaDataComponent).setComponentCheckResult(metaDataCompCheckResult);
            for (Map.Entry entry : componentsToAdd.entrySet()) {
                comp = (Component)entry.getValue();
                boolean found = false;
                PatchInventoryImpl patchInventoryImpl2 = im;
                Objects.requireNonNull(patchInventoryImpl2);
                PatchInventoryImpl.ComponentImpl componentImpl = new PatchInventoryImpl.ComponentImpl(patchInventoryImpl2, comp.getName(), comp.getVersion(), comp.getPatchLevel(), "");
                ComponentCheckResult componentCheckResult = PatchFactoryImpl.instance().createComponentCheckResult((PatchInventory.Component)componentImpl);
                if (this.getHome().getInstalledComponent(comp.getName(), comp.getVersion(), comp.getPatchLevel()) != null) {
                    found = true;
                    componentCheckResult.setResult(Result.PROCESSING_NOT_REQUIRED);
                }
                if (!found) {
                    for (Map.Entry<FeatureSet, Set<Component>> entry2 : this.getComponentMetaDataPatchHandler().getFeatureSetMap().entrySet()) {
                        if (!entry2.getValue().contains(comp)) continue;
                        found = true;
                        componentCheckResult.setResult(Result.PROCESS_COMPONENT);
                        comp.setSingleton(entry2.getKey().isSingleton());
                        break;
                    }
                }
                if (!found) {
                    String details5 = "Unable to calculate parent FeatureSet for component " + comp;
                    componentCheckResult.setResult(Result.METADATA_ERROR);
                    componentCheckResult.setDetails(details5);
                    _log.severe(details5);
                } else {
                    for (ComponentReference componentReference : this.getHome().getInstalledComponents()) {
                        if (!componentReference.getName().equals(comp.getName()) || !componentReference.isSingleton() && !comp.isSingleton()) continue;
                        found = true;
                        details = "Component " + comp + " singleton: " + comp.isSingleton() + " cannot be installed because component " + (Object)((Object)componentReference) + " singleton: " + componentReference.isSingleton() + " is already installed in the Home.";
                        componentCheckResult.setResult(Result.METADATA_ERROR);
                        componentCheckResult.setDetails((String)details);
                        _log.severe((String)details);
                        break;
                    }
                }
                ((InventoryComponentInfoImpl)entry.getKey()).setComponentCheckResult(componentCheckResult);
            }
            for (Map.Entry entry : componentsToRemove.entrySet()) {
                comp = (Component)entry.getValue();
                boolean found = false;
                PatchInventoryImpl patchInventoryImpl3 = im;
                Objects.requireNonNull(patchInventoryImpl3);
                PatchInventoryImpl.ComponentImpl componentImpl = new PatchInventoryImpl.ComponentImpl(patchInventoryImpl3, comp.getName(), comp.getVersion(), comp.getPatchLevel(), "");
                ComponentCheckResult componentCheckResult = PatchFactoryImpl.instance().createComponentCheckResult((PatchInventory.Component)componentImpl);
                for (Map.Entry<FeatureSet, Set<Component>> entry3 : this.getComponentMetaDataPatchHandler().getFeatureSetMap().entrySet()) {
                    if (!entry3.getValue().contains(comp)) continue;
                    found = true;
                    componentCheckResult.setResult(Result.PROCESS_COMPONENT);
                    break;
                }
                if (!found) {
                    if (this.getHome().getInstalledComponent(comp.getName(), comp.getVersion()) == null) {
                        componentCheckResult.setResult(Result.IGNORE_NOT_FOUND);
                    } else {
                        String details2 = "Parent FeatureSet for Component " + comp.getName() + " " + comp.getVersion() + " could not be calculated.";
                        _log.severe(details2);
                        componentCheckResult.setResult(Result.METADATA_ERROR);
                        componentCheckResult.setDetails(details2);
                    }
                }
                ((InventoryComponentInfoImpl)entry.getKey()).setComponentCheckResult(componentCheckResult);
            }
        }
    }

    private void revertChanges(Registry unmodifiedRegistry) throws GdrException {
        if (!this.getHome().isRegistryLocked() && unmodifiedRegistry != null) {
            Registry registry = this.getLockedRegistry();
            registry.setDistributions(unmodifiedRegistry.getDistributions());
            registry.setSessions(unmodifiedRegistry.getSessions());
            this.unlockRegistry(true);
        }
        for (Path file : this.getCreatedFiles()) {
            try {
                Files.delete(file);
            }
            catch (IOException e) {
                _log.log(Level.SEVERE, "Failed to delete file: " + file, e);
            }
        }
    }

    @Override
    public void processUpdatePatch(Patch patch, com.oracle.cie.gdr.dao.pch.Patch daoPatch, PatchCheckResults patchCheckResults, boolean rollback, RegenerationHelper libraryRegenerationHelper) throws GdrException {
        HashSet<String> patchIDs = new HashSet<String>(Arrays.asList(patch.getPatchUpi()));
        this.processUpdatePatch(daoPatch, patchIDs, rollback, libraryRegenerationHelper, true, false);
        if (!rollback) {
            ComponentMetaDataPatchHandler.applyUpdatePatchRegistryEntries(this, patch, patchCheckResults);
            FeatureSetMetaDataPatchHandler.applyUpdatePatchRegistryEntries(this, patch, libraryRegenerationHelper.getModifiedFeatureSets());
        } else {
            ComponentMetaDataPatchHandler.rollbackUpdatePatchRegistryEntries(this, patch);
            FeatureSetMetaDataPatchHandler.rollbackUpdatePatchRegistryEntries(this, patch);
        }
    }

    public void processUpdatePatch(Patch patch, PatchCheckResults patchCheckResults, boolean rollback, RegenerationHelper libraryRegenerationHelper) throws GdrException {
        this.processUpdatePatch(patch, null, patchCheckResults, rollback, libraryRegenerationHelper);
    }

    @Override
    public void processUpdatePatch(String patchID, boolean rollback, RegenerationHelper regenerationHelper) throws GdrException {
        HashSet<String> patchIDs = new HashSet<String>(Arrays.asList(patchID));
        this.processUpdatePatch(patchIDs, rollback, regenerationHelper, false, false);
    }

    @Override
    public void processUpdatePatch(Set<String> patchIDs, boolean rollback, RegenerationHelper regenerationHelper) throws GdrException {
        this.processUpdatePatch(patchIDs, rollback, regenerationHelper, false, true);
    }

    private void processUpdatePatch(Set<String> patchIDs, boolean rollback, RegenerationHelper regenerationHelper, boolean internal, boolean backupFiles) throws GdrException {
        this.processUpdatePatch(null, patchIDs, rollback, regenerationHelper, internal, backupFiles);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processUpdatePatch(com.oracle.cie.gdr.dao.pch.Patch daoPatch, Set<String> patchIDs, boolean rollback, RegenerationHelper regenerationHelper, boolean internal, boolean backupFiles) throws GdrException {
        if (!rollback) {
            try {
                Map<String, Set<FeatureSet>> affectedFeatures = FeatureSetMetaDataPatchHandler.processFeatureSetUpdatePatches(this);
                regenerationHelper.addModifiedFeatureSets(affectedFeatures);
                Map<String, Set<Component>> affectedComponents = ComponentMetaDataPatchHandler.processComponentUpdatePatches(this, daoPatch);
                regenerationHelper.addModifiedComponents(affectedComponents);
                if (internal || affectedFeatures.isEmpty() && affectedComponents.isEmpty()) return;
                this._home.refresh();
                return;
            }
            catch (Exception e) {
                LocalizedGdrException ex = new LocalizedGdrException("70005", e, this.getHome());
                _log.throwing(PatchHandlerImpl.class.getName(), "processUpdatePatch", (Throwable)((Object)ex));
                throw ex;
            }
        }
        try {
            Map<String, Set<Component>> affectedComponents = ComponentMetaDataPatchHandler.removeComponentUpdatePatch(this, patchIDs, backupFiles);
            regenerationHelper.addModifiedComponents(affectedComponents);
            Map<String, Set<FeatureSet>> affectedFeatures = FeatureSetMetaDataPatchHandler.removeFeatureSetUpdatePatch((InternalPatchHandler)this, patchIDs);
            regenerationHelper.addModifiedFeatureSets(affectedFeatures);
            return;
        }
        catch (Exception e) {
            LocalizedGdrException ex = new LocalizedGdrException("70006", e, this.getHome());
            _log.throwing(PatchHandlerImpl.class.getName(), "processUpdatePatch", (Throwable)((Object)ex));
            throw ex;
        }
    }

    private void analyzeDistributionUpgradePatches() throws GdrException, IOException, DataHandlerException {
        this._distributionMetaDataPatchHandler.analyzeUpgradePatches();
    }

    private void applyDistributionUpgradePatches(Patch patch) throws GdrException, IOException, DataHandlerException {
        this._distributionMetaDataPatchHandler.setPatch(patch);
        this._distributionMetaDataPatchHandler.applyUpgradePatches();
    }

    private void rollbackDistributionUpgradePatches(Patch patch) throws GdrException, IOException, DataHandlerException {
        DistributionMetaDataPatchHandler distributionMetaDataPatchHandler = new DistributionMetaDataPatchHandler(this, patch);
        distributionMetaDataPatchHandler.rollbackUpgradePatches();
    }

    private void analyzeFeatureSetUpgradePatches() throws GdrException, IOException, DataHandlerException {
        this._featureSetMetaDataPatchHandler.analyzeUpgradePatches();
    }

    private void applyFeatureSetUpgradePatches(Patch patch) throws GdrException, IOException, DataHandlerException {
        this._featureSetMetaDataPatchHandler.setPatch(patch);
        this._featureSetMetaDataPatchHandler.applyUpgradePatches();
    }

    private void rollbackFeatureSetUpgradePatches(Patch patch) throws GdrException, IOException, DataHandlerException {
        FeatureSetMetaDataPatchHandler featureSetMetaDataPatchHandler = new FeatureSetMetaDataPatchHandler(this, patch);
        featureSetMetaDataPatchHandler.rollbackUpgradePatches();
    }

    private void analyzeComponentUpgradePatches() throws GdrException, IOException, DataHandlerException {
        this._componentMetaDataPatchHandler.analyzeUpgradePatches();
    }

    private void applyComponentUpgradePatches(Patch patch, PatchCheckResults patchCheckResults, List<Path> affectedFilePaths) throws GdrException, IOException, DataHandlerException {
        this._componentMetaDataPatchHandler.setPatch(patch);
        this._componentMetaDataPatchHandler.setPatchCheckResults(patchCheckResults);
        this._componentMetaDataPatchHandler.setAffectedFilePaths(affectedFilePaths);
        this._componentMetaDataPatchHandler.applyUpgradePatches();
    }

    private void rollbackComponentUpgradePatches(Patch patch, PatchCheckResults patchCheckResults, Map<ComponentReference, Map<Path, Path>> overwrittenFilesMap) throws GdrException, IOException, DataHandlerException {
        ComponentMetaDataPatchHandler componentMetaDataPatchHandler = new ComponentMetaDataPatchHandler(this, patch, patchCheckResults, null);
        componentMetaDataPatchHandler.setOverwrittenFiles(overwrittenFilesMap);
        componentMetaDataPatchHandler.rollbackUpgradePatches();
        componentMetaDataPatchHandler.restoreOverwrittenFiles();
    }

    private void executeStringSubs(Patch patch, List<Path> affectedFiles, PatchCheckResults patchCheckResults) throws GdrException {
        Set processedComponents = patchCheckResults.getComponentCheckResults(new Result[]{Result.PROCESS_COMPONENT});
        if (!processedComponents.isEmpty() && affectedFiles != null && !affectedFiles.isEmpty()) {
            boolean globalObjectStoreInitialized = false;
            LinkedHashMap<Component, ArrayList<StringsubsGroup>> stringSubGroupMap = new LinkedHashMap<Component, ArrayList<StringsubsGroup>>();
            Home home = this.getHome();
            VariableResolverService variableService = VariableResolverService.getVariableResolverService();
            ComponentHelper compHelper = ComponentHelper.getInstance(home.getClassLoader());
            Path componentMetadataHome = home.getMetaDataHome().getComponentMetaDataHomePath();
            for (ComponentCheckResult componentCheckResult : processedComponents) {
                Stringsubs componentStringSubs;
                List<StringsubsGroup> stringSubsGroups;
                PatchInventory.Component patchComponent = componentCheckResult.getComponent();
                if ("oracle.nextgen.metadata".equals(patchComponent.getName())) continue;
                QuickReference compRef = new QuickReference(patchComponent.getName(), patchComponent.getVersion());
                Component component = this._componentCache.get((Object)compRef);
                if (component == null) {
                    try {
                        component = compHelper.getComponentArchiveFromShipHome(componentMetadataHome, (Reference)compRef);
                        this._componentCache.put(compRef, component);
                    }
                    catch (Exception e) {
                        _log.log(Level.WARNING, "Failed to load component: " + (Object)((Object)compRef), e);
                        continue;
                    }
                }
                if ((stringSubsGroups = (componentStringSubs = component.getStringsubs()) != null ? componentStringSubs.getGroups() : null) == null || stringSubsGroups.isEmpty()) continue;
                if (!globalObjectStoreInitialized) {
                    if (this.getStringSubsEnvHandler() != null) {
                        this.getStringSubsEnvHandler().initVariables(variableService.getGlobalObjectStore());
                    }
                    globalObjectStoreInitialized = true;
                }
                component.setComponentTargets(ComponentMetaDataPatchHandler.getComponentTargets(home, component));
                IObjectStore componentObjectStore = variableService.getObjectStore(component.getNamespace());
                compHelper.initComponentVariables(Collections.singletonList(component), variableService);
                Set<Home> fohSet = home.getAllFederatedHomes(true);
                for (Home foh : fohSet) {
                    if (HomeHelper.isLegacyHome(foh.getHomePath())) continue;
                    for (String productFamily : foh.getProductFamilies()) {
                        componentObjectStore.storeAll(ProductFamilyService.getInstance().generateProductFamilyVariables(productFamily, foh.getHome().getAbsoluteFile()));
                    }
                }
                for (StringsubsGroup stringsubsGroup : stringSubsGroups) {
                    LinkedHashMap<Path, StringsubsFileEntry> patchedStringSubsFileEntries = new LinkedHashMap<Path, StringsubsFileEntry>();
                    List<StringsubsFileEntry> fileEntries = stringsubsGroup.getFileEntries();
                    for (StringsubsFileEntry fileEntry : fileEntries) {
                        Path stringSubFile = NioHelper.getInstance().getPath(componentObjectStore.substitute(fileEntry.getName()), new String[0]);
                        if (!affectedFiles.contains(stringSubFile)) continue;
                        patchedStringSubsFileEntries.put(stringSubFile, fileEntry);
                    }
                    if (patchedStringSubsFileEntries.isEmpty()) continue;
                    stringsubsGroup.setFileEntries(new ArrayList<StringsubsFileEntry>(patchedStringSubsFileEntries.values()));
                    ArrayList<StringsubsGroup> groups = (ArrayList<StringsubsGroup>)stringSubGroupMap.get(component);
                    if (groups == null) {
                        groups = new ArrayList<StringsubsGroup>();
                        stringSubGroupMap.put(component, groups);
                    }
                    groups.add(stringsubsGroup);
                }
            }
            if (!stringSubGroupMap.isEmpty()) {
                try {
                    Path templatesLoc = home.getInventoryDirectoryPath().toRealPath(new LinkOption[0]).resolve("Templates");
                    Path templatesBackup = home.getInventoryDirectoryPath().toRealPath(new LinkOption[0]).resolve("Templates-Backup");
                    Path originalTemplatesBackup = templatesBackup.resolve("originals");
                    if (!Files.exists(originalTemplatesBackup, new LinkOption[0]) && Files.isDirectory(templatesLoc, new LinkOption[0])) {
                        Map<Path, Path> filesCopied = PatchHandlerImpl.copyDirectory(templatesLoc, originalTemplatesBackup);
                        if (this.getStringSubsEnvHandler() != null) {
                            this.getStringSubsEnvHandler().fixBackupPermissions(PatchHandlerImpl.convertFileMapToStringPaths(filesCopied));
                        }
                    }
                    for (Map.Entry entry : stringSubGroupMap.entrySet()) {
                        StringsubsDefinition stringSubsDefinition = ComponentHelper.getInstance(home.getClassLoader()).getStringsubsDefinition((Component)entry.getKey(), (List)entry.getValue());
                        IObjectStore componentObjectStore = variableService.getObjectStore(((Component)entry.getKey()).getNamespace());
                        Map<String, String> backupFiles = ComponentHelper.getInstance(home.getClassLoader()).stringsub(stringSubsDefinition, componentObjectStore, templatesLoc, home.getHome().getAbsolutePath());
                        if (this.getStringSubsEnvHandler() != null) {
                            this.getStringSubsEnvHandler().fixBackupPermissions(backupFiles);
                        }
                        Path templatesBackupPatchDir = templatesBackup.resolve(patch.getPatchUpi()).resolve(((Component)entry.getKey()).getName() + "_" + ((Component)entry.getKey()).getVersion());
                        HashMap<String, String> patchBackupFiles = new HashMap<String, String>();
                        for (String backupPath : backupFiles.values()) {
                            Path patchDirBackupFile = templatesBackupPatchDir.resolve(backupPath.substring(templatesLoc.toString().length() + 1));
                            if (Files.exists(patchDirBackupFile, new LinkOption[0])) continue;
                            Path backupFile = NioHelper.getInstance().getPath(backupPath, new String[0]);
                            NioCopy.copyFile((Path)backupFile, (Path)patchDirBackupFile);
                            patchBackupFiles.put(backupPath, patchDirBackupFile.toAbsolutePath().toString());
                        }
                        if (this.getStringSubsEnvHandler() == null) continue;
                        this.getStringSubsEnvHandler().fixBackupPermissions(patchBackupFiles);
                    }
                }
                catch (Exception e) {
                    LocalizedGdrException ex = new LocalizedGdrException("70016", e, this.getHome(), patch.getPatchUpi());
                    _log.throwing(PatchHandlerImpl.class.getName(), "executeStringSubs", (Throwable)((Object)ex));
                    throw ex;
                }
            }
        }
    }

    private void restoreStringSubsTemplateBackup(Patch patch, PatchCheckResults patchCheckResults, Registry unmodifiedRegistry) {
        RegistryHelper registryHelper = RegistryHelper.getInstance(this.getHome().getClassLoader());
        List<ComponentInfo> componentInfosForPatch = registryHelper.getComponentInfosForPatch(unmodifiedRegistry, patch.getPatchUpi());
        if (!componentInfosForPatch.isEmpty()) {
            Path templatesLoc = this.getHome().getInventoryDirectoryPath().resolve("Templates");
            Path templatesBackup = this.getHome().getInventoryDirectoryPath().resolve("Templates-Backup");
            Set processResults = patchCheckResults.getComponentCheckResults(new Result[]{Result.PROCESS_COMPONENT});
            for (ComponentCheckResult result : processResults) {
                HashSet<String> originalPatchIds = new HashSet<String>();
                PatchInventory.Component component = result.getComponent();
                List<ComponentInfo> matchingCompInfos = registryHelper.getComponentInfos(componentInfosForPatch, component.getName(), component.getVersion(), false);
                for (ComponentInfo matchingCompInfo : matchingCompInfos) {
                    SessionInfo sessionInfo = registryHelper.getSessionInfoForPatch(matchingCompInfo, patch.getPatchUpi());
                    String originalPatchId = sessionInfo.getOriginatingPatchId();
                    if (StringUtil.isNullOrEmpty((String)originalPatchId, (boolean)true)) continue;
                    originalPatchIds.add(originalPatchId);
                }
                for (String patchId : originalPatchIds) {
                    Path templatesBackupPatchDir = templatesBackup.resolve(patchId);
                    Path templatesBackupPatchCompDir = templatesBackupPatchDir.resolve(component.getName() + "_" + component.getVersion());
                    if (!Files.isDirectory(templatesBackupPatchCompDir, new LinkOption[0])) continue;
                    try {
                        Map<Path, Path> filesCopied = PatchHandlerImpl.copyDirectory(templatesBackupPatchCompDir, templatesLoc);
                        if (this.getStringSubsEnvHandler() != null) {
                            this.getStringSubsEnvHandler().fixBackupPermissions(PatchHandlerImpl.convertFileMapToStringPaths(filesCopied));
                        }
                        NioDelete.delete((Path)templatesBackupPatchDir);
                    }
                    catch (IOException e) {
                        _log.warning("Failed to restore string subs backup files from " + templatesBackupPatchCompDir + " to " + templatesLoc);
                    }
                    NioDelete.delete((Path)templatesBackupPatchDir);
                }
            }
        }
    }

    private void updateProductVars(PatchCheckResults patchCheckResults, Map<Reference, Component> previousComponentStates) {
        Set processedComponents;
        if (!Boolean.getBoolean("PatchHandlerImpl.disable.productVars.update") && !(processedComponents = patchCheckResults.getComponentCheckResults(new Result[]{Result.PROCESS_COMPONENT})).isEmpty()) {
            try {
                Home home = this.getHome();
                Collection<DistributionTarget> distTargets = home.getInstalledDistributions();
                ComponentHelper compHelper = ComponentHelper.getInstance(home.getClassLoader());
                Path componentMetadataHome = home.getMetaDataHome().getComponentMetaDataHomePath();
                for (DistributionTarget distTarget : distTargets) {
                    Set<ComponentReference> compRefs = distTarget.getInstalledComponents();
                    HashMap<Component, Component> components = new HashMap<Component, Component>();
                    block5: for (ComponentReference compRef : compRefs) {
                        for (ComponentCheckResult componentCheckResult : processedComponents) {
                            PatchInventory.Component patchComponent = componentCheckResult.getComponent();
                            QuickReference quickRef = new QuickReference(patchComponent.getName(), patchComponent.getVersion());
                            if (!compRef.equals((Object)quickRef)) continue;
                            Component component = this._componentCache.get((Object)quickRef);
                            if (component == null) {
                                try {
                                    component = compHelper.getComponentArchiveFromShipHome(componentMetadataHome, (Reference)compRef);
                                    this._componentCache.put(quickRef, component);
                                }
                                catch (Exception e) {
                                    _log.log(Level.WARNING, "Failed to load component: " + (Object)((Object)quickRef), e);
                                }
                            }
                            Component previousComponentState = previousComponentStates.get((Object)quickRef);
                            if ((component == null || component.getProductVariables().isEmpty()) && (previousComponentState == null || previousComponentState.getProductVariables().isEmpty())) continue block5;
                            components.put(component, previousComponentState);
                            continue block5;
                        }
                    }
                    if (components.isEmpty()) continue;
                    DistributionHelper.getInstance().updateProductVariables(home.getInventoryDirectoryPath(), components, distTarget.getDistributionName(), distTarget.getDistributionVersion());
                }
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "Failed to update product variables.", e);
            }
        }
    }

    public static Map<String, String> convertFileMapToStringPaths(Map<Path, Path> map) {
        HashMap<String, String> stringMap = new HashMap<String, String>();
        if (map != null) {
            for (Map.Entry<Path, Path> entry : map.entrySet()) {
                stringMap.put(entry.getKey().toAbsolutePath().toString(), entry.getValue().toAbsolutePath().toString());
            }
        }
        return stringMap;
    }

    public static Map<Path, Path> copyDirectory(Path from, Path to) throws IOException {
        return PatchHandlerImpl.copyDirectory(from, to, null);
    }

    public static Map<Path, Path> copyDirectory(Path from, Path to, FileFilter filter) throws IOException {
        HashMap<Path, Path> filesCopied = new HashMap<Path, Path>();
        PatchHandlerImpl.copyDirectory(from, to, filter, filesCopied);
        return filesCopied;
    }

    public static void copyDirectory(Path from, Path to, FileFilter filter, Map<Path, Path> filesCopied) throws IOException {
        if (from == null || !Files.isDirectory(from, new LinkOption[0])) {
            throw new IllegalArgumentException("You must provide a valid directory to copy from.");
        }
        if (to == null || Files.exists(to, new LinkOption[0]) && !Files.isDirectory(to, new LinkOption[0])) {
            throw new IllegalArgumentException("You must provide a valid directory to copy to.");
        }
        if (!Files.exists(to, new LinkOption[0])) {
            Files.createDirectories(to, new FileAttribute[0]);
        }
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(from);){
            for (Path aFl : directoryStream) {
                if (Files.isDirectory(aFl, new LinkOption[0])) {
                    PatchHandlerImpl.copyDirectory(aFl, to.resolve(aFl.getFileName()), filter, filesCopied);
                    continue;
                }
                Path dest = to.resolve(aFl.getFileName());
                NioCopy.copy((Path)aFl, (Path)dest);
                if (filesCopied == null) continue;
                filesCopied.put(aFl, dest);
            }
        }
    }

    public void regenerateLibraries(Patch patch, List<Path> affectedFiles) throws LibraryException {
        LinkedHashMap<Path, Set<String>> affectedFilesMap = new LinkedHashMap<Path, Set<String>>();
        for (Path affectedFile : affectedFiles) {
            affectedFilesMap.put(this.getHome().getHomePath().relativize(this.getHome().getHomePath().resolve(affectedFile)), new LinkedHashSet());
        }
        LibraryGeneratorImpl libraryGenerator = new LibraryGeneratorImpl(this.getHome().getHome());
        String patchUPI = null;
        if (patch != null) {
            patchUPI = patch.getPatchUpi();
        }
        libraryGenerator.regenerateLibraryPaths(affectedFilesMap, patchUPI, false);
    }

    @Override
    public DistributionMetaDataPatchHandler getDistributionMetaDataPatchHandler() {
        return this._distributionMetaDataPatchHandler;
    }

    @Override
    public FeatureSetMetaDataPatchHandler getFeatureSetMetaDataPatchHandler() {
        return this._featureSetMetaDataPatchHandler;
    }

    @Override
    public ComponentMetaDataPatchHandler getComponentMetaDataPatchHandler() {
        return this._componentMetaDataPatchHandler;
    }
}

