/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.patch;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.Home;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.patch.HomeOperationsImpl;
import com.oracle.cie.gdr.patch.cin.CentralInventoryImpl;
import java.util.logging.Logger;
import oracle.glcm.common.inventory.api.CentralInventory;
import oracle.glcm.common.inventory.api.InventoryException;
import oracle.glcm.opatch.common.api.install.HomeOperations;
import oracle.glcm.opatch.common.api.install.HomeOperationsException;
import oracle.glcm.opatch.common.api.install.HomeOperationsServiceProvider;

public class HomeOperationsServiceProviderImpl
implements HomeOperationsServiceProvider {
    private static final Logger _log = Logger.getLogger(HomeOperationsServiceProviderImpl.class.getName());

    public boolean isHomeSupported(String homeDir) throws HomeOperationsException {
        return Home.isValidHome(NioHelper.getInstance().getPath(homeDir, new String[0]));
    }

    public HomeOperations getHomeOperationsInstance(String homeDir) throws HomeOperationsException {
        if (StringUtil.isNullOrEmpty((String)homeDir, (boolean)true)) {
            throw new HomeOperationsException("The home directory path provided was null or empty.");
        }
        return new HomeOperationsImpl(NioHelper.getInstance().getPath(homeDir, new String[0]));
    }

    public CentralInventory getCentralInventoryInstance(String invPtr) throws HomeOperationsException {
        try {
            return new CentralInventoryImpl(invPtr);
        }
        catch (InventoryException e) {
            String message = "Error instantiating CentralInventory using as central inventory pointer: [" + invPtr + "]";
            _log.severe(message);
            throw new HomeOperationsException(message, (Throwable)e);
        }
    }

    public CentralInventory getCentralInventoryInstance(String centralInventoryLocation, String groupId) throws HomeOperationsException {
        try {
            return new CentralInventoryImpl(centralInventoryLocation, groupId);
        }
        catch (InventoryException e) {
            String message = "Error instantiating CentralInventory. centralInventoryLocation [" + centralInventoryLocation + "] groupId[" + groupId + "]";
            _log.severe(message);
            throw new HomeOperationsException(message, (Throwable)e);
        }
    }
}

