/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.orchestration.action.impl;

import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.deinstallation.DeInstaller;
import com.oracle.cie.gdr.installation.Installer;
import com.oracle.cie.gdr.orchestration.InstallActionFactory;
import com.oracle.cie.gdr.orchestration.InstallActionResult;
import com.oracle.cie.gdr.orchestration.InstallActionTarget;
import com.oracle.cie.gdr.orchestration.action.impl.CommonInstallAction;
import com.oracle.cie.gdr.orchestration.lifecycle.InstallPhase;
import com.oracle.cie.gdr.utils.GdrException;
import java.util.HashSet;
import java.util.Set;

public class StartInstallAction
extends CommonInstallAction {
    public StartInstallAction(InstallActionTarget target) {
        super(target);
    }

    @Override
    public String getName() {
        return "start-install";
    }

    @Override
    public String getDisplayName() {
        return "Start Install";
    }

    @Override
    public Set<Mode> getInstallActionModes() {
        HashSet<Mode> modes = new HashSet<Mode>();
        modes.add(Mode.INSTALL);
        modes.add(Mode.DEINSTALL);
        return modes;
    }

    @Override
    public Set<InstallPhase> getInstallPhases(Mode mode) {
        return this.getInstallPhaseSet(InstallPhase.PREPARE);
    }

    @Override
    public InstallActionResult execute() {
        InstallActionTarget target = this.getTarget();
        if (target.getMode().isInstallMode()) {
            Installer installer = target.getInstaller();
            try {
                installer.startInstall();
            }
            catch (GdrException e) {
                return InstallActionFactory.getFailureResult(this, "Failed to start the installation.", e);
            }
        }
        if (target.getMode().isDeInstallMode()) {
            try {
                DeInstaller deInstaller = target.getDeInstaller();
                deInstaller.startDeInstall();
            }
            catch (GdrException e) {
                return InstallActionFactory.getFailureResult(this, "Failed to start the de-installation.", e);
            }
        }
        return InstallActionFactory.getSuccessResult(this);
    }
}

