/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.orchestration.action.impl;

import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.installation.Installer;
import com.oracle.cie.gdr.orchestration.InstallActionFactory;
import com.oracle.cie.gdr.orchestration.InstallActionResult;
import com.oracle.cie.gdr.orchestration.InstallActionTarget;
import com.oracle.cie.gdr.orchestration.action.impl.CommonInstallAction;
import com.oracle.cie.gdr.orchestration.lifecycle.InstallPhase;
import com.oracle.cie.gdr.tools.NextGenPropertiesManager;
import com.oracle.cie.nextgen.common.utils.JavaHomeHelper;
import com.oracle.cie.nextgen.common.utils.UtilityOps;
import java.util.Set;
import java.util.logging.Logger;

public class GlobalEnvPropertiesAction
extends CommonInstallAction {
    private static final Logger _log = Logger.getLogger(GlobalEnvPropertiesAction.class.getName());

    public GlobalEnvPropertiesAction(InstallActionTarget target) {
        super(target);
    }

    @Override
    public String getName() {
        return "globalEnvProperties";
    }

    @Override
    public String getDisplayName() {
        return "Global Env Properties";
    }

    @Override
    public Set<Mode> getInstallActionModes() {
        return this.getModeSet(Mode.INSTALL);
    }

    @Override
    public Set<InstallPhase> getInstallPhases(Mode mode) {
        return this.getInstallPhaseSet(InstallPhase.POST_PROCESS);
    }

    @Override
    public InstallActionResult execute() {
        Installer installer = this.getTarget().getInstaller();
        String oracleHomeStr = installer.getHome().getHomePath().toString();
        String javaHome = GlobalEnvPropertiesAction.getJavaHome();
        NextGenPropertiesManager manager = NextGenPropertiesManager.getInstance();
        try {
            manager.populateGlobalEnvPropertiesWithJavaHome(javaHome, oracleHomeStr);
        }
        catch (Throwable t) {
            return InstallActionFactory.getFailureResult(this, "Failed to populate JAVA_HOME in .globalEnv.properties", t);
        }
        try {
            manager.populateGlobalEnvPropertiesWithJVM64(UtilityOps.getJVMD64Flag(), oracleHomeStr);
        }
        catch (Throwable t) {
            _log.severe("Failed to populate JVM_64 in .globalEnv.properties: " + t.getMessage());
        }
        return InstallActionFactory.getSuccessResult(this);
    }

    private static String getJavaHome() {
        String javaHome = System.getProperty("java.home");
        javaHome = JavaHomeHelper.getJdkHomeFromJreHome((String)javaHome);
        _log.finer("getJavaHome=" + javaHome);
        return javaHome;
    }
}

