/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.orchestration.action.impl;

import com.oracle.cie.common.comdev.ComdevHelper;
import com.oracle.cie.common.dao.IDataHandlerWrapper;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.Version;
import com.oracle.cie.gdr.dao.cin.CentralInventory;
import com.oracle.cie.gdr.dao.cin.Home;
import com.oracle.cie.gdr.helpers.CentralInventoryHelper;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.orchestration.InstallActionFactory;
import com.oracle.cie.gdr.orchestration.InstallActionResult;
import com.oracle.cie.gdr.orchestration.InstallActionTarget;
import com.oracle.cie.gdr.orchestration.action.impl.CommonInstallAction;
import com.oracle.cie.gdr.orchestration.lifecycle.InstallPhase;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFileAttributes;
import java.util.Properties;
import java.util.Set;

public class CentralInventoryInstallAction
extends CommonInstallAction {
    public CentralInventoryInstallAction(InstallActionTarget target) {
        super(target);
    }

    @Override
    public String getName() {
        return "central-inventory";
    }

    @Override
    public String getDisplayName() {
        return "Central Inventory";
    }

    @Override
    public Set<Mode> getInstallActionModes() {
        return this.getModeSet(Mode.INSTALL, Mode.DEINSTALL);
    }

    @Override
    public Set<InstallPhase> getInstallPhases(Mode mode) {
        return this.getInstallPhaseSet(InstallPhase.FINISH);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public InstallActionResult execute() {
        try {
            if (this.getTarget().getMode().isInstallMode()) {
                Path oraInstLocPath;
                CentralInventory centralInventory;
                String customInvLoc = this.getTarget().getServiceHolder().getVariableResolverService().get("CUSTOM_INVENTORY_LOC");
                if (StringUtil.isNullOrEmpty((String)customInvLoc, (boolean)true)) {
                    String invPtrLoc = this.getTarget().getServiceHolder().getVariableResolverService().get("INVPTR_LOC");
                    if (!StringUtil.isNullOrEmpty((String)invPtrLoc, (boolean)true)) {
                        Path invPtrLocPath = NioHelper.getInstance().getPath(invPtrLoc, new String[0]);
                        if (!Files.exists(invPtrLocPath, new LinkOption[0])) {
                            throw new GdrException("The INVPTR_LOC provided did not exist: " + invPtrLoc);
                        }
                        Properties properties = new Properties();
                        try (InputStream is = Files.newInputStream(invPtrLocPath, new OpenOption[0]);){
                            properties.load(is);
                        }
                        customInvLoc = properties.getProperty("inventory_loc");
                    } else {
                        customInvLoc = null;
                    }
                }
                Path centralInventoryPath = StringUtil.isNullOrEmpty((String)customInvLoc, (boolean)true) ? this.getTarget().getInstaller().getHome().getInventoryDirectoryPath() : NioHelper.getInstance().getPath(customInvLoc, new String[0]);
                Path inventoryXmlPath = CentralInventoryHelper.getInstance().getInventoryXmlPath(centralInventoryPath);
                if (Files.exists(inventoryXmlPath, new LinkOption[0])) {
                    centralInventory = CentralInventoryHelper.getInstance().getCentralInventory(inventoryXmlPath);
                } else {
                    centralInventory = new CentralInventory();
                    centralInventory.setSavedWith(Version.getReleaseVersion());
                    centralInventory.setMinimumVer("2.1.0.6.0");
                }
                int homeIndex = centralInventory.getHighestIdx() + 1;
                String homeName = "OracleHome" + homeIndex;
                String homeType = "O";
                centralInventory.addHome(new Home(homeName, this.getTarget().getHomePath().toString(), homeType));
                CentralInventoryHelper.getInstance().save((IDataHandlerWrapper)centralInventory, inventoryXmlPath);
                String group = null;
                if (!ComdevHelper.isWindows()) {
                    PosixFileAttributes posixFileAttributes = Files.readAttributes(this.getTarget().getHomePath(), PosixFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                    group = posixFileAttributes.group().toString();
                    oraInstLocPath = this.getTarget().getHomePath().resolve("oraInst.loc");
                    CentralInventoryHelper.setDefaultCentralInventoryPermissions(centralInventoryPath);
                    CentralInventoryHelper.setDefaultInventoryXMLPermissions(inventoryXmlPath);
                } else {
                    oraInstLocPath = this.getTarget().getInstaller().getHome().getInventoryDirectoryPath().resolve("oraInst.loc");
                }
                CentralInventoryHelper.getInstance().createOraInvPtr(centralInventoryPath, oraInstLocPath, group);
                return InstallActionFactory.getSuccessResult(this);
            }
            if (!this.getTarget().getMode().isDeInstallMode()) return InstallActionFactory.getSuccessResult(this);
        }
        catch (Exception e) {
            return InstallActionFactory.getFailureResult(this, "Failed to create central inventory.", e);
        }
        return InstallActionFactory.getSuccessResult(this);
    }
}

