/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.orchestration;

import com.oracle.cie.gdr.ComponentTarget;
import com.oracle.cie.gdr.FileTarget;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.deinstallation.DeInstaller;
import com.oracle.cie.gdr.deinstallation.DeInstallerShutdownHook;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InstallActionHelper {
    private static final Logger _log = Logger.getLogger(InstallActionHelper.class.getName());

    public static void deInstallComponent(Component component, DeInstaller deinstaller, Path homeLoc, boolean disableShutdownHook) throws GdrException {
        ArrayList<Path> dirList = new ArrayList<Path>();
        Collection<ComponentTarget> targets = component.getComponentTargets();
        for (ComponentTarget target : targets) {
            boolean bootstrapFileMap = target.getComponentFileMap().isBootstrap();
            if (deinstaller == null || deinstaller.startComponentTargetDeInstall(target)) {
                List<FileTarget> fileTargets = target.getFileTargets();
                for (FileTarget f : fileTargets) {
                    String dest = f.getDest();
                    Path path = homeLoc.resolve(dest);
                    if (!Files.exists(path, new LinkOption[0])) continue;
                    if (!disableShutdownHook && (f.containsModifier(FileTarget.DELAYED_DEINSTALL_MODIFIER) || bootstrapFileMap)) {
                        _log.finest("Adding for delayed deinstall " + path);
                        DeInstallerShutdownHook.add(path.toFile(), !Files.isDirectory(path, new LinkOption[0]));
                        continue;
                    }
                    if (f.isDirectory() || Files.isDirectory(path, new LinkOption[0])) {
                        dirList.add(path);
                        continue;
                    }
                    try {
                        if (Files.deleteIfExists(path)) {
                            _log.finest("Deleted " + path);
                        }
                    }
                    catch (IOException e) {
                        _log.log(Level.WARNING, "Failure occurred while attempting to delete " + path, e);
                    }
                    if (!Files.exists(path, new LinkOption[0])) continue;
                    _log.finest("Still exists, adding for delayed deinstall " + path);
                    DeInstallerShutdownHook.add(path.toFile(), true);
                }
                Collections.sort(dirList);
                Collections.reverse(dirList);
                for (Path dir : dirList) {
                    if (!Files.exists(dir, new LinkOption[0])) continue;
                    DirectoryStream<Path> files = null;
                    try {
                        files = Files.newDirectoryStream(dir);
                    }
                    catch (IOException e) {
                        _log.log(Level.WARNING, "Failure occurred while attempting to get directory stream of " + dir, e);
                    }
                    if (files != null) {
                        for (Path path : files) {
                            if (Files.exists(path, new LinkOption[0])) continue;
                            try {
                                if (!Files.deleteIfExists(path)) continue;
                                _log.finest("Deleted " + path);
                            }
                            catch (IOException e) {
                                _log.log(Level.WARNING, "Failure occurred while attempting to delete " + path, e);
                            }
                        }
                    }
                    try {
                        if (!Files.deleteIfExists(dir)) continue;
                        _log.finest("Deleted empty directory " + dir);
                    }
                    catch (IOException e) {
                        _log.log(Level.WARNING, "Failure occurred while attempting to delete " + dir, e);
                    }
                }
            }
            if (deinstaller == null) continue;
            deinstaller.completeComponentTargetDeInstall(target);
        }
    }
}

