/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.orchestration;

import com.oracle.cie.gdr.deinstallation.DeInstaller;
import com.oracle.cie.gdr.installation.Installer;
import com.oracle.cie.gdr.orchestration.InstallActionExecutor;
import com.oracle.cie.gdr.orchestration.InstallActionManager;
import com.oracle.cie.gdr.orchestration.InstallActionResult;
import com.oracle.cie.gdr.orchestration.InstallActionTarget;
import com.oracle.cie.gdr.orchestration.action.InstallAction;
import com.oracle.cie.gdr.orchestration.impl.InstallActionManagerImpl;
import com.oracle.cie.gdr.orchestration.impl.InstallActionResultImpl;
import com.oracle.cie.gdr.orchestration.impl.InstallActionTargetImpl;
import com.oracle.cie.gdr.orchestration.impl.PatchInstallActionManagerImpl;

public class InstallActionFactory {
    public static InstallActionExecutor getInstallActionExecutor(Installer installer) {
        return InstallActionFactory.getInstallActionManager(installer).getInstallActionExecutor();
    }

    public static InstallActionExecutor getInstallActionExecutor(DeInstaller deInstaller) {
        return InstallActionFactory.getInstallActionManager(deInstaller).getInstallActionExecutor();
    }

    public static InstallActionManager getInstallActionManager(Installer installer) {
        InstallActionTargetImpl target = new InstallActionTargetImpl(installer);
        return InstallActionFactory.getInstallActionManager(target);
    }

    public static InstallActionManager getInstallActionManager(DeInstaller deInstaller) {
        InstallActionTargetImpl target = new InstallActionTargetImpl(deInstaller);
        return InstallActionFactory.getInstallActionManager(target);
    }

    public static InstallActionManager getInstallActionManager(InstallActionTarget target) {
        return new InstallActionManagerImpl(target);
    }

    public static InstallActionManager getPatchInstallActionManager(Installer installer) {
        InstallActionTargetImpl target = new InstallActionTargetImpl(installer);
        return InstallActionFactory.getPatchInstallActionManager(target);
    }

    public static InstallActionManager getPatchInstallActionManager(InstallActionTarget target) {
        return new PatchInstallActionManagerImpl(target);
    }

    public static InstallActionResultImpl getSuccessResult(InstallAction installAction) {
        return InstallActionFactory.getSuccessResult(installAction, null);
    }

    public static InstallActionResultImpl getSuccessResult(InstallAction installAction, String message) {
        return new InstallActionResultImpl(installAction, InstallActionResult.Result.SUCCESS, message, null);
    }

    public static InstallActionResultImpl getFailureResult(InstallAction installAction, String message, Throwable cause) {
        return new InstallActionResultImpl(installAction, InstallActionResult.Result.FAILURE, message, cause);
    }

    public static InstallActionResultImpl getWarningResult(InstallAction installAction, String message, Throwable cause) {
        return new InstallActionResultImpl(installAction, InstallActionResult.Result.WARNING, message, cause);
    }
}

