/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.libraries;

import com.oracle.cie.common.util.JarHelper;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.Home;
import com.oracle.cie.gdr.dao.cmn.FileResolver;
import com.oracle.cie.gdr.dao.cmn.LibraryResolvers;
import com.oracle.cie.gdr.dao.cmn.ManifestResolver;
import com.oracle.cie.gdr.dao.cmn.MergedJarClasspath;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.helpers.RegenerationHelper;
import com.oracle.cie.gdr.libraries.JarLibraryHandler;
import com.oracle.cie.gdr.libraries.LibraryEntryLocation;
import com.oracle.cie.gdr.libraries.LibraryHandlerException;
import com.oracle.cie.gdr.libraries.LibraryKey;
import com.oracle.cie.gdr.libraries.LibraryTarget;
import com.oracle.cie.gdr.libraries.LibraryTargetHolder;
import com.oracle.cie.gdr.libraries.LibraryType;
import com.oracle.cie.gdr.merger.LibraryJarMerger;
import com.oracle.cie.gdr.nio.NioDelete;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.tools.NextGenPropertiesManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MergedJarLibraryHandler
extends JarLibraryHandler {
    private static final Logger _log = Logger.getLogger(MergedJarLibraryHandler.class.getName());
    public static final String MERGER_DIR = "merger";
    public static final String EXTERNAL_JAR_LOCATION = "modules/merger";
    public static final String INTERNAL_JAR_LOCATION = "modules/internal/merger";
    private List<FileResolver> resolvers;
    private ManifestResolver manifestResolver;
    private MergedJarClasspath classpathJarRules;

    @Override
    public LibraryType getLibraryType() {
        return LibraryType.mergedJar;
    }

    @Override
    protected Collection<Path> generate(Home home, Set<LibraryEntryLocation> entryLocations, String productHome, List<String> jarLocations, Attributes manifestAttribs) throws LibraryHandlerException {
        if (home == null) {
            LibraryHandlerException ex = new LibraryHandlerException("The home provided was null.");
            _log.throwing(this.getClass().getName(), "handle", (Throwable)((Object)ex));
            throw ex;
        }
        ArrayList<Path> created = new ArrayList<Path>();
        if (!StringUtil.isNullOrEmpty((String)productHome, (boolean)true)) {
            for (String jarLoc : jarLocations) {
                Path mergedJar;
                block16: {
                    mergedJar = NioHelper.getInstance().getPath(this.getFullJarLocation(productHome + File.separator + jarLoc), new String[0]);
                    if (_log.isLoggable(Level.FINE)) {
                        _log.fine("Creating merged jar at " + mergedJar + " with jars " + entryLocations);
                    }
                    LibraryJarMerger merger = null;
                    try {
                        merger = new LibraryJarMerger(entryLocations, this.getMode(), home.getHomePath(), mergedJar.getParent().toString(), productHome, jarLoc, mergedJar.getFileName().toString(), this.resolvers, this.manifestResolver, this.classpathJarRules);
                    }
                    catch (Exception e) {
                        throw new LibraryHandlerException(e);
                    }
                    Path myTempDir = null;
                    JarHelper jarHelper = null;
                    if (RegenerationHelper.isRegenerateState() && Files.exists(mergedJar, new LinkOption[0]) && merger.extractUpdatedEntries(mergedJar.getParent())) {
                        try {
                            myTempDir = this.createTempDir(mergedJar.getParent());
                            jarHelper = new JarHelper(mergedJar.toFile(), 2);
                            jarHelper.setPreserve(true);
                            if (!jarHelper.update(myTempDir.toFile(), NextGenPropertiesManager.getInstance().getVariable("JAVA_HOME", home.getHomePath().toAbsolutePath().toString()))) {
                                throw new LibraryHandlerException("Failed to update library " + mergedJar);
                            }
                            break block16;
                        }
                        catch (IOException e) {
                            throw new LibraryHandlerException(e);
                        }
                        finally {
                            if (jarHelper != null) {
                                jarHelper.close();
                            }
                            if (myTempDir != null && Files.exists(myTempDir, new LinkOption[0])) {
                                NioDelete.delete((Path)myTempDir);
                            }
                        }
                    }
                    this.cleanLibraryDirectory(mergedJar);
                    merger.addManifestAttributes(manifestAttribs);
                    merger.mergeJars();
                }
                created.add(mergedJar);
            }
        } else {
            _log.finest("No " + (Object)((Object)this.getLibraryType()) + " jars were created for " + jarLocations + " because no product home directories were provided.");
        }
        return created;
    }

    @Override
    public String getInternalJarLocation() {
        return INTERNAL_JAR_LOCATION;
    }

    @Override
    public String getExternalJarLocation() {
        return EXTERNAL_JAR_LOCATION;
    }

    @Override
    public String getComponentJarName(Component component, LibraryKey key, boolean suppressPrefix, boolean suppressVersion) {
        if (suppressVersion) {
            return key.getName() + "." + (Object)((Object)key.getExtension());
        }
        return key.getName() + "_" + key.getVersion() + "." + (Object)((Object)key.getExtension());
    }

    @Override
    public String getFeatureJarName(FeatureSet feature, LibraryKey key, boolean suppressPrefix, boolean suppressVersion) {
        if (suppressVersion) {
            return key.getName() + "." + (Object)((Object)key.getExtension());
        }
        return key.getName() + "_" + key.getVersion() + "." + (Object)((Object)key.getExtension());
    }

    public List<FileResolver> getResolver() {
        return this.resolvers;
    }

    public ManifestResolver getManifestResolver() {
        return this.manifestResolver;
    }

    @Override
    protected void processComponentLibrary(LibraryKey key, LibraryTarget target, Set<LibraryEntryLocation> entryLocations, String location) throws LibraryHandlerException {
        this.setResolvers(target.getLibrary().getLibraryResolvers());
        this.setClasspathJarRules(target.getLibrary().getClasspathJars());
        super.processComponentLibrary(key, target, entryLocations, location);
    }

    @Override
    protected void processFeatureLibrary(LibraryKey key, LibraryTargetHolder holder, Set<LibraryEntryLocation> entryLocations, String location) throws LibraryHandlerException {
        this.setResolvers(holder.getFeatureLibrary(key).getLibraryResolvers());
        this.setClasspathJarRules(holder.getFeatureLibrary(key).getClasspathJars());
        super.processFeatureLibrary(key, holder, entryLocations, location);
    }

    private void setResolvers(LibraryResolvers lResolvers) throws LibraryHandlerException {
        this.resolvers = null;
        this.manifestResolver = null;
        if (lResolvers != null) {
            this.resolvers = lResolvers.getResolvers();
            this.manifestResolver = lResolvers.getManifestResolver();
        }
    }

    private void setClasspathJarRules(MergedJarClasspath classpathJarRules) throws LibraryHandlerException {
        this.classpathJarRules = null;
        if (classpathJarRules != null) {
            this.classpathJarRules = classpathJarRules;
        }
    }

    @Override
    public boolean isThreadable() {
        return true;
    }

    private Path createTempDir(Path parentDir) throws LibraryHandlerException {
        Path myTempDir;
        try {
            myTempDir = Files.createTempDirectory(parentDir, "temp", new FileAttribute[0]);
        }
        catch (IOException e1) {
            throw new LibraryHandlerException("Failed to create temporary directory for : " + parentDir + e1.getMessage());
        }
        if (!Files.exists(myTempDir, new LinkOption[0])) {
            throw new LibraryHandlerException("Failed to create temporary directory for : " + parentDir);
        }
        return myTempDir;
    }
}

