/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.libraries;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.ComponentTarget;
import com.oracle.cie.gdr.FileTarget;
import com.oracle.cie.gdr.Home;
import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.cpd.Library;
import com.oracle.cie.gdr.dao.cpd.LibraryEntry;
import com.oracle.cie.gdr.dao.dbd.DirectoryMap;
import com.oracle.cie.gdr.helpers.ComponentHelper;
import com.oracle.cie.gdr.helpers.DistributionHelper;
import com.oracle.cie.gdr.helpers.RegenerationHelper;
import com.oracle.cie.gdr.libraries.LibraryEntryLocation;
import com.oracle.cie.gdr.libraries.LibraryHandlerException;
import com.oracle.cie.gdr.libraries.LibraryKey;
import com.oracle.cie.gdr.libraries.LibraryType;
import com.oracle.cie.gdr.libraries.LibraryVersion;
import com.oracle.cie.gdr.libraries.LibraryVisibility;
import com.oracle.cie.gdr.utils.GdrException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

public class LibraryTarget {
    private static final Logger _log = Logger.getLogger(LibraryTarget.class.getName());
    private Component _component;
    private Library _library;
    private LibraryKey _key;
    private Set<LibraryEntryLocation> _libraryEntryLocations;
    private String _productHome;
    private DirectoryMap _dirMap;
    private List<String> _libraryLocations;
    private Home _home;

    public LibraryTarget(Component component, Library library, DirectoryMap dirMap, Home home) {
        String version;
        this._component = component;
        this._library = library;
        String type = library.getType();
        String name = library.getName();
        String extension = library.getExtension();
        String completeVersion = version = library.getVersion();
        if (StringUtil.isNullOrEmpty((String)version, (boolean)true)) {
            version = ComponentHelper.getShortenedVersion(component.getVersion());
            completeVersion = component.getVersion();
        }
        this._key = new LibraryKey(type, name, extension, version, completeVersion, library.getVisibility(), library.getIgnoreType(), library.getIgnoreVersion(), library.getPomGen(), library.getHK2Gen(), library.getHK2Location(), library.getOverwriteHigherVersion(), library.getSuppressManifestProperties());
        this._libraryEntryLocations = new LinkedHashSet<LibraryEntryLocation>();
        this._dirMap = dirMap;
        this._home = home;
    }

    private void generateEntryLocations(Mode mode) throws GdrException {
        List<LibraryEntry> entries = this.getEntries();
        if (entries != null && !entries.isEmpty()) {
            Collection<ComponentTarget> compTargets = this.getComponent().getComponentTargets();
            for (LibraryEntry entry : entries) {
                LibraryHandlerException ex;
                if (!StringUtil.isNullOrEmpty((String)entry.getWildcard(), (boolean)true) || !StringUtil.isNullOrEmpty((String)entry.getRegex(), (boolean)true)) {
                    ex = new LibraryHandlerException("Unexpected wildcard or regex values for entry " + (Object)((Object)entry) + " in component " + this.getComponent());
                    _log.throwing(LibraryTarget.class.getName(), "getEntryLocations", (Throwable)((Object)ex));
                    throw ex;
                }
                if (StringUtil.isNullOrEmpty((String)entry.getName(), (boolean)true)) {
                    ex = new LibraryHandlerException("Empty name value for <entry> element in component " + this.getComponent());
                    _log.throwing(LibraryTarget.class.getName(), "getEntryLocations", (Throwable)((Object)ex));
                    throw ex;
                }
                String path = entry.getName();
                if (compTargets != null && !compTargets.isEmpty()) {
                    String productHome = null;
                    String originalSource = null;
                    for (ComponentTarget compTarget : compTargets) {
                        FileTarget fileTarget = compTarget.locateFileTarget(path, mode);
                        if (fileTarget == null) continue;
                        productHome = compTarget.getLocation();
                        originalSource = fileTarget.getSource();
                        break;
                    }
                    if (productHome == null) {
                        LibraryHandlerException ex2 = new LibraryHandlerException("Unable to locate file or directory corresponding to library entry \"" + path + "\" in component " + this.getComponent());
                        _log.throwing(LibraryTarget.class.getName(), "getEntryLocations", (Throwable)((Object)ex2));
                        throw ex2;
                    }
                    _log.fine("Using product home location " + productHome + " for " + path + " in component definition " + this.getComponent());
                    this._libraryEntryLocations.add(new LibraryEntryLocation(entry, this, path, originalSource, productHome, this._home));
                    continue;
                }
                _log.fine("Skipping component library processing since no file maps exist in component: " + this.getComponent());
            }
        }
    }

    public Component getComponent() {
        return this._component;
    }

    public Library getLibrary() {
        return this._library;
    }

    public List<LibraryEntry> getEntries() {
        return this._library.getEntries();
    }

    public LibraryKey getKey() {
        return this._key;
    }

    public LibraryType getType() {
        return this.getKey().getType();
    }

    public String getName() {
        return this.getKey().getName();
    }

    public LibraryVersion getVersion() {
        return this.getKey().getLibraryVersion();
    }

    public String getCompleteVersion() {
        return this.getKey().getCompleteVersion();
    }

    public LibraryVisibility getVisibility() {
        return this.getKey().getVisibility();
    }

    public Set<LibraryEntryLocation> getEntryLocations(Mode mode) throws GdrException {
        if (this._libraryEntryLocations.isEmpty()) {
            this.generateEntryLocations(mode);
        }
        return this._libraryEntryLocations;
    }

    public String getProductHome(Mode mode) throws GdrException {
        if (StringUtil.isNullOrEmpty((String)this._productHome, (boolean)true)) {
            this.generateProductHome(mode);
        }
        return this._productHome;
    }

    protected void generateProductHome(Mode mode) throws GdrException {
        Set<LibraryEntryLocation> entryLocations;
        String symbol = this._library.getSymbol();
        if (!StringUtil.isNullOrEmpty((String)symbol, (boolean)true)) {
            Collection<String> rootDirs = DistributionHelper.getInstance().getRootDirsForSymbol(this._dirMap, symbol);
            if (rootDirs.size() > 1) {
                _log.warning("The symbol " + symbol + " is mapped to more than one directory. Use a different symbol for the library " + this._library.getName());
            }
            if (!rootDirs.isEmpty()) {
                this._productHome = rootDirs.iterator().next();
            }
        }
        if (this._productHome == null && (entryLocations = this.getEntryLocations(mode)) != null && !entryLocations.isEmpty()) {
            this._productHome = entryLocations.iterator().next().getProductHome();
            for (LibraryEntryLocation entryLocation : entryLocations) {
                if (this._productHome.equals(entryLocation.getProductHome())) continue;
                _log.warning("The entries included belong to different product homes. Please use the \"symbol\" attribute on the library " + this._library.getName() + " to set the correct product home");
            }
        }
    }

    protected String getDefaultProductLocation(String locationPrefix) throws GdrException {
        String location = null;
        Collection<ComponentTarget> compTargets = this.getComponent().getComponentTargets();
        if (compTargets != null && !compTargets.isEmpty()) {
            if (locationPrefix != null) {
                for (ComponentTarget compTarget : compTargets) {
                    if (compTarget.locateFileTarget(locationPrefix) == null) continue;
                    location = compTarget.getLocation();
                    break;
                }
            }
            if (location == null) {
                for (ComponentTarget compTarget : compTargets) {
                    if (!compTarget.getPlatforms().isEmpty() || !compTarget.getLocales().isEmpty()) continue;
                    location = compTarget.getLocation();
                    break;
                }
            }
            if (location == null) {
                location = compTargets.iterator().next().getLocation();
            }
        } else {
            _log.fine("Cannot determine default product location since there are no file maps being installed for component " + this.getComponent());
        }
        return location;
    }

    public boolean needsRegeneration() {
        return RegenerationHelper.getInstance().getModifiedComponents().contains(this._component);
    }

    public List<String> getLibraryJarLocations() {
        return this._libraryLocations;
    }

    public void setLibraryJarLocations(List<String> libraryLocations) {
        this._libraryLocations = libraryLocations;
    }

    public void removeLibraryJarLocations(LibraryKey key, Collection<Integer> indexes) {
        ArrayList<String> remove = new ArrayList<String>();
        for (Integer i : indexes) {
            remove.add(this._libraryLocations.get(i));
        }
        this._libraryLocations.removeAll(remove);
    }
}

