/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.libraries;

import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.dao.ftr.FeatureLibrary;
import com.oracle.cie.gdr.dao.ftr.FeatureLibraryInclude;
import com.oracle.cie.gdr.libraries.LibraryEntryLocation;
import com.oracle.cie.gdr.libraries.LibraryKey;
import com.oracle.cie.gdr.libraries.LibraryTarget;
import com.oracle.cie.gdr.libraries.LibraryTargetHolder;
import com.oracle.cie.gdr.libraries.LibraryType;
import com.oracle.cie.gdr.libraries.LibraryVersion;
import com.oracle.cie.gdr.utils.GdrException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LibraryLocation {
    private LibraryType type;
    private Map<FeatureLibraryInclude, Set<LibraryTargetHolder>> globalCycleCheck;
    private Map<FeatureLibraryInclude, Set<FeatureLibraryInclude>> cyclecheck;
    private Set<LibraryEntryLocation> entryLocations;
    private LibraryVersion version;
    private FeatureLibraryInclude include;
    private LibraryTargetHolder holder;

    public LibraryLocation(LibraryType type, FeatureLibraryInclude include, LibraryVersion version, LibraryTargetHolder holder, Set<LibraryEntryLocation> entryLocations, Map<FeatureLibraryInclude, Set<FeatureLibraryInclude>> cycleCheck, Map<FeatureLibraryInclude, Set<LibraryTargetHolder>> globalCycleCheck) {
        this.type = type;
        this.include = include;
        this.version = version;
        this.holder = holder;
        this.entryLocations = entryLocations;
        this.cyclecheck = cycleCheck;
        this.globalCycleCheck = globalCycleCheck;
    }

    public String getName() {
        return this.include.getName();
    }

    public LibraryVersion getVersion() {
        return this.version;
    }

    public boolean isFeature() {
        return this.include.isFeature();
    }

    public Collection<LibraryKey> getLibraryKeys(String name) {
        return this.holder.getLibraryKeys(name);
    }

    public LibraryType getType() {
        return this.type;
    }

    public Set<LibraryEntryLocation> getEntryLocations() {
        return this.entryLocations;
    }

    public Map<FeatureLibraryInclude, Set<FeatureLibraryInclude>> getCycleCheck() {
        return this.cyclecheck;
    }

    public Map<FeatureLibraryInclude, Set<LibraryTargetHolder>> GlobalCycleCheck() {
        return this.globalCycleCheck;
    }

    public FeatureLibraryInclude getInclude() {
        return this.include;
    }

    public void addToGlobalCycleCheck(Set<LibraryTargetHolder> globalCheck, LibraryTargetHolder globalHolder) {
        if (globalCheck == null) {
            this.globalCycleCheck.put(this.include, new HashSet());
        }
        this.globalCycleCheck.get((Object)this.include).add(globalHolder);
    }

    public Map<FeatureLibraryInclude, Set<LibraryTargetHolder>> getGlobalCycleCheck() {
        return this.globalCycleCheck;
    }

    public boolean isGlobal() {
        return this.include.isGlobal();
    }

    public boolean getIgnoreVersion() {
        return this.include.getIgnoreVersion();
    }

    public boolean isSingleton() {
        return this.holder.getFeature().isSingleton();
    }

    public boolean getExplode() {
        return this.include.getExplode();
    }

    public List<LibraryTarget> getLibraryTargets(LibraryKey compKey) {
        return this.holder.getLibraryTargets(compKey);
    }

    public Set<LibraryTargetHolder> getDependencies() {
        return this.holder.getDependencies();
    }

    public boolean getIgnoreType() {
        return this.include.getIgnoreType();
    }

    public Collection<LibraryKey> getFeatureLibraryKeys(String name) {
        return this.holder.getFeatureLibraryKeys(name);
    }

    public void addEntryLocation(LibraryEntryLocation entryLocation) {
        this.entryLocations.add(entryLocation);
    }

    public String getProductHome(FeatureLibrary target, Mode mode) throws GdrException {
        return this.holder.getProductHome(target, mode);
    }

    public FeatureLibrary getFeatureLibrary(LibraryKey featureKey) {
        return this.holder.getFeatureLibrary(featureKey);
    }

    public LibraryTargetHolder getHolder() {
        return this.holder;
    }

    public String toString() {
        return this.getName() + "_" + this.getVersion();
    }
}

