/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.libraries;

import com.oracle.cie.gdr.libraries.LibraryExtension;
import com.oracle.cie.gdr.libraries.LibraryType;
import com.oracle.cie.gdr.libraries.LibraryVersion;
import com.oracle.cie.gdr.libraries.LibraryVisibility;

public class LibraryKey {
    private LibraryType _type;
    private String _name;
    private LibraryExtension _extension;
    private LibraryVersion _version;
    private String _completeVersion;
    private LibraryVisibility _visibility;
    private boolean _ignoreType;
    private boolean _ignoreVersion;
    private boolean _pomGen;
    private boolean _hk2Gen;
    private String _hk2Location;
    private boolean _overwriteHigherVersion;
    private String _suppressManifestProperties;

    LibraryKey(String type, String name, String extension, String version, String completeVersion, String visibility, boolean ignoreType, boolean ignoreVersion, boolean pomGen, boolean hk2Gen, String hk2Location, boolean overwriteHigherVersion, String suppressManifestProperties) {
        this._type = LibraryType.getLibraryType(type);
        this._name = name;
        this._extension = LibraryExtension.getLibraryExtension(extension);
        this._version = new LibraryVersion(version);
        this._completeVersion = completeVersion;
        this._visibility = LibraryVisibility.getLibraryVisibility(visibility);
        this._ignoreType = ignoreType;
        this._ignoreVersion = ignoreVersion;
        this._pomGen = pomGen;
        this._hk2Gen = hk2Gen;
        this._hk2Location = hk2Location;
        this._overwriteHigherVersion = overwriteHigherVersion;
        this._suppressManifestProperties = suppressManifestProperties;
    }

    public String getName() {
        return this._name;
    }

    public LibraryExtension getExtension() {
        return this._extension;
    }

    public LibraryType getType() {
        return this._type;
    }

    public String getVersion() {
        return this._version.toString();
    }

    public LibraryVersion getLibraryVersion() {
        return this._version;
    }

    public String getCompleteVersion() {
        return this._completeVersion;
    }

    public LibraryVisibility getVisibility() {
        return this._visibility;
    }

    public boolean getIgnoreType() {
        return this._ignoreType;
    }

    public boolean getIgnoreVersion() {
        return this._ignoreVersion;
    }

    public boolean getPomGen() {
        return this._pomGen;
    }

    public boolean getHK2Gen() {
        return this._hk2Gen;
    }

    public String getHK2Location() {
        return this._hk2Location;
    }

    public boolean getOverWriteHigherVersion() {
        return this._overwriteHigherVersion;
    }

    public String getSuppressManifestProperties() {
        return this._suppressManifestProperties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LibraryKey that = (LibraryKey)o;
        return !((this._name == null ? that._name != null : !this._name.equals(that._name)) || (this._type == null ? that._type != null : !this._type.equals((Object)that._type)) || (this._extension == null ? that._extension != null : !this._extension.equals((Object)that._extension)) || (this._version == null ? that._version != null : !this._version.equals(that._version)) || (this._visibility == null ? that._visibility != null : !this._visibility.equals((Object)that._visibility)));
    }

    public int hashCode() {
        int result = this._type != null ? this._type.hashCode() : 0;
        result = 31 * result + (this._name != null ? this._name.hashCode() : 0);
        result = 31 * result + (this._extension != null ? this._extension.hashCode() : 0);
        result = 31 * result + (this._version != null ? this._version.hashCode() : 0);
        result = 31 * result + (this._visibility != null ? this._visibility.hashCode() : 0);
        return result;
    }
}

