/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.installation;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.gdr.ComponentLoader;
import com.oracle.cie.gdr.FeatureLoader;
import com.oracle.cie.gdr.Home;
import com.oracle.cie.gdr.dao.cmn.Reference;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.dbd.Distribution;
import com.oracle.cie.gdr.dao.ftr.ComponentReference;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.dao.nfo.ExternalFeatureReference;
import com.oracle.cie.gdr.dao.pch.Patch;
import com.oracle.cie.gdr.installation.CommonInstaller;
import com.oracle.cie.gdr.installation.InstallationSession;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class PatchInstaller
extends CommonInstaller {
    private static final Logger _log = Logger.getLogger(PatchInstaller.class.getName());
    private ComponentLoader _componentLoader;
    private FeatureLoader _featureLoader;

    public PatchInstaller(InstallationSession installationSession, Set<Patch> patchRefs, Map<String, String> variableMap) throws IOException, DataHandlerException, GdrException {
        super(installationSession, variableMap);
        this.init(patchRefs);
    }

    protected void init(Set<Patch> patchRefs) throws GdrException, IOException, DataHandlerException {
    }

    private Set<FeatureSet> getFeatures(Set<Patch> patchRefs) throws IOException, DataHandlerException, GdrException {
        Home home = Home.getHome(this.getMetaDataHome().getGdrMetaDataHomePath());
        HashSet<FeatureSet> features = new HashSet<FeatureSet>();
        for (Patch patch : patchRefs) {
            for (ComponentReference compRef : patch.getComponents()) {
                features.addAll(home.getInstalledFeatureSets(compRef));
            }
        }
        return features;
    }

    public ComponentLoader getComponentLoader() {
        return this._componentLoader;
    }

    public void setComponentLoader(ComponentLoader _componentLoader) {
        this._componentLoader = _componentLoader;
    }

    public FeatureLoader getFeatureLoader() {
        return this._featureLoader;
    }

    public void setFeatureLoader(FeatureLoader _featureLoader) {
        this._featureLoader = _featureLoader;
    }

    @Override
    public Set<FeatureSet> getFeatureSets() {
        return this.getFeatureLoader().getFeatureSets();
    }

    @Override
    public Map<ExternalFeatureReference, List<Reference>> getExternalDistributions() {
        return null;
    }

    @Override
    public Set<FeatureSet> getSelectedFeatures() {
        return new HashSet<FeatureSet>();
    }

    @Override
    public Map<FeatureSet, Collection<Component>> getComponentsMap() {
        return this.getComponentLoader().getComponentsMap();
    }

    @Override
    public void saveHomeMetadata(Path dir) throws GdrException, DataHandlerException, IOException {
    }

    @Override
    public Distribution getDistribution() {
        return null;
    }
}

