/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.installation;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.dependency.DependencyException;
import com.oracle.cie.gdr.ComponentTarget;
import com.oracle.cie.gdr.Home;
import com.oracle.cie.gdr.SourceAccess;
import com.oracle.cie.gdr.dao.cmn.Reference;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.dbd.Distribution;
import com.oracle.cie.gdr.dao.dei.DeInstallInfo;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.dao.nfo.ExternalFeatureReference;
import com.oracle.cie.gdr.dao.rgy.Registry;
import com.oracle.cie.gdr.installation.InstallationSession;
import com.oracle.cie.gdr.libraries.LibraryTargetHolder;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface Installer
extends SourceAccess {
    public Home getHome();

    public File getHomeDir();

    public InstallationSession getInstallationSession();

    public Registry getRegistry();

    public File getRegistryFile();

    public Distribution getDistribution();

    public Set<FeatureSet> getFeatureSets();

    public Set<FeatureSet> getSelectedFeatures();

    public Set<Component> getComponents(FeatureSet var1);

    public Set<Component> getComponents();

    public DeInstallInfo getDeInstallInfo();

    public long getRequiredSpace();

    public Map<ExternalFeatureReference, List<Reference>> getExternalDistributions();

    public Map<FeatureSet, LibraryTargetHolder> getLibraryTargets() throws DependencyException, IOException, DataHandlerException, GdrException;

    public void startInstall() throws GdrException;

    public void completeInstall() throws GdrException;

    public boolean startFeatureInstall(FeatureSet var1) throws GdrException;

    public void completeFeatureInstall(FeatureSet var1) throws GdrException;

    public boolean startComponentInstall(Component var1) throws GdrException;

    public void completeComponentInstall(Component var1) throws GdrException;

    public void completeComponentInstall(Component var1, Map<String, Integer> var2) throws GdrException;

    public boolean startComponentTargetInstall(ComponentTarget var1) throws GdrException;

    public void completeComponentTargetInstall(ComponentTarget var1) throws GdrException;

    public void addExtraFilesToDeInstallInfo(String var1, String var2, Collection<Path> var3, boolean var4) throws GdrException;

    public void saveHomeMetadata(Path var1) throws GdrException, DataHandlerException, IOException;

    public void processPostFeatureOperation(FeatureSet var1) throws GdrException;

    public Set<FeatureSet> getPostProcessFeatures();

    public Set<Component> getPostProcessComponents();

    public void resolveComponentVariables() throws GdrException;
}

