/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.installation;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.dao.IDataHandlerWrapper;
import com.oracle.cie.dependency.DependencyException;
import com.oracle.cie.gdr.ComponentLoader;
import com.oracle.cie.gdr.DistributionTarget;
import com.oracle.cie.gdr.FeatureLoader;
import com.oracle.cie.gdr.dao.cmn.Reference;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.dbd.Distribution;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.dao.nfo.ExternalFeatureReference;
import com.oracle.cie.gdr.dao.rgy.Registry;
import com.oracle.cie.gdr.dao.rgy.SessionInfo;
import com.oracle.cie.gdr.helpers.ComponentHelper;
import com.oracle.cie.gdr.helpers.DistributionHelper;
import com.oracle.cie.gdr.helpers.FeatureSetHelper;
import com.oracle.cie.gdr.installation.CommonInstaller;
import com.oracle.cie.gdr.installation.DistributionInstaller;
import com.oracle.cie.gdr.installation.FeatureArchiveInstallationSession;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class FeatureArchiveInstaller
extends CommonInstaller {
    private static final Logger _log = Logger.getLogger(FeatureArchiveInstaller.class.getName());
    private FeatureArchiveInstallationSession _featureArchiveInstallationSession;

    public FeatureArchiveInstaller(FeatureArchiveInstallationSession installerSession, Map<String, String> variableMap) throws IOException, DataHandlerException, GdrException, DependencyException {
        super(installerSession, variableMap);
        this._featureArchiveInstallationSession = installerSession;
        this._featureArchiveInstallationSession.validateInstallation();
        try {
            this.getFeatureArchiveInstallationSession().prepareFeatureArchiveForInstallation();
        }
        catch (GdrException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GdrException("Failed to prepare feature archive " + this.getFeatureArchiveInstallationSession().getMetaDataHome().getGdrMetaDataHomePath() + " for installation.", (Throwable)e);
        }
    }

    public FeatureArchiveInstallationSession getFeatureArchiveInstallationSession() {
        return this._featureArchiveInstallationSession;
    }

    public FeatureLoader getFeatureLoader() {
        return this.getFeatureArchiveInstallationSession().getFeatureLoader();
    }

    public ComponentLoader getComponentLoader() {
        return this.getFeatureArchiveInstallationSession().getComponentLoader();
    }

    @Override
    public Map<ExternalFeatureReference, List<Reference>> getExternalDistributions() {
        return null;
    }

    @Override
    public Set<FeatureSet> getSelectedFeatures() {
        return FeatureSetHelper.getInstance().getSortedByDiskOrder(this.getFeatureSets(), this.getComponentsMap());
    }

    @Override
    public Map<FeatureSet, Collection<Component>> getComponentsMap() {
        return this.getComponentLoader().getComponentsMap();
    }

    @Override
    public void saveHomeMetadata(Path dir) throws GdrException, DataHandlerException, IOException {
        if (!Files.exists(dir, new LinkOption[0])) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                GdrException ex = new GdrException("Directory specified did not exist and could not be created: " + dir, (Throwable)e);
                _log.throwing(DistributionInstaller.class.getName(), "saveHomeMetadata", ex);
                throw ex;
            }
        } else if (!Files.isDirectory(dir, new LinkOption[0])) {
            GdrException ex = new GdrException("Directory specified was not a directory: " + dir);
            _log.throwing(DistributionInstaller.class.getName(), "saveHomeMetadata", ex);
            throw ex;
        }
        Path distributionDir = dir.resolve("distributions");
        DistributionHelper.getInstance().save((IDataHandlerWrapper)this.getDistribution(), distributionDir.resolve(DistributionHelper.getInstance().getDistributionFileName(this.getDistribution())));
        Path featuresDir = dir.resolve("featuresets");
        FeatureSetHelper.getInstance().saveFeatureSets(this.getFeatureSets(), featuresDir, true);
        ComponentHelper.getInstance().saveComponentsInShipHomeStructure(dir, true, this.getComponentLoader().getComponents());
    }

    @Override
    public Distribution getDistribution() {
        return this.getFeatureArchiveInstallationSession().getDistributions().iterator().next();
    }

    @Override
    public Set<FeatureSet> getFeatureSets() {
        return this.getFeatureLoader().getFeatureSets();
    }

    @Override
    protected void updateRegistry(Registry registry, SessionInfo session, Distribution ignoredDistribution, Map<FeatureSet, Collection<Component>> fullCompMap, Set<FeatureSet> selectedFeatures, boolean dynamic) throws GdrException {
        FeatureArchiveInstallationSession featureArchiveInstallationSession = this.getFeatureArchiveInstallationSession();
        LinkedHashMap<Distribution, LinkedHashSet<FeatureSet>> distributionsMap = new LinkedHashMap<Distribution, LinkedHashSet<FeatureSet>>();
        for (FeatureSet selectedFeature : selectedFeatures) {
            Set<DistributionTarget> distributions = featureArchiveInstallationSession.getDistributions(selectedFeature);
            for (DistributionTarget target : distributions) {
                Distribution distribution = target.getDistribution();
                LinkedHashSet<FeatureSet> distFeatures = (LinkedHashSet<FeatureSet>)distributionsMap.get(distribution);
                if (distFeatures == null) {
                    distFeatures = new LinkedHashSet<FeatureSet>();
                    distributionsMap.put(distribution, distFeatures);
                }
                distFeatures.add(selectedFeature);
            }
        }
        for (Distribution distribution : distributionsMap.keySet()) {
            Set features = (Set)distributionsMap.get(distribution);
            LinkedHashMap<FeatureSet, Collection<Component>> compMap = new LinkedHashMap<FeatureSet, Collection<Component>>();
            for (FeatureSet feature : features) {
                compMap.put(feature, fullCompMap.get(feature));
            }
            super.updateRegistry(registry, session, distribution, compMap, features, true);
        }
    }
}

