/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.installation;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.dependency.DependencyException;
import com.oracle.cie.gdr.Home;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.dbd.Distribution;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.installation.Installer;
import com.oracle.cie.gdr.installation.InstallerWrapper;
import com.oracle.cie.gdr.libraries.LibraryTargetHolder;
import com.oracle.cie.gdr.services.ServiceHolder;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class DefaultInstallerWrapper
implements InstallerWrapper {
    private Installer _installer;

    public DefaultInstallerWrapper(Installer installer) {
        this._installer = installer;
    }

    @Override
    public Map<FeatureSet, LibraryTargetHolder> getLibraryTargets() throws GdrException, DataHandlerException, DependencyException, IOException {
        return this._installer != null ? this._installer.getLibraryTargets() : null;
    }

    @Override
    public void addExtraFilesToDeInstallInfo(String name, String version, Collection<Path> files, boolean isFeature) throws GdrException {
        if (this._installer != null) {
            this._installer.addExtraFilesToDeInstallInfo(name, version, files, isFeature);
        }
    }

    @Override
    public Home getHome() {
        return this._installer != null ? this._installer.getHome() : null;
    }

    @Override
    public Set<FeatureSet> getFeatureSets() {
        return this._installer != null ? this._installer.getFeatureSets() : null;
    }

    @Override
    public Set<Component> getComponents(FeatureSet feature) {
        return this._installer != null ? this._installer.getComponents(feature) : null;
    }

    @Override
    public Set<FeatureSet> getSelectedFeatures() {
        return this._installer != null ? this._installer.getSelectedFeatures() : null;
    }

    @Override
    public Distribution getDistribution() {
        return this._installer != null ? this._installer.getDistribution() : null;
    }

    @Override
    public ServiceHolder getServiceHolder() {
        return this._installer != null ? this._installer.getInstallationSession().getServiceHolder() : null;
    }
}

