/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.helpers;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.dao.shd.ShiphomeDescriptor;
import com.oracle.cie.gdr.dao.shd.ShiphomeDescriptorBuildInfo;
import com.oracle.cie.gdr.helpers.DistributionHelper;
import com.oracle.cie.gdr.helpers.GdrHelper;
import com.oracle.cie.gdr.utils.GdrException;
import java.util.logging.Logger;

public class ShiphomeDescriptorHelper
extends GdrHelper<ShiphomeDescriptor> {
    private static final Logger _log = Logger.getLogger(ShiphomeDescriptorHelper.class.getName());
    public static final String NAMESPACE = "http://xmlns.oracle.com/cie/gdr/shiphome/descriptor";
    public static final String SHIPHOME_DESCRIPTOR = "shiphome-descriptor";
    public static final String SHIPHOME_DESCRIPTOR_DIR = "";
    private static ShiphomeDescriptorHelper _instance;

    public static ShiphomeDescriptorHelper getInstance() {
        if (_instance == null) {
            _instance = new ShiphomeDescriptorHelper(null);
        }
        return _instance;
    }

    public static ShiphomeDescriptorHelper getInstance(ClassLoader classLoader) {
        if (classLoader == null) {
            return ShiphomeDescriptorHelper.getInstance();
        }
        return new ShiphomeDescriptorHelper(classLoader);
    }

    private ShiphomeDescriptorHelper(ClassLoader classLoader) {
        super(ShiphomeDescriptor.class, classLoader);
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public String getRootElement() {
        return SHIPHOME_DESCRIPTOR;
    }

    public String getPath() {
        return SHIPHOME_DESCRIPTOR_DIR;
    }

    public String getShiphomeDescriptorXmlFileName(ShiphomeDescriptor shiphomeDescriptor) {
        return this.getProductLayersFileName(shiphomeDescriptor.getName(), shiphomeDescriptor.getVersion(), "xml");
    }

    public String getShiphomeDescriptorJsonFileName(ShiphomeDescriptor shiphomeDescriptor) {
        return this.getProductLayersFileName(shiphomeDescriptor.getName(), shiphomeDescriptor.getVersion(), "json");
    }

    public String getProductLayersFileName(String name, String version, String extension) {
        return ShiphomeDescriptorHelper.getFormattedNameVersion(name, version) + "." + extension;
    }

    public ShiphomeDescriptor createShiphomeDescriptor(String name, String version, String platform, String distCoord, String shiphomeName, String shiphomeCoord, String[] manifestCoords, String buildLabel, String additionalInfo, int disks) throws GdrException {
        if (StringUtil.isNullOrEmpty((String)name)) {
            GdrException ex = new GdrException("The shiphome descriptor's name was not provided.");
            _log.throwing(DistributionHelper.class.getName(), "createShiphomeDescriptor", ex);
            throw ex;
        }
        if (StringUtil.isNullOrEmpty((String)version)) {
            GdrException ex = new GdrException("The shiphome descriptor's version was not provided.");
            _log.throwing(DistributionHelper.class.getName(), "createShiphomeDescriptor", ex);
            throw ex;
        }
        if (StringUtil.isNullOrEmpty((String)distCoord)) {
            GdrException ex = new GdrException("The shiphome descriptor's distribution coordinate was not provided.");
            _log.throwing(DistributionHelper.class.getName(), "createShiphomeDescriptor", ex);
            throw ex;
        }
        if (StringUtil.isNullOrEmpty((String)shiphomeCoord)) {
            GdrException ex = new GdrException("The shiphome descriptor's shiphome coordinate was not provided.");
            _log.throwing(DistributionHelper.class.getName(), "createShiphomeDescriptor", ex);
            throw ex;
        }
        ShiphomeDescriptor shiphomeDescriptor = new ShiphomeDescriptor();
        shiphomeDescriptor.setName(name);
        shiphomeDescriptor.setVersion(version);
        shiphomeDescriptor.setPlatform(platform);
        shiphomeDescriptor.setDistributionCoordinate(distCoord);
        shiphomeDescriptor.setShiphomeName(shiphomeName);
        shiphomeDescriptor.setShiphomeCoordinate(shiphomeCoord);
        if (disks > 1) {
            shiphomeDescriptor.setDisks(disks);
        }
        ShiphomeDescriptorBuildInfo buildInfo = new ShiphomeDescriptorBuildInfo();
        shiphomeDescriptor.setBuildInfo(buildInfo);
        buildInfo.setManifestCoordinates(manifestCoords);
        buildInfo.setBuildLabel(buildLabel);
        buildInfo.setAdditionalInfo(additionalInfo);
        return shiphomeDescriptor;
    }
}

