/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.helpers;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.util.Delete;
import com.oracle.cie.common.util.FileCopy;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.dependency.mgmt.Artifact;
import com.oracle.cie.dependency.mgmt.DependencyManagementException;
import com.oracle.cie.dependency.mgmt.DependencyManagementFactory;
import com.oracle.cie.gdr.MetaDataHome;
import com.oracle.cie.gdr.dao.cmn.Reference;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.dbd.Distribution;
import com.oracle.cie.gdr.dao.di.DistributionInfo;
import com.oracle.cie.gdr.dao.di.Patch;
import com.oracle.cie.gdr.dao.ftr.ComponentReference;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.dao.pai.PatchAttachmentInfo;
import com.oracle.cie.gdr.dao.pai.PatchInfo;
import com.oracle.cie.gdr.helpers.DistributionHelper;
import com.oracle.cie.gdr.helpers.DistributionInfoHelper;
import com.oracle.cie.gdr.helpers.GdrHelper;
import com.oracle.cie.gdr.helpers.PatchHelper;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.packaging.DistributionPackager;
import com.oracle.cie.gdr.services.RepositoryService;
import com.oracle.cie.gdr.utils.GdrException;
import com.oracle.cie.gdr.utils.OraparamException;
import com.oracle.cie.repository.common.exceptions.RepositoryCommonException;
import com.oracle.cie.rest.RestException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.glcm.opatch.common.api.BasePatchFactory;
import oracle.glcm.opatch.common.api.InvalidPatchMetadataException;
import oracle.glcm.opatch.common.api.PatchFactory;
import oracle.glcm.opatch.common.api.PatchInventory;
import oracle.glcm.opatch.common.api.PatchMetadataLoadingException;
import oracle.glcm.opatch.common.api.PatchNotFoundException;

public class PatchAttachmentInfoHelper
extends GdrHelper<PatchAttachmentInfo> {
    private static final Logger _log = Logger.getLogger(PatchAttachmentInfo.class.getName());
    public static final String NAMESPACE = "http://xmlns.oracle.com/cie/gdr/pai";
    public static final String PATCH_ATTACHMENT_INFO = "patch-attachment-info";
    public static final String PATCH_ATTACHMENT_INFO_DIR = "info";
    public static final String PATCH_ATTACHMENT_INFO_FILE_NAME = "patch-attachment-info.xml";
    public static final String PATCH_ATTACHMENTS_DIR = "swflib";
    public static final String STAGER_ARG_PATCH_ATTACHMENTS_LOCATION = "PATCH_ATTACHMENTS_LOCATION";
    public static final String MOS_USERNAME = "MOS_USERNAME";
    public static final String MOS_PASSWORD = "MOS_PASSWORD";
    public static final String STOP_ON_FAILURE = "STOP_ON_FAILURE";
    private static PatchAttachmentInfoHelper _instance;

    public static PatchAttachmentInfoHelper getInstance() {
        if (_instance == null) {
            _instance = new PatchAttachmentInfoHelper(null);
        }
        return _instance;
    }

    public static PatchAttachmentInfoHelper getInstance(ClassLoader classLoader) {
        if (classLoader == null) {
            return PatchAttachmentInfoHelper.getInstance();
        }
        return new PatchAttachmentInfoHelper(classLoader);
    }

    protected PatchAttachmentInfoHelper(ClassLoader classLoader) {
        super(PatchAttachmentInfo.class, classLoader);
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public String getRootElement() {
        return PATCH_ATTACHMENT_INFO;
    }

    public String getPath() {
        return PATCH_ATTACHMENT_INFO_DIR;
    }

    public File getPatchAttachmentInfoFile(File metaDataRoot) {
        return new File(metaDataRoot, this.getPath() + File.separator + PATCH_ATTACHMENT_INFO_FILE_NAME);
    }

    public File getPatchAttachmentsLocation(File metaDataRoot) {
        return new File(metaDataRoot, PATCH_ATTACHMENTS_DIR);
    }

    public Path getPatchAttachmentsLocation(Path metaDataRoot) {
        return metaDataRoot.resolve(PATCH_ATTACHMENTS_DIR);
    }

    public PatchAttachmentInfo getPatchAttachmentInfo(File patchAttachmentInfoFile) throws IOException, DataHandlerException, GdrException {
        return this.getPatchAttachmentInfo(NioHelper.getInstance().getPath(patchAttachmentInfoFile));
    }

    public PatchAttachmentInfo getPatchAttachmentInfo(Path patchAttachmentInfoFile) throws IOException, DataHandlerException, GdrException {
        if (patchAttachmentInfoFile == null || !Files.exists(patchAttachmentInfoFile, new LinkOption[0]) || Files.isDirectory(patchAttachmentInfoFile, new LinkOption[0])) {
            GdrException ex = new GdrException("Patch attachment info file specified was invalid: " + patchAttachmentInfoFile);
            _log.throwing(PatchAttachmentInfoHelper.class.getName(), "getPatchAttachmentInfo", ex);
            throw ex;
        }
        return (PatchAttachmentInfo)this.getRootWrapper(patchAttachmentInfoFile);
    }

    public PatchAttachmentInfo generatePatchAttachmentInfo(File stageLocation, HashMap<String, oracle.glcm.opatch.common.api.Patch> applicablePatches, boolean stopOnFailure) throws GdrException {
        File attachmentsLocation = this.getPatchAttachmentsLocation(stageLocation.getParentFile());
        ArrayList<PatchInfo> patchInfos = new ArrayList<PatchInfo>();
        if (applicablePatches == null || applicablePatches.isEmpty()) {
            _log.warning("Patch attachment metadata was not generated due to not having applicable patches.");
            return null;
        }
        for (String patchLocation : applicablePatches.keySet()) {
            File patchZipFile = new File(patchLocation);
            try {
                oracle.glcm.opatch.common.api.Patch patchObj = applicablePatches.get(patchLocation);
                PatchInfo patchInfo = new PatchInfo();
                patchInfo.setId(patchObj.getPatchId());
                for (PatchInventory.Component component : patchObj.getComponents()) {
                    patchInfo.addComponent(new Reference(component.getName(), component.getVersion()));
                }
                patchInfos.add(patchInfo);
                FileCopy.copy((File)patchZipFile, (File)new File(attachmentsLocation, patchZipFile.getName()), (boolean)true);
            }
            catch (Exception anyException) {
                GdrException gdrException = new GdrException("There was a problem generating patch attachment info.", (Throwable)anyException);
                _log.log(Level.WARNING, "There was a problem generating patch attachment info.", anyException);
                if (!stopOnFailure) continue;
                throw gdrException;
            }
        }
        PatchAttachmentInfo patchAttachmentInfo = new PatchAttachmentInfo();
        patchAttachmentInfo.setPatchInfos(patchInfos);
        return patchAttachmentInfo;
    }

    public List<PatchInfo> getPatchInfos(RepositoryService repositoryService, File stageLoc, DistributionInfo info, Set<Component> components, Set<Integer> platforms) throws GdrException {
        ArrayList<File> patches;
        HashSet<Reference> compRefs;
        Boolean stopOnFailure;
        File attachmentsLocation;
        ArrayList<PatchInfo> patchInfos;
        block8: {
            patchInfos = new ArrayList<PatchInfo>();
            attachmentsLocation = this.getPatchAttachmentsLocation(stageLoc.getParentFile());
            stopOnFailure = true;
            if (!StringUtil.isNullOrEmpty((String)repositoryService.getVariableResolverService().get(STOP_ON_FAILURE))) {
                stopOnFailure = Boolean.parseBoolean(repositoryService.getVariableResolverService().get(STOP_ON_FAILURE));
            }
            compRefs = new HashSet<Reference>();
            for (Component component : components) {
                compRefs.add(new Reference(component.getName(), component.getVersion()));
            }
            patches = new ArrayList();
            try {
                patches = this.getPatches(repositoryService, info, platforms);
            }
            catch (GdrException e) {
                _log.warning("Unable to process attached patches.");
                _log.throwing(PatchAttachmentInfoHelper.class.getName(), "getPatchInfos", e);
                if (!stopOnFailure.booleanValue()) break block8;
                throw e;
            }
        }
        HashMap<String, oracle.glcm.opatch.common.api.Patch> applicablePatches = this.getApplicablePatches(patches, compRefs, stopOnFailure);
        for (String patchLocation : applicablePatches.keySet()) {
            File patchZipFile = new File(patchLocation);
            oracle.glcm.opatch.common.api.Patch patchObj = applicablePatches.get(patchLocation);
            PatchInfo patchInfo = new PatchInfo();
            patchInfo.setId(patchObj.getPatchId());
            for (PatchInventory.Component component : patchObj.getComponents()) {
                patchInfo.addComponent(new Reference(component.getName(), component.getVersion()));
            }
            patchInfos.add(patchInfo);
            try {
                FileCopy.copy((File)patchZipFile, (File)new File(attachmentsLocation, patchZipFile.getName()), (boolean)true);
            }
            catch (IOException e) {
                _log.warning("There was a problem while copying patch:  " + patchZipFile);
                GdrException ex = new GdrException("There was a problem while copying patch:  " + patchZipFile, (Throwable)e);
                _log.throwing(PatchAttachmentInfoHelper.class.getName(), "getPatchInfos", ex);
                if (!stopOnFailure.booleanValue()) continue;
                throw ex;
            }
        }
        return patchInfos;
    }

    public HashMap<String, oracle.glcm.opatch.common.api.Patch> getApplicablePatches(List<File> patches, File gdrHome, String distributionName, String distributionVersion, boolean stopOnFailure) throws GdrException {
        HashSet<Reference> components;
        block4: {
            components = new HashSet<Reference>();
            try {
                for (FeatureSet featureset : DistributionHelper.getInstance(this.getClassLoader()).getFeatureSets(DistributionHelper.getInstance(this.getClassLoader()).getDistribution(gdrHome, distributionName, distributionVersion), gdrHome)) {
                    for (ComponentReference component : featureset.getComponentReferences()) {
                        components.add(new Reference(component.getName(), component.getVersion()));
                    }
                }
            }
            catch (Exception e) {
                if (!stopOnFailure) break block4;
                _log.warning(e.getMessage());
                _log.throwing(PatchAttachmentInfoHelper.class.getName(), "getApplicablePatches", e);
                throw new GdrException((Throwable)e);
            }
        }
        HashMap<String, oracle.glcm.opatch.common.api.Patch> applicablePatches = this.getApplicablePatches(patches, components, stopOnFailure);
        return applicablePatches;
    }

    public HashMap<String, oracle.glcm.opatch.common.api.Patch> getApplicablePatches(List<File> patches, MetaDataHome metaDataHome, String distributionName, String distributionVersion, boolean stopOnFailure) throws GdrException {
        HashSet<Reference> components;
        block4: {
            components = new HashSet<Reference>();
            try {
                DistributionHelper distributionHelper = DistributionHelper.getInstance(this.getClassLoader());
                Distribution distribution = distributionHelper.getDistribution(metaDataHome, distributionName, distributionVersion);
                for (FeatureSet featureset : distributionHelper.getFeatureSets(distribution, metaDataHome)) {
                    for (ComponentReference component : featureset.getComponentReferences()) {
                        components.add(new Reference(component.getName(), component.getVersion()));
                    }
                }
            }
            catch (Exception e) {
                if (!stopOnFailure) break block4;
                _log.warning(e.getMessage());
                _log.throwing(PatchAttachmentInfoHelper.class.getName(), "getApplicablePatches", e);
                throw new GdrException((Throwable)e);
            }
        }
        HashMap<String, oracle.glcm.opatch.common.api.Patch> applicablePatches = this.getApplicablePatches(patches, components, stopOnFailure);
        return applicablePatches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private HashMap<String, oracle.glcm.opatch.common.api.Patch> getApplicablePatches(List<File> patches, Set<Reference> components, Boolean stopOnFailure) throws GdrException {
        File tempDir = null;
        HashMap<String, oracle.glcm.opatch.common.api.Patch> applicablePatches = new HashMap<String, oracle.glcm.opatch.common.api.Patch>();
        try {
            try {
                tempDir = Files.createTempDirectory(null, new FileAttribute[0]).toFile();
            }
            catch (IOException e) {
                GdrException ex = new GdrException("Unable to create temporary directory to store patches.", (Throwable)e);
                _log.throwing(PatchAttachmentInfoHelper.class.getName(), "getApplicablePatches.", e);
                throw ex;
            }
            if (patches != null && !patches.isEmpty()) {
                PatchFactory fac = BasePatchFactory.instance();
                for (File patchZipFile : patches) {
                    Map<String, String> extractedPatches;
                    block17: {
                        File patchExtractLocation = new File(tempDir, patchZipFile.getName());
                        extractedPatches = null;
                        try {
                            PatchHelper.getInstance(this.getClassLoader()).extractPatch(patchZipFile, patchExtractLocation);
                            extractedPatches = PatchHelper.getInstance(this.getClassLoader()).getPatchLocationMap(patchExtractLocation);
                        }
                        catch (GdrException e) {
                            _log.warning(e.getMessage());
                            _log.throwing(PatchAttachmentInfoHelper.class.getName(), "getApplicablePatches", e);
                            if (!stopOnFailure.booleanValue()) break block17;
                            throw e;
                        }
                    }
                    if (extractedPatches == null) continue;
                    for (Map.Entry<String, String> patchEntry : extractedPatches.entrySet()) {
                        try {
                            oracle.glcm.opatch.common.api.Patch patchObj = fac.createPatch(patchEntry.getValue());
                            _log.info("Analysing patch " + patchObj.getPatchId() + "...");
                            boolean containsRequiredComponents = false;
                            boolean optionalComponentsInDistribution = false;
                            boolean requiredComponentsInDistribution = true;
                            HashSet<Reference> optionalComponents = new HashSet<Reference>();
                            for (PatchInventory.Component component : patchObj.getComponents()) {
                                Reference ref = new Reference(component.getName(), component.getVersion());
                                if (component.isRequired().booleanValue()) {
                                    containsRequiredComponents = true;
                                    if (!components.contains((Object)ref)) {
                                        requiredComponentsInDistribution = false;
                                        String message = "Patch " + patchObj.getPatchId() + " was not attached due to " + component.getName() + ":" + component.getVersion() + " component is required.";
                                        _log.warning(message);
                                        if (!stopOnFailure.booleanValue()) break;
                                        GdrException ex = new GdrException(message);
                                        _log.throwing(PatchAttachmentInfoHelper.class.getName(), "getApplicablePatches", ex);
                                        throw ex;
                                    }
                                    _log.info("Required component " + ref.getName() + " " + ref.getVersion() + " present in distribution.");
                                    continue;
                                }
                                optionalComponents.add(ref);
                            }
                            if (!containsRequiredComponents) {
                                for (Reference ref : optionalComponents) {
                                    if (components.contains((Object)ref)) {
                                        optionalComponentsInDistribution = true;
                                        _log.info("Optional component " + ref.getName() + " " + ref.getVersion() + " present in distribution.");
                                        continue;
                                    }
                                    _log.info("Optional component " + ref.getName() + " " + ref.getVersion() + " not present in distribution.");
                                }
                                applicablePatches.put(patchZipFile.getPath(), patchObj);
                                if (optionalComponentsInDistribution) continue;
                                String message = "Patch " + patchObj.getPatchId() + ": There are no required components defined in the patch metadata and none of the optional components are present in current distribution.";
                                _log.warning(message);
                                continue;
                            }
                            if (!requiredComponentsInDistribution) continue;
                            applicablePatches.put(patchZipFile.getPath(), patchObj);
                        }
                        catch (InvalidPatchMetadataException | PatchMetadataLoadingException | PatchNotFoundException e) {
                            _log.warning("There was a problem while parsing patch the metadata of patch: " + patchZipFile.getPath());
                            GdrException ex = new GdrException("There was a problem while parsing patch the metadata of patch: " + patchZipFile.getPath());
                            _log.throwing(PatchAttachmentInfoHelper.class.getName(), "getApplicablePatches", ex);
                            if (!stopOnFailure.booleanValue()) continue;
                            throw ex;
                        }
                    }
                }
            }
            if (tempDir == null) return applicablePatches;
        }
        catch (Throwable throwable) {
            if (tempDir == null) throw throwable;
            Delete.delete(tempDir);
            throw throwable;
        }
        Delete.delete((File)tempDir);
        return applicablePatches;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<File> getPatches(RepositoryService repositoryService, DistributionInfo info, Set<Integer> platforms) throws GdrException {
        ArrayList<File> patchListFile = new ArrayList<File>();
        String patchesLocation = repositoryService.getVariableResolverService().get(STAGER_ARG_PATCH_ATTACHMENTS_LOCATION);
        if (!StringUtil.isNullOrEmpty((String)patchesLocation)) {
            File patchesLocationFile = new File(patchesLocation);
            if (!patchesLocationFile.exists() || patchesLocationFile.listFiles() == null) return patchListFile;
            patchListFile.addAll(Arrays.asList(patchesLocationFile.listFiles()));
            return patchListFile;
        }
        try {
            List patches;
            if (info == null || (patches = DistributionInfoHelper.getInstance().getPatchesFromDistributionInfo(info, null, false)) == null || patches.isEmpty()) return patchListFile;
            for (Patch patch : patches) {
                if (patch.getOuiPlatform() != 2000 && !platforms.contains(2000) && !platforms.contains(patch.getOuiPlatform())) continue;
                try {
                    Artifact patchArtifact = DependencyManagementFactory.getInstance().getArtifact(this.getPatchGroupId(patch), this.getPatchArtifactId(patch), DependencyManagementFactory.getInstance().getVersion(), "zip");
                    patchListFile.add(repositoryService.retrieveRepositoryArtifact(patchArtifact, true));
                }
                catch (DependencyManagementException | RepositoryCommonException | RestException | IOException e) {
                    GdrException ex = new GdrException("Unable to retrieve repository artifact.", e);
                    _log.throwing(DistributionPackager.class.getName(), "retrievePatches", ex);
                    throw ex;
                    return patchListFile;
                }
            }
        }
        catch (OraparamException oraparamException) {
            // empty catch block
        }
        return patchListFile;
    }

    public boolean distributionContainsPatches(File gdrHome, String distributionName, String distributionVersion) throws GdrException {
        DistributionInfo info = DistributionInfoHelper.getInstance().getDistributionInfo(gdrHome, distributionName, distributionVersion);
        return this.distributionContainsPatches(info);
    }

    public boolean distributionContainsPatches(DistributionInfo info) throws GdrException {
        try {
            List patches;
            if (info != null && !(patches = DistributionInfoHelper.getInstance().getPatchesFromDistributionInfo(info, null, false)).isEmpty()) {
                return true;
            }
        }
        catch (OraparamException oraparamException) {
            // empty catch block
        }
        return false;
    }

    public String getPatchGroupId(Patch patch) {
        return this.getPatchGroupId(patch.getId());
    }

    public String getPatchGroupId(String patchId) {
        return "com.oracle.cie.gdr.patch.mos." + patchId;
    }

    public String getPatchArtifactId(Patch patch) {
        return this.getPatchArtifactId(patch.getId(), patch.getRelease(), patch.getAruPlatform());
    }

    public String getPatchArtifactId(String patchId, String release, String platform) {
        return "p" + patchId + "_" + release.replace(".", "") + "_" + platform;
    }

    public String getPatchFileName(Patch patch) {
        return this.getPatchArtifactId(patch) + "." + "zip";
    }
}

