/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.helpers;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.common.dao.tree.TreeDataHandler;
import com.oracle.cie.common.tree.Tree;
import com.oracle.cie.common.tree.XMLTreeDataFactory;
import com.oracle.cie.gdr.Home;
import com.oracle.cie.gdr.dao.facfg.ConfigFiles;
import com.oracle.cie.gdr.dao.loui.LegacyComponents;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;

public class LegacyComponentHelper {
    private static final Logger _log = Logger.getLogger(LegacyComponentHelper.class.getName());
    public static final String NAMESPACE = "http://xmlns.oracle.com/cie/gdr/loui";
    public static final String RESOURCES_DIR = "resources";
    public static final String PRD_LIST = "PRD_LIST";
    public static final String CONTENTS_XML = "ContentsXML";
    private static LegacyComponentHelper _instance;

    public static LegacyComponentHelper getInstance() {
        if (_instance == null) {
            _instance = new LegacyComponentHelper();
        }
        return _instance;
    }

    public LegacyComponents getLegacyComponents(Path legacyComps) throws IOException, DataHandlerException, GdrException {
        LegacyComponents legacyComponents = null;
        if (legacyComps == null) {
            GdrException e = new GdrException("Legacy comps.xml specified was invalid: " + legacyComps);
            _log.throwing(ConfigFiles.class.getName(), "getConfigFiles", e);
            throw e;
        }
        TreeDataHandler dataHandler = null;
        try (FileInputStream is = null;){
            is = new FileInputStream(legacyComps.toFile());
            Tree tree1 = XMLTreeDataFactory.create((InputStream)is, (boolean)true);
            dataHandler = new TreeDataHandler(tree1, tree1.getId(), tree1.getId(), null, null);
            legacyComponents = new LegacyComponents((IDataHandler)dataHandler);
        }
        return legacyComponents;
    }

    public String getRepositoryPath() {
        return PRD_LIST;
    }

    public static boolean isLegacyHome(File directory) {
        return LegacyComponentHelper.isLegacyHome(NioHelper.getInstance().getPath(directory));
    }

    public static boolean isLegacyHome(Path directory) {
        return !Home.isValidHome(directory) && directory != null && Files.isDirectory(directory, new LinkOption[0]) && Files.isDirectory(directory.resolve("inventory").resolve(CONTENTS_XML), new LinkOption[0]) && Files.exists(directory.resolve("inventory").resolve(CONTENTS_XML).resolve("comps.xml"), new LinkOption[0]);
    }

    public static boolean isLegacyFederatedHome(Path homeDirPath) {
        return Files.exists(homeDirPath.resolve("inventory").resolve(CONTENTS_XML).resolve("federated"), new LinkOption[0]);
    }

    public static Set<String> getLegacyProductFamilies(Path homeDirPath) throws IOException {
        HashSet<String> productFamilies = new HashSet<String>();
        Path fohMarker = homeDirPath.resolve("inventory").resolve(CONTENTS_XML).resolve("federated");
        if (Files.exists(fohMarker, new LinkOption[0])) {
            Properties properties = new Properties();
            try (FileChannel channel = FileChannel.open(fohMarker, StandardOpenOption.READ);
                 FileLock lock = channel.lock(0L, Long.MAX_VALUE, true);){
                properties.load(Channels.newInputStream(channel));
            }
            for (String family : properties.getProperty("PRODUCT_FAMILY").split(",")) {
                productFamilies.add(family);
            }
        }
        return productFamilies;
    }
}

