/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.helpers;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.dao.IDataHandlerWrapper;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.dao.cmn.Reference;
import com.oracle.cie.gdr.dao.lbm.ComponentMapping;
import com.oracle.cie.gdr.dao.lbm.LabelMap;
import com.oracle.cie.gdr.dao.lbm.LabelMapReference;
import com.oracle.cie.gdr.helpers.GdrHelper;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.services.TopLevelDirectoryService;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LabelMapHelper
extends GdrHelper<LabelMap> {
    private static final Logger _log = Logger.getLogger(LabelMapHelper.class.getName());
    public static final String NAMESPACE = "http://xmlns.oracle.com/cie/gdr/lbm";
    public static final String LABEL_MAP = "label-map";
    public static final String LABEL_MAP_DIR = "mappings";
    public static final String LABEL_MAP_FILE = "label-map.xml";
    private static LabelMapHelper _instance;
    private static final String LABEL_MAP_LOCATION_OVERRIDE = "LabelMapHelper.label.map.location.override";

    public static LabelMapHelper getInstance() {
        if (_instance == null) {
            _instance = new LabelMapHelper(null);
        }
        return _instance;
    }

    public static LabelMapHelper getInstance(ClassLoader classLoader) {
        if (classLoader == null) {
            return LabelMapHelper.getInstance();
        }
        return new LabelMapHelper(classLoader);
    }

    private LabelMapHelper(ClassLoader classLoader) {
        super(LabelMap.class, classLoader);
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public String getRootElement() {
        return LABEL_MAP;
    }

    public String getPath() {
        return LABEL_MAP_DIR;
    }

    public LabelMap getLabelMap(File metaDataDir) throws IOException, DataHandlerException, GdrException {
        return this.getLabelMap(NioHelper.getInstance().getPath(metaDataDir));
    }

    public LabelMap getLabelMap(Path metaDataDir) throws IOException, DataHandlerException, GdrException {
        LabelMap labelMap = null;
        String override = System.getProperty(LABEL_MAP_LOCATION_OVERRIDE);
        if (!StringUtil.isNullOrEmpty((String)override, (boolean)true)) {
            labelMap = this.getRootWrapper(new File(override));
        } else {
            List labelMaps = this.getFileLocatorService(metaDataDir).getFiles(this.getPath(), LABEL_MAP_FILE);
            if (labelMaps != null && !labelMaps.isEmpty()) {
                for (File f : labelMaps) {
                    if (_log.isLoggable(Level.FINER)) {
                        _log.finer("Creating root wrapper from metaDataRoot=" + metaDataDir + " for " + LABEL_MAP_FILE + " at " + f);
                    }
                    LabelMap map = this.getRootWrapper(f);
                    if (labelMap == null) {
                        labelMap = map;
                        continue;
                    }
                    this.mergeLabelMaps(labelMap, map);
                }
            }
        }
        if (labelMap != null) {
            this.validateLabelMap(labelMap);
        }
        return labelMap;
    }

    public LabelMap getRootWrapper(File file) throws IOException, DataHandlerException {
        LabelMap labelMap = (LabelMap)super.getRootWrapper(file);
        labelMap.setLabelMapLocation(file);
        return labelMap;
    }

    public void validateLabelMap(LabelMap labelMap) throws DataHandlerException, GdrException {
        List<ComponentMapping> mappings;
        this.validate((IDataHandlerWrapper)labelMap);
        if (labelMap != null && (mappings = labelMap.getMappings()) != null && !mappings.isEmpty()) {
            ArrayList<String> products = new ArrayList<String>();
            ArrayList<String> seriess = new ArrayList<String>();
            ArrayList<String> labels = new ArrayList<String>();
            for (ComponentMapping mapping : mappings) {
                String product = mapping.getProduct();
                String series = mapping.getSeries();
                String label = mapping.getLabel();
                if (StringUtil.isNullOrEmpty((String)product, (boolean)true) && StringUtil.isNullOrEmpty((String)series, (boolean)true) && StringUtil.isNullOrEmpty((String)label, (boolean)true)) {
                    GdrException ex = new GdrException("Encountered mapping in label map which defines no product, series, or label values");
                    _log.throwing(LabelMapHelper.class.getName(), "validateLabelMap", ex);
                    throw ex;
                }
                if (!StringUtil.isNullOrEmpty((String)product, (boolean)true)) {
                    if (products.contains(product)) {
                        GdrException ex = new GdrException("Encountered duplicate mapping in label map for product " + product);
                        _log.throwing(LabelMapHelper.class.getName(), "validateLabelMap", ex);
                        throw ex;
                    }
                    products.add(product);
                }
                if (!StringUtil.isNullOrEmpty((String)series, (boolean)true)) {
                    if (seriess.contains(series)) {
                        GdrException ex = new GdrException("Encountered duplicate mapping in label map for series " + series);
                        _log.throwing(LabelMapHelper.class.getName(), "validateLabelMap", ex);
                        throw ex;
                    }
                    seriess.add(series);
                }
                if (StringUtil.isNullOrEmpty((String)label, (boolean)true)) continue;
                if (labels.contains(label)) {
                    GdrException ex = new GdrException("Encountered duplicate mapping in label map for label " + label);
                    _log.throwing(LabelMapHelper.class.getName(), "validateLabelMap", ex);
                    throw ex;
                }
                labels.add(label);
            }
        }
    }

    public void mergeLabelMaps(LabelMap baseMap, LabelMap extMap) {
        if (baseMap != null && extMap != null) {
            List<ComponentMapping> baseMappings = baseMap.getMappings();
            List<ComponentMapping> extMappings = extMap.getMappings();
            ArrayList<ComponentMapping> mergedMappings = new ArrayList<ComponentMapping>(baseMappings);
            for (ComponentMapping extCompMapping : extMappings) {
                ComponentMapping baseCompMapping = this.getMatchingComponentMapping(extCompMapping, baseMappings);
                if (baseCompMapping != null) {
                    HashSet<LabelMapReference> mergedComps = new HashSet<LabelMapReference>(baseCompMapping.getComponents());
                    mergedComps.addAll(extCompMapping.getComponents());
                    baseCompMapping.setComponents(new ArrayList<LabelMapReference>(mergedComps));
                    continue;
                }
                mergedMappings.add(extCompMapping);
            }
            baseMap.setMappings(mergedMappings);
        }
    }

    public ComponentMapping getMatchingComponentMapping(ComponentMapping componentMapping, List<ComponentMapping> mappings) {
        if (componentMapping != null && mappings != null && !mappings.isEmpty()) {
            for (ComponentMapping mapping : mappings) {
                if (!componentMapping.equals((Object)mapping)) continue;
                return mapping;
            }
        }
        return null;
    }

    public Collection<ComponentMapping> getMappingsForComponent(LabelMap labelMap, Reference reference) {
        List<ComponentMapping> compMappings;
        ArrayList<ComponentMapping> mappings = new ArrayList<ComponentMapping>();
        if (labelMap != null && reference != null && (compMappings = labelMap.getMappings()) != null && !compMappings.isEmpty()) {
            for (ComponentMapping mapping : compMappings) {
                if (this.getLabelMapReference(mapping, reference) == null) continue;
                mappings.add(mapping);
            }
        }
        return mappings;
    }

    public LabelMapReference getLabelMapReference(ComponentMapping mapping, Reference reference) {
        if (mapping != null && reference != null) {
            List<LabelMapReference> comps = mapping.getComponents();
            for (LabelMapReference comp : comps) {
                if (!comp.getName().equals(reference.getName()) || !comp.getVersion().equals(reference.getVersion())) continue;
                return comp;
            }
        }
        return null;
    }

    public Collection<File> getBaseTopLevelDir(File srchome, LabelMap labelMap, Reference ref) throws GdrException {
        Collection<Path> paths = this.getBaseTopLevelDir(NioHelper.getInstance().getPath(srchome), labelMap, ref);
        LinkedHashSet<File> files = null;
        if (paths != null) {
            files = new LinkedHashSet<File>();
            for (Path p : paths) {
                files.add(p.toFile());
            }
        }
        return files;
    }

    public Collection<Path> getBaseTopLevelDir(Path srchome, LabelMap labelMap, Reference ref) throws GdrException {
        Collection<Path> dirs = this.getTopLevelDirs(srchome, labelMap, ref, true, false);
        if (dirs != null && dirs.size() > 1) {
            _log.warning("Encountered multiple base component entries in label map for component: " + (Object)((Object)ref));
        }
        return dirs;
    }

    public Collection<Path> getExtensionTopLevelDirs(Path srchome, LabelMap labelMap, Reference ref) throws GdrException {
        LinkedHashSet dirs = this.getTopLevelDirs(srchome, labelMap, ref, false, true);
        return dirs != null ? dirs : new LinkedHashSet();
    }

    public Collection<File> getTopLevelDirs(File srchome, LabelMap labelMap, Reference ref) throws GdrException {
        Collection<Path> paths = this.getTopLevelDirs(NioHelper.getInstance().getPath(srchome), labelMap, ref, true, true);
        LinkedHashSet<File> files = null;
        if (paths != null) {
            files = new LinkedHashSet<File>();
            for (Path p : paths) {
                files.add(p.toFile());
            }
        }
        return files;
    }

    public Collection<Path> getTopLevelDirs(Path srchome, LabelMap labelMap, Reference ref, boolean base, boolean extension) throws GdrException {
        Collection<ComponentMapping> mappings = this.getMappingsForComponent(labelMap, ref);
        if (mappings == null || mappings.isEmpty()) {
            GdrException ex = new GdrException("Unable to locate label mapping for component: " + (Object)((Object)ref));
            _log.throwing(LabelMapHelper.class.getName(), "getTopLevelDirs", ex);
            throw ex;
        }
        LinkedHashSet<Path> dirs = new LinkedHashSet<Path>();
        if (base || extension) {
            int iterCount = 1;
            for (ComponentMapping mapping : mappings) {
                String productName = mapping.getProduct();
                String seriesName = mapping.getSeries();
                String labelName = mapping.getLabel();
                if (StringUtil.isNullOrEmpty((String)productName, (boolean)true) && StringUtil.isNullOrEmpty((String)seriesName, (boolean)true) && StringUtil.isNullOrEmpty((String)labelName, (boolean)true)) {
                    GdrException ex = new GdrException("Component mapping missing ADE product, series or label name for component: " + (Object)((Object)ref) + " mapping: " + (Object)((Object)mapping));
                    _log.throwing(LabelMapHelper.class.getName(), "getTopLevelDirs", ex);
                    throw ex;
                }
                LabelMapReference labelMapRef = this.getLabelMapReference(mapping, ref);
                if (labelMapRef != null && (extension && labelMapRef.isExtension() || base && !labelMapRef.isExtension())) {
                    String value = null;
                    if (!StringUtil.isNullOrEmpty((String)labelName, (boolean)true)) {
                        value = labelName;
                    } else if (!StringUtil.isNullOrEmpty((String)seriesName, (boolean)true)) {
                        value = seriesName;
                    } else if (!StringUtil.isNullOrEmpty((String)productName, (boolean)true)) {
                        value = productName;
                    }
                    Path file = TopLevelDirectoryService.getTopLevelDirectory(srchome, value, labelMapRef.getTopLevelDir());
                    if (file != null) {
                        dirs.add(file);
                        _log.info("The defined top level directory :" + file.toAbsolutePath() + "\" under the label/series/product \"" + value + "\" is existing");
                    } else {
                        _log.info("The defined top level directory value \"" + labelMapRef.getTopLevelDir() + "\" for \"" + value + "\" was not a matching top level directory.");
                        if (iterCount == mappings.size() && dirs.size() == 0) {
                            _log.info("Throwing GdrException as the defined top-level directory doesn't existing in any of the matching labels");
                            throw new GdrException("The defined top level directory value \"" + labelMapRef.getTopLevelDir() + "\" for \"" + value + "\" was not a matching top level directory.");
                        }
                    }
                }
                ++iterCount;
            }
        }
        return dirs;
    }

    public LabelMap createLabelMap(String series, String tld, Set<Reference> componentReferences) {
        HashMap<Reference, String> tlds = null;
        if (componentReferences != null && !componentReferences.isEmpty() && !StringUtil.isNullOrEmpty((String)tld, (boolean)true)) {
            tlds = new HashMap<Reference, String>();
            for (Reference ref : componentReferences) {
                tlds.put(ref, tld);
            }
        }
        return this.createLabelMap(series, tlds, componentReferences);
    }

    public LabelMap createLabelMap(String series, Map<Reference, String> tlds, Set<Reference> componentReferences) {
        HashMap<Reference, String> serieses = null;
        if (componentReferences != null && !componentReferences.isEmpty()) {
            if (series == null) {
                series = "null";
            }
            serieses = new HashMap<Reference, String>();
            for (Reference ref : componentReferences) {
                serieses.put(ref, series);
            }
        }
        return this.createLabelMap(serieses, tlds, componentReferences);
    }

    public LabelMap createLabelMap(Map<Reference, String> serieses, Map<Reference, String> tlds, Set<Reference> componentReferences) {
        LabelMap labelMap = new LabelMap();
        LinkedHashMap seriesCompMap = new LinkedHashMap();
        if (serieses != null && !serieses.isEmpty()) {
            for (String series : serieses.values()) {
                if (seriesCompMap.containsKey(series)) continue;
                seriesCompMap.put(series, new ArrayList());
            }
            if (componentReferences != null && !componentReferences.isEmpty()) {
                for (Reference compRef : componentReferences) {
                    LabelMapReference ref;
                    String series = serieses.get((Object)compRef);
                    if (series == null && !seriesCompMap.containsKey(series = "null")) {
                        seriesCompMap.put(series, new ArrayList());
                    }
                    List mapRefs = (List)seriesCompMap.get(series);
                    if (compRef instanceof LabelMapReference) {
                        ref = (LabelMapReference)compRef;
                    } else {
                        String tld;
                        ref = new LabelMapReference();
                        ref.setName(compRef.getName());
                        ref.setVersion(compRef.getVersion());
                        String string = tld = tlds != null ? tlds.get((Object)compRef) : null;
                        if (tld != null) {
                            ref.setTopLevelDir(tld);
                        }
                    }
                    mapRefs.add(ref);
                }
            }
        }
        ArrayList<ComponentMapping> compMappings = new ArrayList<ComponentMapping>();
        for (String series : seriesCompMap.keySet()) {
            ComponentMapping mapping = new ComponentMapping();
            mapping.setSeries(series);
            mapping.setComponents((List)seriesCompMap.get(series));
            compMappings.add(mapping);
        }
        labelMap.setMappings(compMappings);
        return labelMap;
    }
}

