/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.helpers;

import com.oracle.cie.common.comdev.ComdevHelper;
import com.oracle.cie.common.dao.AbstractDataHandlerWrapper;
import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.common.dao.IDataHandlerWrapper;
import com.oracle.cie.common.dao.tree.TreeDataHandlerSpiImpl;
import com.oracle.cie.common.util.Delete;
import com.oracle.cie.common.util.FileCopy;
import com.oracle.cie.common.util.IObjectStore;
import com.oracle.cie.common.util.IoBridge;
import com.oracle.cie.common.util.JarHelper;
import com.oracle.cie.common.util.ObjectStoreManager;
import com.oracle.cie.common.util.ObjectStoreValueNotFoundException;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.StringsubsEngine;
import com.oracle.cie.common.util.Xslt;
import com.oracle.cie.common.xml.difftreefilter.ObjectFactory;
import com.oracle.cie.common.xml.difftreefilter.XmlDiffRuleType;
import com.oracle.cie.common.xml.stringsubs.StringsubsDefinition;
import com.oracle.cie.common.xmldiff.XmlDiffRule;
import com.oracle.cie.common.xmldiff.XmlDiffTreeFilter;
import com.oracle.cie.dependency.mgmt.Artifact;
import com.oracle.cie.dependency.mgmt.DependencyManagementException;
import com.oracle.cie.dependency.mgmt.DependencyManagementFactory;
import com.oracle.cie.dependency.mgmt.Version;
import com.oracle.cie.gdr.ComponentTarget;
import com.oracle.cie.gdr.FileTarget;
import com.oracle.cie.gdr.Home;
import com.oracle.cie.gdr.MetaDataHome;
import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.carbdiff.CarbDiffException;
import com.oracle.cie.gdr.carbdiff.Strategy;
import com.oracle.cie.gdr.dao.cmn.Reference;
import com.oracle.cie.gdr.dao.cmn.ResourceBundleInfo;
import com.oracle.cie.gdr.dao.cmn.ResourceBundleInfoHolder;
import com.oracle.cie.gdr.dao.cpd.ArtifactFile;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.cpd.Directory;
import com.oracle.cie.gdr.dao.cpd.FileGroup;
import com.oracle.cie.gdr.dao.cpd.FileMap;
import com.oracle.cie.gdr.dao.cpd.FileModifier;
import com.oracle.cie.gdr.dao.cpd.IncludeExclude;
import com.oracle.cie.gdr.dao.cpd.Library;
import com.oracle.cie.gdr.dao.cpd.LibraryEntry;
import com.oracle.cie.gdr.dao.cpd.Mapping;
import com.oracle.cie.gdr.dao.cpd.Modifier;
import com.oracle.cie.gdr.dao.cpd.Permission;
import com.oracle.cie.gdr.dao.cpd.RepoDirectory;
import com.oracle.cie.gdr.dao.cpd.RepoFile;
import com.oracle.cie.gdr.dao.cpd.RepoFileSet;
import com.oracle.cie.gdr.dao.cpd.Rule;
import com.oracle.cie.gdr.dao.cpd.Selection;
import com.oracle.cie.gdr.dao.cpd.SelectionRefId;
import com.oracle.cie.gdr.dao.cpd.Stringsubs;
import com.oracle.cie.gdr.dao.cpd.StringsubsComponent;
import com.oracle.cie.gdr.dao.cpd.StringsubsGroup;
import com.oracle.cie.gdr.dao.cpd.StringsubsGroupRef;
import com.oracle.cie.gdr.dao.cpd.Variable;
import com.oracle.cie.gdr.dao.cpi.ComponentInfo;
import com.oracle.cie.gdr.dao.cpi.FileMapTarget;
import com.oracle.cie.gdr.dao.dbd.DirectoryMap;
import com.oracle.cie.gdr.dao.facfg.Config;
import com.oracle.cie.gdr.dao.facfg.ConfigFiles;
import com.oracle.cie.gdr.dao.ftr.ComponentReference;
import com.oracle.cie.gdr.dao.lbm.LabelMap;
import com.oracle.cie.gdr.dao.nfo.InstallerComponentInfo;
import com.oracle.cie.gdr.dao.rgy.TargetInfo;
import com.oracle.cie.gdr.deinstallation.DeInstallerShutdownHook;
import com.oracle.cie.gdr.helpers.ComponentInfoHelper;
import com.oracle.cie.gdr.helpers.ConfigFilesHelper;
import com.oracle.cie.gdr.helpers.FeatureSetHelper;
import com.oracle.cie.gdr.helpers.GdrHelper;
import com.oracle.cie.gdr.helpers.LabelMapHelper;
import com.oracle.cie.gdr.helpers.LocaleInfoHelper;
import com.oracle.cie.gdr.helpers.PlatformInfoHelper;
import com.oracle.cie.gdr.helpers.RegenerationHelper;
import com.oracle.cie.gdr.installation.ReferenceCounter;
import com.oracle.cie.gdr.libraries.LibraryHandlerException;
import com.oracle.cie.gdr.libraries.LibraryType;
import com.oracle.cie.gdr.libraries.LibraryVisibility;
import com.oracle.cie.gdr.locale.LocaleInfoHolder;
import com.oracle.cie.gdr.nio.NioBridge;
import com.oracle.cie.gdr.nio.NioCopy;
import com.oracle.cie.gdr.nio.NioDelete;
import com.oracle.cie.gdr.nio.NioDeleteOnExitHook;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.packaging.PackagerComponentTarget;
import com.oracle.cie.gdr.repository.RepositoryReleaseVersionResolver;
import com.oracle.cie.gdr.services.RepositoryService;
import com.oracle.cie.gdr.services.RuleEvaluationService;
import com.oracle.cie.gdr.services.ServiceHolder;
import com.oracle.cie.gdr.services.TopLevelDirectoryService;
import com.oracle.cie.gdr.services.VariableResolverService;
import com.oracle.cie.gdr.utils.ChecksumCache;
import com.oracle.cie.gdr.utils.ComponentArchiveSplitter;
import com.oracle.cie.gdr.utils.ComponentArchiveUtils;
import com.oracle.cie.gdr.utils.FileUtils;
import com.oracle.cie.gdr.utils.GdrException;
import com.oracle.cie.gdr.utils.MsidUtil;
import com.oracle.cie.gdr.utils.StagingFileFilter;
import com.oracle.cie.nextgen.common.DirectoryVerifier;
import com.oracle.cie.repository.resolver.RepositoryVersionResolver;
import com.oracle.cie.repository.resolver.RepositoryVersionResolverException;
import com.oracle.cie.rest.Repository;
import com.oracle.cie.rest.RepositoryType;
import com.oracle.cie.rest.RestException;
import com.oracle.cie.rest.RestFactory;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NotLinkException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import oracle.glcm.opatch.common.api.ArtifactType;
import org.w3c.dom.Element;

public class ComponentHelper
extends GdrHelper<Component> {
    private static final Logger _log = Logger.getLogger(ComponentHelper.class.getName());
    public static final String NAMESPACE = "http://xmlns.oracle.com/cie/gdr/cpd";
    public static final String STRINGSUBS_NAMESPACE = "http://xmlns.oracle.com/cie/stringsubs";
    public static final String COMPONENT_DEF = "component-def";
    public static final String COMPONENTS_DIR = "components";
    public static final String COMPONENT_LABEL_DIR = "components";
    public static final String COMPONENT_SHIPHOME_DIR = "Components";
    public static final String COMPONENT_PATCHES_DIR = "patches";
    public static final String COMPONENT_ROLLBACK_DIR = "rollback";
    public static final String COMPONENT_PATCHES_UPGRADES_DIR = "upgrades";
    public static final String COMPONENT_PATCHES_INSTALL_DIR = "install";
    public static final String COMPONENT_PATCHES_DEINSTALL_DIR = "deinstall";
    public static final String COMPONENT_DEF_FILE_NAME = "compDef.xml";
    public static final String EXTENSIONS_DIR = "extensions";
    public static final String RESOURCE_BASENAME = "component";
    public static final String DEFAULT_FILE_EXCLUDES = "\\.ade_path";
    public static final String DEFAULT_FILE_EXCLUDES_PROPERTY = "ComponentHelper.default.file.excludes";
    public static final String SHIPHOME_LOAD_UNEXPANDED_PROPERTY = "ComponentHelper.shiphome.packaging.load.unexpanded.components";
    public static final String LAUNCHER_PROPERTIES_FILENAME = "launcher.properties";
    public static final String JAVA_CARBS_FILENAME = "java_carbs.properties";
    public static final String LAUNCHER_BOOTSTRAP_PROPERTY = "oracle.launcher.bootstrap";
    public static final String DEFAULT_DIRECTORY_MODE = "750";
    public static final String INSTALL_DIR_OVERRIDE_PROPERTY = "ComponentHelper.install.dir.override";
    public static final String STAGE_DIR_OVERRIDE_PROPERTY = "ComponentHelper.stage.dir.override";
    public static final String ENABLE_FILE_PERMS_FIX = "ComponentHelper.enable.file.perms.xslt";
    public static final String[] RESTRICTED_INSTALL_LOCATIONS = new String[]{"modules/features", "modules/internal/features", "modules/merger", "modules/internal/merger", "modules/clients", "modules/internal/clients"};
    public static final String[] INVALID_DEST_VALUES = new String[]{"..", "."};
    public static final String REPO_ARTIFACT_NAMESPACE = "repo-artifact-namespace";
    private static String _patchId;
    private static File _configFile;
    private static ComponentHelper _instance;

    public static ComponentHelper getInstance() {
        if (_instance == null) {
            _instance = new ComponentHelper(null);
        }
        return _instance;
    }

    public static ComponentHelper getInstance(ClassLoader classLoader) {
        if (classLoader == null) {
            return ComponentHelper.getInstance();
        }
        return new ComponentHelper(classLoader);
    }

    private ComponentHelper(ClassLoader classLoader) {
        super(Component.class, classLoader);
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public String getRootElement() {
        return COMPONENT_DEF;
    }

    public String getPath() {
        return "components";
    }

    public String getShipHomePath() {
        return COMPONENT_SHIPHOME_DIR;
    }

    public static String getStageDir() {
        return "stage";
    }

    public static File getStageDir(File parent) {
        return ComponentHelper.getStageDir(NioHelper.getInstance().getPath(parent)).toFile();
    }

    public static Path getStageDir(Path parent) {
        Path stageDir = null;
        String override = System.getProperty(STAGE_DIR_OVERRIDE_PROPERTY);
        if (override != null) {
            stageDir = NioHelper.getInstance().getPath(override, new String[0]);
        }
        if (stageDir == null) {
            stageDir = parent != null ? parent.resolve(ComponentHelper.getStageDir()) : NioHelper.getInstance().getPath(ComponentHelper.getStageDir(), new String[0]);
        }
        return stageDir.toAbsolutePath();
    }

    public static String getInstallDir() {
        return "nginstall";
    }

    public static File getInstallDir(File parent) {
        return ComponentHelper.getInstallDir(NioHelper.getInstance().getPath(parent)).toFile();
    }

    public static Path getInstallDir(Path parent) {
        Path installDir = null;
        String override = System.getProperty(INSTALL_DIR_OVERRIDE_PROPERTY);
        if (override != null) {
            installDir = NioHelper.getInstance().getPath(override, new String[0]);
        }
        if (installDir == null) {
            installDir = parent != null ? parent.resolve(ComponentHelper.getInstallDir()) : NioHelper.getInstance().getPath(ComponentHelper.getInstallDir(), new String[0]);
        }
        return installDir.toAbsolutePath();
    }

    public static String getComponentDefFileName() {
        return COMPONENT_DEF_FILE_NAME;
    }

    public static String getDataFilesDir() {
        return "DataFiles";
    }

    public static String getDataFilesExtractedDir() {
        return "DataFilesExtracted";
    }

    public static String getComponentLabelDir() {
        return "components";
    }

    public static String getExtensionsDir() {
        return EXTENSIONS_DIR;
    }

    public Component getRootWrapper(File file) throws IOException, DataHandlerException {
        return this.getRootWrapper(NioHelper.getInstance().getPath(file));
    }

    public Component getRootWrapper(Path path) throws IOException, DataHandlerException {
        Component component = Boolean.getBoolean(ENABLE_FILE_PERMS_FIX) ? (Component)super.getRootWrapper(this.getComponentWithFilePermsFixed(path)) : (Component)super.getRootWrapper(path);
        component.setCompDefLocation(path);
        return component;
    }

    public String getComponentWithFilePermsFixed(File file) throws IOException {
        return this.getComponentWithFilePermsFixed(NioHelper.getInstance().getPath(file));
    }

    public String getComponentWithFilePermsFixed(Path path) throws IOException {
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            StreamSource xmlSource = new StreamSource(is);
            StreamSource xsltSource = new StreamSource(this.getClassLoader().getResourceAsStream("resources/xsl/component-file-perms.xsl"));
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(baos);
            try {
                Xslt.xsltTransform((StreamSource)xmlSource, (StreamSource)xsltSource, (Result)result);
            }
            catch (TransformerException e) {
                throw new IOException("Failed to perform file-perms XSLT on component definition " + path, e);
            }
            String string = baos.toString();
            return string;
        }
    }

    @Override
    public void setResourcesBundleInfo(ResourceBundleInfoHolder rbiHolder, File componentsDir) {
        this.setResourcesBundleInfo(rbiHolder, NioHelper.getInstance().getPath(componentsDir));
    }

    @Override
    public void setResourcesBundleInfo(ResourceBundleInfoHolder rbiHolder, Path componentsDir) {
        String name = rbiHolder.getName();
        String version = rbiHolder.getVersion();
        Path p = componentsDir.resolve(ComponentHelper.getFormattedName(name) + File.separator + version);
        if (!Files.exists(p, new LinkOption[0]) && Files.exists(p = componentsDir.resolve(ComponentHelper.getFormattedName(name)), new LinkOption[0])) {
            version = null;
        }
        ResourceBundleInfo rbi = new ResourceBundleInfo(componentsDir, name, version, (GdrHelper)this);
        rbiHolder.setResourceBundleInfo(rbi);
    }

    @Override
    public String getResourceLocation(String name, String version) {
        String location = ComponentHelper.getFormattedName(name);
        if (!StringUtil.isNullOrEmpty((String)version, (boolean)true)) {
            location = location + "/" + version;
        }
        location = location + "/resources";
        return location;
    }

    @Override
    public String getDefaultResourceBundleBaseName() {
        return RESOURCE_BASENAME;
    }

    @Override
    public String getResourceBundleBaseName(String name, String version) {
        String baseName = ComponentHelper.getFormattedName(name);
        if (!StringUtil.isNullOrEmpty((String)version, (boolean)true)) {
            baseName = baseName + "/" + version;
        }
        baseName = baseName + "/resources/" + this.getDefaultResourceBundleBaseName();
        return baseName;
    }

    private void validateComponent(Reference reference, Component component, File compDefFile) throws GdrException {
        this.validateComponent(reference.getName(), reference.getVersion(), component, compDefFile);
    }

    private void validateComponent(Reference reference, Component component, Path compDefFile) throws GdrException {
        this.validateComponent(reference.getName(), reference.getVersion(), component, compDefFile);
    }

    private void validateComponent(String name, String version, Component component, File compDefFile) throws GdrException {
        this.validateComponent(name, version, component, NioHelper.getInstance().getPath(compDefFile));
    }

    private void validateComponent(String name, String version, Component component, Path compDefFile) throws GdrException {
        if (name == null) {
            GdrException ex = new GdrException("Expected component name was null.");
            _log.throwing(ComponentHelper.class.getName(), "validateComponent", ex);
            throw ex;
        }
        if (version == null) {
            if (!name.equals(component.getName())) {
                GdrException ex = new GdrException("The internal component name defined in " + compDefFile + " did not match the expected name: " + name);
                _log.throwing(ComponentHelper.class.getName(), "validateComponent", ex);
                throw ex;
            }
        } else if (!name.equals(component.getName()) || !version.equals(component.getVersion())) {
            GdrException ex = new GdrException("The internal component name and version defined in " + compDefFile + " did not match the expected name and version: " + name + " " + version);
            _log.throwing(ComponentHelper.class.getName(), "validateComponent", ex);
            throw ex;
        }
        if (component.getName().contains(" ")) {
            GdrException ex = new GdrException("The specified component name was invalid.  Component names may not contain spaces: \"" + name + "\"");
            _log.throwing(ComponentHelper.class.getName(), "validateComponent", ex);
            throw ex;
        }
        if (component.isSingleton() && component.isReplicable()) {
            GdrException ex = new GdrException("The specified component " + component + " was invalid.  Singleton components cannot be defined as replicable.");
            _log.throwing(ComponentHelper.class.getName(), "validateComponent", ex);
            throw ex;
        }
    }

    public Component getComponentArchiveFromLabel(File stageDir, Reference ref) throws IOException, DataHandlerException, GdrException {
        return this.getComponentArchiveFromLabel(NioHelper.getInstance().getPath(stageDir), ref);
    }

    public Component getComponentArchiveFromLabel(Path stageDir, Reference ref) throws IOException, DataHandlerException, GdrException {
        Path expandedCompDef = this.getComponentArchiveDefinitionLocation(stageDir, ref);
        Component component = null;
        if (Files.exists(expandedCompDef, new LinkOption[0])) {
            if (_log.isLoggable(Level.FINER)) {
                _log.finer("Creating root wrapper from stageDir=" + stageDir + " for " + expandedCompDef);
            }
            component = this.getRootWrapper(expandedCompDef);
            this.validateComponent(ref, component, expandedCompDef);
            component.setArchiveLocation(expandedCompDef.getParent());
            this.setResourcesBundleInfo((ResourceBundleInfoHolder)component, stageDir.resolve(this.getShipHomePath()));
        }
        return component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Component getComponentArchiveFromArchive(File archive, Reference ref, MetaDataHome metadata, Artifact artifact) throws IOException, DataHandlerException, GdrException {
        Component component;
        try (JarHelper jarFile = null;){
            jarFile = new JarHelper(archive);
            String entryPath = this.getComponentArchiveCarbPath(ref.getName(), ref.getVersion());
            String compDefEntry = entryPath + "/" + ComponentHelper.getComponentDefFileName();
            if (jarFile.getJarEntry(compDefEntry) == null && ref.getVersion().contains("-")) {
                ref.setVersion(ref.getVersion().split("-")[0]);
                entryPath = this.getComponentArchiveCarbPath(ref.getName(), ref.getVersion());
                compDefEntry = entryPath + "/" + ComponentHelper.getComponentDefFileName();
            }
            if (_log.isLoggable(Level.FINER)) {
                _log.finer("Creating root wrapper from archive=" + archive + " for " + entryPath);
            }
            String dataFilesExtractedEntry = entryPath + "/" + ComponentHelper.getDataFilesExtractedDir();
            JarEntry compDefjarEntry = jarFile.getJarEntry(compDefEntry);
            if (compDefjarEntry == null) {
                throw new FileNotFoundException("Unable to locate component definition " + entryPath + " in archive " + archive);
            }
            InputStream is = jarFile.getInputStream(compDefEntry);
            component = (Component)this.getRootWrapper(is);
            if (metadata.isRepository() || metadata.isPatch()) {
                component.setCarb(true);
            }
            for (String dataFilesExtractedJarEntry : jarFile.getEntries()) {
                if (!dataFilesExtractedJarEntry.startsWith(dataFilesExtractedEntry)) continue;
                component.setFlattenedCarb(true);
                break;
            }
        }
        this.validateComponent(ref, component, archive);
        component.setArchiveLocation(archive);
        String stagePath = ComponentHelper.getInstallDir() + "/" + ComponentHelper.getStageDir() + "/" + this.getShipHomePath();
        if (component.isCarb()) {
            if (metadata.isPatch()) {
                this.setResourcesBundleInfoJarFile((ResourceBundleInfoHolder)component, component.getArchiveLocationPath(), artifact, stagePath);
            } else {
                if (artifact == null) {
                    artifact = DependencyManagementFactory.getInstance().getArtifact("com.oracle.cie.gdr.carb.artifacts", ref.getName(), ref.getVersion());
                }
                this.setResourcesBundleInfo((ResourceBundleInfoHolder)component, metadata, artifact, stagePath);
            }
        } else {
            File stageDir = new File(stagePath);
            this.setResourcesBundleInfo((ResourceBundleInfoHolder)component, stageDir);
        }
        return component;
    }

    public File getComponentArchiveDefinitionLocation(File stageDir, Reference ref) {
        File compArchiveDir = this.getComponentArchiveDir(stageDir, ref.getName(), ref.getVersion());
        return new File(compArchiveDir, ComponentHelper.getComponentDefFileName());
    }

    public Path getComponentArchiveDefinitionLocation(Path stageDir, Reference ref) {
        return this.getComponentArchiveDir(stageDir, ref.getName(), ref.getVersion()).resolve(ComponentHelper.getComponentDefFileName());
    }

    public Component getComponentFromLabel(File installDir, Reference ref) throws IOException, DataHandlerException, GdrException {
        return this.getComponentFromLabel(NioHelper.getInstance().getPath(installDir), ref);
    }

    public Component getComponentFromLabel(Path installDir, Reference ref) throws IOException, DataHandlerException, GdrException {
        Path f = this.getComponentDefinitionLabelLocation(installDir, ref);
        if (!Files.exists(f, new LinkOption[0])) {
            FileNotFoundException ex = new FileNotFoundException("Unable to locate " + ComponentHelper.getComponentDefFileName() + " under install dir " + installDir + " for component " + this.getComponentName(ref.getName(), ref.getVersion()));
            _log.throwing(ComponentHelper.class.getName(), "getComponentFromLabel", ex);
            throw ex;
        }
        if (_log.isLoggable(Level.FINER)) {
            _log.finer("Creating root wrapper from installDir=" + installDir + " for " + ref.getName() + " at " + f);
        }
        Component component = this.getRootWrapper(f);
        component.setVersion(RepositoryReleaseVersionResolver.getInstance().replaceVersionToken(component.getVersion()));
        this.validateComponent(ref, component, f);
        Path componentsDir = installDir.resolve(ComponentHelper.getComponentLabelDir());
        this.setResourcesBundleInfo((ResourceBundleInfoHolder)component, componentsDir);
        return component;
    }

    public Path getComponentDefinitionLabelLocation(Path installDir, Reference ref) throws GdrException {
        Path componentsDir = installDir.resolve(ComponentHelper.getComponentLabelDir());
        try {
            ref.setVersion(RepositoryReleaseVersionResolver.getInstance().replaceVersionToken(ref.getVersion()));
        }
        catch (GdrException e) {
            throw new GdrException((Throwable)e);
        }
        Path f = componentsDir.resolve(ComponentHelper.getFormattedName(ref.getName()) + File.separator + ref.getVersion() + File.separator + ComponentHelper.getComponentDefFileName());
        if (!Files.exists(f, new LinkOption[0])) {
            f = componentsDir.resolve(ComponentHelper.getFormattedName(ref.getName()) + File.separator + ComponentHelper.getComponentDefFileName());
        }
        return f;
    }

    public Component getComponentExtensionsFromLabel(Path installDir, Reference ref) throws IOException, DataHandlerException, GdrException {
        Component extension;
        Path componentsDir = installDir.resolve(ComponentHelper.getComponentLabelDir());
        Path extensionsDir = componentsDir.resolve(ComponentHelper.getFormattedName(ref.getName()) + File.separator + ref.getVersion() + File.separator + ComponentHelper.getExtensionsDir());
        if (!Files.exists(extensionsDir, new LinkOption[0])) {
            extensionsDir = componentsDir.resolve(ComponentHelper.getFormattedName(ref.getName()) + File.separator + ComponentHelper.getExtensionsDir());
        }
        if ((extension = this.getComponentExtensions(extensionsDir, ref)) != null) {
            this.setResourcesBundleInfo((ResourceBundleInfoHolder)extension, componentsDir);
        }
        return extension;
    }

    public Component getComponentExtensions(Path extensionsDir, Reference ref) throws IOException, DataHandlerException, GdrException {
        Path f;
        Component extension = null;
        if (extensionsDir != null && Files.exists(extensionsDir, new LinkOption[0]) && Files.exists(f = extensionsDir.resolve(ComponentHelper.getComponentDefFileName()), new LinkOption[0])) {
            if (_log.isLoggable(Level.FINER)) {
                _log.finer("Creating root wrapper from file " + f);
            }
            extension = this.getRootWrapper(f);
            extension.setVersion(RepositoryReleaseVersionResolver.getInstance().replaceVersionToken(extension.getVersion()));
            extension.setExtension(true);
            this.validateComponent(ref, extension, f);
        }
        return extension;
    }

    public void mergeComponentDefinitions(Component component, Collection<Component> extensions) {
        if (component != null && extensions != null && !extensions.isEmpty()) {
            for (Component extComp : extensions) {
                List<FileMap> filemaps = extComp.getFileMaps();
                if (filemaps == null || filemaps.isEmpty()) continue;
                for (FileMap filemap : filemaps) {
                    component.addFileMap(filemap);
                }
            }
        }
    }

    public Component getComponentArchiveFromShipHome(File shipHomeRoot, Reference ref) throws IOException, DataHandlerException, GdrException {
        return this.getComponentArchiveFromShipHome(NioHelper.getInstance().getPath(shipHomeRoot), ref);
    }

    public Component getComponentArchiveFromShipHome(Path shipHomeRoot, Reference ref) throws IOException, DataHandlerException, GdrException {
        return this.getComponentArchiveFromShipHome(shipHomeRoot, ref.getName(), ref.getVersion(), null);
    }

    public Component getComponentArchiveFromShipHome(Path shipHomeRoot, Reference ref, InstallerComponentInfo cinfo) throws IOException, DataHandlerException, GdrException {
        return this.getComponentArchiveFromShipHome(shipHomeRoot, ref.getName(), ref.getVersion(), cinfo);
    }

    public Component getComponentArchiveFromShipHome(File shiphomeRoot, String name, String version, InstallerComponentInfo cinfo) throws IOException, DataHandlerException, GdrException {
        return this.getComponentArchiveFromShipHome(NioHelper.getInstance().getPath(shiphomeRoot), name, version, cinfo);
    }

    public Component getComponentArchiveFromShipHome(Path shiphomeRoot, String name, String version, InstallerComponentInfo cinfo) throws IOException, DataHandlerException, GdrException {
        int disk;
        Path compArchiveDir = this.getComponentArchiveDir(shiphomeRoot, name, version);
        Path patchesDir = compArchiveDir.resolve(COMPONENT_PATCHES_DIR);
        Path compDefFile = null;
        if (Files.isDirectory(patchesDir, new LinkOption[0])) {
            compDefFile = patchesDir.resolve(ComponentHelper.getComponentDefFileName());
            if (Files.exists(compDefFile, new LinkOption[0])) {
                _log.fine("Using patched component definition found at " + compDefFile);
            } else {
                compDefFile = null;
            }
        }
        if (compDefFile == null) {
            compDefFile = compArchiveDir.resolve(ComponentHelper.getComponentDefFileName());
            _log.fine("Using component definition found at " + compDefFile);
        }
        if (_log.isLoggable(Level.FINER)) {
            _log.finer("Creating root wrapper from shiphomeRoot=" + shiphomeRoot + " for " + name + " at " + compDefFile);
        }
        Component component = this.getRootWrapper(compDefFile);
        this.validateComponent(name, version, component, compDefFile);
        this.setResourcesBundleInfo((ResourceBundleInfoHolder)component, shiphomeRoot.resolve(this.getShipHomePath()));
        if (cinfo != null && (disk = cinfo.getDisk()) != 1) {
            component.setDisk(disk);
            Path parentDir = shiphomeRoot.getParent();
            if (parentDir.getFileName().toString().startsWith("Disk")) {
                parentDir = parentDir.getParent().resolve("Disk" + disk);
                compArchiveDir = this.getComponentArchiveDir(ComponentHelper.getStageDir(parentDir), name, version);
                _log.finer("Modified disk location for component " + component + " to " + compArchiveDir);
            } else {
                _log.finer("Attempt to modify disk number for component " + component + " failed for " + compArchiveDir);
            }
        }
        component.setArchiveLocation(compArchiveDir);
        return component;
    }

    public File getComponentArchiveDir(File metaDataRoot, Reference ref) {
        return this.getComponentArchiveDir(metaDataRoot, ref.getName(), ref.getVersion());
    }

    public File getComponentArchiveDir(File metaDataRoot, String name, String version) {
        return this.getComponentArchiveDir(NioHelper.getInstance().getPath(metaDataRoot), name, version).toFile();
    }

    public Path getComponentArchiveDir(Path metaDataRoot, String name, String version) {
        return metaDataRoot.resolve(this.getComponentArchivePath(name, version));
    }

    public String getComponentArchiveCarbPath(String name, String version) {
        return ComponentHelper.getInstallDir() + "/" + ComponentHelper.getStageDir() + "/" + this.getComponentArchivePath(name, version);
    }

    public String getComponentArchivePath(String name, String version) {
        return this.getShipHomePath() + "/" + ComponentHelper.getFormattedName(name) + "/" + version;
    }

    public String getRepositoryComponentArchiveDataPath(String name, String version) {
        return ComponentHelper.getInstallDir() + "/" + ComponentHelper.getStageDir() + "/" + this.getComponentArchivePath(name, version) + "/" + ComponentHelper.getDataFilesExtractedDir();
    }

    public void saveComponentsInShipHomeStructure(File dir, boolean clearSourceFields, Collection<Component> comps) throws GdrException, IOException, DataHandlerException {
        this.saveComponentsInShipHomeStructure(NioHelper.getInstance().getPath(dir), clearSourceFields, comps);
    }

    public void saveComponentsInShipHomeStructure(Path dir, boolean clearSourceFields, Collection<Component> comps) throws GdrException, IOException, DataHandlerException {
        this.saveComponentsInShipHomeStructure(dir, clearSourceFields, comps, true);
    }

    public void saveComponentsInShipHomeStructure(File dir, boolean clearSourceFields, Collection<Component> comps, boolean overwrite) throws GdrException, IOException, DataHandlerException {
        this.saveComponentsInShipHomeStructure(NioHelper.getInstance().getPath(dir), clearSourceFields, comps, overwrite);
    }

    public void saveComponentsInShipHomeStructure(Path dir, boolean clearSourceFields, Collection<Component> comps, boolean overwrite) throws GdrException, IOException, DataHandlerException {
        if (!Files.exists(dir, new LinkOption[0])) {
            Files.createDirectories(dir, new FileAttribute[0]);
            if (!Files.exists(dir, new LinkOption[0])) {
                GdrException ex = new GdrException("Directory specified did not exist and could not be created: " + dir);
                _log.throwing(ComponentHelper.class.getName(), "saveComponentsInShipHomeStructure", ex);
                throw ex;
            }
        } else if (!Files.isDirectory(dir, new LinkOption[0])) {
            GdrException ex = new GdrException("Directory specified was not a directory: " + dir);
            _log.throwing(ComponentHelper.class.getName(), "saveComponentsInShipHomeStructure", ex);
            throw ex;
        }
        if (comps != null && !comps.isEmpty()) {
            ConfigFiles configFiles = new ConfigFiles();
            if (this.getConfigFile() != null && this.getConfigFile().exists()) {
                configFiles = ConfigFilesHelper.getInstance().getConfigFiles(this.getConfigFile());
            }
            for (Component component : comps) {
                Path resourceLocation;
                Path compDir = this.getComponentArchiveDir(dir, component.getName(), component.getVersion());
                Path compDefFile = compDir.resolve(ComponentHelper.getComponentDefFileName());
                if (component.hasReplaces()) {
                    for (Component comp : component.getReplaces()) {
                        if (component.getVersion().compareTo(comp.getVersion()) != 0) continue;
                        overwrite = true;
                        break;
                    }
                }
                if (!overwrite && Files.exists(compDefFile, new LinkOption[0])) continue;
                component = component.copy();
                this.mergeComponentDefinitions(component, component.getComponentExtensions());
                this.addComponentFileTypes(component, configFiles);
                if (clearSourceFields) {
                    this.clearSourceFields(component);
                }
                if (!Files.exists(compDir, new LinkOption[0])) {
                    Files.createDirectories(compDir, new FileAttribute[0]);
                }
                this.save((IDataHandlerWrapper)component, compDefFile);
                ResourceBundleInfo rbi = component.getResourceBundleInfo();
                if (rbi == null || (resourceLocation = rbi.getResourceLocationPath()) == null) continue;
                Path destResourcesDir = compDir.resolve("resources");
                Path srcResourcesDir = null;
                FileSystem carbFileSystem = null;
                if (component.isCarb()) {
                    carbFileSystem = FileSystems.newFileSystem(resourceLocation, null);
                    srcResourcesDir = carbFileSystem.getPath(this.getResourceLocation(rbi.getName(), rbi.getVersion()), new String[0]);
                } else if (Files.isDirectory(resourceLocation, new LinkOption[0])) {
                    srcResourcesDir = resourceLocation.resolve(this.getResourceLocation(rbi.getName(), rbi.getVersion()));
                }
                if (srcResourcesDir != null && Files.isDirectory(srcResourcesDir, new LinkOption[0])) {
                    NioCopy.copy((Path)srcResourcesDir, (Path)destResourcesDir, this.getGlobalExcludeFilter());
                }
                if (carbFileSystem == null) continue;
                try {
                    carbFileSystem.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void addComponentFileTypes(Component component, ConfigFiles configFiles) throws IOException, DataHandlerException, GdrException {
        ArrayList<ArtifactFile> artifactFiles = new ArrayList<ArtifactFile>();
        List<Config> configs = configFiles.getConfigList();
        if (configs != null && !configs.isEmpty()) {
            HashSet<Path> fileTargets = new HashSet<Path>();
            for (ComponentTarget target : component.getComponentTargets()) {
                for (FileTarget fileTarget : target.getFileTargets()) {
                    Path dest = FileSystems.getDefault().getPath(fileTarget.getDest(), new String[0]);
                    fileTargets.add(dest);
                }
            }
            for (Config config : configs) {
                Path location = FileSystems.getDefault().getPath(config.getLocation(), config.getName());
                if (!fileTargets.contains(location)) continue;
                ArtifactFile artifact = new ArtifactFile(location, ArtifactType.CONFIG.getName().toLowerCase());
                artifactFiles.add(artifact);
            }
            if (artifactFiles.size() > 0) {
                component.setFileTypeMapping(artifactFiles);
            }
        }
    }

    public File getConfigFile() {
        return _configFile;
    }

    public void setConfigFile(File configFile) {
        _configFile = configFile;
    }

    public void saveComponentsInRepositoryStructure(Repository repository, Collection<Component> comps) throws GdrException, IOException, DataHandlerException {
        if (repository == null) {
            GdrException ex = new GdrException("The repository specified was null.");
            _log.throwing(ComponentHelper.class.getName(), "saveComponentsInRepositoryStructure", ex);
            throw ex;
        }
        if (!repository.getType().isCache()) {
            GdrException ex = new GdrException("The repository specified was not a " + RepositoryType.CACHE + " repository.");
            _log.throwing(ComponentHelper.class.getName(), "saveComponentsInRepositoryStructure", ex);
            throw ex;
        }
        try {
            if (comps != null && !comps.isEmpty()) {
                for (Component component : comps) {
                    if (component.isCarb()) {
                        this.copyCarbs(component, repository.getCacheLocation());
                        continue;
                    }
                    this.createCarbs(component, repository.getCacheLocation());
                }
            }
        }
        catch (DependencyManagementException e) {
            throw new GdrException((Throwable)e);
        }
    }

    private void copyCarbs(Component component, File installRepo) throws IOException, DataHandlerException, DependencyManagementException, GdrException {
        Collection<ComponentTarget> targets = component.getComponentTargets();
        for (ComponentTarget target : targets) {
            File carbDest;
            Artifact carbArtifact;
            Component targetComponent = target.getComponent();
            if (target instanceof PackagerComponentTarget) {
                PackagerComponentTarget packagerTarget = (PackagerComponentTarget)target;
                targetComponent = packagerTarget.getFileMapComponent();
            }
            if ((carbArtifact = targetComponent.getCarbArtifact()) == null) {
                carbArtifact = DependencyManagementFactory.getInstance().getArtifact("com.oracle.cie.gdr.carb", targetComponent.getName(), targetComponent.getVersion(), "carb");
            }
            if ((carbDest = carbArtifact.getLocalLocation(installRepo)).exists()) continue;
            FileCopy.copy((File)targetComponent.getArchiveLocation(), (File)carbDest);
        }
        File componentInfoFile = component.getComponentInfoFile();
        if (componentInfoFile != null) {
            Artifact componentInfoArtifact = component.getComponentInfoArtifact();
            if (componentInfoArtifact == null) {
                componentInfoArtifact = DependencyManagementFactory.getInstance().getArtifact("com.oracle.cie.gdr.carb.info", component.getName(), component.getVersion(), "xml", new String[]{RepositoryService.getVersionQualifier()});
            }
            FileCopy.copy((File)componentInfoFile, (File)componentInfoArtifact.getLocalLocation(installRepo));
        }
    }

    private void createCarbs(Component component, File installRepo) throws IOException, DataHandlerException, DependencyManagementException, GdrException {
        LinkedHashMap<Artifact, File> createdCarbs = new LinkedHashMap<Artifact, File>();
        Map<Artifact, File> createdArtifacts = this.createCarb(component, installRepo);
        for (Map.Entry<Artifact, File> entry : createdArtifacts.entrySet()) {
            if (!"carb".equals(entry.getKey().getType())) continue;
            createdCarbs.put(entry.getKey(), entry.getValue());
        }
        if (component.hasComponentExtensions()) {
            for (Component extension : component.getComponentExtensions()) {
                createdArtifacts = this.createCarb(extension, installRepo);
                for (Map.Entry<Artifact, File> entry : createdArtifacts.entrySet()) {
                    if (!"carb".equals(entry.getKey().getType())) continue;
                    createdCarbs.put(entry.getKey(), entry.getValue());
                }
            }
        }
        if (!createdCarbs.isEmpty()) {
            ComponentArchiveUtils.createComponentInfos(createdCarbs, installRepo, RepositoryService.getVersionQualifier(), true);
        }
    }

    private Map<Artifact, File> createCarb(Component component, File installRepo) throws IOException, DataHandlerException, DependencyManagementException, GdrException {
        ComponentArchiveSplitter splitter = new ComponentArchiveSplitter(component, installRepo, RepositoryService.getVersionQualifier()){

            @Override
            protected Component getComponent(File stageDir, Reference compRef) throws IOException, DataHandlerException, GdrException {
                return super.getComponent(stageDir, compRef);
            }
        };
        boolean targetedCarbs = true;
        if (VariableResolverService.getVariableResolverService().getVariable("TARGETED_CARBS") != null) {
            targetedCarbs = Boolean.parseBoolean(VariableResolverService.getVariableResolverService().get("TARGETED_CARBS"));
        }
        splitter.setOutputDirRepositoryLayout(true);
        splitter.setCreateCarbPoms(true);
        splitter.setCreateComponentInfo(true);
        splitter.setCreateTargetedCarbs(targetedCarbs);
        return splitter.split();
    }

    public void removeComponents(Collection<Component> components, File metaDataRoot) {
        this.removeComponents(components, NioHelper.getInstance().getPath(metaDataRoot));
    }

    public void removeComponents(Collection<Component> components, Path metaDataRoot) {
        for (Component component : components) {
            Path compDir = this.getComponentArchiveDir(metaDataRoot, component.getName(), component.getVersion());
            if (Files.exists(compDir, new LinkOption[0])) {
                Path componentFile = compDir.resolve(ComponentHelper.getComponentDefFileName());
                try {
                    if (Files.exists(componentFile, new LinkOption[0])) {
                        Files.delete(componentFile);
                        if (Files.exists(componentFile, new LinkOption[0])) {
                            _log.warning("Unable to delete component file " + componentFile);
                            NioDeleteOnExitHook.add((Path)componentFile);
                        }
                    }
                }
                catch (IOException e) {
                    _log.warning("Unable to delete component file " + componentFile);
                    NioDeleteOnExitHook.add((Path)componentFile);
                }
                Path resourcesDir = compDir.resolve("resources");
                if (Files.exists(resourcesDir, new LinkOption[0])) {
                    NioDelete.delete((Path)resourcesDir);
                }
            }
            try {
                if (Files.exists(compDir, new LinkOption[0]) && FileUtils.isDirectoryEmpty(compDir)) {
                    Files.delete(compDir);
                }
                if ((compDir = compDir.getParent()) == null) continue;
                if (Files.exists(compDir, new LinkOption[0]) && FileUtils.isDirectoryEmpty(compDir)) {
                    Files.delete(compDir);
                }
                if ((compDir = compDir.getParent()) == null || !Files.exists(compDir, new LinkOption[0]) || !FileUtils.isDirectoryEmpty(compDir)) continue;
                Files.delete(compDir);
            }
            catch (IOException e) {
                _log.warning("Unable to delete component file " + compDir);
                NioDelete.delete((Path)compDir);
            }
        }
    }

    public String getComponentName(Component component) {
        return this.getComponentName(component.getName(), component.getVersion());
    }

    public String getComponentName(String name, String version) {
        return name + "_" + version;
    }

    private boolean expandFileGroup(FileGroup fileGroup, ServiceHolder serviceHolder) throws GdrException {
        boolean fileDupChecks = Boolean.valueOf(serviceHolder.getVariableResolverService().get(serviceHolder.getNamespace(), "DISABLE_COMPONENT_DUPCHECKS")) == false;
        boolean fileChecksums = Boolean.valueOf(serviceHolder.getVariableResolverService().get(serviceHolder.getNamespace(), "COMPONENT_FILE_CHECKSUMS"));
        ChecksumCache checksumCache = null;
        if (fileDupChecks || fileChecksums) {
            checksumCache = new ChecksumCache();
        }
        return this.expandFileGroup(fileGroup, null, null, checksumCache, serviceHolder, fileDupChecks, fileChecksums);
    }

    private boolean expandFileGroup(FileGroup fileGroup, Directory parent, StagingFileFilter parentFilter, ChecksumCache checksumCache, ServiceHolder serviceHolder, boolean fileDupChecks, boolean fileChecksums) throws GdrException {
        Directory directory;
        if (!serviceHolder.getRuleEvaluationService().evaluateRules(fileGroup.getRules(), RuleEvaluationService.Mode.BUILD)) {
            return false;
        }
        Directory directory2 = directory = fileGroup instanceof Directory ? (Directory)fileGroup : null;
        if (directory != null && StringUtil.isNullOrEmpty((String)directory.getSource(), (boolean)true) && StringUtil.isNullOrEmpty((String)directory.getDest(), (boolean)true)) {
            GdrException ex = new GdrException("Directory entry has no source or dest defined: " + directory + " parent: " + parent);
            _log.throwing(ComponentHelper.class.getName(), "expandFileGroup", ex);
            throw ex;
        }
        StagingFileFilter filter = this.getStagingFileFilter(parentFilter, directory != null ? this.getSourceLocation(directory, parent, serviceHolder) : null, fileGroup.getIncludes(), fileGroup.getExcludes());
        List<Directory> dirs = fileGroup.getDirectories();
        List<com.oracle.cie.gdr.dao.cpd.File> files = fileGroup.getFiles();
        if (dirs != null && !dirs.isEmpty()) {
            boolean dirsRemoved = false;
            Iterator<Directory> it = dirs.iterator();
            while (it.hasNext()) {
                Directory dir = it.next();
                if (this.expandFileGroup(dir, directory, filter, checksumCache, serviceHolder, fileDupChecks, fileChecksums)) continue;
                it.remove();
                dirsRemoved = true;
            }
            if (dirsRemoved) {
                fileGroup.setDirectories(dirs);
            }
        }
        if (directory != null) {
            Path srcDir = this.getSourceLocation(directory, parent, serviceHolder);
            if (srcDir != null) {
                if (!Files.isDirectory(srcDir, new LinkOption[0])) {
                    GdrException ex = new GdrException("Location did not exist or was not a directory: " + srcDir);
                    _log.throwing(ComponentHelper.class.getName(), "expandFileGroup", ex);
                    throw ex;
                }
                directory.setSource(srcDir.toString());
            }
            this.validateMappingDestination(directory, serviceHolder);
            String dest = directory.getDest();
            if (dest == null) {
                if (parent == null) {
                    dest = "";
                    directory.setDest(dest);
                } else {
                    GdrException ex = new GdrException("Child directory entry did not define destination: " + directory);
                    _log.throwing(ComponentHelper.class.getName(), "expandFileGroup", ex);
                    throw ex;
                }
            }
            Object destDir = directory;
            String[] path = (dest = dest.trim().replaceAll("\\\\", "/")).split("/");
            if (path.length > 0) {
                ((Directory)destDir).setDest(path[0]);
                String id = ((Directory)destDir).getId();
                if (!StringUtil.isNullOrEmpty((String)id, (boolean)true)) {
                    ((Directory)destDir).setId(null);
                }
                for (int x = 1; x < path.length; ++x) {
                    List<Directory> childDirs = ((FileGroup)((Object)destDir)).getDirectories();
                    List<com.oracle.cie.gdr.dao.cpd.File> childFiles = ((FileGroup)((Object)destDir)).getFiles();
                    if (!childDirs.isEmpty()) {
                        ((FileGroup)((Object)destDir)).setDirectories(null);
                    }
                    if (!childFiles.isEmpty()) {
                        ((FileGroup)((Object)destDir)).setFiles(null);
                    }
                    Directory newDir = ((FileGroup)((Object)destDir)).addDirectory();
                    newDir.setDest(path[x]);
                    newDir.setSource("/");
                    newDir.setRecursive(((Directory)destDir).isRecursive());
                    newDir.setIncludeEmptyDirs(((Directory)destDir).isIncludeEmptyDirs());
                    newDir.setPreserveSymlinks(((Directory)destDir).isPreserveSymlinks());
                    if (!childDirs.isEmpty()) {
                        newDir.setDirectories(childDirs);
                    }
                    if (!childFiles.isEmpty()) {
                        newDir.setFiles(childFiles);
                    }
                    destDir = newDir;
                }
                if (!StringUtil.isNullOrEmpty((String)id, (boolean)true)) {
                    ((Directory)destDir).setId(id);
                }
            }
            if (fileGroup != destDir) {
                fileGroup = destDir;
            }
            if (srcDir != null) {
                this.expandDirectory((Directory)destDir, srcDir, filter, checksumCache, fileDupChecks, fileChecksums);
            }
        }
        if (files != null && !files.isEmpty()) {
            List<com.oracle.cie.gdr.dao.cpd.File> allFiles = fileGroup.getFiles();
            boolean filesChanged = false;
            for (com.oracle.cie.gdr.dao.cpd.File file : files) {
                if (!serviceHolder.getRuleEvaluationService().evaluateRules(file.getRules(), RuleEvaluationService.Mode.BUILD)) {
                    allFiles.remove(file);
                    filesChanged = true;
                    continue;
                }
                Path srcFile = null;
                Long size = 0L;
                boolean islink = !StringUtil.isNullOrEmpty((String)file.getSymlink());
                boolean zeroByte = false;
                for (FileModifier modifier : file.getModifiers()) {
                    if (!FileTarget.COPY_AS_ZERO_BYTE_MODIFIER.equals(modifier.getType())) continue;
                    zeroByte = true;
                }
                if (!islink && !zeroByte) {
                    GdrException ex;
                    srcFile = this.getSourceLocation(file, directory, serviceHolder);
                    if (srcFile == null) {
                        ex = new GdrException("Unable to determine source for file entry: " + file + " parent: " + (Object)((Object)fileGroup));
                        _log.throwing(ComponentHelper.class.getName(), "expandFileGroup", ex);
                        throw ex;
                    }
                    if (!(Files.exists(srcFile, new LinkOption[0]) && Files.isRegularFile(srcFile, new LinkOption[0]) || file.getAction() != null && (file.getAction() == null || file.getAction().equalsIgnoreCase(Strategy.Delete.name())))) {
                        ex = new GdrException("Location did not exist or was not a file: " + srcFile);
                        _log.throwing(ComponentHelper.class.getName(), "expandFileGroup", ex);
                        throw ex;
                    }
                    try {
                        size = Files.size(srcFile);
                    }
                    catch (IOException e) {
                        throw new GdrException((Throwable)e);
                    }
                    srcFile = fileDupChecks ? ComponentHelper.dupCheck(srcFile, checksumCache) : srcFile;
                    file.setSource(srcFile.toString());
                    file.setSize(size);
                    if (fileChecksums && checksumCache != null) {
                        try {
                            file.setChecksum(checksumCache.getChecksum(srcFile));
                        }
                        catch (IOException e) {
                            throw new GdrException("Failed to get checksum for file: " + srcFile, (Throwable)e);
                        }
                    }
                    this.expandRules(file);
                }
                this.validateMappingDestination(file, serviceHolder);
                String dest = file.getDest();
                if (!islink && !zeroByte && StringUtil.isNullOrEmpty((String)dest)) {
                    file.setDest(srcFile.getFileName().toString());
                    continue;
                }
                String[] path = (dest = dest.trim().replaceAll("\\\\", "/")).split("/");
                if (path.length > 1) {
                    com.oracle.cie.gdr.dao.cpd.File existingFile;
                    FileGroup destDir = fileGroup;
                    file.setDest(path[path.length - 1]);
                    for (int x = 0; x < path.length - 1; ++x) {
                        Directory locatedDir = this.locateDirectory(destDir, path[x]);
                        if (locatedDir == null) {
                            destDir = destDir.addDirectory();
                            ((Directory)destDir).setDest(path[x]);
                            ((Directory)destDir).setSource("/");
                            continue;
                        }
                        destDir = locatedDir;
                    }
                    List<com.oracle.cie.gdr.dao.cpd.File> destDirFiles = destDir.getFiles();
                    int index = destDirFiles.indexOf(file);
                    if (index > -1 && (existingFile = destDirFiles.get(index)).getRules().isEmpty()) {
                        destDirFiles.remove(file);
                    }
                    destDirFiles.add(file);
                    destDir.setFiles(destDirFiles);
                    allFiles.remove(file);
                    filesChanged = true;
                    continue;
                }
                allFiles.remove(file);
                allFiles.add(file);
                filesChanged = true;
            }
            if (filesChanged) {
                fileGroup.setFiles(allFiles);
            }
        }
        if (directory != null) {
            this.removeEmptyDirectories(directory);
            directory.setIncludes(null);
            directory.setExcludes(null);
        }
        return true;
    }

    private void expandRules(com.oracle.cie.gdr.dao.cpd.File file) {
        List<Rule> rules = file.getRules();
        if (rules != null && !rules.isEmpty()) {
            for (Rule rule : rules) {
                com.oracle.cie.common.Version v;
                if (!RuleEvaluationService.isJarVersionEval(rule.getEval()) || !StringUtil.isNullOrEmpty((String)rule.getArg2(), (boolean)true) || (v = RuleEvaluationService.getJarVersion(new File(file.getSource()), false)) == null) continue;
                rule.setArg2(v.toString());
            }
        }
    }

    public void expandLibrary(Component component) throws GdrException {
        HashMap<String, FileTarget> dests = new HashMap<String, FileTarget>();
        List<Library> libraries = component.getLibraries();
        if (component.getComponentExtensions() != null) {
            for (Component extComp : component.getComponentExtensions()) {
                libraries.addAll(extComp.getLibraries());
            }
        }
        if (!libraries.isEmpty()) {
            for (ComponentTarget target : component.getComponentTargets()) {
                List<FileTarget> fileTargets = target.getFileTargets();
                if (fileTargets == null || fileTargets.isEmpty()) continue;
                for (FileTarget fileTarget : fileTargets) {
                    if (fileTarget.getSource() == null) continue;
                    dests.put(fileTarget.getDest(), fileTarget);
                    if (!fileTarget.hasDuplicateDests()) continue;
                    dests.putAll(fileTarget.getDuplicateDestsMap());
                }
            }
        }
        for (Library library : libraries) {
            String subVersion;
            String version;
            String subName;
            if (LibraryType.getLibraryType(library.getType()).isRuntime()) {
                LibraryHandlerException ex = new LibraryHandlerException("runtime libraries are no longer supported. Please use \"manifest\" type libraries instead");
                _log.throwing(((Object)((Object)this)).getClass().getName(), "expandLibrary", (Throwable)((Object)ex));
                throw ex;
            }
            String name = library.getName();
            if (!StringUtil.isNullOrEmpty((String)name, (boolean)true) && !name.equals(subName = VariableResolverService.getVariableResolverService().substitute(component.getNamespace(), name, true))) {
                library.setName(subName);
            }
            if (!StringUtil.isNullOrEmpty((String)(version = library.getVersion()), (boolean)true) && !version.equals(subVersion = VariableResolverService.getVariableResolverService().substitute(component.getNamespace(), version, true))) {
                library.setVersion(subVersion);
            }
            ArrayList<LibraryEntry> allExpandedEntries = new ArrayList<LibraryEntry>();
            long librarySize = 0L;
            for (LibraryEntry entry : library.getEntries()) {
                if (entry.isEmpty()) {
                    LibraryHandlerException ex = new LibraryHandlerException("Empty name, wildcard, regex, pathmatcher or refid value for <entry> element in library: " + library.getName());
                    _log.throwing(((Object)((Object)this)).getClass().getName(), "expandLibrary", (Throwable)((Object)ex));
                    throw ex;
                }
                entry.setName(this.resolveVariables(entry.getName(), component.getNamespace()));
                entry.setWildcard(this.resolveVariables(entry.getWildcard(), component.getNamespace()));
                entry.setRegex(this.resolveVariables(entry.getRegex(), component.getNamespace()));
                entry.setPathMatcher(this.resolveVariables(entry.getPathMatcher(), component.getNamespace()));
                entry.setRefId(this.resolveVariables(entry.getRefId(), component.getNamespace()));
                ArrayList<LibraryEntry> expandedEntries = new ArrayList<LibraryEntry>();
                for (Map.Entry dest : dests.entrySet()) {
                    List<Selection> expandedIncludes;
                    if (!entry.matches((String)dest.getKey(), ((FileTarget)dest.getValue()).getId()) || (expandedIncludes = entry.expandIncludes(((FileTarget)dest.getValue()).getSource())) != null && expandedIncludes.isEmpty()) continue;
                    LibraryEntry partialPathEntry = new LibraryEntry();
                    partialPathEntry.setName((String)dest.getKey());
                    partialPathEntry.setExplode(entry.getExplode());
                    partialPathEntry.setIncludeParent(entry.getIncludeParent());
                    if (expandedIncludes != null && !expandedIncludes.isEmpty()) {
                        partialPathEntry.setIncludes(expandedIncludes);
                    }
                    librarySize += ((FileTarget)dest.getValue()).getSize();
                    _log.fine("Adding file " + dest + " to library entries for " + library.getName() + " library.");
                    expandedEntries.add(partialPathEntry);
                }
                if (expandedEntries.isEmpty()) {
                    throw new LibraryHandlerException("Unable to locate any file corresponding to library entry " + (Object)((Object)entry) + " in library " + library.getName() + " from component " + component);
                }
                for (LibraryEntry libraryEntry : expandedEntries) {
                    int index = allExpandedEntries.indexOf((Object)libraryEntry);
                    if (index != -1) {
                        allExpandedEntries.remove(index);
                    }
                    allExpandedEntries.add(libraryEntry);
                }
            }
            library.setEntries(allExpandedEntries);
            if (LibraryType.getLibraryType(library.getType()).isManifest() || LibraryType.getLibraryType(library.getType()).isRuntime()) continue;
            library.setSize(librarySize);
        }
    }

    private String resolveVariables(String value, String nameSpace) {
        String subVars;
        if (!StringUtil.isNullOrEmpty((String)value, (boolean)true) && !value.equals(subVars = VariableResolverService.getVariableResolverService().substitute(nameSpace, value))) {
            return subVars;
        }
        return value;
    }

    private boolean removeEmptyDirectories(Directory directory) {
        if (!directory.isIncludeEmptyDirs()) {
            List<com.oracle.cie.gdr.dao.cpd.File> files;
            List<Directory> dirs = directory.getDirectories();
            if (dirs != null && !dirs.isEmpty()) {
                int size = dirs.size();
                Iterator<Directory> it = dirs.iterator();
                while (it.hasNext()) {
                    Directory dir = it.next();
                    if (!this.removeEmptyDirectories(dir)) continue;
                    it.remove();
                }
                if (dirs.size() != size) {
                    directory.setDirectories(dirs);
                }
            }
            if (((files = directory.getFiles()) == null || files.isEmpty()) && (dirs == null || dirs.isEmpty())) {
                return true;
            }
        }
        return false;
    }

    private void expandDirectory(Directory directory, Path srcFile, StagingFileFilter filter, ChecksumCache checksumCache, boolean fileDupChecks, boolean fileChecksums) throws GdrException {
        try (DirectoryStream<Path> paths = Files.newDirectoryStream(srcFile, filter);){
            for (Path f : paths) {
                String symlink;
                String string = symlink = directory.isPreserveSymlinks() ? this.getSymlink(f) : null;
                if (symlink == null && Files.isDirectory(f, new LinkOption[0])) {
                    Directory d = this.locateDirectory(directory, f.getFileName().toString());
                    if (d == null) {
                        d = directory.addDirectory();
                        d.setDest(f.getFileName().toString());
                        d.setSource(f.toString());
                    }
                    if (!directory.isRecursive()) continue;
                    d.setPreserveSymlinks(directory.isPreserveSymlinks());
                    this.expandDirectory(d, f, filter, checksumCache, fileDupChecks, fileChecksums);
                    continue;
                }
                com.oracle.cie.gdr.dao.cpd.File file = new com.oracle.cie.gdr.dao.cpd.File();
                file.setDest(f.getFileName().toString());
                if (directory.getFiles().contains(file)) continue;
                if (symlink == null) {
                    long size;
                    Path dupFile = fileDupChecks ? ComponentHelper.dupCheck(f, checksumCache) : f;
                    file.setSource(dupFile.toString());
                    try {
                        size = Files.size(dupFile);
                    }
                    catch (IOException e) {
                        throw new GdrException("An error occurred while getting size of " + dupFile, (Throwable)e);
                    }
                    file.setSize(size);
                    if (fileChecksums && checksumCache != null) {
                        file.setChecksum(checksumCache.getChecksum(f));
                    }
                } else {
                    file.setSymlink(symlink);
                }
                String osFamily = filter.getOsFamily(f);
                if (!StringUtil.isNullOrEmpty((String)osFamily)) {
                    file.setOsFamily(osFamily);
                }
                directory.addFile(file);
            }
        }
        catch (IOException e) {
            throw new GdrException("An error occurred while reading files of dir " + srcFile, (Throwable)e);
        }
    }

    public String getSymlink(File file) throws GdrException {
        return this.getSymlink(NioHelper.getInstance().getPath(file));
    }

    public String getSymlink(Path path) throws GdrException {
        if (!ComdevHelper.cIsWin32) {
            try {
                return Files.readSymbolicLink(path).toString();
            }
            catch (NotLinkException e) {
                return null;
            }
            catch (IOException e) {
                throw new GdrException((Throwable)e);
            }
        }
        return null;
    }

    private Directory locateDirectory(FileGroup directory, String name) {
        Directory dir = null;
        List<Directory> dirs = directory.getDirectories();
        if (dirs != null && !dirs.isEmpty()) {
            for (Directory d : dirs) {
                if ("".equals(d.getDest())) {
                    dir = this.locateDirectory(d, name);
                    if (dir == null) continue;
                    break;
                }
                if (!name.equals(d.getDest())) continue;
                dir = d;
                break;
            }
        }
        return dir;
    }

    private static Path dupCheck(Path path, ChecksumCache checksumCache) throws GdrException {
        Path dupPath;
        long size;
        if (checksumCache == null) {
            return path;
        }
        if (path == null || !Files.exists(path, new LinkOption[0])) {
            return path;
        }
        try {
            size = Files.size(path);
        }
        catch (IOException e1) {
            throw new GdrException((Throwable)e1);
        }
        if (size < 1L) {
            return path;
        }
        try {
            dupPath = checksumCache.getDupCheckPath(path);
        }
        catch (IOException e) {
            throw new GdrException("Dup check failed for path: " + path, (Throwable)e);
        }
        return dupPath != null ? dupPath : path;
    }

    private void validateMappingDestination(Mapping mapping, ServiceHolder serviceHolder) throws GdrException {
        this.substituteMappingDest(mapping, serviceHolder, true);
        String dest = mapping.getDest();
        if (!StringUtil.isNullOrEmpty((String)dest, (boolean)true)) {
            if ((dest = dest.trim().replace("\\\\", "/")).startsWith("/") || dest.startsWith("~") || dest.matches("^.:/.*")) {
                GdrException ex = new GdrException("Encountered absolute path in destination string of: " + mapping);
                _log.throwing(ComponentHelper.class.getName(), "validateMapping", ex);
                throw ex;
            }
            String[] split = dest.split("/");
            for (String value : INVALID_DEST_VALUES) {
                for (String s : split) {
                    if (!value.equals(s)) continue;
                    GdrException ex = new GdrException("Encountered invalid value of \"" + value + "\" in destination string of: " + mapping);
                    _log.throwing(ComponentHelper.class.getName(), "validateMapping", ex);
                    throw ex;
                }
            }
        }
    }

    private void substituteMappingDest(Mapping mapping, ServiceHolder serviceHolder, boolean validate) {
        String subDest;
        String dest = mapping.getDest();
        if (!(StringUtil.isNullOrEmpty((String)dest, (boolean)true) || MsidUtil.isMSIDTagged(dest) || dest.equals(subDest = serviceHolder.getVariableResolverService().substitute(serviceHolder.getNamespace(), dest, validate)))) {
            mapping.setDest(subDest);
        }
    }

    private boolean compactFileGroup(FileGroup fileGroup, ServiceHolder serviceHolder) throws GdrException {
        Iterator<AbstractDataHandlerWrapper> it;
        if (!serviceHolder.getRuleEvaluationService().evaluateRules(fileGroup.getRules(), RuleEvaluationService.Mode.RUNTIME)) {
            return false;
        }
        List<Directory> dirs = fileGroup.getDirectories();
        List<com.oracle.cie.gdr.dao.cpd.File> files = fileGroup.getFiles();
        if (dirs != null && !dirs.isEmpty()) {
            boolean dirsRemoved = false;
            it = dirs.iterator();
            while (it.hasNext()) {
                if (this.compactFileGroup((FileGroup)it.next(), serviceHolder)) continue;
                it.remove();
                dirsRemoved = true;
            }
            if (dirsRemoved) {
                fileGroup.setDirectories(dirs);
            }
        }
        if (files != null && !files.isEmpty()) {
            boolean filesRemoved = false;
            it = files.iterator();
            while (it.hasNext()) {
                com.oracle.cie.gdr.dao.cpd.File file = (com.oracle.cie.gdr.dao.cpd.File)it.next();
                if (serviceHolder.getRuleEvaluationService().evaluateRules(file.getRules(), RuleEvaluationService.Mode.RUNTIME) && serviceHolder.getPlatformService().hasOsFamily(file.getOsFamily())) continue;
                it.remove();
                filesRemoved = true;
            }
            if (filesRemoved) {
                fileGroup.setFiles(files);
            }
        }
        return true;
    }

    public List<FileTarget> getFilesForPackaging(ComponentTarget target, Mode packagingMode) throws GdrException {
        List<FileTarget> fileTargets = null;
        if (target != null) {
            FileMap fileMap = target.getComponentFileMap();
            if (!fileMap.isExpanded()) {
                if (_log.isLoggable(Level.FINE)) {
                    _log.fine("Expanding file-map with symbol " + fileMap.getSymbol() + " from component " + target.getComponent());
                }
                this.expandRepoEntries(fileMap, target.getServicesHolder(), target);
                if (!this.expandFileGroup(fileMap, target.getServicesHolder())) {
                    fileMap.clear();
                }
                fileMap.setExpanded(true);
            }
            fileTargets = this.getFilesForPackaging(target.getComponentFileMap(), target.getGlobalPermissions(), packagingMode);
        }
        return fileTargets;
    }

    private void expandRepoEntries(FileGroup fileGroup, ServiceHolder serviceHolder, ComponentTarget target) throws GdrException {
        List<RepoDirectory> repoDirs;
        Directory directory;
        GdrException ex;
        if (fileGroup == null) {
            GdrException ex2 = new GdrException("The file-group provided was null.");
            _log.throwing(ComponentHelper.class.getName(), "expandRepoEntries", ex2);
            throw ex2;
        }
        if (target == null) {
            GdrException ex3 = new GdrException("The component target provided was null.");
            _log.throwing(ComponentHelper.class.getName(), "expandRepoEntries", ex3);
            throw ex3;
        }
        VariableResolverService variableResolverService = serviceHolder.getVariableResolverService();
        RepositoryService repositoryService = target.getComponent().getRepositoryService();
        if (repositoryService == null) {
            repositoryService = new RepositoryService(variableResolverService);
            target.getComponent().setRepositoryService(repositoryService);
        }
        IObjectStore objectStore = ObjectStoreManager.getObjectStore((String)REPO_ARTIFACT_NAMESPACE);
        objectStore.setBackingStore(serviceHolder.getVariableResolverService().getObjectStore(target.getComponent().getNamespace()));
        List<RepoFileSet> repoFileSets = fileGroup.getRepoFileSet();
        if (repoFileSets != null && !repoFileSets.isEmpty()) {
            for (RepoFileSet repoFileSet : repoFileSets) {
                List<RepoFile> repoFileSetRepoFiles = repoFileSet.getRepoFiles();
                if (repoFileSetRepoFiles == null || repoFileSetRepoFiles.isEmpty()) continue;
                String string = repoFileSet.getDestDir();
                if (StringUtil.isNullOrEmpty((String)string, (boolean)true)) {
                    ex = new GdrException("The required \"dest-dir\" attribute is missing a value for the repo-file-set [" + (Object)((Object)repoFileSet) + "] in the component [" + target.getComponent() + "]");
                    _log.throwing(ComponentHelper.class.getName(), "expandRepoEntries", ex);
                    throw ex;
                }
                String fileNameMapping = repoFileSet.getFileNameMapping();
                if (StringUtil.isNullOrEmpty((String)fileNameMapping, (boolean)true)) {
                    GdrException ex4 = new GdrException("The required \"fileNameMapping\" attribute is missing a value for the repo-file-set [" + (Object)((Object)repoFileSet) + "] in the component [" + target.getComponent() + "]");
                    _log.throwing(ComponentHelper.class.getName(), "expandRepoEntries", ex4);
                    throw ex4;
                }
                String repoFileSetGroup = repoFileSet.getGroup();
                String repoFileSetType = repoFileSet.getType();
                String repoFileSetMode = repoFileSet.getMode();
                directory = fileGroup.addDirectory();
                directory.setDest(string);
                directory.setFileModifiers(repoFileSet.getModifiers());
                directory.setPermissions(repoFileSet.getPermissions());
                String repoFileSetId = repoFileSet.getId();
                for (RepoFile repoFile : repoFileSetRepoFiles) {
                    String dest;
                    String mode;
                    String type;
                    String group = repoFile.getGroup();
                    if (StringUtil.isNullOrEmpty((String)group, (boolean)true)) {
                        if (StringUtil.isNullOrEmpty((String)repoFileSetGroup, (boolean)true)) {
                            GdrException ex5 = new GdrException("Unable to determine \"group\" value for repo-file [" + repoFile + "] in the the repo-file-set [" + (Object)((Object)repoFileSet) + "] in the component [" + target.getComponent() + "]");
                            _log.throwing(ComponentHelper.class.getName(), "expandRepoEntries", ex5);
                            throw ex5;
                        }
                        repoFile.setGroup(repoFileSetGroup);
                    }
                    if (StringUtil.isNullOrEmpty((String)(type = repoFile.getType()), (boolean)true) && !StringUtil.isNullOrEmpty((String)repoFileSetType, (boolean)true)) {
                        repoFile.setType(repoFileSetType);
                    }
                    if (StringUtil.isNullOrEmpty((String)(mode = repoFile.getMode()), (boolean)true) && !StringUtil.isNullOrEmpty((String)repoFileSetMode, (boolean)true)) {
                        repoFile.setMode(repoFileSetMode);
                    }
                    if (StringUtil.isNullOrEmpty((String)(dest = repoFile.getDest()), (boolean)true)) {
                        repoFile.setDest(fileNameMapping);
                        dest = fileNameMapping;
                    }
                    repoFile.setDest(dest);
                    String id = repoFile.getId();
                    if (!StringUtil.isNullOrEmpty((String)id, (boolean)true) || StringUtil.isNullOrEmpty((String)repoFileSetId, (boolean)true)) continue;
                    repoFile.setId(repoFileSetId);
                }
                directory.setRepoFiles(repoFileSetRepoFiles);
            }
            fileGroup.setRepoFileSets(null);
        }
        List<Directory> directories = fileGroup.getDirectories();
        List<RepoFile> repoFiles = fileGroup.getRepoFiles();
        if (repoFiles != null && !repoFiles.isEmpty()) {
            try {
                for (RepoFile repoFile : repoFiles) {
                    if (StringUtil.isNullOrEmpty((String)repoFile.getDest(), (boolean)true)) {
                        ex = new GdrException("The required \"dest\" attribute is missing for the repo-file [" + repoFile + "] in the component [" + target.getComponent() + "]");
                        _log.throwing(ComponentHelper.class.getName(), "expandRepoEntries", ex);
                        throw ex;
                    }
                    if (StringUtil.isNullOrEmpty((String)repoFile.getGroup(), (boolean)true)) {
                        ex = new GdrException("The required \"group\" attribute is missing for the repo-file [" + repoFile + "] in the component [" + target.getComponent() + "]");
                        _log.throwing(ComponentHelper.class.getName(), "expandRepoEntries", ex);
                        throw ex;
                    }
                    File artifactFile = repositoryService.retrieveRepositoryArtifact(repoFile);
                    com.oracle.cie.gdr.dao.cpd.File file = repoFile.createFile();
                    file.setDest(variableResolverService.substitute(REPO_ARTIFACT_NAMESPACE, file.getDest(), true));
                    file.setSource(artifactFile.getAbsolutePath());
                    file.setPatchable(this.isPatchable(fileGroup, repoFile.getPatchable()));
                    fileGroup.addFile(file);
                }
                fileGroup.setRepoFiles(null);
            }
            catch (GdrException e) {
                throw e;
            }
            catch (Exception e) {
                throw new GdrException((Throwable)e);
            }
        }
        if ((repoDirs = fileGroup.getRepoDirectories()) != null && !repoDirs.isEmpty()) {
            try {
                for (RepoDirectory repoDir : repoDirs) {
                    File artifactFile = repositoryService.retrieveRepositoryArtifact(repoDir);
                    final File expansionDir = new File(artifactFile.getParentFile(), "expanded");
                    DirectoryVerifier directoryVerifier = new DirectoryVerifier(expansionDir);
                    if (!directoryVerifier.verify()) {
                        if (expansionDir.exists()) {
                            Delete.delete((File)expansionDir, (boolean)false);
                            if (expansionDir.exists()) {
                                GdrException ex6 = new GdrException("Unable to delete existing expansion directory " + expansionDir);
                                _log.throwing(ComponentHelper.class.getName(), "expandRepoEntries", ex6);
                                throw ex6;
                            }
                        }
                        expansionDir.mkdirs();
                        JarHelper jarHelper = new JarHelper(artifactFile);
                        jarHelper.extract(expansionDir, new FileFilter(){

                            @Override
                            public boolean accept(File pathname) {
                                return !pathname.getPath().substring(expansionDir.getPath().length() + 1).startsWith("META-INF");
                            }
                        });
                        jarHelper.close();
                        directoryVerifier.save();
                    }
                    DeInstallerShutdownHook.add(expansionDir, true);
                    DeInstallerShutdownHook.add(directoryVerifier.getVerifyFile(), true);
                    directory = repoDir.createDirectory();
                    directory.setDest(variableResolverService.substitute(REPO_ARTIFACT_NAMESPACE, directory.getDest(), true));
                    String source = repoDir.getSource();
                    source = StringUtil.isNullOrEmpty((String)source, (boolean)true) ? expansionDir.getAbsolutePath() : expansionDir.getAbsolutePath() + "/" + source;
                    directory.setSource(source);
                    directory.setPatchable(this.isPatchable(fileGroup, repoDir.getPatchable()));
                    fileGroup.addDirectory(directory);
                }
                fileGroup.setRepoDirectories(null);
            }
            catch (GdrException gdrException) {
                throw gdrException;
            }
            catch (Exception exception) {
                throw new GdrException((Throwable)exception);
            }
        }
        if (directories != null && !directories.isEmpty()) {
            for (Directory directory2 : directories) {
                this.expandRepoEntries(directory2, serviceHolder, target);
            }
        }
    }

    private List<FileTarget> getFilesForPackaging(FileMap fileMap, List<Permission> globalPermissions, Mode packagingMode) throws GdrException {
        ArrayList<FileTarget> fileTargets = new ArrayList<FileTarget>();
        this.getFilesForPackaging(fileMap, null, fileMap.getModifiers(), globalPermissions, fileTargets, fileMap.hasDuplicates() || fileMap.isBootstrap(), packagingMode);
        return fileTargets;
    }

    private void getFilesForPackaging(FileGroup fileGroup, String parentPath, List<Modifier> parentModifiers, List<Permission> parentPermissions, List<FileTarget> fileTargets, boolean disableDupChecks, Mode packagingMode) throws GdrException {
        if (packagingMode != Mode.PACKAGE_COMPONENT && packagingMode != Mode.PACKAGE_SHIPHOME) {
            GdrException ex = new GdrException("Only the " + (Object)((Object)Mode.PACKAGE_COMPONENT) + " and " + (Object)((Object)Mode.PACKAGE_SHIPHOME) + " modes are supported by this method.");
            _log.throwing(ComponentHelper.class.getName(), "getFilesForPackaging", ex);
            throw ex;
        }
        if (fileGroup != null) {
            String prefix = "";
            if (!StringUtil.isNullOrEmpty((String)parentPath) && !(prefix = parentPath).endsWith("/")) {
                prefix = prefix + "/";
            }
            ArrayList<Permission> perms = new ArrayList<Permission>();
            List<Permission> fgPerms = fileGroup.getPermissions();
            if (fgPerms != null && !fgPerms.isEmpty()) {
                perms.addAll(fgPerms);
            }
            if (parentPermissions != null && !parentPermissions.isEmpty()) {
                perms.addAll(parentPermissions);
            }
            List<Directory> dirs = fileGroup.getDirectories();
            for (Directory dir : dirs) {
                List<Modifier> dirMods;
                String dest = dir.getDest();
                ArrayList<Modifier> mods = new ArrayList<Modifier>();
                if (parentModifiers != null && !parentModifiers.isEmpty()) {
                    mods.addAll(parentModifiers);
                }
                if ((dirMods = dir.getModifiers()) != null && !dirMods.isEmpty()) {
                    mods.addAll(dirMods);
                }
                if (!StringUtil.isNullOrEmpty((String)dest)) {
                    String fullDest = prefix + dest;
                    Set<String> modifiers = this.getModifierTypes(fullDest, dir.getId(), mods, true);
                    String mode = this.getDirectoryTargetMode(dir, fullDest, perms);
                    FileTarget dirTarget = new FileTarget(fullDest, dir.getSource(), true, mode, dir.getId(), modifiers, dir.getGroup(), dir.getArtifact(), dir.getVersion(), dir.isIgnoreVersionKeywords(), dir.getBaseVersion(), dir.getClassifier(), dir.getType());
                    if (!fileTargets.contains(dirTarget)) {
                        fileTargets.add(dirTarget);
                    }
                }
                dir.setPatchable(this.isPatchable(fileGroup, dir.getPatchable()));
                dir.setForce(this.isForced(fileGroup, dir.getForce()));
                this.getFilesForPackaging(dir, prefix + dest, mods, perms, fileTargets, disableDupChecks, packagingMode);
            }
            List<com.oracle.cie.gdr.dao.cpd.File> files = fileGroup.getFiles();
            for (com.oracle.cie.gdr.dao.cpd.File file : files) {
                if (!StringUtil.isNullOrEmpty((String)file.getSymlink())) {
                    _log.finest("Not adding file entry to packaging list since it is a symbolic link: " + file);
                    continue;
                }
                String fullDest = prefix + file.getDest();
                Set<String> modifiers = this.getModifierTypes(fullDest, file.getId(), parentModifiers, file.getModifiers(), false);
                String source = file.getSource();
                if (packagingMode == Mode.PACKAGE_COMPONENT && source == null && !modifiers.contains(FileTarget.COPY_AS_ZERO_BYTE_MODIFIER)) {
                    GdrException ex = new GdrException("File entry missing source value for " + file);
                    _log.throwing(ComponentHelper.class.getName(), "getFilesForPackaging", ex);
                    throw ex;
                }
                String mode = this.getFileTargetMode(file, fullDest, perms);
                FileTarget fileTarget = new FileTarget(fullDest, source, mode, file.getId(), modifiers, file.getGroup(), file.getArtifact(), file.getVersion(), file.isIgnoreVersionKeywords(), file.getBaseVersion(), file.getClassifier(), file.getType());
                fileTarget.setAction(file.getAction());
                fileTarget.setSize(file.getSize());
                fileTarget.setPatchable(this.isPatchable(fileGroup, file.getPatchable()));
                fileTarget.setForced(this.isForced(fileGroup, file.getForce()));
                if (source != null) {
                    boolean dup = false;
                    if (!disableDupChecks && !fileTarget.isBootstrap()) {
                        for (FileTarget target : fileTargets) {
                            if (!source.equals(target.getSource())) continue;
                            file.setJarEntry(target.getDest());
                            target.addDuplicateDest(fullDest, fileTarget);
                            dup = true;
                            break;
                        }
                    }
                    if (dup) continue;
                    file.setJarEntry(null);
                    fileTargets.add(fileTarget);
                    continue;
                }
                source = file.getJarEntry();
                if (StringUtil.isNullOrEmpty((String)source, (boolean)true)) {
                    source = fullDest;
                } else {
                    fileTarget.setAction(Strategy.Injection.getXmlName());
                }
                fileTarget.setSource(source);
                fileTargets.add(fileTarget);
            }
        }
    }

    public List<FileTarget> getFilesForInstallation(ComponentTarget target) throws GdrException {
        List<FileTarget> fileTargets = new ArrayList<FileTarget>();
        if (target != null) {
            FileMap fileMap = target.getComponentFileMap();
            MsidUtil.initMsidVariables(target);
            if (!fileMap.isExpanded()) {
                GdrException ex = new GdrException("Component definition file map was not expanded: " + target.getComponent() + "->" + target.getSymbol());
                _log.throwing(ComponentHelper.class.getName(), "getFilesForInstallation", ex);
                throw ex;
            }
            if (!fileMap.isCompacted()) {
                List<Directory> dirs;
                List<RepoFile> repoFiles = fileMap.getRepoFiles();
                if (repoFiles != null && !repoFiles.isEmpty()) {
                    GdrException ex = new GdrException("Component definition file map contains repo-file entries:" + target.getComponent() + "->" + target.getSymbol());
                    _log.throwing(ComponentHelper.class.getName(), "getFilesForInstallation", ex);
                    throw ex;
                }
                if (!this.compactFileGroup(fileMap, target.getServicesHolder())) {
                    fileMap.clear();
                }
                if ((dirs = fileMap.getDirectories()) != null && !dirs.isEmpty()) {
                    for (Directory dir : dirs) {
                        this.removeEmptyDirectories(dir);
                    }
                }
                fileMap.setCompacted(true);
            }
            String componentRootDir = target.getLocation();
            fileTargets = this.getFilesForInstallation(target, target.getComponentFileMap(), componentRootDir);
            if (componentRootDir != null && componentRootDir.length() > 0) {
                Set<String> modifiers = this.getModifierTypes(componentRootDir, null, fileMap.getModifiers(), null, true);
                fileTargets.add(new FileTarget(componentRootDir, "/", true, target.getLocationMode(), modifiers));
            }
        }
        return fileTargets;
    }

    private List<FileTarget> getFilesForInstallation(ComponentTarget target, FileMap fileMap, String componentRootDir) throws GdrException {
        ArrayList<FileTarget> fileTargets = new ArrayList<FileTarget>();
        this.getFilesForInstallation(target, fileMap, componentRootDir, null, null, fileMap.getModifiers(), fileTargets);
        return fileTargets;
    }

    private void getFilesForInstallation(ComponentTarget target, FileGroup fileGroup, String componentRootDir, String parentPath, String srcPath, List<Modifier> parentModifiers, List<FileTarget> fileTargets) throws GdrException {
        if (fileGroup != null) {
            Set<String> modifiers;
            String fullDest;
            String dest;
            String originalDest;
            VariableResolverService variableResolverService = target.getServicesHolder().getVariableResolverService();
            String rootDir = "";
            if (!StringUtil.isNullOrEmpty((String)componentRootDir)) {
                rootDir = rootDir + componentRootDir + "/";
            }
            String parent = "";
            if (!StringUtil.isNullOrEmpty((String)parentPath)) {
                parent = parent + parentPath + "/";
            }
            String srcParent = "";
            if (!StringUtil.isNullOrEmpty((String)srcPath)) {
                srcParent = srcParent + srcPath + "/";
            }
            List<com.oracle.cie.gdr.dao.cpd.File> files = fileGroup.getFiles();
            for (com.oracle.cie.gdr.dao.cpd.File file : files) {
                boolean msidPointerFilePresent = false;
                originalDest = file.getDest();
                if (!StringUtil.isNullOrEmpty((String)originalDest) && MsidUtil.isMSIDTagged(originalDest)) {
                    msidPointerFilePresent = MsidUtil.getMsidTimestampFromPointerFile(target, rootDir + parent, originalDest);
                }
                dest = variableResolverService.substitute(target.getServicesHolder().getNamespace(), originalDest);
                file.setDest(dest);
                if (msidPointerFilePresent) continue;
                String source = file.getSymlink();
                boolean symlink = false;
                if (!StringUtil.isNullOrEmpty((String)source, (boolean)true)) {
                    symlink = true;
                } else {
                    String string = source = target.getComponent().isUnstaged() ? file.getSource() : file.getJarEntry();
                    if (StringUtil.isNullOrEmpty((String)source)) {
                        source = srcParent + originalDest;
                    }
                }
                fullDest = rootDir + parent + dest;
                modifiers = this.getModifierTypes(fullDest, file.getId(), parentModifiers, file.getModifiers(), false);
                FileTarget fileTarget = new FileTarget(fullDest, source, false, file.getMode(), file.getId(), modifiers, symlink, file.getGroup(), file.getArtifact(), file.getVersion(), file.isIgnoreVersionKeywords(), file.getBaseVersion(), file.getClassifier(), file.getType(), file.isPack());
                fileTarget.setAction(file.getAction());
                fileTarget.setPatchable(this.isPatchable(fileGroup, file.getPatchable()));
                fileTarget.setChecksum(file.getChecksum());
                fileTargets.add(fileTarget);
            }
            List<Directory> dirs = fileGroup.getDirectories();
            for (Directory dir : dirs) {
                FileTarget dirTarget;
                List<Modifier> dirMods;
                originalDest = dir.getDest();
                dest = variableResolverService.substitute(target.getServicesHolder().getNamespace(), originalDest);
                dir.setDest(dest);
                ArrayList<Modifier> mods = new ArrayList<Modifier>();
                if (parentModifiers != null && !parentModifiers.isEmpty()) {
                    mods.addAll(parentModifiers);
                }
                if ((dirMods = dir.getModifiers()) != null && !dirMods.isEmpty()) {
                    mods.addAll(dirMods);
                }
                fullDest = rootDir + parent + dest;
                modifiers = this.getModifierTypes(fullDest, dir.getId(), mods, true);
                if (!StringUtil.isNullOrEmpty((String)dest) && !fileTargets.contains(dirTarget = new FileTarget(fullDest, "/", true, dir.getMode(), dir.getId(), modifiers, dir.getGroup(), dir.getArtifact(), dir.getVersion(), dir.isIgnoreVersionKeywords(), dir.getBaseVersion(), dir.getClassifier(), dir.getType()))) {
                    fileTargets.add(dirTarget);
                }
                this.getFilesForInstallation(target, dir, componentRootDir, parent + dest, srcParent + originalDest, mods, fileTargets);
            }
        }
    }

    public boolean isPatchable(FileGroup fileGroup, Boolean childPatchable) {
        Boolean parentPatchable = null;
        if (fileGroup instanceof Directory) {
            parentPatchable = ((Directory)fileGroup).getPatchable();
        }
        if (childPatchable == null) {
            if (parentPatchable == null) {
                return true;
            }
            return parentPatchable;
        }
        return childPatchable;
    }

    public boolean isForced(FileGroup fileGroup, Boolean childPatchable) {
        Boolean parentForced = null;
        if (fileGroup instanceof Directory) {
            parentForced = ((Directory)fileGroup).getForce();
        }
        if (childPatchable == null) {
            if (parentForced == null) {
                return false;
            }
            return parentForced;
        }
        return childPatchable;
    }

    private Set<String> getModifierTypes(String path, String id, List<Modifier> modifiers, boolean directory) {
        return this.getModifierTypes(path, id, modifiers, null, directory);
    }

    private Set<String> getModifierTypes(String path, String id, List<Modifier> modifiers, List<FileModifier> fileModifiers, boolean isDirectory) {
        HashSet<String> modifierTypes;
        block3: {
            block2: {
                modifierTypes = null;
                if (fileModifiers == null || fileModifiers.isEmpty()) break block2;
                modifierTypes = new HashSet<String>();
                for (FileModifier mod : fileModifiers) {
                    modifierTypes.add(mod.getType());
                }
                break block3;
            }
            if (modifiers == null || modifiers.isEmpty()) break block3;
            modifierTypes = new HashSet();
            for (Modifier mod : modifiers) {
                if (!this.isSelectionMatch(mod, path, id, isDirectory)) continue;
                modifierTypes.add(mod.getType());
            }
        }
        return modifierTypes;
    }

    public boolean isSelectionMatch(SelectionRefId selection, String value, String id, boolean isDirectory) {
        return (isDirectory && selection.isMatchDirs() || !isDirectory && selection.isMatchFiles()) && selection.matches(value, id);
    }

    private Path getSourceLocation(Mapping mapping, Directory parent, ServiceHolder serviceHolder) throws GdrException {
        String src;
        String parentSource;
        String definedSrc = mapping.getSource();
        boolean srcDefined = !StringUtil.isNullOrEmpty((String)definedSrc, (boolean)true);
        String string = parentSource = parent != null ? parent.getSource() : null;
        if (!srcDefined && StringUtil.isNullOrEmpty((String)parentSource, (boolean)true)) {
            return null;
        }
        String string2 = src = srcDefined ? definedSrc : mapping.getDest();
        if (!(src.startsWith("%") || src.replaceAll("\\\\", "/").startsWith("/") || src.matches("^.:/.*") || StringUtil.isNullOrEmpty((String)parentSource, (boolean)true))) {
            src = parentSource + "/" + src;
        }
        try {
            src = serviceHolder.getVariableResolverService().substitute(serviceHolder.getNamespace(), src, true);
        }
        catch (ObjectStoreValueNotFoundException e) {
            GdrException ex = new GdrException("Unable to resolve variables in source location: " + src + " of mapping: " + mapping, (Throwable)e);
            _log.throwing(ComponentHelper.class.getName(), "getSourceLocation", ex);
            throw ex;
        }
        Path srcPath = null;
        try {
            srcPath = NioHelper.getInstance().getPath(src, new String[0]).toAbsolutePath();
        }
        catch (InvalidPathException e) {
            GdrException ex = new GdrException("Invalid source location: " + src, (Throwable)e);
            _log.throwing(ComponentHelper.class.getName(), "getSourceLocation", ex);
            throw ex;
        }
        return srcPath;
    }

    public String getFileTargetMode(com.oracle.cie.gdr.dao.cpd.File file, String destPath, List<Permission> perms) throws GdrException {
        String mode = file.getMode();
        if (StringUtil.isNullOrEmpty((String)mode, (boolean)true) && (mode = this.getTargetMode(file.getSource(), destPath, file.getId(), false, perms)) != null) {
            file.setMode(mode);
        }
        return mode;
    }

    public String getDirectoryTargetMode(Directory directory, String destPath, List<Permission> perms) throws GdrException {
        String mode = directory.getMode();
        if (StringUtil.isNullOrEmpty((String)mode, (boolean)true)) {
            String src = directory.getSource();
            if ("/".equals(src)) {
                src = null;
            }
            if ((mode = this.getTargetMode(src, destPath, directory.getId(), true, perms)) != null) {
                directory.setMode(mode);
            }
        }
        return mode;
    }

    private String getTargetMode(String srcPath, String destPath, String id, boolean isDirectory, List<Permission> perms) throws GdrException {
        Permission matchedPerm = null;
        if (destPath != null && perms != null && !perms.isEmpty()) {
            String permPath = destPath.replaceAll("\\\\", "/");
            while (permPath.endsWith("/") && permPath.length() > 0) {
                permPath = permPath.substring(0, permPath.length() - 1);
            }
            int slash = permPath.lastIndexOf(47);
            String name = slash > -1 && permPath.length() > slash + 1 ? permPath.substring(slash + 1) : permPath;
            for (Permission perm : perms) {
                if (perm.getMode() == null && !perm.isSourcePerms()) {
                    GdrException ex = new GdrException("The permission element is required to define a mode if source-perms attribute is false: " + (Object)((Object)perm));
                    _log.throwing(ComponentHelper.class.getName(), "getTargetMode", ex);
                    throw ex;
                }
                if (perm.isMatchDirs() && !isDirectory || !this.isSelectionMatch(perm, name, id, isDirectory)) continue;
                matchedPerm = perm;
                break;
            }
        }
        String mode = null;
        if (matchedPerm != null && matchedPerm.isSourcePerms() && srcPath != null) {
            if (!System.getProperty("os.name").startsWith("Win")) {
                try {
                    List<String> output = TopLevelDirectoryService.getCommandOutput("stat", "-L", "-c", "%a", srcPath);
                    if (output != null && output.size() == 1) {
                        mode = output.get(0).trim();
                        if (mode.length() == 3) {
                            try {
                                Integer.parseInt(mode);
                            }
                            catch (NumberFormatException e) {
                                mode = null;
                            }
                        } else {
                            mode = null;
                        }
                        if (mode == null) {
                            _log.log(Level.FINEST, "Unable to detect mode, stat command output was incorrect " + output.get(0));
                            mode = matchedPerm.getMode();
                        }
                    }
                }
                catch (IOException e) {
                    _log.log(Level.FINEST, "Unable to detect mode.", e);
                }
            }
        } else if (matchedPerm != null) {
            mode = matchedPerm.getMode();
        }
        if (mode == null && isDirectory) {
            mode = DEFAULT_DIRECTORY_MODE;
        }
        return mode;
    }

    public void clearSourceFields(Component component) {
        List<FileMap> fileMaps = component.getFileMaps();
        if (fileMaps != null && !fileMaps.isEmpty()) {
            for (FileMap fileMap : fileMaps) {
                if (!fileMap.isExpanded()) continue;
                this.clearSourceFields(fileMap);
            }
        }
    }

    public void clearSourceFields(FileGroup fileGroup) {
        List<com.oracle.cie.gdr.dao.cpd.File> files = fileGroup.getFiles();
        for (com.oracle.cie.gdr.dao.cpd.File f : files) {
            f.setSource(null);
        }
        if (fileGroup instanceof Directory) {
            ((Directory)fileGroup).setSource(null);
        }
        for (Directory dir : fileGroup.getDirectories()) {
            this.clearSourceFields(dir);
        }
    }

    public long getFileGroupSize(FileGroup fileGroup) {
        List<Directory> dirs;
        long size = 0L;
        List<com.oracle.cie.gdr.dao.cpd.File> files = fileGroup.getFiles();
        if (files != null && !files.isEmpty()) {
            for (com.oracle.cie.gdr.dao.cpd.File file : files) {
                size += file.getSize();
            }
        }
        if ((dirs = fileGroup.getDirectories()) != null && !dirs.isEmpty()) {
            for (Directory dir : dirs) {
                size += this.getFileGroupSize(dir);
            }
        }
        return size;
    }

    public long getLibrariesSize(Component component) {
        long size = 0L;
        List<Library> libraries = component.getLibraries();
        if (component.getComponentExtensions() != null) {
            for (Component extComp : component.getComponentExtensions()) {
                libraries.addAll(extComp.getLibraries());
            }
        }
        if (libraries != null && !libraries.isEmpty()) {
            for (Library library : libraries) {
                if (LibraryType.getLibraryType(library.getType()).isManifest() || LibraryType.getLibraryType(library.getType()).isNone() || LibraryVisibility.getLibraryVisibility(library.getVisibility()) == LibraryVisibility.none) continue;
                Set<String> locations = library.getLocation();
                if (locations.isEmpty()) {
                    size += library.getSize();
                    continue;
                }
                size += library.getSize() * (long)locations.size();
            }
        }
        return size;
    }

    public void initComponentVariables(Collection<Component> components, VariableResolverService variableService) throws GdrException {
        for (Component component : components) {
            List<Variable> variables = component.getVariables();
            for (Variable variable : variables) {
                if (variable.isGlobal()) {
                    Variable var = variableService.getVariable(variable.getName());
                    if (var == null || RegenerationHelper.isRegenerateState()) {
                        variableService.addVariable(variable);
                        continue;
                    }
                    if (var.isVariableEqual(variable)) continue;
                    GdrException ex = new GdrException("The component \"" + this.getComponentName(component) + "\" contains a conflicting definition for the global variable \"" + variable.getName() + "\".");
                    _log.throwing(ComponentHelper.class.getName(), "getGlobalVariables", ex);
                    throw ex;
                }
                variableService.addVariable(component.getNamespace(), variable);
            }
        }
    }

    public StagingFileFilter getStagingFileFilter(StagingFileFilter parentFilter, Path sourceDir, List<IncludeExclude> includes, List<IncludeExclude> excludes) {
        Collection<String> globalExcludes = this.getGlobalExcludes();
        if (globalExcludes != null && !globalExcludes.isEmpty()) {
            if (excludes == null) {
                excludes = new ArrayList<IncludeExclude>();
            }
            for (String exclude : globalExcludes) {
                IncludeExclude inex = new IncludeExclude();
                inex.setRegex(exclude);
                inex.setMatchDirs(true);
                excludes.add(0, inex);
            }
        }
        if (sourceDir != null) {
            String regex;
            String wildcard;
            String sourcePath = sourceDir.toAbsolutePath().toString().replace("\\", "/");
            for (IncludeExclude exclude : excludes) {
                if (!exclude.isMatchPath()) continue;
                wildcard = exclude.getWildcard();
                regex = exclude.getRegex();
                if (!StringUtil.isNullOrEmpty((String)wildcard, (boolean)true) && !wildcard.startsWith("*")) {
                    exclude.setWildcard(sourcePath + "/" + wildcard);
                }
                if (StringUtil.isNullOrEmpty((String)regex, (boolean)true) || regex.startsWith(".*")) continue;
                exclude.setRegex(sourcePath + "/" + regex);
            }
            for (IncludeExclude include : includes) {
                if (!include.isMatchPath()) continue;
                wildcard = include.getWildcard();
                regex = include.getRegex();
                if (!StringUtil.isNullOrEmpty((String)wildcard, (boolean)true) && !wildcard.startsWith("*")) {
                    include.setWildcard(sourcePath + "/" + wildcard);
                }
                if (StringUtil.isNullOrEmpty((String)regex, (boolean)true) || regex.startsWith(".*")) continue;
                include.setRegex(sourcePath + "/" + regex);
            }
        }
        return new StagingFileFilter(parentFilter, includes, excludes);
    }

    public Set<Reference> findComponents(File installDir, boolean unexpanded, boolean staged) throws IOException, DataHandlerException, GdrException {
        return this.findComponents(NioHelper.getInstance().getPath(installDir), unexpanded, staged);
    }

    public Set<Reference> findComponents(Path installDir, boolean unexpanded, boolean staged) throws IOException, DataHandlerException, GdrException {
        Collection<String> globalExcludes = this.getGlobalExcludes();
        globalExcludes.add("\\..*");
        HashSet<Reference> componentRefs = new HashSet<Reference>();
        if (staged) {
            Path stageDir = ComponentHelper.getStageDir().equals(installDir.getFileName().toString()) ? installDir : ComponentHelper.getStageDir(installDir);
            Path shipHomeCompDir = stageDir.resolve(this.getShipHomePath());
            componentRefs.addAll(this.findComponents(shipHomeCompDir, true));
        }
        if (unexpanded) {
            Path labelCompDir = installDir.resolve(this.getPath());
            componentRefs.addAll(this.findComponents(labelCompDir, false));
        }
        return componentRefs;
    }

    private Set<Reference> findComponents(Path compsDir, boolean requireVersionDir) throws IOException, DataHandlerException, GdrException {
        final Collection<String> globalExcludes = this.getGlobalExcludes();
        globalExcludes.add("\\..*");
        if (_log.isLoggable(Level.FINEST)) {
            _log.finest("Searching " + compsDir + " for components...");
        }
        HashSet<Reference> componentRefs = new HashSet<Reference>();
        if (Files.exists(compsDir, new LinkOption[0])) {
            ArrayList<Path> compDirs = new ArrayList<Path>();
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(compsDir, (DirectoryStream.Filter<? super Path>)new DirectoryStream.Filter<Path>(){

                @Override
                public boolean accept(Path entry) throws IOException {
                    return Files.isDirectory(entry, new LinkOption[0]) && !ComponentHelper.this.isGloballyExcluded(entry, (Collection<String>)globalExcludes);
                }
            });){
                for (Path dir : stream) {
                    compDirs.add(dir);
                }
            }
            if (compDirs.size() > 0) {
                if (_log.isLoggable(Level.FINEST)) {
                    _log.finest("Found " + compDirs.size() + " directories under component directory " + compsDir);
                }
                for (Path compDir : compDirs) {
                    if (_log.isLoggable(Level.FINEST)) {
                        _log.finest("Searching for component definitions under " + compDir);
                    }
                    ArrayList<Path> verDirs = new ArrayList<Path>();
                    try (DirectoryStream<Path> stream = Files.newDirectoryStream(compDir, (DirectoryStream.Filter<? super Path>)new DirectoryStream.Filter<Path>(){

                        @Override
                        public boolean accept(Path entry) throws IOException {
                            String fileName = entry.getFileName().toString();
                            return Files.isDirectory(entry, new LinkOption[0]) && !ComponentHelper.this.isGloballyExcluded(entry, (Collection<String>)globalExcludes) && !ComponentHelper.getExtensionsDir().equals(fileName) && !"resources".equals(fileName);
                        }
                    });){
                        Iterator<Path> iterator = stream.iterator();
                        while (iterator.hasNext()) {
                            Path dir = iterator.next();
                            verDirs.add(dir);
                        }
                    }
                    if (verDirs.size() > 0) {
                        for (Path verDir : verDirs) {
                            Path compXml = verDir.resolve(ComponentHelper.getComponentDefFileName());
                            Path extCompXml = verDir.resolve(ComponentHelper.getExtensionsDir() + File.separator + ComponentHelper.getComponentDefFileName());
                            if (Files.exists(compXml, new LinkOption[0]) || Files.exists(extCompXml, new LinkOption[0])) {
                                Path p = Files.exists(compXml, new LinkOption[0]) ? compXml : extCompXml;
                                Component component = this.getComponentUsingTreeParser(p);
                                component.setVersion(RepositoryReleaseVersionResolver.getInstance().replaceVersionToken(component.getVersion()));
                                this.validateComponent(compDir.getFileName().toString(), verDir.getFileName().toString(), component, p);
                                ComponentReference ref = new ComponentReference(component.getName(), component.getVersion());
                                componentRefs.add(ref);
                                if (!_log.isLoggable(Level.FINE)) continue;
                                _log.fine("Found component " + (Object)((Object)ref) + " at " + compXml);
                                continue;
                            }
                            if (!_log.isLoggable(Level.FINEST)) continue;
                            _log.finest("No component definition exists at " + compXml);
                        }
                    } else if (_log.isLoggable(Level.FINEST)) {
                        _log.finest("No component version directories found under " + compDir);
                    }
                    if (requireVersionDir) continue;
                    Path compXml = compDir.resolve(ComponentHelper.getComponentDefFileName());
                    Path extCompXml = compDir.resolve(ComponentHelper.getExtensionsDir() + File.separator + ComponentHelper.getComponentDefFileName());
                    if (Files.exists(compXml, new LinkOption[0]) || Files.exists(extCompXml, new LinkOption[0])) {
                        Path p = Files.exists(compXml, new LinkOption[0]) ? compXml : extCompXml;
                        Component component = this.getComponentUsingTreeParser(p);
                        component.setVersion(RepositoryReleaseVersionResolver.getInstance().replaceVersionToken(component.getVersion()));
                        this.validateComponent(compDir.getFileName().toString(), null, component, p);
                        ComponentReference ref = new ComponentReference(component.getName(), component.getVersion());
                        if (!componentRefs.contains((Object)ref)) {
                            componentRefs.add(ref);
                            if (!_log.isLoggable(Level.FINE)) continue;
                            _log.fine("Found component " + (Object)((Object)ref) + " at " + compXml);
                            continue;
                        }
                        if (!_log.isLoggable(Level.WARNING)) continue;
                        _log.warning("Ignored duplicate component " + (Object)((Object)ref) + " at " + compXml);
                        continue;
                    }
                    if (!_log.isLoggable(Level.FINEST)) continue;
                    _log.finest("No component definition exists at " + compXml);
                }
            } else if (_log.isLoggable(Level.FINEST)) {
                _log.finest("Found no component directories under " + compsDir);
            }
        } else if (_log.isLoggable(Level.FINEST)) {
            _log.finest("The components directory " + compsDir + " did not exist.");
        }
        return componentRefs;
    }

    public Component getComponentUsingTreeParser(File compXml) throws DataHandlerException {
        return this.getComponentUsingTreeParser(NioHelper.getInstance().getPath(compXml));
    }

    public Component getComponentUsingTreeParser(Path compXml) throws DataHandlerException {
        Component component;
        block8: {
            InputStream is = Files.newInputStream(compXml, new OpenOption[0]);
            try {
                component = this.getComponentUsingTreeParser(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new DataHandlerException("Failed to read path " + compXml, (Throwable)e);
                }
            }
            is.close();
        }
        return component;
    }

    public Component getComponentUsingTreeParser(InputStream is) throws DataHandlerException {
        IDataHandler dataHandler = new TreeDataHandlerSpiImpl().create(NAMESPACE, COMPONENT_DEF, is);
        return new Component(dataHandler);
    }

    public long getRequiredSpace(Home home, Set<Component> selectedComps) {
        long size = 0L;
        if (selectedComps != null && !selectedComps.isEmpty()) {
            for (Component component : selectedComps) {
                Collection<ComponentTarget> targets;
                if (component.isReplicable()) {
                    targets = component.getComponentTargets();
                    for (ComponentTarget target : targets) {
                        if (this.isComponentTargetInstalled(home, target)) continue;
                        size += target.getSize();
                    }
                    continue;
                }
                targets = component.getComponentTargets();
                for (ComponentTarget target : targets) {
                    size += target.getSize();
                }
            }
        }
        return size;
    }

    public boolean isComponentTargetInstalled(Home home, ComponentTarget target) {
        Component component = target.getComponent();
        String qualifier = component.isReplicable() ? target.getReferenceQualifier() : null;
        return ReferenceCounter.getReferenceCount(home.getHomePath(), ReferenceCounter.RefType.components, component.getName(), component.getVersion(), qualifier) > 0;
    }

    public MetaDataHome findMetaDataHome(File rootDir) throws GdrException, FileNotFoundException {
        return this.findMetaDataHome(rootDir, true);
    }

    public MetaDataHome findMetaDataHome(File rootDir, boolean gdrLabelRequired) throws GdrException, FileNotFoundException {
        File gdrMetaDataHome;
        if (rootDir == null) {
            GdrException ex = new GdrException("The rootDir directory was null.");
            _log.throwing(ComponentHelper.class.getName(), "findMetaDataHome", ex);
            throw ex;
        }
        if (!rootDir.exists()) {
            GdrException ex = new GdrException("The rootDir directory did not exist: " + rootDir);
            _log.throwing(ComponentHelper.class.getName(), "findMetaDataHome", ex);
            throw ex;
        }
        boolean shiphome = true;
        File localRepoCarbsPath = new File(rootDir, "install-repo" + File.separator + "com.oracle.cie.gdr.carb".replace(".", File.separator));
        File localRepoPath = new File(rootDir, "com.oracle.cie.gdr.carb".replace(".", File.separator));
        if (localRepoCarbsPath.isDirectory() || localRepoPath.isDirectory()) {
            _log.finer("Located component meta-data home at " + rootDir + ", assumed local repository structure.");
            try {
                RestFactory.getRestHandlerConfig().setDefaultCacheRepository(new File(rootDir, localRepoCarbsPath.isDirectory() ? "install-repo" : ""));
                Repository localRepo = RestFactory.getRestHandlerConfig().getDefaultCacheRepository();
                RepositoryVersionResolver repositoryVersionResolver = new RepositoryVersionResolver(RepositoryService.getNextGenHelper(), new Repository[]{localRepo}, null, true);
                RepositoryService repositoryService = new RepositoryService(VariableResolverService.getVariableResolverService(), repositoryVersionResolver);
                return new MetaDataHome(repositoryService);
            }
            catch (RepositoryVersionResolverException | RestException e) {
                throw new GdrException("Failed to create local repository and version resolver.", e);
            }
        }
        File componentMetaDataHome = ComponentHelper.getStageDir(new File(rootDir, "Disk1"));
        if (componentMetaDataHome.exists()) {
            Repository installRepo = RepositoryService.getInstallRepo(componentMetaDataHome);
            if (installRepo.getCacheLocation().isDirectory()) {
                RepositoryVersionResolver repositoryVersionResolver;
                try {
                    repositoryVersionResolver = new RepositoryVersionResolver(RepositoryService.getNextGenHelper(), new Repository[]{installRepo}, null, true);
                }
                catch (RepositoryVersionResolverException e) {
                    throw new GdrException("Failed to create version resolver.", (Throwable)e);
                }
                RepositoryService repositoryService = new RepositoryService(VariableResolverService.getVariableResolverService(), repositoryVersionResolver);
                RepositoryService.setLocalCacheRepository(installRepo);
                return new MetaDataHome(repositoryService);
            }
            gdrMetaDataHome = componentMetaDataHome;
            _log.finer("Located component meta-data home at " + componentMetaDataHome + ", assumed shiphome structure and set gdr meta-data home to the same location.");
        } else {
            shiphome = false;
            File installDir = ComponentHelper.getInstallDir(rootDir);
            if (installDir.exists()) {
                File stageDir = ComponentHelper.getStageDir(installDir);
                if (!stageDir.exists()) {
                    _log.finer("The current root directory contains the " + installDir.getName() + " directory, but no " + stageDir.getName() + " directory.  Setting component meta-data home to root dir " + rootDir);
                    componentMetaDataHome = rootDir;
                } else {
                    componentMetaDataHome = installDir.getParentFile();
                }
                try {
                    gdrMetaDataHome = TopLevelDirectoryService.getGdrLabelTopLevelDirectory(rootDir.getParentFile());
                }
                catch (FileNotFoundException e) {
                    if (gdrLabelRequired) {
                        throw e;
                    }
                    gdrMetaDataHome = componentMetaDataHome;
                    _log.finest("Failed to locate gdr meta-data home due to \"" + e.getMessage() + "\", set gdr meta-data home to " + gdrMetaDataHome);
                }
                _log.finer("Located component meta-data home at " + componentMetaDataHome + ", assumed label structure and set gdr meta-data home to " + gdrMetaDataHome);
            } else {
                componentMetaDataHome = rootDir;
                gdrMetaDataHome = rootDir;
                String path = rootDir.getPath().replace("\\", "/");
                if (path.endsWith("/")) {
                    path = path.substring(0, path.length() - 1);
                }
                shiphome = path.endsWith("Disk1/stage") || new File(rootDir, "install.jar").exists();
                _log.finer("Unable to determine component or gdr meta-data home, setting both to root dir " + rootDir);
            }
        }
        return new MetaDataHome(gdrMetaDataHome, componentMetaDataHome, shiphome);
    }

    public Collection<String> getGlobalExcludes() {
        String globalExcludes = System.getProperty(DEFAULT_FILE_EXCLUDES_PROPERTY, DEFAULT_FILE_EXCLUDES);
        return globalExcludes != null && globalExcludes.length() > 0 ? new ArrayList<String>(Arrays.asList(globalExcludes.split(","))) : new ArrayList<String>();
    }

    public boolean isGloballyExcluded(File file) {
        return this.isGloballyExcluded(file, this.getGlobalExcludes());
    }

    public boolean isGloballyExcluded(Path path) {
        return this.isGloballyExcluded(path, this.getGlobalExcludes());
    }

    public boolean isGloballyExcluded(File file, Collection<String> globalExcludes) {
        return this.isGloballyExcluded(NioHelper.getInstance().getPath(file), globalExcludes);
    }

    public boolean isGloballyExcluded(Path file, Collection<String> globalExcludes) {
        if (globalExcludes != null && !globalExcludes.isEmpty()) {
            for (String exclude : globalExcludes) {
                if (!file.getFileName().toString().matches(exclude)) continue;
                return true;
            }
        }
        return false;
    }

    public FileFilter getGlobalExcludeFileFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return !ComponentHelper.this.isGloballyExcluded(pathname);
            }
        };
    }

    public DirectoryStream.Filter<Path> getGlobalExcludeFilter() {
        return new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path pathname) {
                return !ComponentHelper.this.isGloballyExcluded(pathname);
            }
        };
    }

    public Component getComponent(MetaDataHome metaDataHome, ComponentReference ref, Mode mode) throws GdrException, IOException, DataHandlerException {
        return this.getComponent(metaDataHome, null, ref, null, mode);
    }

    public Component getComponent(MetaDataHome metaDataHome, ComponentReference ref, InstallerComponentInfo cinfo, Mode mode) throws GdrException, IOException, DataHandlerException {
        return this.getComponent(metaDataHome, null, ref, cinfo, mode);
    }

    public Component getComponent(MetaDataHome metaDataHome, LabelMap labelMap, ComponentReference ref, InstallerComponentInfo cinfo, Mode mode) throws GdrException, IOException, DataHandlerException {
        Path baseInstallDir;
        boolean baseRequired;
        Component component;
        block50: {
            if (metaDataHome == null) {
                GdrException ex = new GdrException("The meta-date home provided was null.");
                _log.throwing(ComponentHelper.class.getName(), "getComponent", ex);
                throw ex;
            }
            if (ref == null) {
                GdrException ex = new GdrException("The component reference provided was null.");
                _log.throwing(ComponentHelper.class.getName(), "getComponent", ex);
                throw ex;
            }
            if (mode == null) {
                GdrException ex = new GdrException("The mode provided was null.");
                _log.throwing(ComponentHelper.class.getName(), "getComponent", ex);
                throw ex;
            }
            component = null;
            if (metaDataHome.isRepository()) {
                return this.getComponentArchiveFromRepository(metaDataHome, ref, mode);
            }
            if (metaDataHome.isArchive()) {
                component = this.getComponentArchiveFromArchive(metaDataHome.getComponentMetaDataHome(), ref, metaDataHome, null);
                if (component == null) {
                    FileNotFoundException ex = new FileNotFoundException("Unable to locate component definition for \"" + (Object)((Object)ref) + "\" in archive " + metaDataHome.getComponentMetaDataHome());
                    _log.throwing(ComponentHelper.class.getName(), "getComponent", ex);
                    throw ex;
                }
                return component;
            }
            baseRequired = false;
            baseInstallDir = null;
            Path baseStageDir = null;
            if (labelMap != null && (mode.isInstallMode() || mode.isShiphomePackagingMode()) && !metaDataHome.isShiphome()) {
                Collection<Path> baseTopLevelDirs = LabelMapHelper.getInstance(this.getClassLoader()).getBaseTopLevelDir(metaDataHome.getSrchomePath(), labelMap, (Reference)ref);
                if (baseTopLevelDirs != null) {
                    Path baseTopLevelDir;
                    if (_log.isLoggable(Level.FINE)) {
                        _log.fine("Base top level directories are " + baseTopLevelDirs);
                    }
                    Iterator<Path> iterator = baseTopLevelDirs.iterator();
                    while (iterator.hasNext() && !Files.exists(this.getComponentArchiveDefinitionLocation(baseStageDir = ComponentHelper.getStageDir(baseInstallDir = ComponentHelper.getInstallDir(baseTopLevelDir = iterator.next())), (Reference)ref), new LinkOption[0]) && !Files.exists(this.getComponentDefinitionLabelLocation(baseInstallDir, ref), new LinkOption[0])) {
                    }
                } else if (_log.isLoggable(Level.FINE)) {
                    _log.fine("No base top level directory could not be located in the label map for component: " + (Object)((Object)ref));
                }
                boolean bl = baseRequired = baseInstallDir != null;
            }
            if (baseInstallDir == null) {
                baseInstallDir = metaDataHome.getInstallDirPath();
                if (_log.isLoggable(Level.FINEST)) {
                    _log.finest("No base install directory found, defaulting to " + baseInstallDir);
                }
            }
            if (baseStageDir == null) {
                baseStageDir = metaDataHome.getStageDirPath();
            }
            if (_log.isLoggable(Level.FINE)) {
                _log.fine("Base install directory is " + baseInstallDir);
                _log.fine("Base stage directory is " + baseStageDir);
            }
            try {
                if (mode.isShiphomePackagingMode() || mode.isInstallMode() || mode.isDeInstallMode()) {
                    component = mode.isDeInstallMode() || metaDataHome.isShiphome() ? this.getComponentArchiveFromShipHome(metaDataHome.getComponentMetaDataHomePath(), ref, cinfo) : this.getComponentArchiveFromLabel(baseStageDir, (Reference)ref);
                }
                if (component == null && (mode.isComponentPackagingMode() || mode.isShiphomePackagingMode() && Boolean.getBoolean(SHIPHOME_LOAD_UNEXPANDED_PROPERTY))) {
                    block49: {
                        try {
                            component = this.getComponentFromLabel(baseInstallDir, (Reference)ref);
                        }
                        catch (FileNotFoundException fne) {
                            if (!_log.isLoggable(Level.FINEST)) break block49;
                            _log.log(Level.FINEST, "Unable to locate base component definition for \"" + (Object)((Object)ref) + "\" under directory: " + baseInstallDir);
                        }
                    }
                    if (component == null && mode.isComponentPackagingMode()) {
                        component = this.getComponentArchiveFromLabel(baseStageDir, (Reference)ref);
                    }
                }
                if (component != null && _log.isLoggable(Level.FINE)) {
                    _log.fine("Located component definition for \"" + (Object)((Object)ref) + "\" at " + component.getCompDefLocationPath());
                }
            }
            catch (FileNotFoundException fne) {
                if (!_log.isLoggable(Level.FINEST)) break block50;
                _log.log(Level.FINEST, "Unable to locate base component definition for \"" + (Object)((Object)ref) + "\" under directory: " + baseInstallDir);
            }
        }
        if (baseRequired && component == null) {
            FileNotFoundException ex = new FileNotFoundException("Unable to locate base component definition for \"" + (Object)((Object)ref) + "\" under the directory " + baseInstallDir);
            _log.throwing(ComponentHelper.class.getName(), "getComponent", ex);
            throw ex;
        }
        ArrayList<Path> extInstallDirs = new ArrayList<Path>();
        if ((mode.isPackagingMode() || mode.isInstallMode()) && !metaDataHome.isShiphome()) {
            ArrayList<Component> extensions = new ArrayList<Component>();
            if (mode.isComponentPackagingMode()) {
                Component extension = this.getComponentExtensionsFromLabel(baseInstallDir, ref);
                if (extension != null) {
                    extensions.add(extension);
                }
            } else if (mode.isShiphomePackagingMode() || mode.isInstallMode()) {
                if (labelMap != null) {
                    Iterator extTopLevelDirs = LabelMapHelper.getInstance(this.getClassLoader()).getExtensionTopLevelDirs(metaDataHome.getSrchomePath(), labelMap, ref);
                    Iterator iterator = extTopLevelDirs.iterator();
                    while (iterator.hasNext()) {
                        Path extTopLevelDir = (Path)iterator.next();
                        extInstallDirs.add(ComponentHelper.getInstallDir(extTopLevelDir));
                    }
                }
                if (!extInstallDirs.isEmpty()) {
                    for (Path extInstallDir : extInstallDirs) {
                        Component extension = this.getComponentArchiveFromLabel(ComponentHelper.getStageDir(extInstallDir), (Reference)ref);
                        if (extension == null || component != null && extension.getCompDefLocationPath().equals(component.getCompDefLocationPath())) continue;
                        extension.setExtension(true);
                        extensions.add(extension);
                    }
                }
            }
            if (!extensions.isEmpty()) {
                for (Component extComp : extensions) {
                    List<FileMap> filemaps = extComp.getFileMaps();
                    if (filemaps == null || filemaps.isEmpty()) continue;
                    for (FileMap filemap : filemaps) {
                        Set<String> platforms = filemap.getPlatforms();
                        Set<String> locales = filemap.getLocales();
                        if (locales != null && !locales.isEmpty() || platforms != null && !platforms.isEmpty()) continue;
                        GdrException ex = new GdrException("Component extensions may not contain generic file-maps, all file-maps must have at least one platform and/or locale defined: " + extComp);
                        _log.throwing(FeatureSetHelper.class.getName(), "getComponent", ex);
                        throw ex;
                    }
                }
                if (component == null) {
                    component = (Component)extensions.remove(0);
                }
                if (!extensions.isEmpty()) {
                    for (Component extComp : extensions) {
                        if (extComp.getName().equals(component.getName()) && extComp.getVersion().equals(component.getVersion())) continue;
                        GdrException ex = new GdrException("Component extension's name and version did not match. Expected: " + component.getName() + " " + component.getVersion() + " Found: " + extComp.getName() + " " + extComp.getVersion());
                        _log.throwing(FeatureSetHelper.class.getName(), "getComponent", ex);
                        throw ex;
                    }
                    if (mode.isComponentPackagingMode() && component.isComponentArchive()) {
                        List<FileMap> baseFileMaps = component.getFileMaps();
                        boolean modified = false;
                        for (Component extComp : extensions) {
                            List<FileMap> extFileMaps = extComp.getFileMaps();
                            if (extFileMaps == null || extFileMaps.isEmpty()) continue;
                            for (FileMap extFileMap : extFileMaps) {
                                Set<String> extPlatforms = extFileMap.getPlatforms();
                                Set<String> extLocales = extFileMap.getLocales();
                                String extSymbol = extFileMap.getSymbol();
                                Iterator it = baseFileMaps.iterator();
                                while (it.hasNext()) {
                                    FileMap baseFileMap = (FileMap)((Object)it.next());
                                    if (!extSymbol.equals(baseFileMap.getSymbol()) || (extPlatforms.isEmpty() || !baseFileMap.getPlatforms().containsAll(extPlatforms)) && (extLocales.isEmpty() || !baseFileMap.getLocales().containsAll(extLocales))) continue;
                                    it.remove();
                                    modified = true;
                                }
                            }
                        }
                        if (modified) {
                            component.setFileMaps(baseFileMaps);
                        }
                    }
                }
                component.setComponentExtensions(extensions);
            }
        }
        if (component == null) {
            if (extInstallDirs.isEmpty()) {
                extInstallDirs.add(baseInstallDir);
            }
            ArrayList<String> compDirs = new ArrayList<String>();
            for (Path installDir : extInstallDirs) {
                compDirs.add(installDir + File.separator + ComponentHelper.getComponentLabelDir() + File.separator + ComponentHelper.getFormattedName(ref.getName()) + File.separator + "...");
            }
            FileNotFoundException ex = new FileNotFoundException("Unable to locate a component definition (compDef.xml) for \"" + (Object)((Object)ref) + "\" under the following area(s) " + compDirs);
            _log.throwing(ComponentHelper.class.getName(), "getComponent", ex);
            throw ex;
        }
        if (mode.isPackagingMode()) {
            this.validateComponentFileMapTargets(component);
        }
        return component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getComponentArchiveFromRepository(MetaDataHome metaDataHome, ComponentReference ref, Mode mode) throws GdrException, IOException, DataHandlerException {
        Component baseComponent;
        block39: {
            if (metaDataHome == null) {
                throw new GdrException("The meta-data home specified was null.");
            }
            if (ref == null) {
                throw new GdrException("The component reference specified was null.");
            }
            if (!metaDataHome.isRepository()) {
                throw new GdrException("The meta-data home specified was not a repository meta-data home");
            }
            baseComponent = null;
            RepositoryService repositoryService = metaDataHome.getRepositoryService();
            RepositoryVersionResolver versionResolver = repositoryService.getRepositoryVersionResolver();
            String compName = ref.getName();
            Version compVersion = DependencyManagementFactory.getInstance().getVersion(ref.getVersion());
            try {
                Artifact componentInfoArtifact = null;
                File compInfoFile = null;
                try {
                    componentInfoArtifact = versionResolver.getComponentInfoArtifact(compName, compVersion.getBaseVersion());
                }
                catch (RepositoryVersionResolverException e) {
                    _log.finer("Unable to locate component info for component " + (Object)((Object)ref));
                }
                if (componentInfoArtifact == null) {
                    try {
                        componentInfoArtifact = versionResolver.getPatchComponentInfoArtifact(compName, compVersion.getBaseVersion());
                    }
                    catch (RepositoryVersionResolverException e) {
                        _log.finer("Unable to locate component info for patch component " + (Object)((Object)ref));
                    }
                }
                ArrayList<Object> carbArtifacts = new ArrayList<Object>();
                ComponentInfo compInfo = null;
                if (componentInfoArtifact != null) {
                    compInfoFile = repositoryService.getArtifactLocation(componentInfoArtifact);
                    if (!compInfoFile.exists()) {
                        componentInfoArtifact = null;
                        compInfoFile = null;
                        _log.finer("Unable to locate component info for component " + (Object)((Object)ref));
                    } else {
                        compInfo = ComponentInfoHelper.getInstance().getComponentInfo(compInfoFile, false);
                    }
                }
                if (compInfo == null || compInfo.isGeneric()) {
                    Artifact carbArtifact = versionResolver.getComponentArchiveArtifact("com.oracle.cie.gdr.carb", compName, compVersion.getVersion());
                    File carbFile = repositoryService.getArtifactLocation(carbArtifact);
                    if (!carbFile.exists()) {
                        carbArtifact = versionResolver.getComponentArchiveArtifact("com.oracle.cie.gdr.patch.carb." + _patchId, compName, compVersion.getVersion());
                    }
                    carbArtifacts.add(carbArtifact);
                }
                Set targetPlatforms = null;
                Collection<LocaleInfoHolder> targetLocales = null;
                if (compInfo != null) {
                    List fileMapTargets;
                    if (mode.isInstallMode()) {
                        targetPlatforms = PlatformInfoHelper.getInstance().getPlatformInfoHolders(PlatformInfoHelper.getInstance().getCurrentPlatformId());
                        targetLocales = null;
                    }
                    if ((fileMapTargets = compInfo.getFileMapTargets()) != null && !fileMapTargets.isEmpty()) {
                        ArrayList<Artifact> targetedCarbArtifacts = new ArrayList<Artifact>();
                        for (FileMapTarget fileMapTarget : fileMapTargets) {
                            Set platforms = fileMapTarget.getPlatforms();
                            Set locales = fileMapTarget.getLocales();
                            if (platforms.isEmpty() && locales.isEmpty() || mode.isInstallMode() && !ComponentArchiveUtils.matchesTarget(platforms, locales, targetPlatforms, targetLocales)) continue;
                            _log.finest("Processing matching target for component " + (Object)((Object)ref) + " platforms " + platforms + " locales " + locales);
                            String targetString = ComponentArchiveUtils.getTargetIdentifier(platforms, locales);
                            if (StringUtil.isNullOrEmpty((String)targetString, (boolean)true)) {
                                GdrException ex = new GdrException("Encountered unexpected empty target identifier for component " + (Object)((Object)ref) + " and component info target " + fileMapTarget);
                                _log.throwing(ComponentHelper.class.getName(), "getComponentArchiveFromRepository", ex);
                                throw ex;
                            }
                            _log.finest("Using target identifier " + targetString + " for component " + (Object)((Object)ref) + " platforms " + platforms + " locales " + locales);
                            Object carbGroupId = "com.oracle.cie.gdr.carb." + targetString;
                            try {
                                targetedCarbArtifacts.add(versionResolver.getComponentArchiveArtifact((String)carbGroupId, compName, compVersion.getVersion()));
                            }
                            catch (RepositoryVersionResolverException e) {
                                _log.finer("Unable to locate targeted carb for component " + (Object)((Object)ref) + " and group id " + (String)carbGroupId);
                            }
                            if (targetedCarbArtifacts.isEmpty()) {
                                for (String platform : platforms) {
                                    _log.finest("Using target identifier " + targetString + " for component " + (Object)((Object)ref) + " platform " + platform);
                                    carbGroupId = "com.oracle.cie.gdr.carb." + platform.toLowerCase();
                                    try {
                                        targetedCarbArtifacts.add(versionResolver.getComponentArchiveArtifact((String)carbGroupId, compName, compVersion.getVersion()));
                                    }
                                    catch (RepositoryVersionResolverException e) {
                                        _log.finer("Unable to locate targeted carb for component " + (Object)((Object)ref) + " and group id " + (String)carbGroupId);
                                    }
                                }
                            }
                            carbArtifacts.addAll(targetedCarbArtifacts);
                        }
                    }
                }
                if (!carbArtifacts.isEmpty()) {
                    ArrayList<Component> extensions = new ArrayList<Component>();
                    for (Artifact artifact : carbArtifacts) {
                        File carbFile = repositoryService.getArtifactLocation(artifact);
                        if (!carbFile.exists()) {
                            FileNotFoundException ex = new FileNotFoundException("The carb file did not exist " + carbFile);
                            _log.throwing(ComponentHelper.class.getName(), "getComponentArchiveFromRepository", ex);
                            throw ex;
                        }
                        Component component = this.getComponentArchiveFromArchive(carbFile, ref, metaDataHome, artifact);
                        if (component == null) {
                            FileNotFoundException ex = new FileNotFoundException("Unable to locate component definition for \"" + (Object)((Object)ref) + "\" in archive " + carbFile);
                            _log.throwing(ComponentHelper.class.getName(), "getComponentArchiveFromRepository", ex);
                            throw ex;
                        }
                        if (repositoryService.isConvertLegacyCarbs() && !component.isFlattenedCarb()) {
                            String stageDir = ComponentHelper.getInstallDir() + "/" + ComponentHelper.getStageDir() + "/";
                            try (JarHelper jar = new JarHelper(carbFile);){
                                for (JarEntry entry : Collections.list(jar.getJar().entries())) {
                                    if (!entry.getName().startsWith(stageDir + COMPONENT_SHIPHOME_DIR) && !entry.getName().startsWith(stageDir + "Queries") && !entry.getName().startsWith(stageDir + "Actions") && !entry.getName().startsWith(stageDir + "libs.xml")) continue;
                                    File extractionFile = new File(carbFile.getParent(), "../../" + entry.getName().replaceFirst("nginstall/stage", ""));
                                    jar.extract(entry, extractionFile);
                                }
                            }
                            this.createCarbs(component, repositoryService.getLocalCacheRepositoryLocation());
                            ref.setVersion(compVersion.getBaseVersion() + "-" + RepositoryService.getVersionQualifier());
                            Delete.delete((File)new File(carbFile.getParent(), "../../Components"));
                            Delete.delete((File)new File(carbFile.getParent(), "../../Queries"));
                            Delete.delete((File)new File(carbFile.getParent(), "../../Actions"));
                            Delete.delete((File)new File(carbFile.getParent(), "../../libs.xml"));
                            final Component comp = this.getComponentArchiveFromRepository(metaDataHome, ref, mode);
                            Runtime.getRuntime().addShutdownHook(new Thread(){

                                @Override
                                public void run() {
                                    File parentDir = comp.getArchiveLocation().getParentFile();
                                    if (parentDir.exists()) {
                                        parentDir.deleteOnExit();
                                        File[] files = parentDir.listFiles();
                                        if (files != null) {
                                            for (File child : files) {
                                                child.deleteOnExit();
                                            }
                                        }
                                    }
                                }
                            });
                            return comp;
                        }
                        component.setCarbArtifact(artifact);
                        component.setComponentInfoArtifact(componentInfoArtifact);
                        component.setComponentInfoFile(compInfoFile);
                        if (baseComponent == null) {
                            baseComponent = component;
                            continue;
                        }
                        component.setExtension(true);
                        extensions.add(component);
                    }
                    if (!extensions.isEmpty()) {
                        baseComponent.setComponentExtensions(extensions);
                    }
                    break block39;
                }
                FileNotFoundException ex = new FileNotFoundException("Unable to locate a component definition (compDef.xml) for \"" + (Object)((Object)ref) + "\" under the following area(s) " + repositoryService.getLocalCacheRepository());
                _log.throwing(ComponentHelper.class.getName(), "getComponentArchiveFromRepository", ex);
                throw ex;
            }
            catch (RepositoryVersionResolverException e) {
                throw new FileNotFoundException(e.getMessage());
            }
            catch (DependencyManagementException | RestException e) {
                throw new GdrException(e);
            }
        }
        return baseComponent;
    }

    public Component getComponentArchiveFromPatch(MetaDataHome metaDataHome, Reference ref, Path carbPath) throws GdrException, IOException, DataHandlerException {
        if (metaDataHome == null) {
            throw new GdrException("The meta-data home specified was null.");
        }
        if (ref == null) {
            throw new GdrException("The component reference specified was null.");
        }
        if (!metaDataHome.isPatch()) {
            throw new GdrException("The meta-data home specified was not a patch meta-data home");
        }
        if (carbPath != null) {
            if (!Files.exists(carbPath, new LinkOption[0])) {
                FileNotFoundException ex = new FileNotFoundException("The carb file did not exist " + carbPath);
                _log.throwing(ComponentHelper.class.getName(), "getComponentArchiveFromPath", ex);
                throw ex;
            }
            Component component = this.getComponentArchiveFromArchive(carbPath.toFile(), ref, metaDataHome, null);
            if (component == null) {
                FileNotFoundException ex = new FileNotFoundException("Unable to locate component definition for \"" + (Object)((Object)ref) + "\" in archive " + carbPath);
                _log.throwing(ComponentHelper.class.getName(), "getComponentArchiveFromPath", ex);
                throw ex;
            }
            return component;
        }
        FileNotFoundException ex = new FileNotFoundException("Unable to locate a component definition (compDef.xml) for \"" + (Object)((Object)ref) + "\" under the following area(s) " + metaDataHome.getComponentMetaDataHome() + ". The provided CARB path was null.");
        _log.throwing(ComponentHelper.class.getName(), "getComponentArchiveFromPatch", ex);
        throw ex;
    }

    public void validateComponentFileMapTargets(Component component) throws GdrException {
        if (component != null) {
            ArrayList<Component> components = new ArrayList<Component>();
            components.add(component);
            if (component.hasComponentExtensions()) {
                components.addAll(component.getComponentExtensions());
            }
            for (Component c : components) {
                List<FileMap> fileMaps = component.getFileMaps();
                if (fileMaps == null || fileMaps.isEmpty()) continue;
                for (FileMap fileMap : fileMaps) {
                    try {
                        fileMap.getPlatforms(true, true);
                    }
                    catch (GdrException e) {
                        GdrException ex = new GdrException("Encountered unsupported platform value in component " + c, (Throwable)e);
                        _log.throwing(ComponentInfoHelper.class.getName(), "validateComponentFileMapTargets", ex);
                        throw ex;
                    }
                    Set<String> locales = fileMap.getLocales();
                    if (locales == null || locales.isEmpty()) continue;
                    for (String l : locales) {
                        if (LocaleInfoHelper.getInstance().isSupportedLocale(l)) continue;
                        GdrException ex = new GdrException("Encountered unsupported locale value " + l + " in component " + c);
                        _log.throwing(ComponentInfoHelper.class.getName(), "validateComponentFileMapTargets", ex);
                        throw ex;
                    }
                }
            }
        }
    }

    public void setPatchId(String patch) {
        _patchId = patch;
    }

    public void stringsub(Component component, VariableResolverService variableResolver) throws GdrException {
        this.stringsub(component, variableResolver, (Path)null, null);
    }

    public Map<String, String> stringsub(Component component, VariableResolverService variableResolver, File backupLocation, String backupPrefix) throws GdrException {
        return this.stringsub(component, variableResolver, NioHelper.getInstance().getPath(backupLocation), backupPrefix);
    }

    public Map<String, String> stringsub(Component component, VariableResolverService variableResolver, Path backupLocation, String backupPrefix) throws GdrException {
        Map<String, String> backupFiles = null;
        if (component != null) {
            Stringsubs stringsubs;
            if (Boolean.getBoolean("ComponentHelper.disable.stringsubs")) {
                _log.finer("Skipping string subs of component " + component + " due to \"ComponentHelper.disable.stringsubs\" system property being set.");
                return null;
            }
            if (variableResolver == null) {
                variableResolver = VariableResolverService.getVariableResolverService();
            }
            if ((stringsubs = component.getStringsubs()) != null) {
                try {
                    com.oracle.cie.gdr.dao.cpd.StringsubsDefinition subsDef = this.getStringsubsDefinition(component);
                    if (subsDef != null) {
                        backupFiles = this.stringsub(subsDef, variableResolver.getObjectStore(component.getNamespace()), backupLocation, backupPrefix);
                    }
                }
                catch (StringsubsEngine.StringsubsEngineException e) {
                    throw new GdrException((Throwable)e);
                }
            }
        }
        if (backupFiles == null || backupFiles.size() == 0) {
            _log.fine("The templates map is null or empty.");
        }
        return backupFiles;
    }

    public com.oracle.cie.gdr.dao.cpd.StringsubsDefinition getStringsubsDefinition(Component component) {
        return this.getStringsubsDefinition(component, null);
    }

    public com.oracle.cie.gdr.dao.cpd.StringsubsDefinition getStringsubsDefinition(Component component, List<StringsubsGroup> groups) {
        Stringsubs stringsubs;
        com.oracle.cie.gdr.dao.cpd.StringsubsDefinition subsDef = null;
        if (component != null && (stringsubs = component.getStringsubs()) != null) {
            if (groups == null || groups.isEmpty()) {
                groups = stringsubs.getGroups();
            }
            if (groups != null && !groups.isEmpty()) {
                ArrayList<StringsubsGroupRef> groupRefs = new ArrayList<StringsubsGroupRef>();
                for (StringsubsGroup group : groups) {
                    groupRefs.add(new StringsubsGroupRef(group.getId()));
                }
                StringsubsComponent subsComp = new StringsubsComponent(component.toString());
                subsComp.setGroupRefs(groupRefs);
                ArrayList<StringsubsComponent> subsComps = new ArrayList<StringsubsComponent>();
                subsComps.add(subsComp);
                subsDef = new com.oracle.cie.gdr.dao.cpd.StringsubsDefinition(component.getName(), component.getVersion());
                subsDef.setComponents(subsComps);
                subsDef.setGroups(groups);
                subsDef.setChangePairs(stringsubs.getChangePairs());
            }
        }
        return subsDef;
    }

    public Map<String, String> stringsub(com.oracle.cie.gdr.dao.cpd.StringsubsDefinition stringsubsDefinition, IObjectStore ojectStore, File backupLocation, String backupPrefix) throws StringsubsEngine.StringsubsEngineException {
        return this.stringsub(stringsubsDefinition, ojectStore, NioHelper.getInstance().getPath(backupLocation), backupPrefix);
    }

    public Map<String, String> stringsub(com.oracle.cie.gdr.dao.cpd.StringsubsDefinition stringsubsDefinition, IObjectStore ojectStore, Path backupLocation, String backupPrefix) throws StringsubsEngine.StringsubsEngineException {
        Map backupFiles = null;
        if (stringsubsDefinition != null) {
            StringsubsEngine engine = new StringsubsEngine((StringsubsDefinition)stringsubsDefinition.getDataHandler().getObject(), (IoBridge)new NioBridge());
            engine.setFileBackups(backupLocation.toString(), backupPrefix);
            engine.execute(ojectStore);
            backupFiles = engine.getBackupFiles();
        }
        return backupFiles;
    }

    public Map<String, String> getComponentVariables(Component component, VariableResolverService varService) {
        Map<String, String> variables = this.getComponentSymbolVariables(component, varService);
        if (component != null) {
            String componentVersion = component.getVersion();
            variables.put("component.version", componentVersion);
            variables.put("component.releaseVersion", ComponentHelper.getShortenedVersion(componentVersion));
            variables.put("component.name", component.getName());
        }
        return variables;
    }

    public Map<String, String> getComponentSymbolVariables(Component component, VariableResolverService varService) {
        Collection<ComponentTarget> targets;
        HashMap<String, String> variables = new HashMap<String, String>();
        if (component != null && (targets = component.getComponentTargets()) != null && !targets.isEmpty()) {
            for (ComponentTarget target : targets) {
                String location = target.getLocation();
                if (StringUtil.isNullOrEmpty((String)location, (boolean)true)) continue;
                String symbol = target.getSymbol();
                variables.put(symbol, location);
                String oh = varService.get("ORACLE_HOME");
                if (oh == null) {
                    oh = "";
                }
                if (!oh.replace("\\", "/").endsWith("/")) {
                    location = File.separator + location;
                }
                variables.put(symbol + ".path", oh + location);
            }
        }
        return variables;
    }

    public Component getComponent(Collection<Component> components, Reference compRef) {
        if (compRef != null) {
            return this.getComponent(components, compRef.getName(), compRef.getVersion());
        }
        return null;
    }

    public Component getComponent(Collection<Component> components, String compName, String compVer) {
        if (components != null) {
            for (Component comp : components) {
                if (!comp.getName().equals(compName) || !comp.getVersion().equals(compVer)) continue;
                return comp;
            }
        }
        return null;
    }

    public Collection<Component> getSortedByDiskOrder(Collection<Component> components) {
        if (components != null && !components.isEmpty()) {
            HashMap<Integer, ArrayList<Component>> map = new HashMap<Integer, ArrayList<Component>>();
            for (Component component : components) {
                ArrayList<Component> comps;
                int disk = component.getDisk();
                if (disk < 1) {
                    disk = 1;
                }
                if ((comps = (ArrayList<Component>)map.get(disk)) == null) {
                    comps = new ArrayList<Component>();
                    map.put(disk, comps);
                }
                comps.add(component);
            }
            LinkedHashSet<Component> ordered = new LinkedHashSet<Component>();
            TreeSet sortedSet = new TreeSet(map.keySet());
            for (Integer i : sortedSet) {
                ordered.addAll((Collection)map.get(i));
            }
            return ordered;
        }
        return components;
    }

    public Collection<ComponentTarget> getBootstrapComponentTargets(Set<Component> components) throws GdrException {
        ArrayList<ComponentTarget> bootstrapTargets = new ArrayList<ComponentTarget>();
        if (components != null && !components.isEmpty()) {
            for (Component component : components) {
                Collection<ComponentTarget> targets = component.getComponentTargets();
                if (targets == null || targets.isEmpty()) continue;
                for (ComponentTarget target : targets) {
                    if (!target.isBootstrap() && !target.hasBootstrapFileTargets()) continue;
                    bootstrapTargets.add(target);
                }
            }
        }
        return bootstrapTargets;
    }

    public Set<Component> getBootstrapComponents(Set<Component> components) throws GdrException {
        LinkedHashSet<Component> bootstrapComponents = new LinkedHashSet<Component>();
        Collection<ComponentTarget> targets = this.getBootstrapComponentTargets(components);
        if (targets != null && !targets.isEmpty()) {
            for (ComponentTarget target : targets) {
                bootstrapComponents.add(target.getComponent());
            }
        }
        return bootstrapComponents;
    }

    public void createLauncherProperties(File dir, Set<Component> components, DirectoryMap directoryMap) throws IOException, GdrException {
        Collection<ComponentTarget> bootstrapTargets;
        if (dir != null && components != null && !components.isEmpty() && directoryMap != null && !(bootstrapTargets = this.getBootstrapComponentTargets(components)).isEmpty()) {
            HashMap<String, String> platformMap = new HashMap<String, String>();
            for (ComponentTarget target : bootstrapTargets) {
                String bootstrapJarPath = "";
                if (target.getComponent().isFlattenedCarb()) {
                    Artifact carbArtifact = target.getComponent().getCarbArtifact();
                    if (target instanceof PackagerComponentTarget) {
                        carbArtifact = ((PackagerComponentTarget)target).getFileMapComponent().getCarbArtifact();
                    }
                    bootstrapJarPath = ComponentHelper.getStageDir() + "/" + "install-repo" + "/" + carbArtifact.getGroupIdNameVersionRepoPath() + "/" + target.getArchiveLocation().getName();
                    bootstrapJarPath = bootstrapJarPath + "!/" + ComponentHelper.getInstallDir() + "/" + ComponentHelper.getStageDir() + "/" + this.getShipHomePath() + "/" + target.getComponent().getName() + "/" + target.getComponent().getVersion() + "/" + ComponentHelper.getDataFilesExtractedDir() + "/" + target.getSource() + "/";
                } else {
                    bootstrapJarPath = ComponentHelper.getStageDir() + "/" + this.getShipHomePath() + "/" + target.getComponent().getName() + "/" + target.getComponent().getVersion() + "/" + ComponentHelper.getDataFilesDir() + "/" + target.getSource();
                }
                ArrayList<String> entries = new ArrayList<String>();
                if (target.isBootstrap()) {
                    entries.add(bootstrapJarPath);
                } else if (target.hasBootstrapFileTargets()) {
                    for (FileTarget fileTarget : target.getBootstrapFileTargets()) {
                        entries.add(bootstrapJarPath + "!/" + fileTarget.getDest());
                    }
                }
                String location = target.getLocation();
                if (location == null) {
                    GdrException ex = new GdrException("The location was not set for the component target: " + target);
                    _log.throwing(((Object)((Object)this)).getClass().getName(), "createLauncherProperties", ex);
                    throw ex;
                }
                if (location.trim().isEmpty()) {
                    location = ".";
                }
                String boostrapEntry = null;
                for (String entry : entries) {
                    boostrapEntry = boostrapEntry == null ? entry : boostrapEntry + "," + entry;
                    boostrapEntry = boostrapEntry + ":" + location;
                }
                Set<String> platforms = target.getPlatforms();
                if (platforms == null) {
                    platforms = new HashSet<String>();
                }
                if (platforms.isEmpty()) {
                    platforms.add("ALL_PLATFORMS");
                }
                for (String platform : platforms) {
                    String bootstrapEntries = (String)platformMap.get(platform);
                    bootstrapEntries = bootstrapEntries != null ? bootstrapEntries + "," : "";
                    bootstrapEntries = bootstrapEntries + boostrapEntry;
                    platformMap.put(platform, bootstrapEntries);
                }
            }
            File propertiesFile = new File(dir, LAUNCHER_PROPERTIES_FILENAME);
            Properties properties = new Properties();
            if (propertiesFile.exists()) {
                FileReader fr = new FileReader(propertiesFile);
                properties.load(fr);
                fr.close();
            }
            for (String platform : platformMap.keySet()) {
                String bootstrapEntries = (String)platformMap.get(platform);
                if ("ALL_PLATFORMS".equals(platform)) {
                    properties.setProperty(LAUNCHER_BOOTSTRAP_PROPERTY, bootstrapEntries);
                    continue;
                }
                properties.setProperty("oracle.launcher.bootstrap." + platform, bootstrapEntries);
            }
            dir.mkdirs();
            FileWriter fw = new FileWriter(propertiesFile);
            properties.store(fw, null);
            fw.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createJavaCarbsFile(String[] jdkComps, Set<Component> components, String parentDir) throws GdrException, IOException {
        if (jdkComps != null && jdkComps.length > 0) {
            String javaCarbsProperty = "";
            HashSet<Component> javaComponents = new HashSet<Component>();
            HashSet<String> javaComponentNames = new HashSet<String>(Arrays.asList(jdkComps));
            for (Component component : components) {
                if (!javaComponentNames.contains(component.getName())) continue;
                javaComponents.add(component);
            }
            for (Component javaComp : javaComponents) {
                for (ComponentTarget target : javaComp.getComponentTargets()) {
                    Artifact carbArtifact = target.getComponent().getCarbArtifact();
                    if (target instanceof PackagerComponentTarget) {
                        carbArtifact = ((PackagerComponentTarget)target).getFileMapComponent().getCarbArtifact();
                    }
                    String value = "Disk1/" + ComponentHelper.getStageDir() + "/" + "install-repo" + "/" + carbArtifact.getGroupIdNameVersionRepoPath() + "/" + target.getArchiveLocation().getName();
                    value = value + "!" + ComponentHelper.getInstallDir() + "/" + ComponentHelper.getStageDir() + "/" + this.getShipHomePath() + "/" + target.getComponent().getName() + "/" + target.getComponent().getVersion() + "/" + ComponentHelper.getDataFilesExtractedDir() + "/" + target.getSource();
                    if (StringUtil.isNullOrEmpty((String)javaCarbsProperty)) {
                        javaCarbsProperty = value;
                        continue;
                    }
                    javaCarbsProperty = javaCarbsProperty + "," + value;
                }
            }
            if (!StringUtil.isNullOrEmpty((String)javaCarbsProperty)) {
                File propertiesFile = new File(parentDir, JAVA_CARBS_FILENAME);
                try (FileWriter fw = null;){
                    fw = new FileWriter(propertiesFile);
                    fw.write(javaCarbsProperty);
                    fw.flush();
                }
            }
        }
    }

    public static String getShortenedVersion(String version) {
        int index;
        String shortVersion = "";
        if (version != null && (index = version.indexOf("-")) > -1) {
            version = version.substring(0, index);
        }
        String[] split = version != null ? version.split("\\.") : new String[]{};
        for (int x = 0; x < 3; ++x) {
            if (x > 0) {
                shortVersion = shortVersion + ".";
            }
            shortVersion = split.length > x ? shortVersion + split[x] : shortVersion + "0";
        }
        return shortVersion;
    }

    public Map<String, FileTarget> getCarbDiffFileTargets(Component component, FileMap fileMap) throws CarbDiffException {
        HashMap<String, FileTarget> fileTargetMap = new HashMap<String, FileTarget>();
        try {
            List<FileTarget> fileTargets = new PackagerComponentTarget(component, fileMap, new ServiceHolder(), Mode.PACKAGE_SHIPHOME).getFileTargets();
            if (fileTargets != null && !fileTargets.isEmpty()) {
                for (FileTarget ft : fileTargets) {
                    fileTargetMap.put(ft.getDest(), ft);
                }
            }
        }
        catch (GdrException e) {
            throw new CarbDiffException(e);
        }
        return fileTargetMap;
    }

    public boolean hasLanguageToInstall(Component comp, Home home) {
        boolean res = false;
        com.oracle.cie.gdr.dao.rgy.ComponentInfo cInfo = home.getRegistryHelper().getComponentInfoFromDist(home.getRegistry().getDistributions(), comp.getName(), comp.getVersion());
        Iterator<ComponentTarget> targets = comp.getComponentTargets().iterator();
        if (cInfo != null) {
            while (targets.hasNext()) {
                ComponentTarget target = targets.next();
                boolean installed = false;
                for (TargetInfo installedTarget : cInfo.getTargets()) {
                    if (!target.getSource().equals(installedTarget.getSource())) continue;
                    installed = true;
                }
                if (installed || target.getLocales() == null || target.getLocales().isEmpty()) continue;
                res = true;
            }
        }
        return res;
    }

    public XmlDiffTreeFilter getDefaultXmlDiffTreeFilter(XmlDiffTreeFilter existingFilter) throws GdrException {
        XmlDiffTreeFilter xmlDiffFilter;
        XmlDiffTreeFilter xmlDiffTreeFilter = xmlDiffFilter = existingFilter != null ? existingFilter : new XmlDiffTreeFilter();
        if (!Boolean.getBoolean("ComponentHelper.disable.default.diff.tree.filter")) {
            try {
                xmlDiffFilter.addExclude(new XmlDiffRule("file-map"));
                XmlDiffRuleType ruleType = new ObjectFactory().createXmlDiffRuleType();
                Element ruleElement = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument().createElement("library");
                ruleElement.setAttribute("size", "");
                ruleType.setAny(ruleElement);
                xmlDiffFilter.addAttributeExclude(new XmlDiffRule(ruleType));
                ruleType = new ObjectFactory().createXmlDiffRuleType();
                ruleElement = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument().createElement(COMPONENT_DEF);
                ruleElement.setAttribute("patch-level", "");
                ruleType.setAny(ruleElement);
                xmlDiffFilter.addAttributeExclude(new XmlDiffRule(ruleType));
            }
            catch (Exception e) {
                throw new GdrException("Failed to populate XML Diff Tree Filter.", (Throwable)e);
            }
        }
        return xmlDiffFilter;
    }

    public Map<String, ArtifactType> getFileTypeMapping(Component component) throws GdrException {
        HashMap<String, ArtifactType> fileMapping = new HashMap<String, ArtifactType>();
        List<ArtifactFile> fileTypes = component.getFileTypeMapping();
        if (!fileTypes.isEmpty()) {
            for (ComponentTarget targets : component.getComponentTargets()) {
                for (FileTarget fileTarget : targets.getFileTargets()) {
                    String dest = fileTarget.getDest();
                    for (ArtifactFile fileType : fileTypes) {
                        if (!fileType.matches(dest)) continue;
                        fileMapping.put(fileTarget.getDest(), ArtifactType.getArtifactType((String)fileType.getType()));
                    }
                }
            }
        }
        return fileMapping;
    }
}

