/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.helpers;

import com.oracle.cie.common.comdev.ComdevHelper;
import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.common.dao.IDataHandlerWrapper;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.dao.cin.CentralInventory;
import com.oracle.cie.gdr.dao.cin.Home;
import com.oracle.cie.gdr.dao.cin.HomeValidator;
import com.oracle.cie.gdr.helpers.GdrHelper;
import com.oracle.cie.gdr.nio.NioFileLockService;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.patch.cin.CentralInventoryUpdater;
import com.oracle.cie.gdr.utils.ConsistentProperties;
import com.oracle.cie.gdr.utils.GdrException;
import com.oracle.cie.nextgen.common.utils.UtilityOps;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

public class CentralInventoryHelper
extends GdrHelper<CentralInventory> {
    private static final Logger _log = Logger.getLogger(CentralInventoryHelper.class.getName());
    public static final String NAMESPACE = "http://xmlns.oracle.com/cie/gdr/cin";
    public static final String CENTRAL_INVENTORY_DEF = "INVENTORY";
    public static final String CENTRAL_INVENTORY_DIR = "ContentsXML";
    public static final String INVENTORY_XML = "inventory.xml";
    public static final String UNIX_LOCATION_FILE_LOC = "inventory_loc";
    public static final String UNIX_GROUP_PTR = "inst_group";
    public static final String SOL_PROPERTIES_HEADER = "Oracle Installer Location File Location";
    public static final String CUSTOM_INVENTORY_LOC = "CUSTOM_INVENTORY_LOC";
    public static final String INVPTR_LOC = "INVPTR_LOC";
    private static final int DEFAULT_ATTEMPTS = 10;
    private static final int DEFAULT_WAIT_TIME = 5000;
    private static volatile CentralInventoryHelper _instance;
    private static final Object _mutex;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CentralInventoryHelper getInstance() {
        CentralInventoryHelper result = _instance;
        if (result == null) {
            Object object = _mutex;
            synchronized (object) {
                result = _instance;
                if (result == null) {
                    _instance = result = new CentralInventoryHelper(null);
                }
            }
        }
        return result;
    }

    public static CentralInventoryHelper getInstance(ClassLoader classLoader) {
        if (classLoader == null) {
            return CentralInventoryHelper.getInstance();
        }
        return new CentralInventoryHelper(classLoader);
    }

    private CentralInventoryHelper(ClassLoader classLoader) {
        super(CentralInventory.class, classLoader);
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public String getRootElement() {
        return CENTRAL_INVENTORY_DEF;
    }

    public String getPath() {
        return CENTRAL_INVENTORY_DIR;
    }

    public Path getInventoryXmlPath(Path centralInventoryPath) {
        return centralInventoryPath.resolve(this.getPath() + File.separator + INVENTORY_XML);
    }

    public synchronized CentralInventory getCentralInventory(Path centralInventoryFile) throws GdrException {
        if (centralInventoryFile == null || !Files.isRegularFile(centralInventoryFile, new LinkOption[0])) {
            GdrException ex = new GdrException("Central Inventory file specified was invalid: " + centralInventoryFile);
            _log.throwing(CentralInventoryHelper.class.getName(), "getCentralInventory", ex);
            throw ex;
        }
        try {
            NioFileLockService.getFileLockWithLimitedWait((Path)centralInventoryFile, (int)10, (int)5000);
            CentralInventory ex = (CentralInventory)this.getRootWrapper(NioFileLockService.getFileChannel((Path)centralInventoryFile));
            return ex;
        }
        catch (Exception e) {
            throw new GdrException("Failed trying to read Central Inventory [" + centralInventoryFile + "]", (Throwable)e);
        }
        finally {
            try {
                NioFileLockService.releaseFileLock((Path)centralInventoryFile);
            }
            catch (IOException e) {
                _log.log(Level.SEVERE, "Failed trying to release the file lock for:" + centralInventoryFile, e);
            }
        }
    }

    private CentralInventory getCentralInventory(String centralInventoryLocation) throws GdrException {
        Path centralInventoryPath = NioHelper.getInstance().getPath(centralInventoryLocation, new String[0]);
        Path inventoryXmlPath = this.getInventoryXmlPath(centralInventoryPath);
        if (!Files.exists(inventoryXmlPath, new LinkOption[0])) {
            throw new GdrException("The Inventory xml path file does not exist. [" + inventoryXmlPath + "]");
        }
        return this.getCentralInventory(inventoryXmlPath);
    }

    public Properties getInventoryPointerProperties(String inventoryPtrFile) throws GdrException {
        if (StringUtil.isNullOrEmpty((String)inventoryPtrFile, (boolean)true)) {
            throw new GdrException("The Inventory Pointer File parameter is null or empty.");
        }
        Path inventoryPtrPath = NioHelper.getInstance().getPath(inventoryPtrFile, new String[0]);
        if (!Files.exists(inventoryPtrPath, new LinkOption[0])) {
            throw new GdrException("The Inventory Pointer File does not exist. Path [" + inventoryPtrFile + "]");
        }
        Properties properties = new Properties();
        try (InputStream is = Files.newInputStream(inventoryPtrPath, new OpenOption[0]);){
            properties.load(is);
        }
        catch (IOException e) {
            throw new GdrException("Error reading properties from Inventory Pointer File. Path[" + inventoryPtrPath + "]", (Throwable)e);
        }
        return properties;
    }

    public synchronized List<Home> getHomes(String inventoryLocation) throws GdrException {
        if (StringUtil.isNullOrEmpty((String)inventoryLocation, (boolean)true)) {
            throw new GdrException("The Inventory Location is null or empty.");
        }
        CentralInventory centralInventory = this.getCentralInventory(inventoryLocation);
        return centralInventory.getHomes();
    }

    public synchronized Home getHome(String inventoryLocation, String homeLocation) throws GdrException {
        if (StringUtil.isNullOrEmpty((String)inventoryLocation, (boolean)true)) {
            throw new GdrException("The Inventory Location is null or empty.");
        }
        if (StringUtil.isNullOrEmpty((String)homeLocation, (boolean)true)) {
            throw new GdrException("The homeLocation is null or empty.");
        }
        CentralInventory centralInventory = this.getCentralInventory(inventoryLocation);
        List<Home> homes = centralInventory.getHomes();
        if (homes == null || homes.isEmpty()) {
            return null;
        }
        Path homeLocationPath = NioHelper.getInstance().getPath(homeLocation.trim(), new String[0]);
        for (Home home : homes) {
            Path indexHomeLocationPath;
            if (home == null || home.isRemoved() || !(indexHomeLocationPath = NioHelper.getInstance().getPath(home.getLoc(), new String[0])).equals(homeLocationPath)) continue;
            return home;
        }
        return null;
    }

    public static boolean validateHome(List<Home> homes, HomeValidator validator) {
        for (Home h : homes) {
            if (validator.validate(h)) continue;
            _log.warning("Invalid home [" + (Object)((Object)h) + "]");
            return false;
        }
        return true;
    }

    public static String dumpParams(String[] params) {
        if (params == null || params.length < 1) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (String param : params) {
            result.append("" + param + ", ");
        }
        if (result.length() > 0) {
            result.delete(result.length() - 2, result.length());
        }
        return result.toString();
    }

    public synchronized void updateCentralInventory(String centralInventoryLocation, CentralInventoryUpdater updater) throws GdrException {
        _log.info("updateCentralInventory centralInventoryLocation(" + centralInventoryLocation + ")");
        if (StringUtil.isNullOrEmpty((String)centralInventoryLocation, (boolean)true)) {
            throw new GdrException("The Inventory Location is null or empty.");
        }
        Path inventoryXmlPath = this.getInventoryXmlPath(NioHelper.getInstance().getPath(centralInventoryLocation, new String[0]));
        if (!Files.exists(inventoryXmlPath, new LinkOption[0])) {
            throw new GdrException("The Inventory xml path file does not exist. [" + inventoryXmlPath + "]");
        }
        CentralInventory centralInventory = null;
        try {
            _log.info("updateCentralInventory locking central inventory[" + inventoryXmlPath + "]");
            NioFileLockService.getFileLockWithLimitedWait((Path)inventoryXmlPath, (int)10, (int)5000);
            FileChannel ciChannel = NioFileLockService.getFileChannel((Path)inventoryXmlPath);
            _log.info("updateCentralInventory Reading from FileChannel central inventory[" + inventoryXmlPath + "]");
            centralInventory = (CentralInventory)this.getRootWrapper(ciChannel);
            _log.info("updateCentralInventory updating central inventory object[" + (Object)((Object)centralInventory) + "]");
            updater.update(centralInventory);
            _log.info("updateCentralInventory Writing central inventory[" + (Object)((Object)centralInventory) + "] to File [" + inventoryXmlPath + "]");
            this.save((IDataHandlerWrapper)centralInventory, ciChannel);
        }
        catch (DataHandlerException | IOException e) {
            throw new GdrException("Failed trying to update Central Inventory [" + inventoryXmlPath + "]", e);
        }
        finally {
            try {
                _log.info("updateCentralInventory releasing central inventory[" + inventoryXmlPath + "]");
                NioFileLockService.releaseFileLock((Path)inventoryXmlPath);
            }
            catch (IOException e) {
                _log.log(Level.SEVERE, "Failed trying to release the file lock for path:" + inventoryXmlPath, e);
            }
        }
    }

    public static Set<PosixFilePermission> getDefaultCentralInventoryPermissions() {
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
        perms.add(PosixFilePermission.OWNER_WRITE);
        perms.add(PosixFilePermission.OWNER_READ);
        perms.add(PosixFilePermission.OWNER_EXECUTE);
        perms.add(PosixFilePermission.GROUP_WRITE);
        perms.add(PosixFilePermission.GROUP_READ);
        perms.add(PosixFilePermission.GROUP_EXECUTE);
        return perms;
    }

    public static Set<PosixFilePermission> getDefaultInventoryXMLPermissions() {
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
        perms.add(PosixFilePermission.OWNER_WRITE);
        perms.add(PosixFilePermission.OWNER_READ);
        perms.add(PosixFilePermission.GROUP_WRITE);
        perms.add(PosixFilePermission.GROUP_READ);
        return perms;
    }

    public static void setDefaultCentralInventoryPermissions(Path centralInventoryPath) throws GdrException {
        CentralInventoryHelper.changePermissionsRecursively(centralInventoryPath, CentralInventoryHelper.getDefaultCentralInventoryPermissions());
    }

    public static void setDefaultInventoryXMLPermissions(Path inventoryXML) throws GdrException {
        CentralInventoryHelper.changePermissionsRecursively(inventoryXML, CentralInventoryHelper.getDefaultInventoryXMLPermissions());
    }

    private static void changePermissionsRecursively(Path path, Set<PosixFilePermission> perms) throws GdrException {
        try {
            Set<PosixFilePermission> currentPerms = Files.getPosixFilePermissions(path, LinkOption.NOFOLLOW_LINKS);
            if (!currentPerms.equals(perms)) {
                Files.setPosixFilePermissions(path, perms);
            }
            if (path.toFile().isDirectory()) {
                for (File f : path.toFile().listFiles()) {
                    if (!f.isDirectory()) continue;
                    CentralInventoryHelper.changePermissionsRecursively(f.toPath(), perms);
                }
            }
        }
        catch (FileSystemException e) {
            throw new GdrException("Could not modify permissions for path: " + path.toString() + " " + e.getMessage());
        }
        catch (IOException e) {
            throw new GdrException("Could not set the permissions for path: " + path.toString() + " " + e.getMessage());
        }
    }

    public void createOraInvPtr(Path invLoc, Path oraInstLoc, String group) throws GdrException, IOException {
        if (invLoc == null) {
            throw new GdrException("The invLoc path provided was null.");
        }
        if (oraInstLoc == null) {
            throw new GdrException("The oraInstLoc path provided was null.");
        }
        if (StringUtil.isNullOrEmpty((String)group, (boolean)true)) {
            if (ComdevHelper.isWindows() || !Files.exists(oraInstLoc, new LinkOption[0])) {
                group = "";
            } else if (Files.exists(oraInstLoc, new LinkOption[0])) {
                Properties properties = this.getInventoryPointerProperties(oraInstLoc.toString());
                group = properties.getProperty(UNIX_GROUP_PTR);
            }
        }
        ConsistentProperties props = new ConsistentProperties();
        props.setProperty(UNIX_LOCATION_FILE_LOC, invLoc.toString());
        props.setProperty(UNIX_GROUP_PTR, group);
        Files.createDirectories(oraInstLoc.getParent(), new FileAttribute[0]);
        try (OutputStream out = Files.newOutputStream(oraInstLoc, new OpenOption[0]);){
            props.store(out, SOL_PROPERTIES_HEADER, UtilityOps.getStoredSessionTimeStampCalendar().getTime());
            _log.finest("Saved the inventory pointer file at " + oraInstLoc);
        }
        catch (IOException e) {
            String message = "Save of inventory pointer file at " + oraInstLoc + " failed: " + e.toString();
            _log.warning(message);
            if (_log.isLoggable(Level.FINEST)) {
                _log.log(Level.FINEST, message, e);
            }
            throw e;
        }
    }

    public IDataHandler parse(Path path) throws IOException, DataHandlerException {
        if (_log.isLoggable(Level.FINER)) {
            _log.finer("Parsing " + path);
        }
        if (path == null) {
            throw new NullPointerException("The path specified was null.");
        }
        if (!Files.exists(path, new LinkOption[0])) {
            throw new FileNotFoundException("The path specified did not exist " + path);
        }
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            IDataHandler iDataHandler = this.parse(is);
            return iDataHandler;
        }
    }

    public IDataHandler parse(InputStream is) throws IOException, DataHandlerException {
        try {
            return this.getDataHandlerProvider().create(this.getNamespace(), this.getRootElement(), this.getMissingNamespaceSaxSource(is, this.getNamespace()), this.getClassLoader());
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new DataHandlerException((Throwable)e);
        }
    }

    public IDataHandler parse(String s) throws DataHandlerException {
        try {
            return this.parse(new ByteArrayInputStream(s.getBytes()));
        }
        catch (IOException e) {
            throw new DataHandlerException((Throwable)e);
        }
    }

    private SAXSource getMissingNamespaceSaxSource(InputStream is, String namespace) throws ParserConfigurationException, SAXException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        XMLReader reader = factory.newSAXParser().getXMLReader();
        XMLNamespaceFilter xmlFilter = new XMLNamespaceFilter(reader, namespace);
        return new SAXSource(xmlFilter, new InputSource(is));
    }

    static {
        _mutex = new Object();
    }

    private class XMLNamespaceFilter
    extends XMLFilterImpl {
        private String _namespace;

        public XMLNamespaceFilter(XMLReader parent, String namespace) {
            super(parent);
            this._namespace = namespace;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            super.startElement(this._namespace, localName, qName, attributes);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            super.endElement(this._namespace, localName, qName);
        }
    }
}

