/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.generation;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.external.builder.BuilderException;
import com.oracle.cie.gdr.generation.GenerationProperty;
import com.oracle.cie.gdr.generation.GenerationType;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public abstract class GenerationConfig {
    private Map<String, String> _configGenerationProperties = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    protected File _sourceDirectory;

    protected abstract GenerationType getGenerationType();

    protected abstract String validateGenerationProperty(String var1, String var2) throws BuilderException;

    public GenerationConfig(String defaultName, Map<String, String> props) throws BuilderException {
        this(defaultName, props, null);
    }

    public GenerationConfig(String defaultName, Map<String, String> props, File sorceDirectory) throws BuilderException {
        this._sourceDirectory = sorceDirectory;
        this.initGenerationProperties();
        this.overrideGenerationProperties(defaultName, props);
    }

    private void overrideGenerationProperties(String defaultName, Map<String, String> props) throws BuilderException {
        for (Map.Entry<String, String> prop : props.entrySet()) {
            String propValue = prop.getValue();
            if (StringUtil.isNullOrEmpty((String)propValue)) {
                throw new BuilderException("Failure in while creating \"" + (Object)((Object)this.getGenerationType()) + "\" generation configuration. Property \"" + prop.getKey() + "\" value cannot empty");
            }
            propValue = propValue.replaceAll("@defaultName@", defaultName);
            this.overrideGenerationPropery(prop.getKey(), propValue);
        }
    }

    private void initGenerationProperties() {
        this.setGenerationProperty(GenerationProperty.GENERIC_NAME, null);
        this.setGenerationProperty(GenerationProperty.GENERIC_VERSION, null);
        for (GenerationProperty property : GenerationProperty.values(this.getGenerationType())) {
            this.setGenerationProperty(property, null);
        }
    }

    public void overrideGenerationPropery(String key, String value) throws BuilderException {
        if (!this._configGenerationProperties.containsKey(key)) {
            throw new BuilderException("Failure while trying to create a " + (Object)((Object)this.getGenerationType()) + " generation configuration due to property\"" + key + "\" is not recognized");
        }
        this.setGenerationProperty(key, this.validateGenerationProperty(key, value.trim()));
    }

    public final String getVersion() {
        return this.getGenerationProperty(GenerationProperty.GENERIC_VERSION);
    }

    public final String getName() {
        return this.getGenerationProperty(GenerationProperty.GENERIC_NAME);
    }

    protected String getGenerationProperty(GenerationProperty property) {
        return this._configGenerationProperties.get(property.getName());
    }

    private void setGenerationProperty(GenerationProperty property, String value) {
        this.setGenerationProperty(property.getName(), value);
    }

    private void setGenerationProperty(String property, String value) {
        this._configGenerationProperties.put(property, value);
    }

    protected Map<String, String> createMapFromString(String mapString, String entryDelimiter, String keValueDelimiter) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (mapString != null && mapString.trim().length() > 0) {
            String[] keyValueStrings;
            for (String keyValueString : keyValueStrings = mapString.split(entryDelimiter)) {
                String[] keyValue = keyValueString.split(keValueDelimiter);
                if (keyValue.length != 2) continue;
                map.put(keyValue[0], keyValue[1]);
            }
        }
        return map;
    }

    protected Set<String> createSetFromString(String setString, String delimiter) {
        HashSet<String> set = new HashSet<String>();
        if (setString != null && setString.trim().length() > 0) {
            set = new HashSet<String>(Arrays.asList(setString.split(delimiter)));
        }
        return set;
    }

    protected List<String> createListFromString(String listString, String delimiter) {
        ArrayList<String> list = new ArrayList<String>();
        if (listString != null && listString.trim().length() > 0) {
            list = new ArrayList<String>(Arrays.asList(listString.split(delimiter)));
        }
        return list;
    }

    protected Map<String, Object> parsePropertiesToMap(String input) throws BuilderException {
        HashMap<String, Object> propMap = new HashMap<String, Object>();
        input = input.replaceAll("\\s?:\\s?", ":").replaceAll("\\s?,\\s?", ",").replaceAll("\\s?\\[\\s?", "[").replaceAll("\\s?\\]\\s?", "]").replace("\\s?\\{\\s?", "{").replace("\\s?\\}\\s?", "}");
        this.splitCharProperties(input.toCharArray(), 0, propMap, false);
        return propMap;
    }

    private int splitCharProperties(char[] properties, int startIndex, Map<String, Object> propMap, boolean waitForClossing) throws BuilderException {
        StringBuilder propertyName = new StringBuilder();
        boolean waitForComma = false;
        while (startIndex < properties.length) {
            char key = properties[startIndex];
            switch (key) {
                case ':': {
                    if (startIndex + 1 < properties.length && (properties[startIndex + 1] == '[' || properties[startIndex + 1] == '{')) {
                        if (propertyName.length() == 0) {
                            throw new BuilderException("Invalid Character, empty string cannot before key delimiter:  " + new String(properties).substring(0, startIndex + 2));
                        }
                        HashMap<String, Object> propMapSect = new HashMap<String, Object>();
                        switch (properties[startIndex + 1]) {
                            case '[': {
                                startIndex = this.splitCharProperties(properties, startIndex + 2, propMapSect, true);
                                break;
                            }
                            case '{': {
                                startIndex = this.splitBracedSubsets(properties, startIndex + 2, propMapSect);
                            }
                        }
                        propMap.put(propertyName.toString(), propMapSect);
                        propertyName.setLength(0);
                        waitForComma = true;
                        break;
                    }
                }
                default: {
                    if (waitForComma) {
                        throw new BuilderException("Invalid Format. comma ',' was expected :  " + new String(properties).substring(0, startIndex + 1));
                    }
                    propertyName.append(key);
                    break;
                }
                case '[': {
                    throw new BuilderException("Invalid Character, opening array bracket \"[\" ony can be used as key in format \":[\":  " + new String(properties).substring(0, startIndex + 1));
                }
                case ',': {
                    if (waitForComma) {
                        waitForComma = false;
                        break;
                    }
                    if (propertyName.length() > 0) {
                        propMap.put(propertyName.toString(), null);
                        propertyName.setLength(0);
                        break;
                    }
                    throw new BuilderException("Invalid Format, comma ',' is NOT expected: " + new String(properties).substring(0, startIndex + 1));
                }
                case ']': {
                    if (waitForClossing) {
                        if (propertyName.length() > 0) {
                            propMap.put(propertyName.toString(), null);
                        }
                        propertyName.setLength(0);
                        return startIndex;
                    }
                    throw new BuilderException("Invalid Format. opening array bracket \"]\"  is NOT expected:  " + new String(properties).substring(0, startIndex + 1));
                }
            }
            ++startIndex;
        }
        if (waitForClossing) {
            throw new BuilderException("Invalid Format, closing array bracket  \"]\" was expected in property value: " + new String(properties));
        }
        if (propertyName.length() > 0) {
            propMap.put(propertyName.toString(), null);
        }
        return startIndex;
    }

    private int splitBracedSubsets(char[] properties, int startIndex, Map<String, Object> propMapSect) throws BuilderException {
        StringBuilder propertyName = new StringBuilder();
        boolean waitForCloosingBrace = true;
        while (startIndex < properties.length) {
            propertyName.append(properties[startIndex]);
            char key = properties[startIndex];
            switch (key) {
                case '}': {
                    if (!waitForCloosingBrace) break;
                    propMapSect.put(propertyName.deleteCharAt(propertyName.length() - 1).toString(), null);
                    waitForCloosingBrace = false;
                    propertyName.setLength(0);
                    break;
                }
                case ',': {
                    if (startIndex + 1 >= properties.length) break;
                    if (properties[startIndex + 1] == '{') {
                        if (waitForCloosingBrace) {
                            throw new BuilderException("Invalid Format. closing array brace \"}\" was expected before an opening array brace \"{\": " + new String(properties).substring(0, startIndex + 1));
                        }
                        ++startIndex;
                        waitForCloosingBrace = true;
                        propertyName.setLength(0);
                        break;
                    }
                    if (waitForCloosingBrace) break;
                    return startIndex - 1;
                }
                case ']': {
                    if (waitForCloosingBrace) {
                        throw new BuilderException("Invalid Format. closing array brace  \"}\" was expected before closing array bracket \"]\": " + new String(properties).substring(0, startIndex + 1));
                    }
                    return startIndex - 1;
                }
            }
            ++startIndex;
        }
        if (waitForCloosingBrace) {
            throw new BuilderException("Invalid Format, closing array brace  \"}\" was expected in property value: " + new String(properties).substring(0, startIndex + 1));
        }
        return startIndex;
    }
}

