/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.external.impl;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.DistributionTarget;
import com.oracle.cie.gdr.Home;
import com.oracle.cie.gdr.LegacyHome;
import com.oracle.cie.gdr.MetaDataHome;
import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.dao.ftr.ComponentReference;
import com.oracle.cie.gdr.external.Component;
import com.oracle.cie.gdr.external.Distribution;
import com.oracle.cie.gdr.external.FeatureSet;
import com.oracle.cie.gdr.external.FederatedRelationship;
import com.oracle.cie.gdr.external.FederatedSorting;
import com.oracle.cie.gdr.external.InventoryException;
import com.oracle.cie.gdr.external.OracleHomeInventory;
import com.oracle.cie.gdr.external.Patch;
import com.oracle.cie.gdr.external.impl.BaseInventoryImpl;
import com.oracle.cie.gdr.external.impl.DistributionImpl;
import com.oracle.cie.gdr.external.impl.FeatureSetImpl;
import com.oracle.cie.gdr.external.impl.InventoryCache;
import com.oracle.cie.gdr.external.impl.OracleHomeInventoryFactory;
import com.oracle.cie.gdr.external.impl.PatchImpl;
import com.oracle.cie.gdr.helpers.HomeHelper;
import com.oracle.cie.gdr.nio.NioHelper;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OracleHomeInventoryImpl
extends BaseInventoryImpl
implements OracleHomeInventory {
    protected Path _homeDir;
    private static final Logger _log = Logger.getLogger(OracleHomeInventoryImpl.class.getName());

    protected OracleHomeInventoryImpl() {
    }

    OracleHomeInventoryImpl(File homeDir) throws InventoryException {
        this(NioHelper.getInstance().getPath(homeDir));
    }

    OracleHomeInventoryImpl(Path homePath) throws InventoryException {
        Home home;
        this._homeDir = homePath;
        try {
            if (!Home.isValidHome(this._homeDir)) {
                throw new InventoryException("The home location was not a valid oracle home: " + this._homeDir);
            }
            home = Home.getHome(this._homeDir);
            this._metaDataHome = home.getMetaDataHome();
        }
        catch (Exception anyException) {
            throw new InventoryException(anyException);
        }
        if (null == InventoryCache.getInstance().getHome(this._metaDataHome)) {
            InventoryCache.getInstance().putHome(this._metaDataHome, home);
        }
    }

    OracleHomeInventoryImpl(Home home) throws InventoryException {
        this._homeDir = home.getHomePath();
        try {
            this._metaDataHome = home.getMetaDataHome();
        }
        catch (Exception anyException) {
            throw new InventoryException(anyException);
        }
        if (null == InventoryCache.getInstance().getHome(this._metaDataHome)) {
            InventoryCache.getInstance().putHome(this._metaDataHome, home);
        }
    }

    @Override
    protected MetaDataHome loadMetaDataHome(File metaDataHome) throws InventoryException {
        return this._metaDataHome;
    }

    @Override
    protected MetaDataHome loadMetaDataHome(Path metaDataHome) throws InventoryException {
        return this._metaDataHome;
    }

    @Override
    public File getHomeDir() {
        return this._homeDir.toFile();
    }

    @Override
    public Path getHomeDirPath() {
        return this._homeDir;
    }

    @Override
    public void enableInventoryCache() {
        InventoryCache.enableCache();
    }

    @Override
    public void disableInventoryCache() {
        InventoryCache.disableCache();
    }

    @Override
    public void cleanInventoryCache() {
        InventoryCache.getInstance().clearCache();
    }

    @Override
    public Collection<FeatureSet> getInstalledFeatureSets() throws InventoryException {
        try {
            return this.getFeatureSets(Home.getHome(this._homeDir).getInstalledFeatures());
        }
        catch (Exception exception) {
            throw new InventoryException(exception);
        }
    }

    @Override
    public Collection<Component> getInstalledComponents() throws InventoryException {
        try {
            return this.getComponents(Home.getHome(this._homeDir).getInstalledComponents());
        }
        catch (Exception exception) {
            throw new InventoryException(exception);
        }
    }

    @Override
    public Collection<Distribution> getInstalledDistributions() throws InventoryException {
        try {
            return this.getDistributionsFromDistributionsTargets(Home.getHome(this._homeDir).getInstalledDistributions());
        }
        catch (Exception exception) {
            throw new InventoryException(exception);
        }
    }

    @Override
    public FeatureSet getInstalledFeatureSet(String name, String version) throws InventoryException {
        if (null == name || null == version) {
            throw new InventoryException("The name and version are required to retrieve the installed feature set.");
        }
        for (FeatureSet featureSet : this.getInstalledFeatureSets()) {
            if (!name.equals(featureSet.getName()) || !version.equals(featureSet.getVersion())) continue;
            return featureSet;
        }
        return null;
    }

    @Override
    public Component getInstalledComponent(String name, String version) throws InventoryException {
        if (null == name || null == version) {
            throw new InventoryException("The name and version are required for retrieving an installed component.");
        }
        for (Component component : this.getInstalledComponents()) {
            if (!name.equals(component.getName()) || !version.equals(component.getVersion())) continue;
            return component;
        }
        return null;
    }

    @Override
    public Distribution getInstalledDistribution(String name, String version) throws InventoryException {
        if (null == name || null == version) {
            throw new InventoryException("The name and version are required for retrieving an installed distribution.");
        }
        for (Distribution distribution : this.getInstalledDistributions()) {
            if (!name.equals(distribution.getName()) || !version.equals(distribution.getVersion())) continue;
            return distribution;
        }
        return null;
    }

    @Override
    public boolean isFeatureSetinstalled(String name, String version) throws InventoryException {
        if (null == name || null == version) {
            throw new InventoryException("The name and version are required for verifying if the feature set is installed.");
        }
        for (FeatureSet featureSet : this.getInstalledFeatureSets()) {
            if (!name.equals(featureSet.getName()) || !version.equals(featureSet.getVersion())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isComponentInstalled(String name, String version) throws InventoryException {
        if (null == name || null == version) {
            throw new InventoryException("The name and version are required for verifying if the component is installed.");
        }
        for (Component component : this.getInstalledComponents()) {
            if (!name.equals(component.getName()) || !version.equals(component.getVersion())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDistributionInstalled(String name, String version) throws InventoryException {
        if (null == name || null == version) {
            throw new InventoryException("The name and version are required for verifying if the distribution is installed.");
        }
        for (Distribution distribution : this.getInstalledDistributions()) {
            if (!name.equals(distribution.getName()) || !version.equals(distribution.getVersion())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<Distribution> getInstalledDistributions(Component component) throws InventoryException {
        if (null == component) {
            throw new InventoryException("The component is required for retrieving the installed distributions.");
        }
        try {
            Home home = Home.getHome(this._homeDir);
            return this.getDistributionsFromDistributionsTargets(home.getInstalledDistributions(new ComponentReference(component.getName(), component.getVersion(), home.getClassLoader())));
        }
        catch (Exception anyException) {
            _log.log(Level.SEVERE, "A problem occurred when retrieving the installed distributions.", anyException);
            throw new InventoryException(anyException);
        }
    }

    @Override
    public Collection<Distribution> getInstalledDistributions(FeatureSet featureSet) throws InventoryException {
        if (null == featureSet) {
            throw new InventoryException("The feature set is required for retrieving the installed distributions.");
        }
        try {
            Home home = Home.getHome(this._homeDir);
            return this.getDistributionsFromDistributionsTargets(home.getInstalledDistributions(new com.oracle.cie.gdr.dao.ftr.FeatureSet(featureSet.getName(), featureSet.getVersion(), home.getClassLoader())));
        }
        catch (Exception anyException) {
            _log.log(Level.SEVERE, "A problem occurred when retrieving the installed distributions.", anyException);
            throw new InventoryException(anyException);
        }
    }

    @Override
    public Collection<FeatureSet> getInstalledFeatureSets(Component component) throws InventoryException {
        if (null == component) {
            throw new InventoryException("The component is required for retrieving the installed feature sets.");
        }
        try {
            Home home = Home.getHome(this._homeDir);
            return this.getFeatureSets(home.getInstalledFeatureSets(new ComponentReference(component.getName(), component.getVersion(), home.getClassLoader())));
        }
        catch (Exception anyException) {
            _log.log(Level.SEVERE, "A problem occurred when retrieving the installed feature sets.", anyException);
            throw new InventoryException(anyException);
        }
    }

    Collection<Distribution> getDistributionsFromDistributionsTargets(Collection<DistributionTarget> distributionsTargets) throws InventoryException {
        LinkedHashSet<Distribution> distributions = new LinkedHashSet<Distribution>();
        for (DistributionTarget distributionTarget : distributionsTargets) {
            Distribution cachedDistribution = InventoryCache.getInstance().getDistribution(this._metaDataHome, distributionTarget.getDistributionName(), distributionTarget.getDistributionVersion());
            if (null == cachedDistribution) {
                cachedDistribution = new DistributionImpl(distributionTarget, this._metaDataHome);
                InventoryCache.getInstance().putDistribution(this._metaDataHome, cachedDistribution);
            }
            distributions.add(cachedDistribution);
        }
        return distributions;
    }

    @Override
    Collection<FeatureSet> getFeatureSets(Collection<com.oracle.cie.gdr.dao.ftr.FeatureSet> featureSets) throws InventoryException {
        LinkedHashSet<FeatureSet> featureSetsWrappers = new LinkedHashSet<FeatureSet>();
        FeatureSet cachedFeatureSet = null;
        for (com.oracle.cie.gdr.dao.ftr.FeatureSet featureSet : featureSets) {
            cachedFeatureSet = InventoryCache.getInstance().getFeatureSet(this._metaDataHome, featureSet.getName(), featureSet.getVersion());
            if (null == cachedFeatureSet) {
                cachedFeatureSet = new FeatureSetImpl(featureSet, this._metaDataHome, Mode.DEINSTALL);
                InventoryCache.getInstance().putFeatureSet(this._metaDataHome, cachedFeatureSet);
            }
            featureSetsWrappers.add(cachedFeatureSet);
        }
        return featureSetsWrappers;
    }

    Patch getPatch(com.oracle.cie.gdr.dao.pch.Patch patch) {
        if (patch != null) {
            return new PatchImpl(patch, this._metaDataHome, Mode.DEINSTALL);
        }
        return null;
    }

    Collection<Patch> getPatches(Collection<com.oracle.cie.gdr.dao.pch.Patch> patches) throws InventoryException {
        ArrayList<Patch> patchesWrappers = new ArrayList<Patch>();
        Patch cachedPatch = null;
        for (com.oracle.cie.gdr.dao.pch.Patch patch : patches) {
            cachedPatch = InventoryCache.getInstance().getPatch(this._metaDataHome, patch.getPatchId());
            if (null == cachedPatch) {
                cachedPatch = new PatchImpl(patch, this._metaDataHome, Mode.DEINSTALL);
                InventoryCache.getInstance().putPatch(this._metaDataHome, cachedPatch);
            }
            patchesWrappers.add(cachedPatch);
        }
        return patchesWrappers;
    }

    @Override
    public Patch getInstalledPatch(String patchId) throws InventoryException {
        if (StringUtil.isNullOrEmpty((String)patchId)) {
            throw new InventoryException("The name and version parameters are required.");
        }
        try {
            return this.getPatch(Home.getHome(this._homeDir).getInstalledPatch(patchId));
        }
        catch (Exception anyException) {
            _log.log(Level.SEVERE, "A problem occurred when loading installed patch.", anyException);
            throw new InventoryException(anyException);
        }
    }

    @Override
    public Collection<Patch> getInstalledPatches() throws InventoryException {
        try {
            return this.getPatches(Home.getHome(this._homeDir).getInstalledPatches());
        }
        catch (Exception anyException) {
            _log.log(Level.SEVERE, "A problem occurred when loading installed patches.", anyException);
            throw new InventoryException(anyException);
        }
    }

    @Override
    public Collection<Patch> getInstalledPatches(Component component) throws InventoryException {
        if (null == component) {
            throw new InventoryException("The component parameter is required.");
        }
        try {
            Home home = Home.getHome(this._homeDir);
            return this.getPatches(home.getInstalledPatches(new com.oracle.cie.gdr.dao.cpd.Component(component.getName(), component.getVersion(), home.getClassLoader())));
        }
        catch (Exception anyException) {
            _log.log(Level.SEVERE, "A problem occurred when loading installed patches.", anyException);
            throw new InventoryException(anyException);
        }
    }

    @Override
    public Collection<Patch> getInstalledPatches(FeatureSet featureSet) throws InventoryException {
        if (null == featureSet) {
            throw new InventoryException("The feature set parameter is required.");
        }
        com.oracle.cie.gdr.dao.ftr.FeatureSet matchingFeature = null;
        try {
            for (com.oracle.cie.gdr.dao.ftr.FeatureSet feature : Home.getHome(this._homeDir).getInstalledFeatures()) {
                if (!featureSet.getName().equals(feature.getName()) || !featureSet.getVersion().equals(feature.getVersion())) continue;
                matchingFeature = feature;
                break;
            }
            return this.getPatches(Home.getHome(this._homeDir).getInstalledPatches(matchingFeature));
        }
        catch (Exception anyException) {
            _log.log(Level.SEVERE, "A problem occurred when loading installed patches.", anyException);
            throw new InventoryException(anyException);
        }
    }

    @Override
    public Collection<Patch> getInstalledPatches(Distribution distribution) throws InventoryException {
        if (null == distribution) {
            throw new InventoryException("The distribution parameter is required.");
        }
        com.oracle.cie.gdr.dao.dbd.Distribution matchingDistribution = null;
        try {
            for (DistributionTarget distributionTarget : Home.getHome(this._homeDir).getInstalledDistributions()) {
                if (!distribution.getName().equals(distributionTarget.getDistributionName()) || !distribution.getVersion().equals(distributionTarget.getDistributionVersion())) continue;
                matchingDistribution = distributionTarget.getDistribution();
                break;
            }
            return this.getPatches(Home.getHome(this._homeDir).getInstalledPatches(matchingDistribution));
        }
        catch (Exception anyException) {
            _log.log(Level.SEVERE, "A problem occurred when loading installed patches.", anyException);
            throw new InventoryException(anyException);
        }
    }

    @Override
    public boolean isPatchInstalled(String patchId) throws InventoryException {
        try {
            return Home.getHome(this._homeDir).isPatchInstalled(patchId);
        }
        catch (Exception anyException) {
            _log.log(Level.SEVERE, "A problem occurred when verifying if patch " + patchId + " is installed.", anyException);
            throw new InventoryException(anyException);
        }
    }

    @Override
    public void refresh() throws InventoryException {
        try {
            Home.getHome(this._homeDir).refresh();
        }
        catch (Exception e) {
            throw new InventoryException(e);
        }
    }

    @Override
    public Collection<FeatureSet> getInstalledFeatureSets(String type, String subtype) throws InventoryException {
        ArrayList<FeatureSet> filteredInstalledFeatures = new ArrayList<FeatureSet>();
        for (FeatureSet feature : this.getInstalledFeatureSets()) {
            if (feature == null || StringUtil.isNullOrEmpty((String)feature.getType()) || !feature.getType().equals(type) || StringUtil.isNullOrEmpty((String)feature.getSubType()) || !feature.getSubType().equals(subtype)) continue;
            filteredInstalledFeatures.add(feature);
        }
        return filteredInstalledFeatures;
    }

    @Override
    public Collection<FeatureSet> getInstalledFeatureSets(String type) throws InventoryException {
        ArrayList<FeatureSet> filteredInstalledFeatures = new ArrayList<FeatureSet>();
        for (FeatureSet feature : this.getInstalledFeatureSets()) {
            if (feature == null || StringUtil.isNullOrEmpty((String)feature.getType()) || !feature.getType().equals(type)) continue;
            filteredInstalledFeatures.add(feature);
        }
        return filteredInstalledFeatures;
    }

    @Override
    public String getGlobalUniqueID() throws InventoryException {
        try {
            return Home.getHome(this._homeDir, true).getRegistry().getGuid();
        }
        catch (Exception anyException) {
            throw new InventoryException(anyException);
        }
    }

    @Override
    public boolean isFederatedHome() throws InventoryException {
        try {
            Home home = Home.getHome(this._homeDir, true);
            return home.isFederatedHome();
        }
        catch (Exception e) {
            throw new InventoryException(e);
        }
    }

    @Override
    public Collection<OracleHomeInventory> getFederatedOracleHomeInventories(FederatedRelationship relationship, boolean includeSelf) throws InventoryException {
        return this.getFederatedOracleHomeInventories(relationship, FederatedSorting.DIRECT_FIRST, includeSelf);
    }

    @Override
    public Collection<OracleHomeInventory> getFederatedOracleHomeInventories(FederatedRelationship relationship, FederatedSorting sorting, boolean includeSelf) throws InventoryException {
        ArrayList<OracleHomeInventory> inventories = new ArrayList<OracleHomeInventory>();
        Home home = null;
        try {
            if (Home.isValidHome(this._homeDir)) {
                home = Home.getHome(this._homeDir);
            } else if (HomeHelper.isLegacyHome(this._homeDir)) {
                home = LegacyHome.getHome(this._homeDir);
            }
        }
        catch (Exception e) {
            throw new InventoryException(e);
        }
        Set<Home> federatedHomes = home.getFederatedHomes(relationship, sorting, includeSelf);
        OracleHomeInventoryFactory factory = new OracleHomeInventoryFactory();
        for (Home federatedHome : federatedHomes) {
            if (home.equals(federatedHome)) {
                inventories.add(this);
                continue;
            }
            inventories.add(factory.createInventory(federatedHome));
        }
        return inventories;
    }
}

