/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.external.impl;

import com.oracle.cie.gdr.Home;
import com.oracle.cie.gdr.external.BaseInventory;
import com.oracle.cie.gdr.external.BaseInventoryFactory;
import com.oracle.cie.gdr.external.InventoryException;
import com.oracle.cie.gdr.external.OracleHomeInventory;
import com.oracle.cie.gdr.external.impl.DummyOracleHomeInventoryImpl;
import com.oracle.cie.gdr.external.impl.LegacyOracleHomeInventoryImpl;
import com.oracle.cie.gdr.external.impl.OracleHomeInventoryImpl;
import com.oracle.cie.gdr.helpers.HomeHelper;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.nextgen.common.inputs.enums.OperationModeType;
import com.oracle.cie.nextgen.common.inputs.helpers.InputHandler;
import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;

public class OracleHomeInventoryFactory
implements BaseInventoryFactory {
    private static Map<Path, OracleHomeInventory> _cache = new HashMap<Path, OracleHomeInventory>();

    @Override
    public OracleHomeInventory createInventory(File homeDir) throws InventoryException {
        if (homeDir == null) {
            throw new InventoryException("The home directory provided was null.");
        }
        return this.createInventory(NioHelper.getInstance().getPath(homeDir));
    }

    @Override
    public OracleHomeInventory createInventory(Path homePath) throws InventoryException {
        if (homePath == null) {
            throw new InventoryException("The home directory provided was null.");
        }
        BaseInventory oracleHomeInventory = _cache.get(homePath);
        if (null == oracleHomeInventory) {
            OperationModeType mode = InputHandler.getInputs().getOperationModeType();
            oracleHomeInventory = HomeHelper.isLegacyHome(homePath) ? new LegacyOracleHomeInventoryImpl(homePath) : (mode != null && mode.isInstallerUpdate() ? new DummyOracleHomeInventoryImpl(homePath) : new OracleHomeInventoryImpl(homePath));
            _cache.put(homePath, (OracleHomeInventory)oracleHomeInventory);
        }
        return oracleHomeInventory;
    }

    OracleHomeInventory createInventory(Home home) throws InventoryException {
        if (home == null) {
            throw new InventoryException("The home provided was null.");
        }
        OracleHomeInventory oracleHomeInventory = _cache.get(home.getHome());
        if (null == oracleHomeInventory) {
            OperationModeType mode = InputHandler.getInputs().getOperationModeType();
            oracleHomeInventory = mode != null && mode.isInstallerUpdate() ? new DummyOracleHomeInventoryImpl(home.getHome()) : (!HomeHelper.isLegacyHome(home.getHomePath()) ? new OracleHomeInventoryImpl(home) : new LegacyOracleHomeInventoryImpl(home.getHomePath()));
            _cache.put(home.getHomePath(), oracleHomeInventory);
        }
        return oracleHomeInventory;
    }

    public static void clearCache() {
        _cache.clear();
    }
}

