/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.external.impl;

import com.oracle.cie.gdr.MetaDataHome;
import com.oracle.cie.gdr.external.InventoryException;
import com.oracle.cie.gdr.external.Mapping;
import com.oracle.cie.gdr.external.RootMapping;
import com.oracle.cie.gdr.external.impl.InventoryCache;
import com.oracle.cie.gdr.external.impl.RootMappingImpl;
import java.io.File;

public class MappingImpl
implements Mapping {
    private com.oracle.cie.gdr.dao.dbd.Mapping _mapping;
    private com.oracle.cie.gdr.dao.dbd.RootMapping _rootMapping;
    private MetaDataHome _metaDataHome;

    MappingImpl(com.oracle.cie.gdr.dao.dbd.Mapping mapping, MetaDataHome metaDataHome) {
        this._mapping = mapping;
        this._metaDataHome = metaDataHome;
    }

    MappingImpl(com.oracle.cie.gdr.dao.dbd.RootMapping rootMapping, MetaDataHome metaDataHome) {
        this._rootMapping = rootMapping;
        this._metaDataHome = metaDataHome;
    }

    @Override
    public String getDirectory() {
        if (null != this._mapping) {
            return this._mapping.getDirectory();
        }
        if (null != this._rootMapping) {
            return "";
        }
        return null;
    }

    @Override
    public String[] getSymbols() {
        if (null != this._mapping) {
            return this._mapping.getSymbols();
        }
        if (null != this._rootMapping) {
            return this._rootMapping.getSymbols();
        }
        return null;
    }

    @Override
    public File getDirectoryLocation() throws InventoryException {
        if (this.isGdrInventory()) {
            throw new InventoryException("The directory location is not available for a gdr inventory.");
        }
        if (null != this._mapping) {
            return new File(this._metaDataHome.getSrchome().getAbsolutePath() + File.separator + this._mapping.getDirectory());
        }
        if (this.isRoot()) {
            return this._metaDataHome.getSrchome();
        }
        return null;
    }

    private boolean isGdrInventory() throws InventoryException {
        return null == InventoryCache.getInstance().getHome(this._metaDataHome);
    }

    @Override
    public boolean isRoot() {
        return null != this._rootMapping;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Mapping that = (Mapping)o;
        String thisDirectory = this.getDirectory();
        String thatDirectory = that.getDirectory();
        return !(thisDirectory == null ? thatDirectory != null : !thisDirectory.equals(thatDirectory));
    }

    public int hashCode() {
        String thisDirectory = this.getDirectory();
        int result = thisDirectory != null ? thisDirectory.hashCode() : 0;
        result = 31 * result;
        return result;
    }

    public String toString() {
        return this.getDirectory();
    }

    @Override
    public RootMapping getRootMapping() {
        return new RootMappingImpl(this._rootMapping);
    }
}

