/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.external.impl;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.DistributionLoader;
import com.oracle.cie.gdr.DistributionLoaderFactory;
import com.oracle.cie.gdr.DistributionTarget;
import com.oracle.cie.gdr.Home;
import com.oracle.cie.gdr.MetaDataHome;
import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.dao.cmn.Reference;
import com.oracle.cie.gdr.dao.dbd.FeatureSetReference;
import com.oracle.cie.gdr.dao.rgy.DistributionInfo;
import com.oracle.cie.gdr.external.Component;
import com.oracle.cie.gdr.external.DirectoryMap;
import com.oracle.cie.gdr.external.Distribution;
import com.oracle.cie.gdr.external.FeatureSet;
import com.oracle.cie.gdr.external.InstallType;
import com.oracle.cie.gdr.external.InventoryException;
import com.oracle.cie.gdr.external.impl.DirectoryMapImpl;
import com.oracle.cie.gdr.external.impl.FeatureSetImpl;
import com.oracle.cie.gdr.external.impl.InstallTypeImpl;
import com.oracle.cie.gdr.external.impl.InventoryCache;
import com.oracle.cie.gdr.tools.FeatureSetDependencyAnalyzer;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DistributionImpl
implements Distribution {
    protected com.oracle.cie.gdr.dao.dbd.Distribution _distribution;
    private MetaDataHome _metaDataHome;
    private DistributionInfo _distInfo;
    protected DistributionTarget _distributionTarget;
    private static final Logger _log = Logger.getLogger(DistributionImpl.class.getName());

    DistributionImpl() {
    }

    DistributionImpl(DistributionTarget distributionTarget, MetaDataHome metaDataHome) {
        this(distributionTarget.getDistribution(), metaDataHome);
        this._distributionTarget = distributionTarget;
    }

    DistributionImpl(com.oracle.cie.gdr.dao.dbd.Distribution distribution, MetaDataHome metaDataHome) {
        this._distribution = distribution;
        this._metaDataHome = metaDataHome;
    }

    @Override
    public List<InstallType> getInstallType() {
        ArrayList<InstallType> installTypes = new ArrayList<InstallType>();
        for (com.oracle.cie.gdr.dao.dbd.InstallType installType : this._distribution.getInstallType()) {
            installTypes.add(new InstallTypeImpl(installType));
        }
        return installTypes;
    }

    @Override
    public DirectoryMap getDirectoryMap() {
        com.oracle.cie.gdr.dao.dbd.DirectoryMap directoryMap = this._distributionTarget != null ? this._distributionTarget.getDirectoryMap() : this._distribution.getDirectoryMap();
        return new DirectoryMapImpl(directoryMap, this, this._metaDataHome);
    }

    @Override
    public String getName() {
        return this._distribution.getName();
    }

    @Override
    public String getVersion() {
        return this._distribution.getVersion();
    }

    @Override
    public String getExternalName() {
        return this._distribution.getExternalName();
    }

    @Override
    public String getDescription() {
        return this._distribution.getLocalizedDescription();
    }

    @Override
    public String getExternalVersion() {
        return this._distribution.getExternalVersion();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Distribution that = (Distribution)o;
        String thisName = this.getName();
        String thisVersion = this.getVersion();
        String thatName = that.getName();
        String thatVersion = that.getVersion();
        return !(thisName == null ? thatName != null : !thisName.equals(thatName)) && !(thisVersion == null ? thatVersion != null : !thisVersion.equals(thatVersion));
    }

    public int hashCode() {
        String thisName = this.getName();
        String thisVersion = this.getVersion();
        int result = thisName != null ? thisName.hashCode() : 0;
        result = 31 * result + (thisVersion != null ? thisVersion.hashCode() : 0);
        return result;
    }

    public String toString() {
        String version;
        String name = this.getExternalName();
        if (StringUtil.isNullOrEmpty((String)name, (boolean)true)) {
            name = this.getName();
        }
        if (StringUtil.isNullOrEmpty((String)(version = this.getExternalVersion()), (boolean)true)) {
            version = this.getVersion();
        }
        return name + " " + version;
    }

    @Override
    public Collection<Component> getComponents() throws InventoryException {
        HashSet<Component> components = new HashSet<Component>();
        Collection<FeatureSet> featureSets = this.getFeatureSets();
        for (FeatureSet featureSet : featureSets) {
            components.addAll(featureSet.getComponents());
        }
        return components;
    }

    @Override
    public Collection<FeatureSet> getFeatureSets() throws InventoryException {
        DistributionLoader distributionLoader;
        try {
            MetaDataHome metaDataHome = new MetaDataHome(this._metaDataHome.getGdrMetaDataHomePath());
            metaDataHome.setClassLoader(this._metaDataHome.getClassLoader());
            distributionLoader = DistributionLoaderFactory.getDistributionLoader(metaDataHome, this.getName(), this.getVersion());
        }
        catch (Exception exception) {
            _log.log(Level.SEVERE, "A problem occurred when loading the feature sets for the distribution.", exception);
            throw new InventoryException(exception);
        }
        return this.getFeatureSets(distributionLoader.getFeatureSets());
    }

    Collection<FeatureSet> getFeatureSets(Collection<com.oracle.cie.gdr.dao.ftr.FeatureSet> featureSets) throws InventoryException {
        ArrayList<FeatureSet> featureSetsWrappers = new ArrayList<FeatureSet>();
        FeatureSet cachedFeatureSet = null;
        for (com.oracle.cie.gdr.dao.ftr.FeatureSet featureSet : featureSets) {
            cachedFeatureSet = InventoryCache.getInstance().getFeatureSet(this._metaDataHome, featureSet.getName(), featureSet.getVersion());
            if (null == cachedFeatureSet) {
                cachedFeatureSet = new FeatureSetImpl(featureSet, this._metaDataHome, Mode.DEINSTALL);
                InventoryCache.getInstance().putFeatureSet(this._metaDataHome, cachedFeatureSet);
            }
            featureSetsWrappers.add(cachedFeatureSet);
        }
        return featureSetsWrappers;
    }

    @Override
    public Collection<FeatureSet> getFeatureDependencies(FeatureSet feature) throws InventoryException {
        return this.getFeatureDependencies(new Reference(feature.getName(), feature.getVersion(), this._metaDataHome != null ? this._metaDataHome.getClassLoader() : null));
    }

    @Override
    public Collection<FeatureSet> getFeatureDependencies(Reference feature) throws InventoryException {
        Collection<FeatureSet> features;
        try {
            FeatureSetDependencyAnalyzer featureDepAnalyzer = new FeatureSetDependencyAnalyzer(this._metaDataHome, this.getName(), this.getVersion());
            features = this.getFeatureSets(featureDepAnalyzer.getFeatureSetDependencies(Home.getHome(this._metaDataHome.getSrchome()).getInstalledFeature(new Reference(feature.getName(), feature.getVersion(), this._metaDataHome != null ? this._metaDataHome.getClassLoader() : null))));
        }
        catch (Exception exception) {
            throw new InventoryException(exception);
        }
        return features;
    }

    @Override
    public Collection<FeatureSet> getExternalFeatureSets() throws InventoryException {
        try {
            DistributionLoader distLoader = DistributionLoaderFactory.getDistributionLoader(this._metaDataHome, this.getName(), this.getVersion());
            Set<FeatureSetReference> externalRefs = distLoader.getFeatureLoader().getExternalFeatures();
            HashSet<FeatureSet> externals = new HashSet<FeatureSet>();
            for (FeatureSetReference ref : externalRefs) {
                com.oracle.cie.gdr.dao.ftr.FeatureSet ext = new com.oracle.cie.gdr.dao.ftr.FeatureSet(ref.getName(), ref.getVersion(), this._metaDataHome != null ? this._metaDataHome.getClassLoader() : null);
                FeatureSetImpl extImpl = new FeatureSetImpl(ext, this._metaDataHome, Mode.INSTALL);
                externals.add(extImpl);
            }
            return externals;
        }
        catch (GdrException exception) {
            throw new InventoryException();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (DataHandlerException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public Collection<String> getProductFamilies() throws InventoryException {
        return this._distribution.getProductFamilies();
    }
}

