/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.external.impl;

import com.oracle.cie.gdr.MetaDataHome;
import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.dao.ftr.ComponentReference;
import com.oracle.cie.gdr.external.BaseInventory;
import com.oracle.cie.gdr.external.Component;
import com.oracle.cie.gdr.external.Distribution;
import com.oracle.cie.gdr.external.FeatureSet;
import com.oracle.cie.gdr.external.InventoryException;
import com.oracle.cie.gdr.external.impl.ComponentImpl;
import com.oracle.cie.gdr.external.impl.DistributionImpl;
import com.oracle.cie.gdr.external.impl.FeatureSetImpl;
import com.oracle.cie.gdr.external.impl.InventoryCache;
import com.oracle.cie.gdr.helpers.DistributionHelper;
import com.oracle.cie.gdr.helpers.FeatureSetHelper;
import com.oracle.cie.gdr.nio.NioHelper;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class BaseInventoryImpl
implements BaseInventory {
    MetaDataHome _metaDataHome;
    Mode _mode = Mode.DEINSTALL;
    private static final Logger _log = Logger.getLogger(BaseInventoryImpl.class.getName());

    protected BaseInventoryImpl() {
    }

    BaseInventoryImpl(File metaDataHome) throws InventoryException {
        this(NioHelper.getInstance().getPath(metaDataHome));
    }

    BaseInventoryImpl(Path metaDataHome) throws InventoryException {
        this._metaDataHome = this.loadMetaDataHome(metaDataHome);
    }

    protected abstract MetaDataHome loadMetaDataHome(File var1) throws InventoryException;

    protected abstract MetaDataHome loadMetaDataHome(Path var1) throws InventoryException;

    @Override
    public Collection<Distribution> getDistributions() throws InventoryException {
        Collection<Distribution> distributions;
        try {
            distributions = this.getDistributions(DistributionHelper.getInstance().getDistributions(this._metaDataHome.getGdrMetaDataHomePath()));
        }
        catch (Exception exception) {
            _log.log(Level.SEVERE, "A problem occurred when loading the distributions.", exception);
            throw new InventoryException(exception);
        }
        return distributions;
    }

    @Override
    public Distribution getDistribution(String name, String version) throws InventoryException {
        Distribution distribution;
        if (null == name || null == version) {
            throw new InventoryException("The name and version are required to retrieve the distribution.");
        }
        try {
            distribution = InventoryCache.getInstance().getDistribution(this._metaDataHome, name, version);
            if (null == distribution) {
                distribution = new DistributionImpl(DistributionHelper.getInstance().getDistribution(this._metaDataHome.getGdrMetaDataHomePath(), name, version), this._metaDataHome);
                InventoryCache.getInstance().putDistribution(this._metaDataHome, distribution);
            }
        }
        catch (Exception exception) {
            _log.log(Level.SEVERE, "A problem occurred when loading the distribution.", exception);
            throw new InventoryException(exception);
        }
        return distribution;
    }

    @Override
    public Collection<FeatureSet> getFeatureSets() throws InventoryException {
        Collection<FeatureSet> featureSets;
        try {
            featureSets = this.getFeatureSets(FeatureSetHelper.getInstance().getFeatureSets(this._metaDataHome.getGdrMetaDataHomePath()));
        }
        catch (Exception exception) {
            _log.log(Level.SEVERE, "A problem occurred when loading the feature sets from the home.", exception);
            throw new InventoryException(exception);
        }
        return featureSets;
    }

    @Override
    public FeatureSet getFeatureSet(String name, String version) throws InventoryException {
        FeatureSet featureSet;
        if (null == name || null == version) {
            throw new InventoryException("The name and version are required to retrieve the feature set.");
        }
        try {
            featureSet = InventoryCache.getInstance().getFeatureSet(this._metaDataHome, name, version);
            if (null == featureSet) {
                featureSet = new FeatureSetImpl(FeatureSetHelper.getInstance().getFeatureSet(this._metaDataHome.getGdrMetaDataHomePath(), name, version), this._metaDataHome, this._mode);
                InventoryCache.getInstance().putFeatureSet(this._metaDataHome, featureSet);
            }
        }
        catch (Exception exception) {
            _log.log(Level.SEVERE, "A problem occurred when loading the feature set.", exception);
            throw new InventoryException(exception);
        }
        return featureSet;
    }

    @Override
    public Collection<Component> getComponents() throws InventoryException {
        HashSet<Component> components = new HashSet<Component>();
        for (FeatureSet featureSet : this.getFeatureSets()) {
            components.addAll(featureSet.getComponents());
        }
        return components;
    }

    @Override
    public Component getComponent(String name, String version) throws InventoryException {
        if (null == name || null == version) {
            throw new InventoryException("The name and version are required to retrieve the component.");
        }
        Component cachedComponent = null;
        for (FeatureSet featureSet : this.getFeatureSets()) {
            for (Component component : featureSet.getComponents()) {
                if (!name.equals(component.getName()) || !version.equals(component.getVersion())) continue;
                cachedComponent = InventoryCache.getInstance().getComponent(this._metaDataHome, name, version);
                if (null == cachedComponent) {
                    cachedComponent = ComponentImpl.newInstance(component.getName(), component.getVersion(), this._metaDataHome, this._mode);
                    InventoryCache.getInstance().putComponent(this._metaDataHome, cachedComponent);
                }
                return cachedComponent;
            }
        }
        return null;
    }

    @Override
    public Collection<FeatureSet> getFeatureSets(Component component) throws InventoryException {
        if (null == component) {
            throw new InventoryException("The component is required to retrieve the feature sets.");
        }
        HashSet<FeatureSet> parentFeatureSets = new HashSet<FeatureSet>();
        for (FeatureSet featureSet : this.getFeatureSets()) {
            for (Component componentInFeature : featureSet.getComponents()) {
                if (!component.equals(componentInFeature)) continue;
                parentFeatureSets.add(featureSet);
            }
        }
        return parentFeatureSets;
    }

    @Override
    public Collection<Distribution> getDistributions(Component component) throws InventoryException {
        if (null == component) {
            throw new InventoryException("The component is required to retrieve the distributions.");
        }
        HashSet<Distribution> parentDistributions = new HashSet<Distribution>();
        for (FeatureSet featureSet : this.getFeatureSets(component)) {
            parentDistributions.addAll(this.getDistributions(featureSet));
        }
        return parentDistributions;
    }

    @Override
    public Collection<Distribution> getDistributions(FeatureSet featureSet) throws InventoryException {
        if (null == featureSet) {
            throw new InventoryException("The feature set is required to retrieve the distributions.");
        }
        HashSet<Distribution> parentDistributions = new HashSet<Distribution>();
        for (Distribution distribution : this.getDistributions()) {
            for (FeatureSet distFeatureSet : distribution.getFeatureSets()) {
                if (!featureSet.equals(distFeatureSet)) continue;
                parentDistributions.add(distribution);
            }
        }
        return parentDistributions;
    }

    Collection<Distribution> getDistributions(Collection<com.oracle.cie.gdr.dao.dbd.Distribution> distributions) throws InventoryException {
        HashSet<Distribution> distributionsWrappers = new HashSet<Distribution>();
        Distribution cachedDistribution = null;
        for (com.oracle.cie.gdr.dao.dbd.Distribution distribution : distributions) {
            cachedDistribution = InventoryCache.getInstance().getDistribution(this._metaDataHome, distribution.getName(), distribution.getVersion());
            if (null == cachedDistribution) {
                cachedDistribution = new DistributionImpl(distribution, this._metaDataHome);
                InventoryCache.getInstance().putDistribution(this._metaDataHome, cachedDistribution);
            }
            distributionsWrappers.add(cachedDistribution);
        }
        return distributionsWrappers;
    }

    Collection<FeatureSet> getFeatureSets(Collection<com.oracle.cie.gdr.dao.ftr.FeatureSet> featureSets) throws InventoryException {
        HashSet<FeatureSet> featureSetsWrappers = new HashSet<FeatureSet>();
        FeatureSet cachedFeatureSet = null;
        for (com.oracle.cie.gdr.dao.ftr.FeatureSet featureSet : featureSets) {
            cachedFeatureSet = InventoryCache.getInstance().getFeatureSet(this._metaDataHome, featureSet.getName(), featureSet.getVersion());
            if (null == cachedFeatureSet) {
                cachedFeatureSet = new FeatureSetImpl(featureSet, this._metaDataHome, this._mode);
                InventoryCache.getInstance().putFeatureSet(this._metaDataHome, cachedFeatureSet);
            }
            featureSetsWrappers.add(cachedFeatureSet);
        }
        return featureSetsWrappers;
    }

    Collection<Component> getComponents(Collection<ComponentReference> componentsReferences) throws InventoryException {
        HashSet<Component> components = new HashSet<Component>();
        Component cachedComponent = null;
        for (ComponentReference componentReference : componentsReferences) {
            cachedComponent = InventoryCache.getInstance().getComponent(this._metaDataHome, componentReference.getName(), componentReference.getVersion());
            if (null == cachedComponent) {
                cachedComponent = ComponentImpl.newInstance(componentReference.getName(), componentReference.getVersion(), this._metaDataHome, this._mode);
                InventoryCache.getInstance().putComponent(this._metaDataHome, cachedComponent);
            }
            components.add(cachedComponent);
        }
        return components;
    }
}

