/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.external.builder.impl;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.dao.di.Property;
import com.oracle.cie.gdr.dao.di.Section;
import com.oracle.cie.gdr.external.builder.BuilderException;
import com.oracle.cie.gdr.external.builder.SectionBuilder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SectionBuilderImpl
implements SectionBuilder {
    private Section _section;
    private Map<String, Property> _properties = new LinkedHashMap<String, Property>();
    private List<String> _forcedProperties = new ArrayList<String>();

    public SectionBuilderImpl(String name) throws BuilderException {
        if (StringUtil.isNullOrEmpty((String)name)) {
            throw new BuilderException("The section name was null or empty.");
        }
        this._section = new Section(name);
    }

    @Override
    public void addProperty(String name, String[] values) {
        this.addProperty(name, values, false);
    }

    @Override
    public void addProperty(String name, String[] values, boolean forced) {
        Property property = this._properties.get(name);
        if (property == null) {
            property = new Property(name);
            this._properties.put(name, property);
            property.setValues(values);
        } else if (!forced && !this._forcedProperties.contains(name) || forced) {
            property.setValues(values);
        }
        if (forced && !this._forcedProperties.contains(name)) {
            this._forcedProperties.add(name);
        }
    }

    Section getSection() {
        if (!this._properties.isEmpty()) {
            this._section.setProperties(new ArrayList<Property>(this._properties.values()));
        }
        return this._section;
    }
}

