/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.external.builder.impl;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.dao.cpd.Directory;
import com.oracle.cie.gdr.dao.cpd.File;
import com.oracle.cie.gdr.dao.cpd.FileMap;
import com.oracle.cie.gdr.external.builder.BuilderException;
import com.oracle.cie.gdr.external.builder.DirectoryBuilder;
import com.oracle.cie.gdr.external.builder.FileBuilder;
import com.oracle.cie.gdr.external.builder.FileMapBuilder;
import com.oracle.cie.gdr.external.builder.IncludeExcludeBuilder;
import com.oracle.cie.gdr.external.builder.PermissionBuilder;
import com.oracle.cie.gdr.external.builder.impl.DirectoryBuilderImpl;
import com.oracle.cie.gdr.external.builder.impl.FileBuilderImpl;
import com.oracle.cie.gdr.external.builder.impl.IncludeExcludeBuilderImpl;
import com.oracle.cie.gdr.external.builder.impl.PermissionBuilderImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class FileMapBuilderImpl
implements FileMapBuilder {
    private FileMap _fileMap;
    private List<PermissionBuilder> _permissions = new ArrayList<PermissionBuilder>();
    private List<IncludeExcludeBuilder> _includes = new ArrayList<IncludeExcludeBuilder>();
    private List<IncludeExcludeBuilder> _excludes = new ArrayList<IncludeExcludeBuilder>();

    public FileMapBuilderImpl(String symbol) throws BuilderException {
        if (StringUtil.isNullOrEmpty((String)symbol, (boolean)true)) {
            throw new BuilderException("The file-map symbol was null or empty.");
        }
        this._fileMap = new FileMap();
        this._fileMap.setSymbol(symbol);
        this.setPermissions(this.getDefaultPermissions());
    }

    @Override
    public String getSymbol() {
        return this._fileMap.getSymbol();
    }

    @Override
    public void addFile(String source, String dest) {
        File file = this._fileMap.addFile();
        file.setSource(source);
        file.setDest(dest);
    }

    @Override
    public void addFile(FileBuilder file) {
        this._fileMap.addFile(((FileBuilderImpl)file).getFile());
    }

    @Override
    public void addDirectory(String source, String dest) {
        this.addFileMapDirectory(source, dest);
    }

    @Override
    public void addDirectory(DirectoryBuilder directory) throws BuilderException {
        this._fileMap.addDirectory(((DirectoryBuilderImpl)directory).getDirectory());
    }

    @Override
    public void addDirectory(String source, String dest, List<IncludeExcludeBuilder> includes, List<IncludeExcludeBuilder> excludes) throws BuilderException {
        this.addDirectory(source, dest, null, includes, excludes);
    }

    @Override
    public void addDirectory(String source, String dest, List<PermissionBuilder> permissions) throws BuilderException {
        this.addDirectory(source, dest, permissions, null, null);
    }

    @Override
    public void addDirectory(String source, String dest, List<PermissionBuilder> permissions, List<IncludeExcludeBuilder> includes, List<IncludeExcludeBuilder> excludes) throws BuilderException {
        Directory directory = this.addFileMapDirectory(source, dest);
        if (permissions != null && !permissions.isEmpty()) {
            directory.setPermissions(PermissionBuilderImpl.getFileMapPermissions(permissions));
        }
        if (includes != null && !includes.isEmpty()) {
            directory.setIncludes(IncludeExcludeBuilderImpl.getFileMapIncludeExcludes(includes));
        }
        if (excludes != null && !excludes.isEmpty()) {
            directory.setExcludes(IncludeExcludeBuilderImpl.getFileMapIncludeExcludes(excludes));
        }
    }

    protected Directory addFileMapDirectory(String source, String dest) {
        Directory directory = this._fileMap.addDirectory();
        directory.setSource(source);
        directory.setDest(dest);
        return directory;
    }

    @Override
    public List<PermissionBuilder> getPermissions() {
        return this._permissions;
    }

    @Override
    public void setPermissions(List<PermissionBuilder> permissions) {
        this._permissions = permissions;
    }

    @Override
    public PermissionBuilder addPermission(String mode) {
        PermissionBuilder permission = this.getPermissionBuilder(mode);
        this.addPermission(permission);
        return permission;
    }

    @Override
    public PermissionBuilder getPermissionBuilder(String mode) {
        return new PermissionBuilderImpl(mode);
    }

    @Override
    public IncludeExcludeBuilder getIncludeExcludeBuilder() {
        return new IncludeExcludeBuilderImpl();
    }

    @Override
    public List<IncludeExcludeBuilder> getIncludes() {
        return this._includes;
    }

    @Override
    public void setIncludes(List<IncludeExcludeBuilder> includes) {
        this._includes = includes;
    }

    @Override
    public List<IncludeExcludeBuilder> getExcludes() {
        return this._excludes;
    }

    @Override
    public void setExcludes(List<IncludeExcludeBuilder> excludes) {
        this._excludes = excludes;
    }

    void addPermission(PermissionBuilder permission) {
        this._permissions.add(permission);
    }

    @Override
    public Set<String> getPlatforms() {
        return this._fileMap.getPlatforms();
    }

    @Override
    public void setPlatforms(Set<String> platforms) {
        this._fileMap.setPlatforms(platforms);
    }

    @Override
    public void setLocales(Set<String> locales) {
        this._fileMap.setLocales(locales);
    }

    @Override
    public void setBootstrap(String bootstrap) {
        if (!StringUtil.isNullOrEmpty((String)bootstrap)) {
            this._fileMap.setBootstrap(Boolean.valueOf(bootstrap));
        }
    }

    protected List<PermissionBuilder> getDefaultPermissions() {
        ArrayList<PermissionBuilder> permissions = new ArrayList<PermissionBuilder>();
        permissions.add(new PermissionBuilderImpl("640"));
        return permissions;
    }

    FileMap getFileMap() throws BuilderException {
        this._fileMap.setPermissions(PermissionBuilderImpl.getFileMapPermissions(this._permissions));
        this._fileMap.setIncludes(IncludeExcludeBuilderImpl.getFileMapIncludeExcludes(this._includes));
        this._fileMap.setExcludes(IncludeExcludeBuilderImpl.getFileMapIncludeExcludes(this._excludes));
        return this._fileMap;
    }
}

