/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.dependency;

import com.oracle.cie.dependency.DependencyException;
import com.oracle.cie.dependency.EKey;
import com.oracle.cie.dependency.SelectionTarget;
import com.oracle.cie.dependency.TEdge;
import com.oracle.cie.dependency.TVertex;
import com.oracle.cie.dependency.VKey;
import com.oracle.cie.dependency.dao.DependencyRef;
import com.oracle.cie.dependency.graph.DirectedGraph;
import com.oracle.cie.dependency.graph.Vertex;
import com.oracle.cie.gdr.common.NLS;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;

public class FeatureUndeterministicSelectionException
extends DependencyException {
    private DirectedGraph<VKey, TVertex, EKey, TEdge> _graph;
    private Collection<TVertex> _unresolvedORs;

    public FeatureUndeterministicSelectionException(Collection<TVertex> unresolvedORs, DirectedGraph<VKey, TVertex, EKey, TEdge> graph) {
        this._graph = graph;
        this._unresolvedORs = unresolvedORs;
        this._type = SelectionTarget.ErrorType.UNDETERMINISTIC;
        this.setDetails(this.constructDetails());
    }

    public Collection<TVertex> getUnresolvedORs() {
        return this._unresolvedORs;
    }

    public DirectedGraph<VKey, TVertex, EKey, TEdge> getGraph() {
        return this._graph;
    }

    protected String constructDetails() {
        LinkedHashSet ors = new LinkedHashSet();
        StringBuilder sb = new StringBuilder();
        if (this.getUnresolvedORs() != null && !this.getUnresolvedORs().isEmpty()) {
            for (TVertex tVertex : this.getUnresolvedORs()) {
                LinkedHashSet<EdgeWrapper> destSet = new LinkedHashSet<EdgeWrapper>();
                List temp = this.getGraph().getOutgoingEdges((Vertex)tVertex);
                for (TEdge t : temp) {
                    EdgeWrapper ew = new EdgeWrapper(t);
                    destSet.add(ew);
                }
                ors.add(destSet);
            }
            for (LinkedHashSet linkedHashSet : ors) {
                sb.append(NLS.getString("FeatureUndeterministicSelection.unresolved.ors"));
                for (EdgeWrapper t : linkedHashSet) {
                    sb.append("\n");
                    if (((VKey)t.getVertex().getKey()).getType() == VKey.VType.TINFO) {
                        sb.append(this.getFeatureSetStr(t.getVertex()));
                    }
                    if (((VKey)t.getVertex().getKey()).getType() == VKey.VType.UNRESOLVED) {
                        sb.append(this.getUnresolvedInfoStr(t.getVertex()));
                    }
                    if (((VKey)t.getVertex().getKey()).getType() != VKey.VType.AND_COND) continue;
                    sb.append(NLS.getString("FeatureUndeterministicSelection.dependency.and")).append(this.getConditionalOpDetails(t.getVertex(), 1));
                }
            }
        }
        return sb.toString();
    }

    private String getConditionalOpDetails(TVertex vertex, int level) {
        StringBuilder sb = new StringBuilder();
        List outE = this.getGraph().getOutgoingEdges((Vertex)vertex);
        for (TEdge e : outE) {
            sb.append(this.insertSpace(level));
            if (((VKey)((TVertex)e.getDest()).getKey()).getType() == VKey.VType.AND_COND) {
                sb.append(NLS.getString("FeatureUndeterministicSelection.dependency.and")).append(this.getConditionalOpDetails((TVertex)e.getDest(), level + 1));
            }
            if (((VKey)((TVertex)e.getDest()).getKey()).getType() == VKey.VType.OR_COND) {
                sb.append(NLS.getString("FeatureUndeterministicSelection.dependency.or")).append(this.getConditionalOpDetails((TVertex)e.getDest(), level + 1));
            }
            if (((VKey)((TVertex)e.getDest()).getKey()).getType() == VKey.VType.TINFO) {
                sb.append(NLS.getMsg(this.getEdgeDescr(e), this.getFeatureSetStr((TVertex)e.getDest())));
            }
            if (((VKey)((TVertex)e.getDest()).getKey()).getType() != VKey.VType.UNRESOLVED) continue;
            sb.append(NLS.getMsg(this.getEdgeDescr(e), this.getUnresolvedInfoStr((TVertex)e.getDest())));
        }
        return sb.toString();
    }

    private String insertSpace(int n) {
        StringBuilder sb = new StringBuilder("\n");
        for (int i = 0; i < n; ++i) {
            sb.append("  ");
        }
        return sb.toString();
    }

    private String getEdgeDescr(TEdge e) {
        return ((EKey)e.getKey()).getType() == EKey.EType.REQUIRES ? "FeatureUndeterministicSelection.dependency.requires" : "FeatureUndeterministicSelection.dependency.conflicts";
    }

    private String getFeatureSetStr(TVertex v) {
        FeatureSet feature = (FeatureSet)v.getKey(FeatureSet.class).getItem();
        StringBuilder sb = new StringBuilder();
        sb.append(feature.getName()).append(" - ").append(feature.getVersion());
        return sb.toString();
    }

    private String getUnresolvedInfoStr(TVertex v) {
        DependencyRef dep = ((VKey)v.getKey()).getUnresolvedDep();
        StringBuilder sb = new StringBuilder();
        sb.append(dep.getName()).append(((VKey)v.getKey()).getVersionDetails(dep));
        return sb.toString();
    }

    private class EdgeWrapper {
        private TVertex _vertex;
        private EKey.EType _type;

        public EdgeWrapper(TEdge edge) {
            this._vertex = (TVertex)edge.getDest();
            this._type = ((EKey)edge.getKey()).getType();
        }

        public TVertex getVertex() {
            return this._vertex;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + ((Object)((Object)this.getOuterType())).hashCode();
            result = 31 * result + (this._type == null ? 0 : this._type.hashCode());
            result = 31 * result + (this._vertex == null ? 0 : this._vertex.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EdgeWrapper other = (EdgeWrapper)obj;
            if (!((Object)((Object)this.getOuterType())).equals((Object)other.getOuterType())) {
                return false;
            }
            if (this._type == null ? other._type != null : !this._type.equals((Object)other._type)) {
                return false;
            }
            return !(this._vertex == null ? other._vertex != null : !this._vertex.equals(other._vertex));
        }

        private DependencyException getOuterType() {
            return FeatureUndeterministicSelectionException.this;
        }
    }
}

