/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.dependency;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.gdr.MetaDataHome;
import com.oracle.cie.gdr.dao.ftr.FeatureSetDependencies;
import com.oracle.cie.gdr.dao.ftr.FeatureSetDependency;
import com.oracle.cie.gdr.helpers.DistributionHelper;
import com.oracle.cie.gdr.helpers.FeatureSetHelper;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FeatureDependencyManager {
    private static final Logger _log = Logger.getLogger(FeatureDependencyManager.class.getName());
    public static final String FEATURE_SET_DEPENDENCY = "feature-set-dependency";
    public static final String FEATURE_SET_DEPENDENCIES = "feature-set-dependencies";
    public static final String FEATURE_SETS_DEPENDENCIES_DIR = "dependencies";
    public static final String DISTRIBUTION_COMPATIBILITY_DIR = "compatibility";
    public static final String COMPATIBILITY_FILE_PROPERTY = "oracle.installer.compatibilityFile";
    private Map<String, FeatureSetDependency> _featureDependenciesMap = new HashMap<String, FeatureSetDependency>();
    private FeatureSetDependencies _featureSetDependencies;
    private ClassLoader _classLoader;
    private FeatureSetHelper _featureSetHelper;

    public FeatureDependencyManager() {
        this(null);
    }

    public FeatureDependencyManager(ClassLoader classLoader) {
        this._classLoader = classLoader;
        this._featureSetHelper = FeatureSetHelper.getInstance(this._classLoader);
    }

    public static String getFeatureSetDependencyPath() {
        return "featuresets/dependencies";
    }

    public static String getDistributionCompatibilityPath() {
        return "distributions/compatibility";
    }

    public void saveFeatureDependencies(MetaDataHome home) throws GdrException, DataHandlerException {
        this.saveFeatureDependencies(home.getGdrMetaDataHomePath().resolve(FeatureDependencyManager.getFeatureSetDependencyPath()));
    }

    public List<File> getDistributionCompatibilityFiles(File metaDataDir) {
        List<Path> paths = this.getDistributionCompatibilityPaths(NioHelper.getInstance().getPath(metaDataDir));
        ArrayList<File> files = new ArrayList<File>();
        for (Path path : paths) {
            files.add(path.toFile());
        }
        return files;
    }

    public List<Path> getDistributionCompatibilityPaths(Path metaDataDir) {
        ArrayList<Path> paths = new ArrayList<Path>();
        if (metaDataDir != null && Files.isDirectory(metaDataDir, new LinkOption[0])) {
            paths.addAll(this._featureSetHelper.getFileLocatorService(metaDataDir).getPathsUnderPath(FeatureDependencyManager.getDistributionCompatibilityPath()));
            Iterator it = paths.iterator();
            while (it.hasNext()) {
                Path path = (Path)it.next();
                if (Files.isRegularFile(path, new LinkOption[0]) && path.getFileName().toString().endsWith(".xml")) continue;
                it.remove();
            }
        }
        return paths;
    }

    public File getDistributionCompatibilityFile(File metadataHome, String name, String version) throws FileNotFoundException {
        return this.getDistributionCompatibilityPath(NioHelper.getInstance().getPath(metadataHome), name, version).toFile();
    }

    public Path getDistributionCompatibilityPath(Path metadataHome, String name, String version) throws FileNotFoundException {
        return DistributionHelper.getInstance(this._classLoader).getFileLocatorService(metadataHome).getPath(FeatureDependencyManager.getDistributionCompatibilityPath(), this.getDistributionCompatibilityFileName(name, version));
    }

    public String getDistributionCompatibilityFileName(String name, String version) {
        return DistributionHelper.getInstance(this._classLoader).getDistributionFileName(name, version);
    }

    public void saveFeatureDependencies(File directory) throws GdrException, DataHandlerException {
        this.saveFeatureDependencies(NioHelper.getInstance().getPath(directory));
    }

    public void saveFeatureDependencies(Path directory) throws GdrException, DataHandlerException {
        if (!this._featureDependenciesMap.isEmpty()) {
            for (FeatureSetDependency featureSetDependency : this._featureDependenciesMap.values()) {
                Path dest = directory.resolve(this._featureSetHelper.getFeatureSetFileName(featureSetDependency.getName(), featureSetDependency.getVersion()));
                _log.fine("Saving feature set dependency " + (Object)((Object)featureSetDependency) + " to " + dest);
                this.saveFeatureDependencies(featureSetDependency.getDataHandler(), dest);
            }
        } else {
            _log.fine("No feature-set dependencies to save.");
        }
    }

    public void saveFeatureDependencies(FeatureSetDependencies featureDependencies, File directory) throws GdrException, DataHandlerException {
        this.saveFeatureDependencies(featureDependencies, NioHelper.getInstance().getPath(directory));
    }

    public void saveFeatureDependencies(FeatureSetDependencies featureDependencies, Path directory) throws GdrException, DataHandlerException {
        Path dest = directory.resolve(this._featureSetHelper.getFeatureSetFileName(featureDependencies.getName(), featureDependencies.getVersion()));
        _log.fine("Saving feature set dependencies " + (Object)((Object)featureDependencies) + " to " + dest);
        this.saveFeatureDependencies(featureDependencies.getDataHandler(), dest);
    }

    private void saveFeatureDependencies(IDataHandler data, Path dest) throws GdrException, DataHandlerException {
        block6: {
            Path directory = dest.getParent();
            if (directory == null) {
                GdrException ex = new GdrException("The directory specified was null.");
                _log.throwing(FeatureDependencyManager.class.getName(), "saveFeatureDependency", ex);
                throw ex;
            }
            if (!Files.exists(directory, new LinkOption[0])) {
                try {
                    Files.createDirectories(directory, new FileAttribute[0]);
                    if (!Files.exists(directory, new LinkOption[0])) {
                        GdrException ex = new GdrException("The directory specified did not exist and could not be created: " + directory);
                        _log.throwing(FeatureDependencyManager.class.getName(), "saveFeatureDependency", ex);
                        throw ex;
                    }
                    break block6;
                }
                catch (IOException e) {
                    GdrException ex = new GdrException("The directory specified did not exist and could not be created: " + directory, (Throwable)e);
                    _log.throwing(FeatureDependencyManager.class.getName(), "saveFeatureDependency", ex);
                    throw ex;
                }
            }
            if (!Files.isDirectory(directory, new LinkOption[0])) {
                GdrException ex = new GdrException("The directory specified was not a directory: " + directory);
                _log.throwing(FeatureDependencyManager.class.getName(), "saveFeatureDependency", ex);
                throw ex;
            }
        }
        this._featureSetHelper.save(data, dest);
    }

    public void loadFeatureSetDependencies(MetaDataHome metaDataHome) throws IOException, DataHandlerException, GdrException {
        Path dependenciesDir;
        if (metaDataHome != null && Files.isDirectory(dependenciesDir = metaDataHome.getGdrMetaDataHomePath().resolve(FeatureDependencyManager.getFeatureSetDependencyPath()), new LinkOption[0])) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(dependenciesDir);){
                for (Path file : stream) {
                    this.loadFeatureSetDependency(file);
                }
            }
        }
    }

    public FeatureSetDependencies loadDistributionCompatibilityFile(File distributionCompatibilityFile, boolean validateFileName) throws GdrException, MalformedURLException, DataHandlerException {
        return this.loadDistributionCompatibilityFile(NioHelper.getInstance().getPath(distributionCompatibilityFile), validateFileName);
    }

    public FeatureSetDependencies loadDistributionCompatibilityFile(Path distributionCompatibilityFile, boolean validateFileName) throws GdrException, MalformedURLException, DataHandlerException {
        FeatureSetDependencies featureSetDependencies;
        if (distributionCompatibilityFile != null) {
            if (_log.isLoggable(Level.FINER)) {
                _log.finer("Parsing file " + distributionCompatibilityFile);
            }
            try (InputStream is = Files.newInputStream(distributionCompatibilityFile, new OpenOption[0]);){
                featureSetDependencies = new FeatureSetDependencies(this._featureSetHelper.getDataHandlerProvider().create(this._featureSetHelper.getNamespace(), FEATURE_SET_DEPENDENCIES, is, this._featureSetHelper.getClassLoader()));
            }
            catch (IOException e) {
                throw new GdrException((Throwable)e);
            }
            featureSetDependencies.setFeatureSetDependenciesLocation(distributionCompatibilityFile.toUri().toURL());
            if (validateFileName && !distributionCompatibilityFile.getFileName().toString().equals(this.getDistributionCompatibilityFileName(featureSetDependencies.getName(), featureSetDependencies.getVersion()))) {
                GdrException ex = new GdrException("The internal distribution compatibility file name and version is incorrect.  File name should be: " + this.getDistributionCompatibilityFileName(featureSetDependencies.getName(), featureSetDependencies.getVersion()) + " File name is: " + distributionCompatibilityFile.getFileName());
                _log.throwing(FeatureDependencyManager.class.getName(), "loadDistributionCompatibilityFile", ex);
                throw ex;
            }
        } else {
            GdrException ex = new GdrException("The specified distribution compatibility file was null.");
            _log.throwing(FeatureDependencyManager.class.getName(), "loadDistributionCompatibilityFile", ex);
            throw ex;
        }
        return featureSetDependencies;
    }

    public void loadDistributionCompatibilityFile(File featureSetDependenciesFile) throws GdrException, MalformedURLException, DataHandlerException {
        this.loadDistributionCompatibilityFile(NioHelper.getInstance().getPath(featureSetDependenciesFile));
    }

    public void loadDistributionCompatibilityFile(Path featureSetDependenciesFile) throws GdrException, MalformedURLException, DataHandlerException {
        FeatureSetDependencies featureSetDependencies = this.loadDistributionCompatibilityFile(featureSetDependenciesFile, false);
        this.loadFeatureSetDependencies(featureSetDependencies);
    }

    public void loadFeatureSetDependencies(FeatureSetDependencies featureSetDependencies) throws GdrException {
        if (featureSetDependencies != null) {
            for (FeatureSetDependency featureSetDependency : featureSetDependencies.getFeatureSetDependencies()) {
                String key = this.buildFeatureKey(featureSetDependency.getName(), featureSetDependency.getVersion());
                if (this._featureDependenciesMap.containsKey(key)) continue;
                this._featureDependenciesMap.put(key, featureSetDependency);
            }
        } else {
            GdrException ex = new GdrException("The specified FeatureSetDependencies were null.");
            _log.throwing(FeatureDependencyManager.class.getName(), "loadFeatureSetDependencies", ex);
            throw ex;
        }
    }

    public void loadFeatureSetDependency(Path featureDependencyFile) throws IOException, DataHandlerException, GdrException {
        String key;
        FeatureSetDependency featureDependency = this.getFeatureSetDependency(featureDependencyFile);
        if (featureDependency != null && !this._featureDependenciesMap.containsKey(key = this.buildFeatureKey(featureDependency.getName(), featureDependency.getVersion()))) {
            this._featureDependenciesMap.put(key, featureDependency);
        }
    }

    public FeatureSetDependency getFeatureSetDependency(String name, String version) {
        return this._featureDependenciesMap.get(this.buildFeatureKey(name, version));
    }

    public FeatureSetDependencies getFeatureSetDependencies() {
        if (this._featureSetDependencies == null) {
            this._featureSetDependencies = new FeatureSetDependencies(this._classLoader);
        }
        this._featureSetDependencies.setFeatureSetDependencies(new ArrayList<FeatureSetDependency>(this._featureDependenciesMap.values()));
        return this._featureSetDependencies;
    }

    public boolean hasFeatureSetDependencies() {
        return !this._featureDependenciesMap.isEmpty();
    }

    private FeatureSetDependency getFeatureSetDependency(Path featureSetDependencyFile) throws IOException, DataHandlerException, GdrException {
        return this.getFeatureSetDependency(featureSetDependencyFile, true);
    }

    private FeatureSetDependency getFeatureSetDependency(Path featureSetDependencyFile, boolean validateFileName) throws IOException, DataHandlerException, GdrException {
        FeatureSetDependency featureSetDependency;
        if (featureSetDependencyFile != null) {
            GdrException ex;
            if (_log.isLoggable(Level.FINER)) {
                _log.finer("Parsing file " + featureSetDependencyFile);
            }
            try (InputStream is = Files.newInputStream(featureSetDependencyFile, new OpenOption[0]);){
                featureSetDependency = new FeatureSetDependency(this._featureSetHelper.getDataHandlerProvider().create(this._featureSetHelper.getNamespace(), FEATURE_SET_DEPENDENCY, is, this._featureSetHelper.getClassLoader()));
            }
            featureSetDependency.setFeatureSetDependencyLocation(featureSetDependencyFile.toUri().toURL());
            if (validateFileName && !featureSetDependencyFile.getFileName().toString().equals(this._featureSetHelper.getFeatureSetFileName(featureSetDependency.getName(), featureSetDependency.getVersion()))) {
                ex = new GdrException("The internal feature set dependency name and version is incorrect.  File name should be: " + this._featureSetHelper.getFeatureSetFileName(featureSetDependency.getName(), featureSetDependency.getVersion()) + " File name is: " + featureSetDependencyFile.getFileName());
                _log.throwing(FeatureDependencyManager.class.getName(), "getFeatureSetDependency", ex);
                throw ex;
            }
            if (featureSetDependency.getName().contains(" ")) {
                ex = new GdrException("The feature set dependency file " + featureSetDependencyFile + " contains an invalid name.  Feature sets names may not contain spaces: \"" + featureSetDependency.getName() + "\"");
                _log.throwing(FeatureDependencyManager.class.getName(), "getFeatureSetDependency", ex);
                throw ex;
            }
        } else {
            GdrException ex = new GdrException("The specified feature set dependency file was null.");
            _log.throwing(FeatureDependencyManager.class.getName(), "getFeatureSetDependency", ex);
            throw ex;
        }
        return featureSetDependency;
    }

    public void cleanDependencies() {
        this._featureSetDependencies = null;
        this._featureDependenciesMap.clear();
    }

    private String buildFeatureKey(String name, String version) {
        return name + ":" + version;
    }
}

