/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.deinstallation;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.gdr.ComponentLoader;
import com.oracle.cie.gdr.DistributionLoader;
import com.oracle.cie.gdr.DistributionTarget;
import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.dbd.Distribution;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.dao.rgy.ComponentInfo;
import com.oracle.cie.gdr.dao.rgy.DistributionInfo;
import com.oracle.cie.gdr.dao.rgy.FeatureInfo;
import com.oracle.cie.gdr.dao.rgy.Registry;
import com.oracle.cie.gdr.dao.rgy.SessionInfo;
import com.oracle.cie.gdr.dao.rgy.TargetInfo;
import com.oracle.cie.gdr.deinstallation.CommonDeInstaller;
import com.oracle.cie.gdr.deinstallation.DeInstallationSession;
import com.oracle.cie.gdr.deinstallation.FeatureSetDeInstallationSession;
import com.oracle.cie.gdr.external.DeInstallerSession;
import com.oracle.cie.gdr.helpers.RegistryHelper;
import com.oracle.cie.gdr.selection.Status;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FeatureSetDeInstaller
extends CommonDeInstaller {
    private List<ComponentLoader> _componentLoaders;
    private Map<Distribution, ComponentLoader> _distributionMap;

    public FeatureSetDeInstaller(DeInstallationSession deInstallationSession) throws GdrException, IOException, DataHandlerException {
        super(deInstallationSession);
    }

    public FeatureSetDeInstaller(DeInstallerSession deInstallerSession) throws GdrException, IOException, DataHandlerException {
        super((DeInstallationSession)deInstallerSession);
        this.init();
    }

    public void init() throws IOException, DataHandlerException, GdrException {
        this._componentLoaders = new ArrayList<ComponentLoader>();
        this._distributionMap = new HashMap<Distribution, ComponentLoader>();
        Map<Distribution, Set<FeatureSet>> sessionMap = this.getFeatureSetSessionMap();
        for (DistributionLoader distributionLoader : this.getDistributionLoaders()) {
            Set<FeatureSet> featuresToUninstall = sessionMap.get(distributionLoader.getDistribution());
            ComponentLoader componentLoader = new ComponentLoader(this.getMetaDataHome(), this.getServiceHolder(), Mode.DEINSTALL, featuresToUninstall, distributionLoader.getDirectoryMap(), this.getDeInstallInfo());
            this._componentLoaders.add(componentLoader);
            this._distributionMap.put(distributionLoader.getDistribution(), componentLoader);
        }
    }

    public List<ComponentLoader> getComponentLoaders() {
        return this._componentLoaders;
    }

    public FeatureSetDeInstallationSession getFeatureSetDeInstallationSession() {
        return (FeatureSetDeInstallationSession)this.getDeInstallationSession();
    }

    public List<DistributionLoader> getDistributionLoaders() {
        return this.getFeatureSetDeInstallationSession().getDistributionLoaders();
    }

    public Map<Distribution, Set<FeatureSet>> getFeatureSetSessionMap() {
        return this.getFeatureSetDeInstallationSession().getFeatureSetSessionMap();
    }

    public List<DistributionTarget> getDistributionTargets() {
        ArrayList<DistributionTarget> distributionTargets = new ArrayList<DistributionTarget>();
        for (DistributionLoader distributionLoader : this.getDistributionLoaders()) {
            distributionTargets.add(distributionLoader.getDistributionTarget());
        }
        return distributionTargets;
    }

    @Override
    public Set<Component> getComponents() {
        HashSet<Component> components = new HashSet<Component>();
        for (ComponentLoader componentLoader : this._componentLoaders) {
            for (Component component : componentLoader.getComponents()) {
                components.add(component);
            }
        }
        return components;
    }

    @Override
    public Map<Distribution, Set<FeatureSet>> getFeatureSetsMap() {
        return this.getFeatureSetSessionMap();
    }

    @Override
    public Set<Distribution> getDistributions() {
        HashSet<Distribution> distributions = new HashSet<Distribution>();
        for (DistributionLoader distributionLoader : this.getDistributionLoaders()) {
            distributions.add(distributionLoader.getDistribution());
        }
        return distributions;
    }

    @Override
    int getFeatureRemainingRefCount(FeatureSet feature) {
        return 0;
    }

    @Override
    Collection<DistributionTarget> getAffectedDistributions() {
        HashSet<DistributionTarget> affectedDistributions = new HashSet<DistributionTarget>();
        for (DistributionLoader distributionLoader : this.getDistributionLoaders()) {
            affectedDistributions.add(distributionLoader.getDistributionTarget());
        }
        return affectedDistributions;
    }

    @Override
    public Set<FeatureSet> getSelectedFeatures() {
        return this.getFeatureSetDeInstallationSession().getSelectedFeatures();
    }

    @Override
    public List<Component> getSelectedComponents(FeatureSet featureSet) {
        ArrayList<Component> selected = new ArrayList<Component>();
        Set<FeatureSet> selectedFeatures = this.getSelectedFeatures();
        if (selectedFeatures.contains(featureSet)) {
            for (ComponentLoader componentLoader : this._componentLoaders) {
                for (Map.Entry<FeatureSet, Collection<Component>> entry : componentLoader.getComponentsMap().entrySet()) {
                    if (!entry.getKey().equals(featureSet)) continue;
                    selected.addAll(componentLoader.getComponentsMap().get(featureSet));
                }
            }
        }
        return selected;
    }

    @Override
    public Map<FeatureSet, Collection<Component>> getComponentsMap() {
        HashMap<FeatureSet, Collection<Component>> componentsMap = new HashMap<FeatureSet, Collection<Component>>();
        for (ComponentLoader componentLoader : this._componentLoaders) {
            for (Map.Entry<FeatureSet, Collection<Component>> entry : componentLoader.getComponentsMap().entrySet()) {
                componentsMap.put(entry.getKey(), entry.getValue());
            }
        }
        return componentsMap;
    }

    @Override
    public Map<FeatureSet, Collection<Component>> getComponentsMap(Distribution distribution) {
        return this._distributionMap.get(distribution).getComponentsMap();
    }

    @Override
    protected void updateRegistry(Registry registry, SessionInfo session) {
        Map<Distribution, Set<FeatureSet>> sessionMap = this.getFeatureSetSessionMap();
        for (Distribution distribution : this.getDistributions()) {
            DistributionInfo dinfo = RegistryHelper.getInstance().getDistributionInfo(registry, distribution.getName(), distribution.getVersion());
            if (dinfo == null) continue;
            dinfo.addSession(session);
            Set<FeatureSet> selectedFeatures = sessionMap.get(distribution);
            List<FeatureInfo> finfos = dinfo.getFeatures();
            for (FeatureSet feature : selectedFeatures) {
                FeatureInfo finfo = RegistryHelper.getInstance().getFeatureInfo(finfos, feature.getName(), feature.getVersion());
                if (finfo == null) continue;
                finfo.setStatus(Status.notinstalled);
                finfo.addSession(session);
                List<ComponentInfo> cinfos = finfo.getComponents();
                for (ComponentInfo cinfo : cinfos) {
                    cinfo.setStatus(Status.notinstalled);
                    cinfo.addSession(session);
                    List<TargetInfo> tinfos = cinfo.getTargets();
                    if (tinfos == null || tinfos.isEmpty()) continue;
                    for (TargetInfo tinfo : tinfos) {
                        tinfo.setStatus(Status.notinstalled);
                        tinfo.addSession(session);
                    }
                }
            }
            boolean distributionEmpty = true;
            for (FeatureInfo finfo : finfos) {
                if (!finfo.getStatus().isInstalled()) continue;
                distributionEmpty = false;
                break;
            }
            if (!distributionEmpty) continue;
            dinfo.setStatus(Status.notinstalled);
        }
    }
}

