/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.deinstallation;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.gdr.ComponentLoader;
import com.oracle.cie.gdr.DistributionLoader;
import com.oracle.cie.gdr.DistributionTarget;
import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.dbd.Distribution;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.dao.rgy.ComponentInfo;
import com.oracle.cie.gdr.dao.rgy.DistributionInfo;
import com.oracle.cie.gdr.dao.rgy.FeatureInfo;
import com.oracle.cie.gdr.dao.rgy.Registry;
import com.oracle.cie.gdr.dao.rgy.SessionInfo;
import com.oracle.cie.gdr.dao.rgy.TargetInfo;
import com.oracle.cie.gdr.deinstallation.CommonDeInstaller;
import com.oracle.cie.gdr.deinstallation.DeInstallationSession;
import com.oracle.cie.gdr.deinstallation.DistributionDeInstallationSession;
import com.oracle.cie.gdr.external.DeInstallerSession;
import com.oracle.cie.gdr.helpers.RegistryHelper;
import com.oracle.cie.gdr.selection.Status;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DistributionDeInstaller
extends CommonDeInstaller {
    private ComponentLoader _componentLoader;

    public DistributionDeInstaller(DeInstallerSession deInstallationSession) throws GdrException, IOException, DataHandlerException {
        super((DeInstallationSession)deInstallationSession);
        this.init();
    }

    public DistributionDeInstallationSession getDistributionDeInstallationSession() {
        return (DistributionDeInstallationSession)this.getDeInstallationSession();
    }

    public DistributionLoader getDistributionLoader() {
        return this.getDistributionDeInstallationSession().getDistributionLoader();
    }

    public ComponentLoader getComponentLoader() {
        return this._componentLoader;
    }

    public Distribution getDistribution() {
        return this.getDistributionLoader().getDistribution();
    }

    public void init() throws IOException, DataHandlerException, GdrException {
        this._componentLoader = new ComponentLoader(this.getMetaDataHome(), this.getServiceHolder(), Mode.DEINSTALL, this.getDistributionLoader().getFeatureSets(), this.getDistributionLoader().getDirectoryMap(), this.getDeInstallInfo());
    }

    @Override
    public Set<FeatureSet> getSelectedFeatures() {
        return this.getDistributionDeInstallationSession().getSelectedFeatures();
    }

    @Override
    public List<Component> getSelectedComponents(FeatureSet featureSet) {
        ArrayList<Component> selected = new ArrayList<Component>();
        Set<FeatureSet> selectedFeatures = this.getSelectedFeatures();
        if (selectedFeatures.contains(featureSet)) {
            selected.addAll(this._componentLoader.getComponentsMap().get(featureSet));
        }
        return selected;
    }

    @Override
    public Map<FeatureSet, Collection<Component>> getComponentsMap() {
        return this.getComponentLoader().getComponentsMap();
    }

    @Override
    public Map<FeatureSet, Collection<Component>> getComponentsMap(Distribution distribution) {
        return this.getComponentLoader().getComponentsMap();
    }

    @Override
    public Set<Component> getComponents() {
        return this.getComponentLoader().getComponents();
    }

    @Override
    public Map<Distribution, Set<FeatureSet>> getFeatureSetsMap() {
        HashMap<Distribution, Set<FeatureSet>> featureSetsMap = new HashMap<Distribution, Set<FeatureSet>>();
        featureSetsMap.put(this.getDistribution(), this.getSelectedFeatures());
        return featureSetsMap;
    }

    @Override
    public Set<Distribution> getDistributions() {
        HashSet<Distribution> distributions = new HashSet<Distribution>();
        distributions.add(this.getDistribution());
        return distributions;
    }

    @Override
    protected void updateRegistry(Registry registry, SessionInfo session) {
        DistributionInfo dinfo = RegistryHelper.getInstance().getDistributionInfo(registry, this.getDistribution().getName(), this.getDistribution().getVersion());
        if (dinfo != null) {
            dinfo.addSession(session);
            Set<FeatureSet> selectedFeatures = this.getSelectedFeatures();
            List<FeatureInfo> finfos = dinfo.getFeatures();
            for (FeatureSet feature : selectedFeatures) {
                FeatureInfo finfo = RegistryHelper.getInstance().getFeatureInfo(finfos, feature.getName(), feature.getVersion());
                if (finfo == null) continue;
                finfo.setStatus(Status.notinstalled);
                finfo.addSession(session);
                List<ComponentInfo> cinfos = finfo.getComponents();
                for (ComponentInfo cinfo : cinfos) {
                    cinfo.setStatus(Status.notinstalled);
                    cinfo.addSession(session);
                    List<TargetInfo> tinfos = cinfo.getTargets();
                    if (tinfos == null || tinfos.isEmpty()) continue;
                    for (TargetInfo tinfo : tinfos) {
                        tinfo.setStatus(Status.notinstalled);
                        tinfo.addSession(session);
                    }
                }
            }
            boolean distributionEmpty = true;
            for (FeatureInfo finfo : finfos) {
                if (!finfo.getStatus().isInstalled()) continue;
                distributionEmpty = false;
                break;
            }
            if (distributionEmpty) {
                dinfo.setStatus(Status.notinstalled);
            }
        }
    }

    @Override
    Collection<DistributionTarget> getAffectedDistributions() {
        HashSet<DistributionTarget> distributions = new HashSet<DistributionTarget>();
        distributions.add(this.getDistributionLoader().getDistributionTarget());
        return distributions;
    }

    @Override
    int getFeatureRemainingRefCount(FeatureSet feature) {
        return 0;
    }
}

