/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.deinstallation;

import com.oracle.cie.gdr.nio.NioDelete;
import com.oracle.cie.gdr.nio.NioHelper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.ClosedFileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class DeInstallerShutdownHook {
    private static boolean _debug = Boolean.getBoolean("oracle.installer.debug.DeInstallerShutdownHook");
    public static boolean _isWindows = System.getProperty("os.name").toLowerCase().contains("windows");
    public static final String DELETE_SCRIPT_PREFIX = "delete";
    public static final String DELETE_SCRIPT_EXT_WINDOWS = ".cmd";
    public static final String DELETE_SCRIPT_EXT_UNIX = ".sh";
    public static String DELETE_SCRIPT_SLEEP_SECONDS = System.getProperty("oracle.installer.delete_script_sleep_seconds", "10");
    private static boolean _executeDeleteScript = Boolean.getBoolean("oracle.installer.execute_delete_script");
    private static boolean _hookRegistered;
    private static Set<Path> _files;
    private static Set<Path> _directories;
    private static Set<Path> _forceFiles;
    private static Set<Path> _forceDirs;
    public static String LS;

    public static Set<File> getFiles() {
        HashSet<File> files = new HashSet<File>();
        for (Path path : _files) {
            files.add(path.toFile());
        }
        return files;
    }

    public static Set<Path> getPaths() {
        return _files;
    }

    public static Set<File> getDirectories() {
        HashSet<File> directories = new HashSet<File>();
        for (Path dir : _directories) {
            directories.add(dir.toFile());
        }
        return directories;
    }

    public static Set<Path> getDirectoryPaths() {
        return _directories;
    }

    public static void add(File file) {
        DeInstallerShutdownHook.add(file, false);
    }

    public static void add(Path file) {
        DeInstallerShutdownHook.add(file, false);
    }

    public static void add(File file, boolean force) {
        DeInstallerShutdownHook.add(NioHelper.getInstance().getPath(file), force);
    }

    public static void add(Path file, boolean force) {
        if (file != null) {
            if (!_hookRegistered) {
                DeInstallerShutdownHook.registerShutdownHook();
            }
            if (Files.isDirectory(file, new LinkOption[0])) {
                if (force) {
                    _forceDirs.add(file);
                } else {
                    _directories.add(file);
                }
            } else if (force) {
                _forceFiles.add(file);
            } else {
                _files.add(file);
            }
        }
    }

    private static void registerShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                DeInstallerShutdownHook.runHooks();
            }
        });
        _hookRegistered = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void runHooks() {
        Class<DeInstallerShutdownHook> clazz = DeInstallerShutdownHook.class;
        synchronized (DeInstallerShutdownHook.class) {
            Path f;
            Set<Path> files = _files;
            Set<Path> directories = _directories;
            Set<Path> forceFiles = _forceFiles;
            Set<Path> forceDirs = _forceDirs;
            _files = null;
            _directories = null;
            _forceFiles = null;
            _forceDirs = null;
            // ** MonitorExit[var4] (shouldn't be in output)
            if (_debug) {
                System.out.println("Executing shutdown hook to create delete script");
            }
            ArrayList<Path> filesToBeDeleted = new ArrayList<Path>(files);
            ArrayList<Path> dirsToBeDeleted = new ArrayList<Path>(directories);
            ArrayList<Path> forceFilesToBeDeleted = new ArrayList<Path>(forceFiles);
            ArrayList<Path> forceDirsToBeDeleted = new ArrayList<Path>(forceDirs);
            Collections.sort(dirsToBeDeleted);
            Collections.reverse(dirsToBeDeleted);
            Collections.sort(forceDirsToBeDeleted);
            Collections.reverse(forceDirsToBeDeleted);
            Iterator<Path> it = filesToBeDeleted.iterator();
            while (it.hasNext()) {
                f = it.next();
                if (_debug) {
                    System.out.println("filesToBeDeleted " + f);
                }
                if (_isWindows && !_executeDeleteScript) continue;
                try {
                    Files.delete(f);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (Files.exists(f, new LinkOption[0])) continue;
                it.remove();
            }
            it = forceFilesToBeDeleted.iterator();
            while (it.hasNext()) {
                f = it.next();
                if (_debug) {
                    System.out.println("forceFilesToBeDeleted " + f);
                }
                if (_isWindows && !_executeDeleteScript) continue;
                try {
                    Files.delete(f);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (Files.exists(f, new LinkOption[0])) continue;
                it.remove();
            }
            it = dirsToBeDeleted.iterator();
            while (it.hasNext()) {
                f = it.next();
                if (_debug) {
                    System.out.println("dirsToBeDeleted " + f);
                }
                try {
                    Files.delete(f);
                }
                catch (IOException iOException) {
                }
                catch (ClosedFileSystemException closedFileSystemException) {
                    // empty catch block
                }
                try {
                    if (Files.exists(f, new LinkOption[0])) continue;
                    it.remove();
                }
                catch (ClosedFileSystemException closedFileSystemException) {}
            }
            it = forceDirsToBeDeleted.iterator();
            while (it.hasNext()) {
                f = it.next();
                if (_debug) {
                    System.out.println("forceDirsToBeDeleted " + f);
                }
                if (!NioDelete.delete((Path)f, (boolean)false)) continue;
                it.remove();
            }
            try {
                Path scriptLocation = DeInstallerShutdownHook.generateDeleteScript(filesToBeDeleted, forceFilesToBeDeleted, dirsToBeDeleted, forceDirsToBeDeleted);
                if (scriptLocation != null && Files.exists(scriptLocation, new LinkOption[0]) && _executeDeleteScript) {
                    DeInstallerShutdownHook.invokeDeleteScript(scriptLocation);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Path generateDeleteScript(List<Path> files, List<Path> forceFiles, List<Path> directories, List<Path> forceDirs) throws IOException {
        if (_debug) {
            System.out.println("Generating delete script, files=" + (files == null ? "0" : Integer.valueOf(files.size())) + " forceFiles=" + (forceFiles == null ? "0" : Integer.valueOf(forceFiles.size())) + " directories=" + (directories == null ? "0" : Integer.valueOf(directories.size())) + " forceDirs=" + (forceDirs == null ? "0" : Integer.valueOf(forceDirs.size())));
        }
        ArrayList<String> deletes = new ArrayList<String>();
        if (files != null && !files.isEmpty()) {
            for (Path file : files) {
                if (!Files.exists(file, new LinkOption[0])) continue;
                if (_debug) {
                    System.out.println("Adding file " + file);
                }
                deletes.add(DeInstallerShutdownHook.getDeleteCommand(file, false, false));
            }
        }
        if (forceFiles != null && !forceFiles.isEmpty()) {
            for (Path file : forceFiles) {
                if (!Files.exists(file, new LinkOption[0])) continue;
                if (_debug) {
                    System.out.println("Adding file " + file);
                }
                deletes.add(DeInstallerShutdownHook.getDeleteCommand(file, false, true));
            }
        }
        if (directories != null && !directories.isEmpty()) {
            Collections.sort(directories);
            Collections.reverse(directories);
            for (Path dir : directories) {
                try {
                    if (!Files.exists(dir, new LinkOption[0]) || !dir.isAbsolute()) continue;
                    if (_debug) {
                        System.out.println("Adding directory " + dir);
                    }
                    deletes.add(DeInstallerShutdownHook.getDeleteCommand(dir, true, false));
                }
                catch (ClosedFileSystemException closedFileSystemException) {}
            }
        }
        if (forceDirs != null && !forceDirs.isEmpty()) {
            Collections.sort(forceDirs);
            Collections.reverse(forceDirs);
            for (Path f : forceDirs) {
                if (!Files.exists(f, new LinkOption[0]) || !f.isAbsolute()) continue;
                if (_debug) {
                    System.out.println("Adding force directory " + f);
                }
                deletes.add(DeInstallerShutdownHook.getDeleteCommand(f, true, true));
            }
        }
        if (!deletes.isEmpty()) {
            String tmpDir = System.getProperty("java.io.tmpdir");
            String ext = _isWindows ? DELETE_SCRIPT_EXT_WINDOWS : DELETE_SCRIPT_EXT_UNIX;
            String name = DELETE_SCRIPT_PREFIX + System.getProperty("oracle.installer.timestamp") + ext;
            Path deleteScript = Paths.get(tmpDir, name);
            Files.createDirectories(deleteScript.getParent(), new FileAttribute[0]);
            BufferedWriter bw = Files.newBufferedWriter(deleteScript, StandardCharsets.UTF_8, StandardOpenOption.CREATE);
            if (_isWindows) {
                bw.write("@ECHO OFF" + LS);
                bw.write("ping -n " + DELETE_SCRIPT_SLEEP_SECONDS + " 127.0.0.1 > nul" + LS);
            } else {
                bw.write("sleep " + DELETE_SCRIPT_SLEEP_SECONDS + LS);
            }
            for (String delete : deletes) {
                bw.write(delete + LS);
            }
            if (!_debug) {
                bw.write(DeInstallerShutdownHook.getDeleteCommand(deleteScript, false, true) + LS);
            }
            bw.flush();
            bw.close();
            if (_debug) {
                BufferedReader br = null;
                try {
                    BufferedReader reader = Files.newBufferedReader(deleteScript, StandardCharsets.UTF_8);
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        System.out.println(line);
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            return deleteScript;
        }
        if (_debug) {
            System.out.println("Shutdownhook delete script unnecessary");
        }
        return null;
    }

    private static String getDeleteCommand(Path file, boolean dir, boolean force) {
        if (_isWindows) {
            if (dir) {
                if (force) {
                    return "RMDIR /S /Q \"" + file.toAbsolutePath().toString().replace("/", "\\") + "\"";
                }
                return "CMD /C RMDIR \"" + file.toAbsolutePath().toString().replace("/", "\\") + "\"";
            }
            if (force) {
                return "DEL /F \"" + file.toAbsolutePath().toString().replace("/", "\\") + "\"";
            }
            return "DEL \"" + file.toAbsolutePath().toString().replace("/", "\\") + "\"";
        }
        if (dir) {
            if (force) {
                return "rm -rf " + file.toAbsolutePath().toString().replace("\\", "/");
            }
            return "rmdir " + file.toAbsolutePath().toString().replace("\\", "/");
        }
        if (force) {
            return "rm -f " + file.toAbsolutePath().toString().replace("\\", "/");
        }
        return "rm " + file.toAbsolutePath().toString().replace("\\", "/");
    }

    private static void invokeDeleteScript(Path scriptLocation) throws IOException {
        String[] stringArray;
        System.out.println("Invoking delete script: " + scriptLocation.toAbsolutePath());
        if (_isWindows) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "CMD";
            stringArray2[1] = "/C";
            stringArray = stringArray2;
            stringArray2[2] = scriptLocation.toString();
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = "sh";
            stringArray3[1] = "-c";
            stringArray = stringArray3;
            stringArray3[2] = scriptLocation.toAbsolutePath().toString();
        }
        String[] command = stringArray;
        Process p = Runtime.getRuntime().exec(command, null, scriptLocation.getParent().toFile());
        p.getInputStream();
        p.getErrorStream();
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            for (String arg : args) {
                DeInstallerShutdownHook.add(new File(arg));
            }
        }
    }

    static {
        _files = new LinkedHashSet<Path>();
        _directories = new LinkedHashSet<Path>();
        _forceFiles = new LinkedHashSet<Path>();
        _forceDirs = new LinkedHashSet<Path>();
        LS = System.getProperty("line.separator");
    }
}

