/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.deinstallation;

import com.oracle.cie.gdr.ComponentTarget;
import com.oracle.cie.gdr.FileTarget;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.cpd.FileMap;
import com.oracle.cie.gdr.dao.dbd.Mapping;
import com.oracle.cie.gdr.dao.dei.DeInstallInfo;
import com.oracle.cie.gdr.dao.dei.DeInstallRefCount;
import com.oracle.cie.gdr.helpers.ComponentHelper;
import com.oracle.cie.gdr.services.ServiceHolder;
import com.oracle.cie.gdr.utils.GdrException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DeInstallerComponentTarget
extends ComponentTarget {
    private List<FileTarget> _fileTargets;
    private DeInstallInfo _deInstallInfo;
    private Map<DeInstallRefCount, Integer> _affectedRefCounts;

    public DeInstallerComponentTarget(Component component, FileMap componentFileMap, ServiceHolder serviceHolder, Mapping locationMapping, DeInstallInfo deInstallInfo) {
        super(component, componentFileMap, serviceHolder, locationMapping);
        this._deInstallInfo = deInstallInfo;
    }

    @Override
    public List<FileTarget> getFileTargets() throws GdrException {
        if (this._fileTargets == null) {
            List<DeInstallRefCount> refCounts;
            this._fileTargets = ComponentHelper.getInstance().getFilesForInstallation(this);
            if (!this._fileTargets.isEmpty() && this._deInstallInfo != null && (refCounts = this._deInstallInfo.getRefCounts()) != null && !refCounts.isEmpty()) {
                int i;
                for (FileTarget ft : this._fileTargets) {
                    for (DeInstallRefCount refCount : refCounts) {
                        if (!refCount.getPath().equals(ft.getDest())) continue;
                        if (this._affectedRefCounts == null) {
                            this._affectedRefCounts = new HashMap<DeInstallRefCount, Integer>();
                        }
                        i = 1;
                        if (this._affectedRefCounts.containsKey(refCount)) {
                            i += this._affectedRefCounts.get(refCount).intValue();
                        }
                        this._affectedRefCounts.put(refCount, i);
                    }
                }
                if (this._affectedRefCounts != null && !this._affectedRefCounts.isEmpty()) {
                    for (DeInstallRefCount refCount : this._affectedRefCounts.keySet()) {
                        Iterator<FileTarget> it = this._fileTargets.iterator();
                        while (it.hasNext()) {
                            FileTarget ft = it.next();
                            if (!refCount.getPath().equals(ft.getDest())) continue;
                            i = this._affectedRefCounts.get(refCount);
                            if (refCount.getCount() - i <= 0) continue;
                            it.remove();
                        }
                    }
                }
            }
        }
        return new ArrayList<FileTarget>(this._fileTargets);
    }

    public Map<DeInstallRefCount, Integer> getAffectedRefCounts() {
        return this._affectedRefCounts;
    }
}

