/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.deinstallation;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.dao.IDataHandlerWrapper;
import com.oracle.cie.dependency.DependencyException;
import com.oracle.cie.gdr.ComponentLoader;
import com.oracle.cie.gdr.ComponentTarget;
import com.oracle.cie.gdr.DistributionTarget;
import com.oracle.cie.gdr.Home;
import com.oracle.cie.gdr.MetaDataHome;
import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.dbd.DirectoryMap;
import com.oracle.cie.gdr.dao.dbd.FeatureSetReference;
import com.oracle.cie.gdr.dao.dei.DeInstallInfo;
import com.oracle.cie.gdr.dao.dei.DeInstallRefCount;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.dao.lbm.LabelMap;
import com.oracle.cie.gdr.dao.rgy.ComponentInfo;
import com.oracle.cie.gdr.dao.rgy.DistributionInfo;
import com.oracle.cie.gdr.dao.rgy.FeatureInfo;
import com.oracle.cie.gdr.dao.rgy.PatchInfo;
import com.oracle.cie.gdr.dao.rgy.Registry;
import com.oracle.cie.gdr.dao.rgy.SessionInfo;
import com.oracle.cie.gdr.deinstallation.DeInstallationSession;
import com.oracle.cie.gdr.deinstallation.DeInstaller;
import com.oracle.cie.gdr.deinstallation.DeInstallerComponentTarget;
import com.oracle.cie.gdr.deinstallation.DeInstallerShutdownHook;
import com.oracle.cie.gdr.helpers.ComponentHelper;
import com.oracle.cie.gdr.helpers.DeInstallInfoHelper;
import com.oracle.cie.gdr.helpers.DistributionHelper;
import com.oracle.cie.gdr.helpers.FeatureSetHelper;
import com.oracle.cie.gdr.helpers.LocaleInfoHelper;
import com.oracle.cie.gdr.installation.ReferenceCounter;
import com.oracle.cie.gdr.libraries.LibraryTargetHolder;
import com.oracle.cie.gdr.nio.NioFileLockService;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.selection.Status;
import com.oracle.cie.gdr.services.ServiceHolder;
import com.oracle.cie.gdr.tools.NextGenPropertiesManager;
import com.oracle.cie.gdr.utils.FileUtils;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class CommonDeInstaller
implements DeInstaller {
    private static final Logger _log = Logger.getLogger(CommonDeInstaller.class.getName());
    protected DeInstallationSession _deInstallationSession;
    private ServiceHolder _serviceHolder;
    protected DeInstallInfo _deInstallInfo;
    private Path _deInstallInfoPath;
    private long _preRegistryLength = -1L;
    private boolean _deInstallationStarted;
    private boolean _deInstallationCompleted;
    protected SessionInfo _registrySession;
    private Map<FeatureSet, ReferenceCounter> _featureRefCounters = new HashMap<FeatureSet, ReferenceCounter>();
    private Map<Component, ReferenceCounter> _componentRefCounters = new HashMap<Component, ReferenceCounter>();
    private Map<ComponentTarget, ReferenceCounter> _componentTargetRefCounters = new HashMap<ComponentTarget, ReferenceCounter>();
    private Collection<FeatureSet> _removedFeatures = new ArrayList<FeatureSet>();
    private Collection<Component> _removedComponents = new ArrayList<Component>();

    public CommonDeInstaller(DeInstallationSession deInstallationSession) throws GdrException, IOException, DataHandlerException {
        if (deInstallationSession == null) {
            GdrException ex = new GdrException("The DeInstallationSession provided was null.");
            _log.throwing(CommonDeInstaller.class.getName(), "CommonDeInstaller", ex);
            throw ex;
        }
        this._deInstallationSession = deInstallationSession;
        HashSet<Integer> platforms = new HashSet<Integer>();
        platforms.add(this.getHome().getRegistry().getPlatform());
        HashSet<Integer> locales = new HashSet<Integer>();
        locales.addAll(LocaleInfoHelper.getInstance().getSupportedLanguagesIds());
        this._serviceHolder = new ServiceHolder(platforms, locales, null);
        this._deInstallInfoPath = DeInstallInfoHelper.getInstance(this.getHome().getClassLoader()).getDeInstallInfoFilePath(this._deInstallationSession.getHome().getInventoryDirectoryPath());
        if (Files.exists(this._deInstallInfoPath, new LinkOption[0])) {
            this._deInstallInfo = DeInstallInfoHelper.getInstance(this.getHome().getClassLoader()).getDeInstallInfo(this._deInstallInfoPath);
        }
    }

    @Override
    public DeInstallationSession getDeInstallationSession() {
        return this._deInstallationSession;
    }

    public MetaDataHome getMetaDataHome() {
        return this._deInstallationSession.getMetaDataHome();
    }

    @Override
    public Home getHome() {
        return this._deInstallationSession.getHome();
    }

    @Override
    public File getHomeDir() {
        return this.getHome().getHome();
    }

    @Override
    public Path getHomeDirPath() {
        return this.getHome().getHomePath();
    }

    public ServiceHolder getServiceHolder() {
        return this._serviceHolder;
    }

    @Override
    public Registry getRegistry() {
        return this.getHome().getRegistry();
    }

    @Override
    public File getRegistryFile() {
        return this.getRegistryPath().toFile();
    }

    @Override
    public Path getRegistryPath() {
        return this.getHome().getRegistryFilePath();
    }

    @Override
    public File getPreRegistryFile() {
        return this.getPreRegistryPath().toFile();
    }

    @Override
    public Path getPreRegistryPath() {
        return this.getHome().getInventoryDirectoryPath().resolve("registry.pre");
    }

    public File getDeInstallInfoFile() {
        return this.getDeInstallInfoPath().toFile();
    }

    public Path getDeInstallInfoPath() {
        return this._deInstallInfoPath;
    }

    @Override
    public DeInstallInfo getDeInstallInfo() {
        return this._deInstallInfo;
    }

    Collection<Component> getRemovedComponents() {
        return this._removedComponents;
    }

    Collection<FeatureSet> getRemovedFeatures() {
        return this._removedFeatures;
    }

    public Map<FeatureSet, LibraryTargetHolder> getLibraryTargets() throws DependencyException, IOException, DataHandlerException, GdrException {
        LinkedHashMap<FeatureSet, LibraryTargetHolder> libraryTargets = new LinkedHashMap<FeatureSet, LibraryTargetHolder>();
        Set<FeatureSet> features = this.getSelectedFeatures();
        LabelMap labelMap = null;
        Collection<DistributionTarget> distributions = this.getAffectedDistributions();
        for (DistributionTarget dist : distributions) {
            DirectoryMap dirMap = dist.getDirectoryMap();
            ComponentLoader _componentLoader = new ComponentLoader(this.getMetaDataHome(), new ServiceHolder(), Mode.DEINSTALL, features, dirMap, null, labelMap);
            libraryTargets.putAll(FeatureSetHelper.getInstance(this.getHome().getClassLoader()).getLibraryTargets(features, this.getHome(), _componentLoader.getComponentsMap(), new ServiceHolder(), dirMap));
        }
        return libraryTargets;
    }

    protected boolean isForcedDeInstall() {
        return false;
    }

    abstract int getFeatureRemainingRefCount(FeatureSet var1);

    abstract Collection<DistributionTarget> getAffectedDistributions();

    public abstract List<Component> getSelectedComponents(FeatureSet var1);

    protected abstract void updateRegistry(Registry var1, SessionInfo var2);

    protected void updateRegistryForPatches(Registry registry, SessionInfo session, List<Component> components) {
        for (DistributionTarget affectedDistributionTarget : this.getAffectedDistributions()) {
            DistributionInfo dinfo = this.getHome().getRegistryHelper().getDistributionInfo(registry, affectedDistributionTarget.getDistributionName(), affectedDistributionTarget.getDistributionVersion());
            if (null == dinfo) continue;
            List<FeatureInfo> finfos = dinfo.getFeatures();
            Set<FeatureSet> selectedFeaturesForRemoval = this.getSelectedFeatures();
            dinfo.addSession(session);
            for (FeatureSet feature : selectedFeaturesForRemoval) {
                FeatureInfo finfo = this.getHome().getRegistryHelper().getFeatureInfo(finfos, feature.getName(), feature.getVersion());
                if (finfo == null) continue;
                List<ComponentInfo> cinfos = finfo.getComponents();
                for (Component removeComp : components) {
                    ComponentInfo rComp = new ComponentInfo(this.getHome().getRegistryHelper().getClassLoader(), removeComp.getName(), removeComp.getVersion());
                    for (ComponentInfo cinfo : cinfos) {
                        if (!cinfo.equals(rComp)) continue;
                        List<PatchInfo> pinfos = cinfo.getPatches();
                        for (PatchInfo pinfo : pinfos) {
                            pinfo.setStatus(Status.notinstalled);
                            pinfo.addSession(session);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void startDeInstall() throws GdrException {
        if (this._deInstallationCompleted) {
            GdrException ex = new GdrException("The deInstallation was already completed.");
            _log.throwing(CommonDeInstaller.class.getName(), "startDeInstall", ex);
            throw ex;
        }
        Path preRegistryPath = this.getPreRegistryPath();
        try {
            if (!NioFileLockService.getFileLock((Path)preRegistryPath)) {
                GdrException ex = new GdrException("Unable to obtain lock on pre-registry.");
                _log.throwing(CommonDeInstaller.class.getName(), "startDeInstall", ex);
                throw ex;
            }
            FileChannel fc = NioFileLockService.getFileChannel((Path)preRegistryPath);
            Registry preRegistry = fc.size() > 0L ? this.getHome().getRegistryHelper().getRegistry(fc) : new Registry(this.getRegistry().getDataHandler().copy());
            this._registrySession = this.getRegistrySession(preRegistry);
            this.updateRegistry(preRegistry, this._registrySession);
            this.getHome().getRegistryHelper().save((IDataHandlerWrapper)preRegistry, fc);
            this._preRegistryLength = Files.size(preRegistryPath);
            NioFileLockService.releaseFileLock((Path)preRegistryPath);
        }
        catch (IOException e) {
            throw new GdrException((Throwable)e);
        }
        catch (DataHandlerException e) {
            throw new GdrException((Throwable)e);
        }
        this._deInstallationStarted = true;
    }

    protected SessionInfo getRegistrySession(Registry preRegistry) throws GdrException {
        return this.getHome().getRegistryHelper().getRegistrySession(preRegistry, Mode.DEINSTALL);
    }

    @Override
    public void completeDeInstall() throws GdrException {
        block13: {
            if (!this._deInstallationStarted) {
                GdrException ex = new GdrException("The deInstallation was not started.");
                _log.throwing(CommonDeInstaller.class.getName(), "completeDeInstall", ex);
                throw ex;
            }
            if (!(this._featureRefCounters.isEmpty() && this._componentRefCounters.isEmpty() && this._componentTargetRefCounters.isEmpty())) {
                GdrException ex = new GdrException("The feature or component deInstallation was never finished.");
                _log.throwing(CommonDeInstaller.class.getName(), "completeDeInstall", ex);
                throw ex;
            }
            Path preRegistryPath = this.getPreRegistryPath();
            try {
                DeInstallInfoHelper.getInstance(this.getHome().getClassLoader()).saveDeInstallInfo(this._deInstallInfo, this._deInstallInfoPath);
                if (!Files.exists(preRegistryPath, new LinkOption[0])) {
                    GdrException ex = new GdrException("The pre-registry does not exist.");
                    _log.throwing(CommonDeInstaller.class.getName(), "completeDeInstall", ex);
                    throw ex;
                }
                long preRegistryLength = Files.size(preRegistryPath);
                Registry registry = this.getLockedRegistry();
                if (!NioFileLockService.getFileLock((Path)preRegistryPath)) {
                    GdrException ex = new GdrException("Unable to obtain lock on pre-registry.");
                    _log.throwing(CommonDeInstaller.class.getName(), "completeDeInstall", ex);
                    throw ex;
                }
                registry.setSessions(this._registrySession.getId());
                this.updateRegistry(registry, this._registrySession);
                this.saveHomeMetadata(this.getHome().getInventoryDirectoryPath());
                if (this._preRegistryLength > -1L && this._preRegistryLength == preRegistryLength) {
                    FileChannel fc = NioFileLockService.getFileChannel((Path)preRegistryPath);
                    fc.truncate(0L);
                    NioFileLockService.releaseFileLock((Path)preRegistryPath);
                    Files.delete(preRegistryPath);
                } else {
                    NioFileLockService.releaseFileLock((Path)preRegistryPath);
                }
                this.unlockRegistry();
                int installedFeatures = 0;
                for (DistributionInfo distributionInfo : this.getHome().getRegistry().getDistributions()) {
                    installedFeatures += distributionInfo.getFeatures().size();
                }
                if (installedFeatures != 0) break block13;
                this.cleanInventoryFiles(this.getHome().getInventoryDirectoryPath());
                Path oracleHome = this.getHomeDirPath();
                this.cleanGlobalEnvProperties(oracleHome);
                try {
                    Files.delete(oracleHome);
                }
                catch (DirectoryNotEmptyException directoryNotEmptyException) {
                    // empty catch block
                }
                if (Files.exists(oracleHome, new LinkOption[0])) {
                    DeInstallerShutdownHook.add(oracleHome, false);
                }
            }
            catch (IOException e) {
                throw new GdrException((Throwable)e);
            }
            catch (DataHandlerException e) {
                throw new GdrException((Throwable)e);
            }
        }
        this._deInstallationStarted = false;
        this._deInstallationCompleted = true;
    }

    protected void unlockRegistry() throws IOException, DataHandlerException, GdrException {
        this.getHome().unlockRegistry();
    }

    protected Registry getLockedRegistry() throws IOException, DataHandlerException, GdrException {
        return this.getHome().lockRegistry();
    }

    private void cleanGlobalEnvProperties(Path oracleHome) throws IOException {
        Path propertiesDirectory = oracleHome.resolve(NextGenPropertiesManager.PROPERTIES_DIRECTORY);
        Path globalEnvProperties = propertiesDirectory.resolve(".globalEnv.properties");
        if (Files.exists(globalEnvProperties, new LinkOption[0])) {
            try {
                Files.delete(globalEnvProperties);
            }
            catch (FileSystemException fileSystemException) {
                // empty catch block
            }
        }
        if (Files.exists(globalEnvProperties, new LinkOption[0])) {
            _log.finest("Adding file to shutdownhook. Failed to delete: " + globalEnvProperties);
            DeInstallerShutdownHook.add(globalEnvProperties, true);
        }
    }

    private void cleanInventoryFiles(Path inventoryFile) throws IOException {
        block17: {
            if (!Files.exists(inventoryFile, new LinkOption[0])) break block17;
            if (Files.isRegularFile(inventoryFile, new LinkOption[0])) {
                try {
                    Files.delete(inventoryFile);
                }
                catch (FileSystemException fileSystemException) {
                    // empty catch block
                }
                if (Files.exists(inventoryFile, new LinkOption[0])) {
                    _log.finest("Adding file to shutdownhook. Failed to delete: " + inventoryFile);
                    DeInstallerShutdownHook.add(inventoryFile, true);
                }
                break block17;
            }
            try (DirectoryStream<Path> inventoryFiles = Files.newDirectoryStream(inventoryFile);){
                if (inventoryFiles != null) {
                    for (Path sub : inventoryFiles) {
                        this.cleanInventoryFiles(sub);
                    }
                }
            }
            try {
                Files.delete(inventoryFile);
                if (Files.exists(inventoryFile, new LinkOption[0])) {
                    _log.finest("Adding file to shutdownhook. Failed to delete: " + inventoryFile);
                    DeInstallerShutdownHook.add(inventoryFile, false);
                }
            }
            catch (DirectoryNotEmptyException e) {
                _log.finest("Adding file to shutdownhook. Failed to delete: " + inventoryFile);
                DeInstallerShutdownHook.add(inventoryFile, false);
            }
        }
    }

    @Override
    public boolean startFeatureDeInstall(FeatureSet feature) throws GdrException {
        if (!this._deInstallationStarted) {
            GdrException ex = new GdrException("The deInstallation was not started.");
            _log.throwing(CommonDeInstaller.class.getName(), "startFeatureDeInstall", ex);
            throw ex;
        }
        if (_log.isLoggable(Level.FINER)) {
            _log.finer("Starting feature deInstall for " + feature);
        }
        if (this._featureRefCounters.remove(feature) != null) {
            GdrException ex = new GdrException("Already deInstalling feature: " + feature);
            _log.throwing(CommonDeInstaller.class.getName(), "startFeatureDeInstall", ex);
            throw ex;
        }
        ReferenceCounter refCounter = ReferenceCounter.getReferenceCounter(this.getHomeDirPath(), ReferenceCounter.RefType.featuresets, feature.getName(), feature.getVersion());
        this._featureRefCounters.put(feature, refCounter);
        return feature.getStatus().isInstalled();
    }

    @Override
    public void completeFeatureDeInstall(FeatureSet feature) throws GdrException {
        ReferenceCounter refCounter;
        if (!this._deInstallationStarted) {
            GdrException ex = new GdrException("The deInstallation was not started.");
            _log.throwing(CommonDeInstaller.class.getName(), "completeFeatureDeInstall", ex);
            throw ex;
        }
        if (_log.isLoggable(Level.FINER)) {
            _log.finer("Completing feature install for " + feature);
        }
        if ((refCounter = this._featureRefCounters.remove(feature)) == null) {
            GdrException ex = new GdrException("Not currently deInstalling feature: " + feature);
            _log.throwing(CommonDeInstaller.class.getName(), "completeFeatureDeInstall", ex);
            throw ex;
        }
        if (this.isForcedDeInstall()) {
            refCounter.setRefCount(this.getFeatureRemainingRefCount(feature));
        } else {
            refCounter.decrement();
        }
        boolean hasNonInstalledReference = false;
        Collection<DistributionTarget> refDistTargets = this.getHome().getReferencingDistributionTargets(feature);
        if (!refDistTargets.isEmpty()) {
            FeatureSetReference quickRef = new FeatureSetReference(feature.getName(), feature.getVersion());
            for (DistributionTarget distTarget : refDistTargets) {
                Set<FeatureSetReference> featureSets = DistributionHelper.getInstance().getFeatureSetReferences(distTarget.getDistribution());
                if (!featureSets.contains((Object)quickRef)) continue;
                hasNonInstalledReference = true;
            }
        }
        if (refCounter.getRefCount() < 1) {
            DeInstallInfoHelper.getInstance(this.getHome().getClassLoader()).removeFeatureSetFiles(this.getDeInstallInfo(), this.getHome(), feature);
            if (!hasNonInstalledReference) {
                this._removedFeatures.add(feature);
            }
        }
        ReferenceCounter.releaseReferenceCounter(refCounter);
    }

    @Override
    public boolean startComponentDeInstall(Component component) throws GdrException {
        boolean proceed;
        if (!this._deInstallationStarted) {
            GdrException ex = new GdrException("The deInstallation was not started.");
            _log.throwing(CommonDeInstaller.class.getName(), "startComponentDeInstall", ex);
            throw ex;
        }
        if (_log.isLoggable(Level.FINER)) {
            _log.finer("Starting component deInstall for " + component);
        }
        if (this._componentRefCounters.get(component) != null) {
            GdrException ex = new GdrException("Already deInstalling component: " + component);
            _log.throwing(CommonDeInstaller.class.getName(), "startComponentDeInstall", ex);
            throw ex;
        }
        ReferenceCounter refCounter = ReferenceCounter.getReferenceCounter(this.getHomeDirPath(), ReferenceCounter.RefType.components, component.getName(), component.getVersion());
        this._componentRefCounters.put(component, refCounter);
        if (component.isReplicable()) {
            Collection<ComponentTarget> targets = component.getComponentTargets();
            for (ComponentTarget target : targets) {
                refCounter = ReferenceCounter.getReferenceCounter(this.getHomeDirPath(), ReferenceCounter.RefType.components, component.getName(), component.getVersion(), target.getReferenceQualifier());
                this._componentTargetRefCounters.put(target, refCounter);
            }
            proceed = true;
        } else {
            proceed = refCounter.getRefCount() < 2;
        }
        return this.isForcedDeInstall() || proceed;
    }

    @Override
    public void completeComponentDeInstall(Component component) throws GdrException {
        ReferenceCounter refCounter;
        if (!this._deInstallationStarted) {
            GdrException ex = new GdrException("The deInstallation was not started.");
            _log.throwing(CommonDeInstaller.class.getName(), "completeComponentDeInstall", ex);
            throw ex;
        }
        if (_log.isLoggable(Level.FINER)) {
            _log.finer("Completing component deInstall for " + component);
        }
        if ((refCounter = this._componentRefCounters.remove(component)) == null) {
            GdrException ex = new GdrException("Not currently DeInstalling component: " + component);
            _log.throwing(CommonDeInstaller.class.getName(), "completeComponentDeInstall", ex);
            throw ex;
        }
        if (component.isReplicable()) {
            Collection<ComponentTarget> targets = component.getComponentTargets();
            for (ComponentTarget target : targets) {
                if (this._componentTargetRefCounters.get(target) == null) continue;
                GdrException ex = new GdrException("Component target deInstallation was never completed: " + target);
                _log.throwing(CommonDeInstaller.class.getName(), "completeComponentDeInstall", ex);
                throw ex;
            }
        }
        if (this.isForcedDeInstall()) {
            refCounter.setRefCount(0);
        } else {
            refCounter.decrement();
        }
        if (refCounter.getRefCount() < 1) {
            DeInstallInfoHelper.getInstance(this.getHome().getClassLoader()).removeComponentFiles(this.getDeInstallInfo(), this.getHome(), component);
            this._removedComponents.add(component);
        }
        ReferenceCounter.releaseReferenceCounter(refCounter);
    }

    @Override
    public boolean startComponentTargetDeInstall(ComponentTarget target) throws GdrException {
        if (!this._deInstallationStarted) {
            GdrException ex = new GdrException("The deInstallation was not started.");
            _log.throwing(CommonDeInstaller.class.getName(), "startComponentTargetDeInstall", ex);
            throw ex;
        }
        if (_log.isLoggable(Level.FINER)) {
            _log.finer("Starting component target deInstall for " + target);
        }
        boolean proceed = true;
        Component component = target.getComponent();
        if (component.isReplicable()) {
            ReferenceCounter refCounter = this._componentTargetRefCounters.get(target);
            if (refCounter == null) {
                GdrException ex = new GdrException("Not currently deInstalling component for target: " + target);
                _log.throwing(CommonDeInstaller.class.getName(), "startComponentTargetDeInstall", ex);
                throw ex;
            }
            proceed = refCounter.getRefCount() < 2;
        }
        return this.isForcedDeInstall() || proceed;
    }

    @Override
    public void completeComponentTargetDeInstall(ComponentTarget target) throws GdrException {
        Component component;
        DeInstallerComponentTarget deInstallTarget;
        Map<DeInstallRefCount, Integer> affected;
        if (!this._deInstallationStarted) {
            GdrException ex = new GdrException("The deInstallation was not started.");
            _log.throwing(CommonDeInstaller.class.getName(), "completeComponentTargetDeInstall", ex);
            throw ex;
        }
        if (_log.isLoggable(Level.FINER)) {
            _log.finer("Completing component target deInstall for " + target);
        }
        if ((affected = (deInstallTarget = (DeInstallerComponentTarget)target).getAffectedRefCounts()) != null && !affected.isEmpty()) {
            for (DeInstallRefCount ref : affected.keySet()) {
                int affect = affected.get(ref);
                int count = ref.getCount();
                if (count <= 0) continue;
                ref.setCount(count - affect);
            }
        }
        if ((component = target.getComponent()).isReplicable()) {
            ReferenceCounter refCounter = this._componentTargetRefCounters.remove(target);
            if (refCounter == null) {
                GdrException ex = new GdrException("Not currently deInstalling component target: " + target);
                _log.throwing(CommonDeInstaller.class.getName(), "completeComponentTargetDeInstall", ex);
                throw ex;
            }
            if (this.isForcedDeInstall()) {
                refCounter.setRefCount(0);
            } else {
                refCounter.decrement();
            }
            ReferenceCounter.releaseReferenceCounter(refCounter);
        }
    }

    void saveHomeMetadata(File dir) throws GdrException, DataHandlerException, IOException {
        this.saveHomeMetadata(NioHelper.getInstance().getPath(dir));
    }

    void saveHomeMetadata(Path dir) throws GdrException, DataHandlerException, IOException {
        Path refCountDir;
        Collection<FeatureSet> removedFeatures;
        boolean allAffectedDistributionsRemoved = true;
        for (DistributionTarget distribution : this.getAffectedDistributions()) {
            DistributionInfo dinfo = this.getHome().getRegistryHelper().getDistributionInfo(this.getRegistry(), distribution.getDistributionName(), distribution.getDistributionVersion());
            List<FeatureInfo> finfos = dinfo.getFeatures();
            boolean distributionEmpty = true;
            for (FeatureInfo finfo : finfos) {
                if (!finfo.getStatus().isInstalled()) continue;
                distributionEmpty = false;
                break;
            }
            if (distributionEmpty) {
                DistributionHelper.getInstance(this.getHome().getClassLoader()).removeDistribution(distribution.getDistribution(), dir);
            } else {
                allAffectedDistributionsRemoved = false;
            }
            this.deleteRemovedComponentsMetadata(dir);
        }
        if (allAffectedDistributionsRemoved && !(removedFeatures = this.getRemovedFeatures()).isEmpty()) {
            FeatureSetHelper.getInstance(this.getHome().getClassLoader()).removeFeatureSets(removedFeatures, dir);
        }
        if (Files.exists(refCountDir = ReferenceCounter.getReferenceCountDirectory(this.getHomeDirPath(), ReferenceCounter.RefType.featuresets), new LinkOption[0]) && FileUtils.isDirectoryEmpty(refCountDir)) {
            Files.delete(refCountDir);
        }
        if (Files.exists(refCountDir = ReferenceCounter.getReferenceCountDirectory(this.getHomeDirPath(), ReferenceCounter.RefType.components).getParent(), new LinkOption[0]) && FileUtils.isDirectoryEmpty(refCountDir)) {
            Files.delete(refCountDir);
        }
        DeInstallInfoHelper.getInstance(this.getHome().getClassLoader()).saveDeInstallInfo(this._deInstallInfo, this.getDeInstallInfoPath());
        Path deinstallInfoPath = this.getDeInstallInfoPath().getParent();
        if (Files.exists(deinstallInfoPath, new LinkOption[0]) && FileUtils.isDirectoryEmpty(deinstallInfoPath)) {
            Files.delete(deinstallInfoPath);
        }
        if (Files.exists(dir, new LinkOption[0]) && FileUtils.isDirectoryEmpty(dir)) {
            Files.delete(dir);
        }
    }

    protected void deleteRemovedComponentsMetadata(Path dir) {
        Collection<Component> removedComponents = this.getRemovedComponents();
        if (!removedComponents.isEmpty()) {
            ComponentHelper.getInstance(this.getHome().getClassLoader()).removeComponents(removedComponents, dir);
        }
    }

    public boolean deinstallPatches(Component component) throws GdrException {
        Path registryFile = this.getRegistryPath();
        Path preRegistryPath = this.getPreRegistryPath();
        try {
            if (Files.notExists(preRegistryPath, new LinkOption[0])) {
                GdrException ex = new GdrException("The pre-registry does not exist.");
                _log.throwing(CommonDeInstaller.class.getName(), "deInstallPatches", ex);
                throw ex;
            }
            long preRegistryLength = Files.size(preRegistryPath);
            Registry registry = this.getLockedRegistry();
            if (!NioFileLockService.getFileLock((Path)preRegistryPath)) {
                GdrException ex = new GdrException("Unable to obtain lock on pre-registry.");
                _log.throwing(CommonDeInstaller.class.getName(), "deInstallPatches", ex);
                throw ex;
            }
            registry.setSessions(this._registrySession.getId());
            this.updateRegistryForPatches(registry, this._registrySession, Arrays.asList(component));
            this.saveHomeMetadata(this.getHome().getInventoryDirectoryPath());
            this.unlockRegistry();
            if (this._preRegistryLength > -1L && this._preRegistryLength == preRegistryLength) {
                FileChannel fc = NioFileLockService.getFileChannel((Path)preRegistryPath);
                fc.truncate(0L);
                NioFileLockService.releaseFileLock((Path)preRegistryPath);
                Files.delete(preRegistryPath);
            } else {
                NioFileLockService.releaseFileLock((Path)preRegistryPath);
            }
            NioFileLockService.releaseFileLock((Path)registryFile);
        }
        catch (IOException e) {
            throw new GdrException((Throwable)e);
        }
        catch (DataHandlerException e) {
            throw new GdrException((Throwable)e);
        }
        this._deInstallationStarted = false;
        this._deInstallationCompleted = true;
        return true;
    }
}

