/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.dao.rgy;

import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.gdr.ComponentTarget;
import com.oracle.cie.gdr.dao.rgy.BaseInfoImpl;
import com.oracle.cie.gdr.helpers.RegistryHelper;

public class TargetInfo
extends BaseInfoImpl {
    public TargetInfo(IDataHandler dataHandler) {
        super(dataHandler);
    }

    public TargetInfo(ClassLoader classLoader) {
        this(RegistryHelper.getInstance(classLoader).create("target-info"));
    }

    public TargetInfo(ClassLoader classLoader, ComponentTarget componentTarget) {
        this(classLoader);
        if (componentTarget == null) {
            throw new NullPointerException("The component target specified was null.");
        }
        this.setQualifier(componentTarget.getReferenceQualifier());
        this.setSource(componentTarget.getSource());
        this.setSymbol(componentTarget.getSymbol());
        this.setLocation(componentTarget.getLocation());
        this.setDirectoryMap(componentTarget.getDirectoryMapName());
    }

    public void setQualifier(String qualifier) {
        this.setAttribute("qualifier", qualifier);
    }

    public String getQualifier() {
        return this.getStringAttribute("qualifier");
    }

    public void setSource(String source) {
        this.setAttribute("source", source);
    }

    public String getSource() {
        return this.getStringAttribute("source");
    }

    public void setSymbol(String symbol) {
        this.setAttribute("symbol", symbol);
    }

    public String getSymbol() {
        return this.getStringAttribute("symbol");
    }

    public void setLocation(String location) {
        this.setAttribute("location", location);
    }

    public String getLocation() {
        return this.getStringAttribute("location");
    }

    public void setDirectoryMap(String directoryMapName) {
        this.setAttribute("directory-map-name", directoryMapName);
    }

    public String getDirectoryMapName() {
        return this.getStringAttribute("directory-map-name");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !TargetInfo.class.isAssignableFrom(o.getClass())) {
            return false;
        }
        TargetInfo thatTarget = (TargetInfo)o;
        String thisQualifier = this.getQualifier();
        String thatQualifier = thatTarget.getQualifier();
        return !(thisQualifier == null ? thatQualifier != null : !thisQualifier.equals(thatQualifier));
    }

    public int hashCode() {
        String qualifier = this.getQualifier();
        int result = qualifier != null ? qualifier.hashCode() : 0;
        result = 31 * result;
        return result;
    }
}

