/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.dao.rgy;

import com.oracle.cie.common.dao.DataHandlerHelper;
import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.dao.rgy.BaseInfoReference;
import com.oracle.cie.gdr.dao.rgy.FeatureInfo;
import com.oracle.cie.gdr.dao.rgy.ProductFamily;
import com.oracle.cie.gdr.helpers.RegistryHelper;
import com.oracle.cie.gdr.selection.Status;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;

public class DistributionInfo
extends BaseInfoReference {
    public DistributionInfo(IDataHandler dataHandler) {
        super(dataHandler);
    }

    public DistributionInfo(ClassLoader classLoader) {
        this(RegistryHelper.getInstance(classLoader).create("distribution-info"));
    }

    public DistributionInfo(ClassLoader classLoader, String name, String version) {
        this(classLoader);
        this.setName(name);
        this.setVersion(version);
    }

    public Calendar getInstallDate() {
        return this.getCalendarAttribute("install-date");
    }

    public void setInstallDate(Calendar date) {
        this.setAttribute("install-date", date);
    }

    public List<ProductFamily> getProductFamilies() {
        return DataHandlerHelper.getWrapperList((IDataHandler)this.getSingleOccuranceComplexValue("product-families"), (String)"product-family", ProductFamily.class);
    }

    public void setProductFamilies(List<ProductFamily> productFamilies) {
        DataHandlerHelper.setWrapperList((IDataHandler)this.getSingleOccuranceComplexValue("product-families", true), (String)"product-family", productFamilies);
    }

    public void setProductFamiliesStrings(Collection<String> prodFams) {
        ArrayList<ProductFamily> productFamilies = null;
        if (prodFams != null && !prodFams.isEmpty()) {
            productFamilies = new ArrayList<ProductFamily>();
            for (String productFamily : prodFams) {
                ProductFamily prodFamily = new ProductFamily(this.getObjectClassLoader());
                prodFamily.setName(productFamily);
                productFamilies.add(prodFamily);
            }
        }
        this.setProductFamilies(productFamilies);
    }

    public List<FeatureInfo> getFeatures() {
        return DataHandlerHelper.getWrapperList((IDataHandler)this.getSingleOccuranceComplexValue("features"), (String)"feature", FeatureInfo.class);
    }

    public void setFeatures(List<FeatureInfo> features) {
        DataHandlerHelper.setWrapperList((IDataHandler)this.getSingleOccuranceComplexValue("features", true), (String)"feature", features);
    }

    public void addFeature(FeatureInfo feature) {
        this.getSingleOccuranceComplexValue("features", true).addComplexValue("feature", feature.getDataHandler());
    }

    public FeatureInfo addFeature(FeatureSet feature) {
        FeatureInfo ref = new FeatureInfo(this.getObjectClassLoader(), feature.getName(), feature.getVersion());
        this.addFeature(ref);
        return ref;
    }

    public void addFeatures(List<FeatureSet> features, boolean excludeDups) {
        if (excludeDups) {
            List<FeatureInfo> current = this.getFeatures();
            for (FeatureSet feature : features) {
                FeatureInfo ref = new FeatureInfo(this.getObjectClassLoader(), feature.getName(), feature.getVersion());
                if (current != null && current.contains(ref)) continue;
                ref.setStatus(Status.installed);
                this.addFeature(ref);
            }
        } else {
            for (FeatureSet feature : features) {
                FeatureInfo ref = new FeatureInfo(this.getObjectClassLoader(), feature.getName(), feature.getVersion());
                ref.setStatus(Status.installed);
                this.addFeature(ref);
            }
        }
    }

    public void removeFeatures(List<FeatureSet> features) {
        if (features != null) {
            for (FeatureSet feature : features) {
                this.removeFeatureInfo(new FeatureInfo(this.getObjectClassLoader(), feature.getName(), feature.getVersion()));
            }
        }
    }

    public void removeFeatureInfo(FeatureInfo featureInfo) {
        List<FeatureInfo> current = this.getFeatures();
        if (current != null && !current.isEmpty()) {
            int origSize = current.size();
            current.remove(featureInfo);
            if (current.size() < origSize) {
                this.setFeatures(current);
            }
        }
    }
}

