/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.dao.pad;

import com.oracle.cie.common.dao.AbstractDataHandlerWrapper;
import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.Wildcard;
import com.oracle.cie.gdr.dao.pad.FileBase;

public class MatchBase
extends AbstractDataHandlerWrapper {
    protected String _regex;
    protected String _wildcard;
    protected String _dest = this.getStringAttribute("dest");
    protected boolean _destSet = this._dest != null;
    protected boolean _regexSet;
    protected boolean _wildcardSet;
    protected Wildcard _wildcardObj;

    protected MatchBase(IDataHandler dataHandler) {
        super(dataHandler);
        this._regex = this.getStringAttribute("regex");
        this._regexSet = !StringUtil.isNullOrEmpty((String)this._regex, (boolean)true);
        this._wildcard = this.getStringAttribute("wildcard");
        this._wildcardSet = !StringUtil.isNullOrEmpty((String)this._wildcard, (boolean)true);
    }

    public String getRegex() {
        return this._regex;
    }

    public void setRegex(String regex) {
        this._regex = regex;
        this._regexSet = !StringUtil.isNullOrEmpty((String)this._regex, (boolean)true);
        this.setAttribute("regex", regex);
    }

    public String getWildcard() {
        return this._wildcard;
    }

    public void setWildcard(String wildcard) {
        this._wildcard = wildcard;
        this._wildcardSet = !StringUtil.isNullOrEmpty((String)this._wildcard, (boolean)true);
        this.setAttribute("wildcard", wildcard);
    }

    public String getDest() {
        return this._dest;
    }

    public void setDest(String dest) {
        this._dest = dest;
        this._destSet = this._dest != null;
        this.setAttribute("dest", dest);
    }

    public boolean matches(String value) {
        if (value == null) {
            return false;
        }
        if (this._destSet) {
            return value.equals(this.getDest());
        }
        if (this._regexSet) {
            return value.matches(this.getRegex().trim());
        }
        if (this._wildcardSet) {
            if (this._wildcardObj == null) {
                this._wildcardObj = new Wildcard(this.getWildcard());
            }
            return this._wildcardObj.matches(value);
        }
        return false;
    }

    public boolean isEmpty() {
        return StringUtil.isNullOrEmpty((String)this.getDest(), (boolean)true) && StringUtil.isNullOrEmpty((String)this.getWildcard(), (boolean)true) && StringUtil.isNullOrEmpty((String)this.getRegex(), (boolean)true);
    }

    public int hashCode() {
        String name = this.getDest();
        String wildcard = this.getWildcard();
        String regex = this.getRegex();
        int result = regex != null ? regex.hashCode() : 0;
        result = 31 * result + (wildcard != null ? wildcard.hashCode() : 0);
        result = 31 * result + (name != null ? name.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !o.getClass().isAssignableFrom(((Object)((Object)this)).getClass())) {
            return false;
        }
        FileBase baseSelect = (FileBase)((Object)o);
        String name = this.getDest();
        String theirName = baseSelect.getDest();
        String wildcard = this.getWildcard();
        String theirWildcard = baseSelect.getWildcard();
        String regex = this.getRegex();
        String theirRegex = baseSelect.getRegex();
        if (name != null && theirName != null && !name.equals(theirName)) {
            return false;
        }
        if (wildcard != null && theirWildcard != null && !wildcard.equals(theirWildcard)) {
            return false;
        }
        return regex == null || theirRegex == null || regex.equals(theirRegex);
    }
}

