/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.dao.lbm;

import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.gdr.dao.cmn.Reference;
import com.oracle.cie.gdr.helpers.LabelMapHelper;

public class LabelMapReference
extends Reference {
    public LabelMapReference(IDataHandler dataHandler) {
        super(dataHandler);
    }

    public LabelMapReference() {
        this(LabelMapHelper.getInstance().create("http://xmlns.oracle.com/cie/gdr/lbm", "label-map-ref"));
    }

    public LabelMapReference(String name, String version) {
        this();
        this.setName(name);
        this.setVersion(version);
    }

    public String getTopLevelDir() {
        return this.getStringAttribute("top-level-dir");
    }

    public void setTopLevelDir(String topLevelDir) {
        this.setAttribute("top-level-dir", topLevelDir);
    }

    public boolean isExtension() {
        return this.getBooleanAttribute("extension");
    }

    public void setExtension(boolean extension) {
        this.setAttribute("extension", extension);
    }

    public boolean isCarb() {
        return this.getBooleanAttribute("carb");
    }

    public void setCarb(boolean carb) {
        this.setAttribute("carb", carb);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !LabelMapReference.class.isAssignableFrom(o.getClass())) {
            return false;
        }
        LabelMapReference reference = (LabelMapReference)((Object)o);
        String name = this.getName();
        String version = this.getVersion();
        String tld = this.getTopLevelDir();
        String otherName = reference.getName();
        String otherVersion = reference.getVersion();
        String otherTld = reference.getTopLevelDir();
        return !((name == null ? otherName != null : !name.equals(otherName)) || (version == null ? otherVersion != null : !version.equals(otherVersion)) || (tld == null ? otherTld != null : !tld.equals(otherTld)));
    }

    @Override
    public int hashCode() {
        String name = this.getName();
        String version = this.getVersion();
        String tld = this.getTopLevelDir();
        int result = name != null ? name.hashCode() : 0;
        result = 31 * result + (version != null ? version.hashCode() : 0);
        result = 31 * result + (tld != null ? tld.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return super.toString() + " top-level-dir=" + this.getTopLevelDir() + " extension=" + this.isExtension();
    }
}

