/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.dao.inv;

import com.oracle.cie.common.dao.AbstractDataHandlerWrapper;
import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.common.dao.IDataHandlerWrapper;
import com.oracle.cie.gdr.dao.inv.ComponentGroupReference;
import com.oracle.cie.gdr.helpers.InventoryHelper;

public class FeatureSetReference
extends AbstractDataHandlerWrapper {
    public FeatureSetReference(IDataHandler dataHandler) {
        super(dataHandler);
    }

    public FeatureSetReference(String name, String version, String type, String subtype) {
        this(InventoryHelper.getInstance().create("feature-set"));
        this.setName(name);
        this.setVersion(version);
        this.setType(type);
        this.setSubType(subtype);
    }

    public FeatureSetReference(String name, String version, ComponentGroupReference componentGroup, String type, String subtype) {
        this(InventoryHelper.getInstance().create("feature-set"));
        this.setName(name);
        this.setVersion(version);
        this.setComponentGroup(componentGroup);
        this.setType(type);
        this.setSubType(subtype);
    }

    public String getName() {
        return this.getStringAttribute("name");
    }

    public void setName(String name) {
        this.setAttribute("name", name);
    }

    public String getVersion() {
        return this.getStringAttribute("version");
    }

    public void setVersion(String version) {
        this.setAttribute("version", version);
    }

    public String getType() {
        return this.getStringAttribute("type");
    }

    public void setType(String type) {
        this.setAttribute("type", type);
    }

    public String getSubType() {
        return this.getStringAttribute("sub-type");
    }

    public void setSubType(String subtype) {
        this.setAttribute("sub-type", subtype);
    }

    public void setOracleHomeDiff(String oracleHomeDiff) {
        this.setAttribute("oh-diff", oracleHomeDiff);
    }

    public String getOracleHomeDiff() {
        return this.getStringAttribute("oh-diff");
    }

    public ComponentGroupReference getComponentGroup() {
        return (ComponentGroupReference)((Object)this.getSingleOccuranceComplexValueWrapped("components", ComponentGroupReference.class));
    }

    public void setComponentGroup(ComponentGroupReference componentGroup) {
        this.setSingleOccuranceComplexValueWrapped("components", (IDataHandlerWrapper)componentGroup);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !FeatureSetReference.class.isAssignableFrom(o.getClass())) {
            return false;
        }
        FeatureSetReference reference = (FeatureSetReference)((Object)o);
        String name = this.getName();
        String version = this.getVersion();
        String otherName = reference.getName();
        String otherVersion = reference.getVersion();
        return !(name == null ? otherName != null : !name.equals(otherName)) && !(version == null ? otherVersion != null : !version.equals(otherVersion));
    }

    public int hashCode() {
        String name = this.getName();
        String version = this.getVersion();
        int result = name != null ? name.hashCode() : 0;
        result = 31 * result + (version != null ? version.hashCode() : 0);
        return result;
    }

    public String toString() {
        String version = this.getVersion();
        if (version == null) {
            return this.getName();
        }
        return this.getName() + " " + version;
    }
}

