/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.dao.dbd;

import com.oracle.cie.common.util.StringUtil;

public class MappingSymbol {
    private String _symbol;
    private boolean _regex = false;

    public MappingSymbol(String symbol) {
        this(symbol, false);
    }

    public MappingSymbol(String symbol, boolean regex) {
        this.setSymbol(symbol);
        if (regex) {
            this.setRegex(true);
        }
    }

    public String getSymbol() {
        return this._symbol;
    }

    public void setSymbol(String symbol) {
        this._symbol = symbol;
    }

    public boolean isRegex() {
        return this._regex;
    }

    public void setRegex(boolean regex) {
        this._regex = regex;
    }

    public boolean matches(String symbol) {
        String sym = this.getSymbol();
        boolean regex = this.isRegex();
        return !StringUtil.isNullOrEmpty((String)symbol, (boolean)true) && (regex && symbol.matches(sym) || !regex && symbol.equals(sym));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !MappingSymbol.class.isAssignableFrom(o.getClass())) {
            return false;
        }
        MappingSymbol that = (MappingSymbol)o;
        if (this.isRegex() != that.isRegex()) {
            return false;
        }
        String thisSymbol = this.getSymbol();
        String thatSymbol = that.getSymbol();
        return !(thisSymbol != null ? !thisSymbol.equals(thatSymbol) : thatSymbol != null);
    }

    public int hashCode() {
        String symbol = this.getSymbol();
        int result = symbol != null ? symbol.hashCode() : 0;
        result = 31 * result + (this.isRegex() ? 1 : 0);
        return result;
    }
}

