/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.dao.dbd;

import com.oracle.cie.common.dao.AbstractDataHandlerWrapper;
import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.dao.cmn.ResourceBundleInfo;
import com.oracle.cie.gdr.dao.dbd.FeatureSetReference;
import com.oracle.cie.gdr.helpers.DistributionHelper;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class InstallType
extends AbstractDataHandlerWrapper {
    private ResourceBundleInfo _resourceBundleInfo;
    private String _incompatible;
    private boolean _installed = false;
    private boolean _fullyInstalled = false;
    private Set<FeatureSetReference> _fullFeatures = new LinkedHashSet<FeatureSetReference>();

    public boolean isFullyInstalled() {
        return this._fullyInstalled;
    }

    public void setFullyInstalled(boolean _fullyInstalled) {
        this._fullyInstalled = _fullyInstalled;
    }

    public InstallType(IDataHandler dataHandler) {
        super(dataHandler);
    }

    public InstallType(String name) {
        this(DistributionHelper.getInstance().create("install-type"));
        this.setName(name);
    }

    public List<FeatureSetReference> getFeatures() {
        return this.getComplexValueWrappedList("feature-set", FeatureSetReference.class);
    }

    public String getName() {
        return this.getStringAttribute("name");
    }

    public void setName(String name) {
        this.setAttribute("name", name);
    }

    public String getExternalName() {
        return this.getStringAttribute("external-name");
    }

    public String getExternalNameKey() {
        return this.getStringAttribute("external-name-key");
    }

    public String getLocalizedExternalName() {
        return ResourceBundleInfo.getLocalizedString(this.getResourceBundleInfo(), this.getExternalNameKey(), this.getExternalName());
    }

    public String getDescriptionKey() {
        return this.getStringAttribute("description-key");
    }

    public String getLocalizedDescription() {
        return ResourceBundleInfo.getLocalizedString(this.getResourceBundleInfo(), this.getDescriptionKey(), this.getName());
    }

    public boolean isDefault() {
        return this.getBooleanAttribute("default");
    }

    public void setDefault(boolean def) {
        this.setAttribute("default", def);
    }

    public boolean isCustom() {
        return this.getBooleanAttribute("custom");
    }

    public void setCustom(boolean custom) {
        this.setAttribute("custom", custom);
    }

    public ResourceBundleInfo getResourceBundleInfo() {
        return this._resourceBundleInfo;
    }

    public void setResourceBundleInfo(ResourceBundleInfo resourceBundleInfo) {
        this._resourceBundleInfo = resourceBundleInfo;
    }

    public boolean isIncompatible() {
        return this._incompatible != null;
    }

    public String getIncompatibility() {
        return this._incompatible;
    }

    public void setIncompatible(String incompatible) {
        this._incompatible = incompatible;
    }

    public void setInstalled(boolean installed) {
        this._installed = installed;
    }

    public boolean isInstalled() {
        return this._installed;
    }

    public Set<FeatureSetReference> getFullFeatures() {
        return this._fullFeatures;
    }

    public void setFullFeatures(Set<FeatureSetReference> fullFeatures) {
        this._fullFeatures = fullFeatures;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        InstallType that = (InstallType)((Object)o);
        String thisName = this.getName();
        String thatName = that.getName();
        return !(thisName != null ? !thisName.equals(thatName) : thatName != null);
    }

    public int hashCode() {
        String name = this.getName();
        return name != null ? name.hashCode() : 0;
    }

    public String toString() {
        String name = this.getLocalizedExternalName();
        if (StringUtil.isNullOrEmpty((String)name, (boolean)true)) {
            name = this.getName();
        }
        return name;
    }
}

