/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.dao.cpd;

import com.oracle.cie.common.dao.AbstractDataHandlerWrapper;
import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.common.dao.IDataHandlerWrapper;
import com.oracle.cie.gdr.dao.cpd.ValueQuery;
import com.oracle.cie.gdr.helpers.ComponentHelper;

public class Variable
extends AbstractDataHandlerWrapper {
    private boolean _valueResolved;
    private Object _resolvedValue;

    public Variable(IDataHandler dataHandler) {
        super(dataHandler);
    }

    public Variable() {
        this(ComponentHelper.getInstance().create("variable"));
    }

    public Variable(String name, String value) {
        this();
        this.setName(name);
        this.setValue(value);
    }

    public ValueQuery getValueQuery() {
        return (ValueQuery)((Object)this.getSingleOccuranceComplexValueWrapped("value-query", ValueQuery.class));
    }

    public void setValueQuery(ValueQuery valueQuery) {
        this.setSingleOccuranceComplexValueWrapped("value-query", (IDataHandlerWrapper)valueQuery);
    }

    public boolean isValueResolved() {
        return this._valueResolved;
    }

    public Object getResolvedValue() {
        return this._resolvedValue;
    }

    public void setResolvedValue(Object resolvedValue) {
        this._resolvedValue = resolvedValue;
        this._valueResolved = true;
    }

    public String getName() {
        return this.getStringAttribute("name");
    }

    public void setName(String name) {
        this.setAttribute("name", name);
    }

    public String getValue() {
        return this.getStringAttribute("value");
    }

    public void setValue(String value) {
        this.setAttribute("value", value);
    }

    public String getType() {
        return this.getStringAttribute("type");
    }

    public String getClazz() {
        return this.getStringAttribute("class");
    }

    public String getMethod() {
        return this.getStringAttribute("method");
    }

    public String getClasspath() {
        return this.getStringAttribute("classpath");
    }

    public boolean isReadOnly() {
        return this.getBooleanAttribute("read-only");
    }

    public boolean isGlobal() {
        return this.getBooleanAttribute("global");
    }

    public boolean isVariableEqual(Variable variable) {
        return variable != null && this.isStringEqual(this.getName(), variable.getName()) && this.isStringEqual(this.getValue(), variable.getValue()) && this.isStringEqual(this.getType(), variable.getType()) && this.isStringEqual(this.getClazz(), variable.getClazz()) && this.isStringEqual(this.getMethod(), variable.getMethod()) && this.isStringEqual(this.getClasspath(), variable.getClasspath()) && this.isReadOnly() == variable.isReadOnly();
    }

    private boolean isStringEqual(String s1, String s2) {
        return s1 == null && s2 == null || s1 != null && s1.equals(s2);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        Variable variable = (Variable)((Object)o);
        String thisName = this.getName();
        String thatName = variable.getName();
        return !(thisName == null ? thatName != null : !thisName.equals(thatName));
    }

    public int hashCode() {
        String name = this.getName();
        return name != null ? name.hashCode() : 0;
    }

    public String toString() {
        return this.isValueResolved() ? this.getResolvedValue() + "" : this.getValue();
    }
}

