/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.dao.cpd;

import com.oracle.cie.common.dao.AbstractDataHandlerWrapper;
import com.oracle.cie.common.dao.DataHandlerHelper;
import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.gdr.dao.cpd.FileModifier;
import com.oracle.cie.gdr.dao.cpd.Permission;
import com.oracle.cie.gdr.dao.cpd.RepoFile;
import com.oracle.cie.gdr.dao.cpd.Rule;
import com.oracle.cie.gdr.helpers.ComponentHelper;
import java.util.List;

public class RepoFileSet
extends AbstractDataHandlerWrapper {
    public RepoFileSet(IDataHandler dataHandler) {
        super(dataHandler);
    }

    public RepoFileSet() {
        super(ComponentHelper.getInstance().create("repo-file-set"));
    }

    public String getId() {
        return this.getStringAttribute("id");
    }

    public void setId(String id) {
        this.setAttribute("id", id);
    }

    public String getDestDir() {
        return this.getStringAttribute("dest-dir");
    }

    public void setDestDir(String dest) {
        this.setAttribute("dest-dir", dest);
    }

    public String getFileNameMapping() {
        return this.getStringAttribute("fileNameMapping");
    }

    public void setFileNameMapping(String fileNameMapping) {
        this.setAttribute("fileNameMapping", fileNameMapping);
    }

    public String getGroup() {
        return this.getStringAttribute("group");
    }

    public void setGroup(String group) {
        this.setAttribute("group", group);
    }

    public String getType() {
        String type = this.getStringAttribute("type");
        if (type != null && type.trim().length() < 1) {
            type = null;
        }
        return type;
    }

    public void setType(String type) {
        this.setAttribute("type", type);
    }

    public String getMode() {
        return this.getStringAttribute("mode");
    }

    public void setMode(String mode) {
        this.setAttribute("mode", mode);
    }

    public List<RepoFile> getRepoFiles() {
        return this.getComplexValueWrappedList("repo-file", RepoFile.class);
    }

    public void setRepoFiles(List<RepoFile> files) {
        this.setComplexValueWrappedList("repo-file", files);
    }

    public List<FileModifier> getModifiers() {
        return this.getComplexValueWrappedList("modifier", FileModifier.class);
    }

    public void setModifiers(List<FileModifier> modifiers) {
        this.setComplexValueWrappedList("modifier", modifiers);
    }

    public List<Rule> getRules() {
        return this.getComplexValueWrappedList("rule", Rule.class);
    }

    public void setRules(List<Rule> rules) {
        this.setComplexValueWrappedList("rule", rules);
    }

    public List<Permission> getPermissions() {
        return DataHandlerHelper.getWrapperList((IDataHandler)this.getSingleOccuranceComplexValue("file-perms"), (String)"permission", Permission.class);
    }

    public void setPermissions(List<Permission> permissions) {
        DataHandlerHelper.setWrapperList((IDataHandler)this.getSingleOccuranceComplexValue("file-perms", true), (String)"permission", permissions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !RepoFileSet.class.isAssignableFrom(o.getClass())) {
            return false;
        }
        RepoFileSet fileSet = (RepoFileSet)((Object)o);
        String thisDest = this.getDestDir();
        String thatDest = fileSet.getDestDir();
        String thisFileNameMapping = this.getFileNameMapping();
        String thatFileNameMapping = fileSet.getFileNameMapping();
        if (thisDest != null ? !thisDest.equals(thatDest) : thatDest != null) {
            return false;
        }
        return !(thisFileNameMapping != null ? !thisFileNameMapping.equals(thatFileNameMapping) : thatFileNameMapping != null);
    }

    public int hashCode() {
        String dest = this.getDestDir();
        String fileNameMapping = this.getFileNameMapping();
        int result = dest != null ? dest.hashCode() : 0;
        result = 31 * result + (fileNameMapping != null ? fileNameMapping.hashCode() : 0);
        return result;
    }
}

