/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.dao.cpd;

import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.common.util.JarHelper;
import com.oracle.cie.gdr.dao.cpd.Include;
import com.oracle.cie.gdr.dao.cpd.Selection;
import com.oracle.cie.gdr.dao.cpd.SelectionRefId;
import com.oracle.cie.gdr.helpers.ComponentHelper;
import com.oracle.cie.gdr.libraries.LibraryHandlerException;
import com.oracle.cie.gdr.utils.GdrException;
import com.oracle.cie.gdr.utils.StagingFileFilter;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.logging.Logger;

public class LibraryEntry
extends SelectionRefId {
    private static final Logger _log = Logger.getLogger(LibraryEntry.class.getName());
    protected boolean _explode;
    protected boolean _includeParent;

    public LibraryEntry(IDataHandler dataHandler) {
        super(dataHandler);
        this._explode = this.getBooleanAttribute("explode");
        this._includeParent = this.getBooleanAttribute("include-parent");
    }

    public LibraryEntry() {
        super(ComponentHelper.getInstance().create("entry"));
    }

    public List<Selection> getIncludes() {
        return this.getComplexValueWrappedList("include", Selection.class);
    }

    public void setIncludes(List<Selection> include) {
        this.setComplexValueWrappedList("include", include);
    }

    public List<Selection> getExcludes() {
        return this.getComplexValueWrappedList("exclude", Selection.class);
    }

    public void setExcludes(List<Selection> exclude) {
        this.setComplexValueWrappedList("exclude", exclude);
    }

    public Boolean getExplode() {
        return this._explode;
    }

    public void setExplode(Boolean explode) {
        this._explode = explode;
        this.setAttribute("explode", explode);
    }

    public Boolean getIncludeParent() {
        return this._includeParent;
    }

    public void setIncludeParent(Boolean includeParent) {
        this._includeParent = includeParent;
        this.setAttribute("include-parent", includeParent);
    }

    public List<Selection> expandIncludes(String sourcepath) throws GdrException {
        LinkedHashSet entries;
        final List<Selection> includes = this.getIncludes();
        final List<Selection> excludes = this.getExcludes();
        if ((includes == null || includes.isEmpty()) && (excludes == null || excludes.isEmpty())) {
            return null;
        }
        LinkedHashSet<Include> expandedIncludes = new LinkedHashSet<Include>();
        try (JarHelper jarFile = null;){
            jarFile = new JarHelper(sourcepath);
            entries = jarFile.getEntries();
            if (entries != null) {
                entries = new LinkedHashSet(entries);
            }
        }
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !file.isDirectory() && StagingFileFilter.accept(file.toPath(), includes, excludes) && !file.getPath().equals("META-INF/MANIFEST.MF");
            }
        };
        if (entries != null) {
            for (String jarEntry : entries) {
                JarEntry je;
                File jarFileEntry = new File(jarEntry, je = new JarEntry(jarEntry)){
                    final /* synthetic */ JarEntry val$je;
                    {
                        this.val$je = jarEntry;
                        super(arg0);
                    }

                    @Override
                    public boolean isDirectory() {
                        return this.val$je.isDirectory();
                    }

                    @Override
                    public boolean isFile() {
                        return !this.isDirectory();
                    }

                    @Override
                    public String getPath() {
                        return this.val$je.getName();
                    }
                };
                if (!filter.accept(jarFileEntry)) continue;
                Include expanded = new Include();
                expanded.setName(jarEntry);
                expanded.setMatchPath(true);
                expandedIncludes.add(expanded);
            }
        }
        if (includes != null) {
            for (Selection include : includes) {
                boolean isWildcard;
                Include namedInclude = new Include(include.getDataHandler());
                boolean bl = isWildcard = namedInclude.getName() == null;
                if (!isWildcard && !expandedIncludes.contains((Object)namedInclude)) {
                    throw new LibraryHandlerException("Incorrect or invalid include entry " + (Object)((Object)namedInclude) + " was not found at library : " + (Object)((Object)this));
                }
                if (!expandedIncludes.isEmpty()) continue;
                if (isWildcard) {
                    _log.warning(sourcepath + " matches library \"" + this.getName() + "\" entries but didn't match include/exclude element criteria " + (Object)((Object)namedInclude) + ". Please verify if the library entries wildcard or regex was correctly defined.");
                    continue;
                }
                throw new LibraryHandlerException("Unable to locate any file corresponding to library " + this.getName() + " includes/excludes in entry " + sourcepath);
            }
        }
        ArrayList<Selection> sorted = new ArrayList<Selection>(expandedIncludes);
        Collections.sort(sorted, new Comparator<Selection>(){

            @Override
            public int compare(Selection o1, Selection o2) {
                String name1 = o1.getName();
                String name2 = o2.getName();
                if (name1 == null) {
                    name1 = "";
                }
                if (name2 == null) {
                    name2 = "";
                }
                return name1.compareTo(name2);
            }
        });
        return sorted;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || !o.getClass().isAssignableFrom(((Object)((Object)this)).getClass())) {
            return false;
        }
        LibraryEntry lib = (LibraryEntry)((Object)o);
        List<Selection> thisIncludes = this.getIncludes();
        List<Selection> thisExcludes = this.getIncludes();
        List<Selection> thatIncludes = lib.getIncludes();
        List<Selection> thatExcludes = lib.getIncludes();
        if (thisIncludes.size() != thatIncludes.size()) {
            return false;
        }
        if (thisExcludes.size() != thatExcludes.size()) {
            return false;
        }
        for (Selection in : thatIncludes) {
            if (thisIncludes.contains((Object)in)) continue;
            return false;
        }
        for (Selection ex : thatExcludes) {
            if (thisExcludes.contains((Object)ex)) continue;
            return false;
        }
        return true;
    }
}

