/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.dao.cpd;

import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.gdr.dao.cmn.LibraryResolvers;
import com.oracle.cie.gdr.dao.cmn.Manifest;
import com.oracle.cie.gdr.dao.cmn.MergedJarClasspath;
import com.oracle.cie.gdr.dao.cmn.Reference;
import com.oracle.cie.gdr.dao.cpd.LibraryEntry;
import com.oracle.cie.gdr.dao.pom.PomArtifact;
import com.oracle.cie.gdr.helpers.ComponentHelper;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Library
extends Reference {
    private static final String LOCATION_SEPARATOR = ",";

    public Library(IDataHandler dataHandler) {
        super(dataHandler);
    }

    public Library() {
        this(ComponentHelper.getInstance().create("library-type"));
    }

    public Library(String name, String type) {
        this();
        this.setName(name);
        this.setType(type);
    }

    public void setType(String type) {
        this.setAttribute("type", type);
    }

    public String getType() {
        return this.getStringAttribute("type");
    }

    public Set<String> getLocation() {
        HashSet<String> locations = new HashSet<String>();
        String location = this.getStringAttribute("location");
        if (location != null) {
            if (!location.contains(LOCATION_SEPARATOR)) {
                locations.add(location);
            } else {
                for (String loc : location.split(LOCATION_SEPARATOR)) {
                    locations.add(loc);
                }
            }
        }
        return locations;
    }

    public String getVisibility() {
        return this.getStringAttribute("visibility");
    }

    public Boolean getSuppressVersion() {
        return this.getBooleanAttribute("suppress-version");
    }

    public Boolean getSuppressPrefix() {
        return this.getBooleanAttribute("suppress-prefix");
    }

    public String getSymbol() {
        return this.getStringAttribute("symbol");
    }

    public String getExtension() {
        return this.getStringAttribute("extension");
    }

    public Boolean getIgnoreType() {
        return this.getBooleanAttribute("ignore-type");
    }

    public void setIgnoreType(Boolean ignoreType) {
        this.setAttribute("ignore-type", ignoreType);
    }

    public Boolean getIgnoreVersion() {
        return this.getBooleanAttribute("ignore-version");
    }

    public void setIgnoreVersion(Boolean ignoreVersion) {
        this.setAttribute("ignore-version", ignoreVersion);
    }

    public Boolean getPomGen() {
        return this.getBooleanAttribute("pom-gen");
    }

    public void setPomGen(boolean pomGen) {
        this.setAttribute("pom-gen", pomGen);
    }

    public Boolean getHK2Gen() {
        return this.getBooleanAttribute("hk2-gen");
    }

    public void setHK2Gen(boolean hk2Gen) {
        this.setAttribute("hk2-gen", hk2Gen);
    }

    public String getHK2Location() {
        return this.getStringAttribute("hk2-location");
    }

    public Boolean getOverwriteHigherVersion() {
        return this.getBooleanAttribute("overwrite-higher-version");
    }

    public String getSuppressManifestProperties() {
        return this.getStringAttribute("suppress-manifest-properties");
    }

    public List<LibraryEntry> getEntries() {
        return this.getComplexValueWrappedList("entry", LibraryEntry.class);
    }

    public void setEntries(List<LibraryEntry> entries) {
        this.setComplexValueWrappedList("entry", entries);
    }

    public Manifest getManifest() {
        return (Manifest)((Object)this.getSingleOccuranceComplexValueWrapped("manifest", Manifest.class));
    }

    public LibraryResolvers getLibraryResolvers() {
        return (LibraryResolvers)((Object)this.getSingleOccuranceComplexValueWrapped("resolvers", LibraryResolvers.class));
    }

    public MergedJarClasspath getClasspathJars() {
        return (MergedJarClasspath)((Object)this.getSingleOccuranceComplexValueWrapped("merged-jar-classpath", MergedJarClasspath.class));
    }

    public PomArtifact getDefaultPomOverride() {
        return (PomArtifact)this.getSingleOccuranceComplexValueWrapped("default-pom-override", PomArtifact.class);
    }

    public long getSize() {
        return (Long)this.getNumberAttribute("size", Long.class);
    }

    public void setSize(long size) {
        this.setAttribute("size", size);
    }

    public boolean matches(String type, String name, String version) {
        String libType = this.getType();
        String libName = this.getName();
        String libVer = this.getVersion();
        return type != null && type.equals(libType) && name != null && name.equals(libName) && (version == null && libVer == null || version != null && version.equals(libVer));
    }
}

