/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.dao.cpd;

import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.dao.cpd.FileGroup;
import com.oracle.cie.gdr.helpers.ComponentHelper;
import com.oracle.cie.gdr.helpers.PlatformInfoHelper;
import com.oracle.cie.gdr.utils.GdrException;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileMap
extends FileGroup {
    private static final Logger _log = Logger.getLogger(FileMap.class.getName());

    public FileMap(IDataHandler dataHandler) {
        super(dataHandler);
    }

    public FileMap() {
        this(ComponentHelper.getInstance().create("file-map"));
    }

    public String getSymbol() {
        return this.getStringAttribute("symbol");
    }

    public void setSymbol(String symbol) {
        this.setAttribute("symbol", symbol);
    }

    public boolean isExpanded() {
        return this.getBooleanAttribute("expanded");
    }

    public void setExpanded(boolean expanded) {
        this.getDataHandler().setAttributeValue("expanded", (Object)expanded);
    }

    public boolean isCompacted() {
        return this.getBooleanAttribute("compacted");
    }

    public void setCompacted(boolean compacted) {
        this.getDataHandler().setAttributeValue("compacted", (Object)compacted);
    }

    public String getSource() {
        return this.getStringAttribute("source");
    }

    public void setSource(String source) {
        this.getDataHandler().setAttributeValue("source", (Object)source);
    }

    public boolean isPackaged() {
        return this.getBooleanAttribute("packaged");
    }

    public void setPackaged(boolean packaged) {
        this.setAttribute("packaged", packaged);
    }

    public boolean isPatch() {
        return !StringUtil.isNullOrEmpty((String)this.getPatch(), (boolean)true);
    }

    public String getPatch() {
        return this.getStringAttribute("patch");
    }

    public void setPatch(String patch) {
        this.setAttribute("patch", patch);
    }

    public boolean isBootstrap() {
        return this.getBooleanAttribute("bootstrap");
    }

    public void setBootstrap(boolean bootstrap) {
        this.setAttribute("bootstrap", bootstrap);
    }

    public boolean hasPomGen() {
        return this.getBooleanAttribute("pom-gen");
    }

    public void setPomGen(boolean pomGen) {
        this.setAttribute("pom-gen", pomGen);
    }

    public Set<String> getPlatforms() {
        try {
            return this.getPlatforms(false, true);
        }
        catch (GdrException e) {
            _log.log(Level.WARNING, e.getMessage(), e);
            return new LinkedHashSet<String>();
        }
    }

    public Set<String> getPlatforms(boolean validate, boolean expandGroups) throws GdrException {
        LinkedHashSet<String> platforms = new LinkedHashSet<String>();
        IDataHandler[] dhs = this.getDataHandler().getComplexValue("platform");
        if (dhs != null && dhs.length > 0) {
            for (IDataHandler dh : dhs) {
                String name = (String)dh.getAttributeValue("name");
                if (StringUtil.isNullOrEmpty((String)name, (boolean)true)) continue;
                if (validate && !PlatformInfoHelper.getInstance().isSupportedPlatformOrGroup(name)) {
                    GdrException ex = new GdrException("Encountered unsupported platform or group value " + name);
                    _log.throwing(FileMap.class.getName(), "getPlatforms", ex);
                    throw ex;
                }
                if (expandGroups && PlatformInfoHelper.getInstance().getGroupInfoHolder(name) != null) {
                    try {
                        platforms.addAll(PlatformInfoHelper.getInstance().getPlatformsFromGroup(name));
                    }
                    catch (GdrException e) {
                        if (validate) {
                            throw e;
                        }
                        _log.log(Level.WARNING, e.getMessage(), e);
                    }
                    continue;
                }
                platforms.add(name);
            }
        }
        return platforms;
    }

    public void setPlatforms(Set<String> platforms) {
        IDataHandler[] dhs = null;
        if (platforms != null && !platforms.isEmpty()) {
            dhs = new IDataHandler[platforms.size()];
            int x = 0;
            for (String platform : platforms) {
                dhs[x] = ComponentHelper.getInstance().create("platform");
                dhs[x].setAttributeValue("name", (Object)platform);
                ++x;
            }
        }
        this.getDataHandler().setComplexValue("platform", dhs);
    }

    public Set<String> getLocales() {
        HashSet<String> locales = new HashSet<String>();
        IDataHandler[] dhs = this.getDataHandler().getComplexValue("locale");
        if (dhs != null && dhs.length > 0) {
            for (IDataHandler dh : dhs) {
                String id = (String)dh.getAttributeValue("name");
                if (id == null) continue;
                locales.add(id);
            }
        }
        return locales;
    }

    public void setLocales(Set<String> locales) {
        IDataHandler[] dhs = null;
        if (locales != null && !locales.isEmpty()) {
            dhs = new IDataHandler[locales.size()];
            int x = 0;
            for (String locale : locales) {
                dhs[x] = ComponentHelper.getInstance().create("locale");
                dhs[x].setAttributeValue("name", (Object)locale);
                ++x;
            }
        }
        this.getDataHandler().setComplexValue("locale", dhs);
    }

    public boolean hasDuplicates() {
        return this.getBooleanAttribute("duplicates");
    }
}

