/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.dao.cpd;

import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.gdr.dao.cpd.FileGroup;
import com.oracle.cie.gdr.dao.cpd.Mapping;
import com.oracle.cie.gdr.helpers.ComponentHelper;
import com.oracle.cie.gdr.services.RepositoryArtifact;

public class Directory
extends FileGroup
implements Mapping,
RepositoryArtifact {
    protected boolean _force;

    public Directory(IDataHandler dataHandler) {
        super(dataHandler);
    }

    public Directory() {
        this(ComponentHelper.getInstance().create("directory"));
    }

    @Override
    public String getSource() {
        return this.getStringAttribute("source");
    }

    @Override
    public void setSource(String source) {
        this.setAttribute("source", source);
    }

    @Override
    public String getDest() {
        return this.getStringAttribute("dest");
    }

    @Override
    public void setDest(String dest) {
        this.setAttribute("dest", dest);
    }

    @Override
    public String getId() {
        return this.getStringAttribute("id");
    }

    @Override
    public void setId(String id) {
        this.setAttribute("id", id);
    }

    public boolean isDeinstall() {
        return this.getBooleanAttribute("deinstall");
    }

    public void setDeinstall(boolean uninstall) {
        this.setAttribute("deinstall", uninstall);
    }

    public boolean isRecursive() {
        return this.getBooleanAttribute("recurse");
    }

    public void setRecursive(boolean recursive) {
        this.setAttribute("recurse", recursive);
    }

    public boolean isIncludeEmptyDirs() {
        return this.getBooleanAttribute("include-empty-dirs");
    }

    public void setIncludeEmptyDirs(boolean include) {
        this.setAttribute("include-empty-dirs", include);
    }

    public boolean isPreserveSymlinks() {
        return this.getBooleanAttribute("preserve-symlinks");
    }

    public void setPreserveSymlinks(boolean preserveSymlinks) {
        this.setAttribute("preserve-symlinks", preserveSymlinks);
    }

    public String getMode() {
        return this.getStringAttribute("mode");
    }

    public void setMode(String mode) {
        this.setAttribute("mode", mode);
    }

    @Override
    public String getGroup() {
        return this.getStringAttribute("group");
    }

    @Override
    public void setGroup(String group) {
        this.setAttribute("group", group);
    }

    @Override
    public String getArtifact() {
        return this.getStringAttribute("artifact");
    }

    @Override
    public void setArtifact(String artifact) {
        this.setAttribute("artifact", artifact);
    }

    @Override
    public String getVersion() {
        return this.getStringAttribute("version");
    }

    @Override
    public void setVersion(String version) {
        this.setAttribute("version", version);
    }

    @Override
    public boolean isIgnoreVersionKeywords() {
        return this.getBooleanAttribute("ignore-version-keywords");
    }

    @Override
    public void setIgnoreVersionKeywords(boolean ignore) {
        this.setAttribute("ignore-version-keywords", ignore);
    }

    @Override
    public String getBaseVersion() {
        return this.getStringAttribute("baseVersion");
    }

    @Override
    public void setBaseVersion(String version) {
        this.setAttribute("baseVersion", version);
    }

    @Override
    public String getClassifier() {
        String classifier = this.getStringAttribute("classifier");
        if (classifier != null && classifier.trim().length() < 1) {
            classifier = null;
        }
        return classifier;
    }

    @Override
    public void setClassifier(String classifier) {
        this.setAttribute("classifier", classifier);
    }

    @Override
    public String getType() {
        String type = this.getStringAttribute("type");
        if (type != null && type.trim().length() < 1) {
            type = null;
        }
        return type;
    }

    @Override
    public void setType(String type) {
        this.setAttribute("type", type);
    }

    public Boolean getPatchable() {
        return (Boolean)this.getDataHandler().getAttributeValue("patchable");
    }

    public void setPatchable(boolean patchable) {
        this.setAttribute("patchable", patchable);
    }

    public Boolean getForce() {
        return this._force;
    }

    public void setForce(boolean force) {
        this._force = force;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Directory directory = (Directory)o;
        String thisDest = this.getDest();
        String theirDest = directory.getDest();
        return !(thisDest == null ? theirDest != null : !thisDest.equals(theirDest));
    }

    public int hashCode() {
        String dest = this.getDest();
        return dest != null ? dest.hashCode() : 0;
    }
}

