/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.dao.cmn;

import com.oracle.cie.common.dao.AbstractDataHandlerWrapper;
import com.oracle.cie.common.dao.DataHandlerSpi;
import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.gdr.helpers.GdrHelper;

public class Reference
extends AbstractDataHandlerWrapper {
    public Reference(IDataHandler dataHandler) {
        super(dataHandler);
    }

    public Reference() {
        this(GdrHelper.getConfiguredClassLoader());
    }

    public Reference(ClassLoader classLoader) {
        this(DataHandlerSpi.getDataHandlerProvider((ClassLoader)classLoader).create("http://xmlns.oracle.com/cie/gdr/cmn", "ref", classLoader));
    }

    public Reference(String name, String version) {
        this();
        this.setName(name);
        this.setVersion(version);
    }

    public Reference(String name, String version, ClassLoader classLoader) {
        this(classLoader);
        this.setName(name);
        this.setVersion(version);
    }

    public String getName() {
        return this.getStringAttribute("name");
    }

    public void setName(String name) {
        this.setAttribute("name", name);
    }

    public String getVersion() {
        return this.getStringAttribute("version");
    }

    public void setVersion(String version) {
        this.setAttribute("version", version);
    }

    public boolean isMatching(Reference ref) {
        return ref != null && ref.getName().equals(this.getName()) && !ref.getVersion().equals(this.getVersion());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !Reference.class.isAssignableFrom(o.getClass())) {
            return false;
        }
        Reference reference = (Reference)((Object)o);
        String name = this.getName();
        String version = this.getVersion();
        String otherName = reference.getName();
        String otherVersion = reference.getVersion();
        return !(name == null ? otherName != null : !name.equals(otherName)) && !(version == null ? otherVersion != null : !version.equals(otherVersion));
    }

    public int hashCode() {
        String name = this.getName();
        String version = this.getVersion();
        int result = name != null ? name.hashCode() : 0;
        result = 31 * result + (version != null ? version.hashCode() : 0);
        return result;
    }

    public String toString() {
        String version = this.getVersion();
        if (version == null) {
            return this.getName();
        }
        return this.getName() + " " + version;
    }
}

